/*
 * Copyright (C) 2010 Texas Instruments
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ----------------------------------------------------------------------------
 *
 */

#ifndef _DDR_DEFS_TI814X_H
#define _DDR_DEFS_TI814X_H

#include <asm/arch/hardware.h>

/* DDR Phy MMRs OFFSETs */
#define CMD0_REG_PHY_CTRL_SLAVE_RATIO_0		0x01C
#define CMD0_REG_PHY_DLL_LOCK_DIFF_0		0x028
#define CMD0_REG_PHY_INVERT_CLKOUT_0		0x02C
#define CMD1_REG_PHY_CTRL_SLAVE_RATIO_0		0x050
#define CMD1_REG_PHY_DLL_LOCK_DIFF_0		0x05C
#define CMD1_REG_PHY_INVERT_CLKOUT_0		0x060
#define CMD2_REG_PHY_CTRL_SLAVE_RATIO_0		0x084
#define CMD2_REG_PHY_DLL_LOCK_DIFF_0		0x090
#define CMD2_REG_PHY_INVERT_CLKOUT_0		0x094

/* DDR0 Phy MMRs */
#define CMD0_REG_PHY0_CTRL_SLAVE_RATIO_0	(0x01C + DDR0_PHY_BASE_ADDR)
#define CMD0_REG_PHY0_DLL_LOCK_DIFF_0		(0x028 + DDR0_PHY_BASE_ADDR)
#define CMD0_REG_PHY0_INVERT_CLKOUT_0		(0x02C + DDR0_PHY_BASE_ADDR)
#define CMD1_REG_PHY0_CTRL_SLAVE_RATIO_0	(0x050 + DDR0_PHY_BASE_ADDR)
#define CMD1_REG_PHY0_DLL_LOCK_DIFF_0		(0x05C + DDR0_PHY_BASE_ADDR)
#define CMD1_REG_PHY0_INVERT_CLKOUT_0		(0x060 + DDR0_PHY_BASE_ADDR)
#define CMD2_REG_PHY0_CTRL_SLAVE_RATIO_0	(0x084 + DDR0_PHY_BASE_ADDR)
#define CMD2_REG_PHY0_DLL_LOCK_DIFF_0		(0x090 + DDR0_PHY_BASE_ADDR)
#define CMD2_REG_PHY0_INVERT_CLKOUT_0		(0x094 + DDR0_PHY_BASE_ADDR)

#define DATA0_REG_PHY0_RD_DQS_SLAVE_RATIO_0	(0x0C8 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_WR_DQS_SLAVE_RATIO_0	(0x0DC + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_WRLVL_INIT_RATIO_0	(0x0F0 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_WRLVL_INIT_MODE_0	(0x0F8 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_GATELVL_INIT_RATIO_0	(0x0FC + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_GATELVL_INIT_MODE_0	(0x104 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_FIFO_WE_SLAVE_RATIO_0	(0x108 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_WR_DATA_SLAVE_RATIO_0	(0x120 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_USE_RANK0_DELAYS		(0x134 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_DLL_LOCK_DIFF_0		(0x138 + DDR0_PHY_BASE_ADDR)

#define DATA1_REG_PHY0_RD_DQS_SLAVE_RATIO_0	(0x16C + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_WR_DQS_SLAVE_RATIO_0	(0x180 + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_WRLVL_INIT_RATIO_0	(0x194 + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_WRLVL_INIT_MODE_0	(0x19C + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_GATELVL_INIT_RATIO_0	(0x1A0 + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_GATELVL_INIT_MODE_0	(0x1A8 + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_FIFO_WE_SLAVE_RATIO_0	(0x1AC + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_WR_DATA_SLAVE_RATIO_0	(0x1C4 + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_USE_RANK0_DELAYS		(0x1D8 + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_DLL_LOCK_DIFF_0		(0x1DC + DDR0_PHY_BASE_ADDR)

#define DATA2_REG_PHY0_RD_DQS_SLAVE_RATIO_0	(0x210 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_WR_DQS_SLAVE_RATIO_0	(0x224 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_WRLVL_INIT_RATIO_0	(0x238 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_WRLVL_INIT_MODE_0	(0x240 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_GATELVL_INIT_RATIO_0	(0x244 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_GATELVL_INIT_MODE_0	(0x24C + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_FIFO_WE_SLAVE_RATIO_0	(0x250 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_WR_DATA_SLAVE_RATIO_0	(0x268 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_USE_RANK0_DELAYS		(0x27C + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_DLL_LOCK_DIFF_0		(0x280 + DDR0_PHY_BASE_ADDR)

#define DATA3_REG_PHY0_RD_DQS_SLAVE_RATIO_0	(0x2B4 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_WR_DQS_SLAVE_RATIO_0	(0x2C8 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_WRLVL_INIT_RATIO_0	(0x2DC + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_WRLVL_INIT_MODE_0	(0x2E4 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_GATELVL_INIT_RATIO_0	(0x2E8 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_GATELVL_INIT_MODE_0	(0x2F0 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_FIFO_WE_SLAVE_RATIO_0	(0x2F4 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_WR_DATA_SLAVE_RATIO_0	(0x30C + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_USE_RANK0_DELAYS		(0x320 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_DLL_LOCK_DIFF_0		(0x324 + DDR0_PHY_BASE_ADDR)

/* DDR1 Phy MMRs */
#define	CMD0_REG_PHY1_CTRL_SLAVE_RATIO_0	(0x01C + DDR1_PHY_BASE_ADDR)
#define	CMD0_REG_PHY1_DLL_LOCK_DIFF_0		(0x028 + DDR1_PHY_BASE_ADDR)
#define	CMD0_REG_PHY1_INVERT_CLKOUT_0		(0x02C + DDR1_PHY_BASE_ADDR)
#define	CMD1_REG_PHY1_CTRL_SLAVE_RATIO_0	(0x050 + DDR1_PHY_BASE_ADDR)
#define	CMD1_REG_PHY1_DLL_LOCK_DIFF_0		(0x05C + DDR1_PHY_BASE_ADDR)
#define	CMD1_REG_PHY1_INVERT_CLKOUT_0		(0x060 + DDR1_PHY_BASE_ADDR)
#define	CMD2_REG_PHY1_CTRL_SLAVE_RATIO_0	(0x084 + DDR1_PHY_BASE_ADDR)
#define	CMD2_REG_PHY1_DLL_LOCK_DIFF_0		(0x090 + DDR1_PHY_BASE_ADDR)
#define	CMD2_REG_PHY1_INVERT_CLKOUT_0		(0x094 + DDR1_PHY_BASE_ADDR)

#define	DATA0_REG_PHY1_RD_DQS_SLAVE_RATIO_0	(0x0C8 + DDR1_PHY_BASE_ADDR)
#define	DATA0_REG_PHY1_WR_DQS_SLAVE_RATIO_0	(0x0DC + DDR1_PHY_BASE_ADDR)
#define	DATA0_REG_PHY1_WRLVL_INIT_RATIO_0	(0x0F0 + DDR1_PHY_BASE_ADDR)
#define	DATA0_REG_PHY1_WRLVL_INIT_MODE_0	(0x0F8 + DDR1_PHY_BASE_ADDR)
#define	DATA0_REG_PHY1_GATELVL_INIT_RATIO_0	(0x0FC + DDR1_PHY_BASE_ADDR)
#define	DATA0_REG_PHY1_GATELVL_INIT_MODE_0	(0x104 + DDR1_PHY_BASE_ADDR)
#define	DATA0_REG_PHY1_FIFO_WE_SLAVE_RATIO_0	(0x108 + DDR1_PHY_BASE_ADDR)
#define	DATA0_REG_PHY1_WR_DATA_SLAVE_RATIO_0	(0x120 + DDR1_PHY_BASE_ADDR)
#define	DATA0_REG_PHY1_USE_RANK0_DELAYS		(0x134 + DDR1_PHY_BASE_ADDR)
#define	DATA0_REG_PHY1_DLL_LOCK_DIFF_0		(0x138 + DDR1_PHY_BASE_ADDR)

#define	DATA1_REG_PHY1_RD_DQS_SLAVE_RATIO_0	(0x16C + DDR1_PHY_BASE_ADDR)
#define	DATA1_REG_PHY1_WR_DQS_SLAVE_RATIO_0	(0x180 + DDR1_PHY_BASE_ADDR)
#define	DATA1_REG_PHY1_WRLVL_INIT_RATIO_0	(0x194 + DDR1_PHY_BASE_ADDR)
#define	DATA1_REG_PHY1_WRLVL_INIT_MODE_0	(0x19C + DDR1_PHY_BASE_ADDR)
#define	DATA1_REG_PHY1_GATELVL_INIT_RATIO_0	(0x1A0 + DDR1_PHY_BASE_ADDR)
#define	DATA1_REG_PHY1_GATELVL_INIT_MODE_0	(0x1A8 + DDR1_PHY_BASE_ADDR)
#define	DATA1_REG_PHY1_FIFO_WE_SLAVE_RATIO_0	(0x1AC + DDR1_PHY_BASE_ADDR)
#define	DATA1_REG_PHY1_WR_DATA_SLAVE_RATIO_0	(0x1C4 + DDR1_PHY_BASE_ADDR)
#define	DATA1_REG_PHY1_USE_RANK0_DELAYS		(0x1D8 + DDR1_PHY_BASE_ADDR)
#define	DATA1_REG_PHY1_DLL_LOCK_DIFF_0		(0x1DC + DDR1_PHY_BASE_ADDR)

#define	DATA2_REG_PHY1_RD_DQS_SLAVE_RATIO_0	(0x210 + DDR1_PHY_BASE_ADDR)
#define	DATA2_REG_PHY1_WR_DQS_SLAVE_RATIO_0	(0x224 + DDR1_PHY_BASE_ADDR)
#define	DATA2_REG_PHY1_WRLVL_INIT_RATIO_0	(0x238 + DDR1_PHY_BASE_ADDR)
#define	DATA2_REG_PHY1_WRLVL_INIT_MODE_0	(0x240 + DDR1_PHY_BASE_ADDR)
#define	DATA2_REG_PHY1_GATELVL_INIT_RATIO_0	(0x244 + DDR1_PHY_BASE_ADDR)
#define	DATA2_REG_PHY1_GATELVL_INIT_MODE_0	(0x24C + DDR1_PHY_BASE_ADDR)
#define	DATA2_REG_PHY1_FIFO_WE_SLAVE_RATIO_0	(0x250 + DDR1_PHY_BASE_ADDR)
#define	DATA2_REG_PHY1_WR_DATA_SLAVE_RATIO_0	(0x268 + DDR1_PHY_BASE_ADDR)
#define	DATA2_REG_PHY1_USE_RANK0_DELAYS		(0x27C + DDR1_PHY_BASE_ADDR)
#define	DATA2_REG_PHY1_DLL_LOCK_DIFF_0		(0x280 + DDR1_PHY_BASE_ADDR)

#define	DATA3_REG_PHY1_RD_DQS_SLAVE_RATIO_0	(0x2B4 + DDR1_PHY_BASE_ADDR)
#define	DATA3_REG_PHY1_WR_DQS_SLAVE_RATIO_0	(0x2C8 + DDR1_PHY_BASE_ADDR)
#define	DATA3_REG_PHY1_WRLVL_INIT_RATIO_0	(0x2DC + DDR1_PHY_BASE_ADDR)
#define	DATA3_REG_PHY1_WRLVL_INIT_MODE_0	(0x2E4 + DDR1_PHY_BASE_ADDR)
#define	DATA3_REG_PHY1_GATELVL_INIT_RATIO_0	(0x2E8 + DDR1_PHY_BASE_ADDR)
#define	DATA3_REG_PHY1_GATELVL_INIT_MODE_0	(0x2F0 + DDR1_PHY_BASE_ADDR)
#define	DATA3_REG_PHY1_FIFO_WE_SLAVE_RATIO_0	(0x2F4 + DDR1_PHY_BASE_ADDR)
#define	DATA3_REG_PHY1_WR_DATA_SLAVE_RATIO_0	(0x30C + DDR1_PHY_BASE_ADDR)
#define	DATA3_REG_PHY1_USE_RANK0_DELAYS		(0x320 + DDR1_PHY_BASE_ADDR)
#define	DATA3_REG_PHY1_DLL_LOCK_DIFF_0		(0x324 + DDR1_PHY_BASE_ADDR)

#define DATA_MACRO_0			0
#define DATA_MACRO_1			1
#define DATA_MACRO_2			2
#define DATA_MACRO_3			3
#define DDR_PHY0			0
#define DDR_PHY1			1

/* Common DDR PHY parameters */
#define	PHY_INVERT_CLKOUT_DEFINE		0
#define	DDR3_PHY_INVERT_CLKOUT_OFF		0
#define	PHY_REG_USE_RANK0_DELAY_DEFINE		0
#define	mDDR_PHY_REG_USE_RANK0_DELAY_DEFINE	1
#define	PHY_DLL_LOCK_DIFF_DEFINE		0x4
#define	PHY_CMD0_DLL_LOCK_DIFF_DEFINE		0x4
#define DDR_EMIF_REF_TRIGGER			0x10000000

#define	PHY_GATELVL_INIT_CS0_DEFINE		0x0
#define	PHY_WRLVL_INIT_CS0_DEFINE		0x0

#define	PHY_GATELVL_INIT_CS1_DEFINE		0x0
#define	PHY_WRLVL_INIT_CS1_DEFINE		0x0
#define	PHY_CTRL_SLAVE_RATIO_CS1_DEFINE		0x80

/* TI814X DDR2 PHY CFG parameters */
#define	DDR2_PHY_RD_DQS_CS0_DEFINE		0x35
#define	DDR2_PHY_WR_DQS_CS0_DEFINE		0x20
#define	DDR2_PHY_RD_DQS_GATE_CS0_DEFINE		0x90
#define	DDR2_PHY_WR_DATA_CS0_DEFINE		0x50
#define	DDR2_PHY_CTRL_SLAVE_RATIO_CS0_DEFINE	0x80

/* TI814X DDR3 PHY CFG parameters */
#if 0
#define DDR3_PHY_RD_DQS_CS0_DEFINE		0x30
#define DDR3_PHY_WR_DQS_CS0_DEFINE		0x21
#define DDR3_PHY_FIFO_WE_CS0_DEFINE		0xC0
#define DDR3_PHY_WR_DATA_CS0_DEFINE		0x44
#else
#if defined(CONFIG_DDR_SPEED_400) //400MHZ
#define DDR3_PHY_RD_DQS_CS0_DEFINE	          ((phy_num == 0)?0x3d:0x3b)             //((phy_num == 0)?0x3d:0x3b)  
#define DDR3_PHY_RD_DQS_GATE_CS0_DEFINE	   ((phy_num == 0)?0xb1:0xab)       //0xb2:0xaa             //0xb1
#define DDR3_PHY_WR_DQS_CS0_DEFINE	0x43                                						 //0x42
#define DDR3_PHY_WR_DATA_CS0_DEFINE	0x80    									//0x7f  
#elif defined(CONFIG_DDR_SPEED_533)

#if 0
u32 DDR3_PHY_RD_DQS_CS0_DEFINE_512M[2][4] =
{
	{0x36, 0x3A, 0x3B, 0x3C},  //0x39  //{0x39, 0x39, 0x39, 0x39}, 
	{0x38, 0x3D, 0x3B, 0x3B}  //0x3A  //{0x3A, 0x3A, 0x3A, 0x3A}   
};
#endif
				
#define DDR3_PHY_RD_DQS_CS0_DEFINE_J   ({                                          \
										u32 v;                              \
										if(phy_num == 0){    \
											switch(macro){   \
												case 0:   \
													v = 0x36;   \
													break;   \
												case 1:   \
													v = 0x3A;   \
													break;    \
												case 2:   \
													v = 0x3B;   \
													break;    \
												default:   \
													v = 0x3C;  \
													break;   \
											}   \
										}else{   \
											switch(macro){  \
												case 0:   \
													v = 0x38;  \
													break;   \
												case 1:   \
													v = 0x3D;  \
													break;   \
												case 2:   \
													v = 0x3B;   \
													break;   \
												default:   \
													v = 0x3B;   \
													break;   \
											}   \
										}  \
										v; })

#if 0

u32 DDR3_PHY_RD_DQS_GATE_CS0_DEFINE_512M[2][4] =
{
	{0xB7, 0xC3, 0xD5, 0xC9}, //0xC6 //{0xC6, 0xC6, 0xC6, 0xC6}, 
	{0xAF, 0xB7, 0xCD, 0xC9} //0xBF  //{0xBF, 0xBF, 0xBF, 0xBF}
};

#endif

#define DDR3_PHY_RD_DQS_GATE_CS0_DEFINE_J  ({                                          \
												u32 v;                              \
												if(phy_num == 0){    \
													switch(macro){   \
														case 0:   \
															v = 0xB7;   \
															break;   \
														case 1:   \
															v = 0xC3;   \
															break;    \
														case 2:   \
															v = 0xD5;   \
															break;    \
														default:   \
															v = 0xC9;  \
															break;   \
													}   \
												}else{   \
													switch(macro){  \
														case 0:   \
															v = 0xAF;  \
															break;   \
														case 1:   \
															v = 0xB7;  \
															break;   \
														case 2:   \
															v = 0xCD;   \
															break;   \
														default:   \
															v = 0xC9;   \
															break;   \
													}   \
												}  \
												v; })
#if 0

u32  DDR3_PHY_WR_DQS_CS0_DEFINE_512M[2][4] = 
{
	{0x47, 0x4A, 0x50, 0x55}, //0x4D {0x4D, 0x4D, 0x4D, 0x4D}, 
	{0x45, 0x45, 0x4B, 0x50}  //0x49 {0x49, 0x49, 0x49, 0x49}
};

#endif


#define DDR3_PHY_WR_DQS_CS0_DEFINE_J	       ({                                          \
												u32 v;                              \
												if(phy_num == 0){    \
													switch(macro){   \
														case 0:   \
															v = 0x47;   \
															break;   \
														case 1:   \
															v = 0x4A;   \
															break;    \
														case 2:   \
															v = 0x50;   \
															break;    \
														default:   \
															v = 0x55;  \
															break;   \
													}   \
												}else{   \
													switch(macro){  \
														case 0:   \
															v = 0x45;  \
															break;   \
														case 1:   \
															v = 0x45;  \
															break;   \
														case 2:   \
															v = 0x4B;   \
															break;   \
														default:   \
															v = 0x50;   \
															break;   \
													}   \
												}  \
												v; })  




#if 0

u32 DDR3_PHY_WR_DATA_CS0_DEFINE_512M[2][4] = 
{
	{0x82, 0x84, 0x82, 0x84}, //0x83 {0x83, 0x83, 0x83,  0x83}, 
	{0x80, 0x82, 0x7F, 0x81} //0x80 //{0x80, 0x80, 0x80,  0x80} 
};

#endif

	
#define DDR3_PHY_WR_DATA_CS0_DEFINE_J	         ({                                          \
												u32 v;                              \
												if(phy_num == 0){    \
													switch(macro){   \
														case 0:   \
															v = 0x82;   \
															break;   \
														case 1:   \
															v = 0x84;   \
															break;    \
														case 2:   \
															v = 0x82;   \
															break;    \
														default:   \
															v = 0x84;  \
															break;   \
													}   \
												}else{   \
													switch(macro){  \
														case 0:   \
															v = 0x80;  \
															break;   \
														case 1:   \
															v = 0x82;  \
															break;   \
														case 2:   \
															v = 0x7F;   \
															break;   \
														default:   \
															v = 0x81;   \
															break;   \
													}   \
												}  \
												v; })  

/* DDR0/1 IO CTRL parameters */
#define DDR0_IO_CTRL_DEFINE_J		0x030303
#define DDR1_IO_CTRL_DEFINE_J		0x030303 


#define DDR3_PHY_RD_DQS_CS0_DEFINE_T		((phy_num == 0)?0x39:0x37) //0x3C                                                   //((phy_num == 0)?0x3a:0x3c)    //((phy_num == 0)?0x3a:0x3c)       
#define DDR3_PHY_RD_DQS_GATE_CS0_DEFINE_T	((phy_num == 0)?0xb0:0xb2)//((phy_num == 0)?0xc7:0xc1)    //((phy_num == 0)?0xc4:0xca)   //((phy_num == 0)?0xc4:0xcb)   
#define DDR3_PHY_WR_DQS_CS0_DEFINE_T	         0x44                                            //((phy_num == 0)?0x46:0x44)           //0x41 //0x40 
#define DDR3_PHY_WR_DATA_CS0_DEFINE_T	        ((phy_num == 0)?0x7f:0x7e) //((phy_num == 0)?0x7e:0x7c)          //((phy_num == 0)?0x7a:0x78)     //0x76 														

/* DDR0/1 IO CTRL parameters */
#define DDR0_IO_CTRL_DEFINE_T		0x21C1C1C
#define DDR1_IO_CTRL_DEFINE_T		0x21C1C1C 


#endif
#endif /*#if 0*/

#define DDR3_PHY_CTRL_SLAVE_RATIO_CS0_DEFINE	0x80

/* Initially set a large DDR refresh period */
#define DDR_EMIF_REF_CTRL		0x00004000

/* TI814X DDR2 EMIF CFG Registers values 333MHz*/
#define DDR2_EMIF_READ_LATENCY		0x07
#define DDR2_EMIF_TIM1			0x0AAAF552
#define DDR2_EMIF_TIM2			0x043631D2
#define DDR2_EMIF_TIM3			0x00000327
#define DDR2_EMIF_REF_CTRL		0x10000C30
#define DDR2_EMIF_SDRAM_CONFIG		0x40801AB2
#define DDR2_EMIF_SDRAM_ZQCR		0x50074BE1


#if defined(CONFIG_DDR_SPEED_533)

#if 1
/* TI814X DDR3 EMIF CFG Registers values 533MHz */
#define DDR3_EMIF_READ_LATENCY		0x00173209    
#define DDR3_EMIF_TIM1			 	0x0EEF36AB  


#define DDR3_EMIF_TIM2_512M				 0x303F7FDA 
#define DDR3_EMIF_TIM3_512M				 0x50FF83AF

#define DDR3_EMIF_TIM2_1G				0x305A7FDA 
#define DDR3_EMIF_TIM3_1G				0x50FF855F

#define DDR3_EMIF_REF_CTRL		 	 0x0081E 

#define DDR3_EMIF_SDRAM_CONFIG_1G	       0x61C11AB2 
#define DDR3_EMIF_SDRAM_CONFIG_512M	0x61C11A32       


#define DDR3_EMIF_SDRAM_ZQCR		0x50074BE1 
#else
/* TI814X DDR3 EMIF CFG Registers values 533MHz */
#define DDR3_EMIF_READ_LATENCY		0x0017320B  
#define DDR3_EMIF_TIM1			 0xEEF36B3 //0x0EEF2664   
#define DDR3_EMIF_TIM2			 0x343F7FDA //0x303F7FE2 
#define DDR3_EMIF_TIM3			 0x501F83AF //0x501F83AF

#define DDR3_EMIF_REF_CTRL		 0x0081E  //0x0000103D

#define DDR3_EMIF_SDRAM_CONFIG_1G	        0x61C12232 // 0x61C121B2  
#define DDR3_EMIF_SDRAM_CONFIG_512M     0x61C121B2  

#define DDR3_EMIF_SDRAM_ZQCR		0xD0074BE1  //0x50074BE1
#endif

#elif defined(CONFIG_DDR_SPEED_400)

/* TI814X DDR3 EMIF CFG Registers values 400MHz */
#define DDR3_EMIF_READ_LATENCY		0x00173209//0x00173209
#define DDR3_EMIF_TIM1			  0xCCCF564   //0xAAAE51B       
#define DDR3_EMIF_TIM2			0x302F81E3  // 0x202F7FDA    
#define DDR3_EMIF_TIM3			 0x510282B7  //0x50FF82B8  
#define DDR3_EMIF_REF_CTRL		 0x618		 //0x00C30  
#define DDR3_EMIF_SDRAM_CONFIG_1G	       0x61C012B2   
#define DDR3_EMIF_SDRAM_CONFIG_512M   0x61C01232 


#define DDR3_EMIF_SDRAM_ZQCR		0x50074BE1  //0xD0074BE1  //0x50074BE1

#else
#error "************DDR Speed Undefined**********" 
#endif


#if 0
#define DDR3_EMIF_READ_LATENCY		0x08
#define DDR3_EMIF_TIM1			0xAAAE51B
#define DDR3_EMIF_TIM2			0x282F7FDA
#define DDR3_EMIF_TIM3			0x531F82BF
#define DDR3_EMIF_REF_CTRL		0x1000C30
#define DDR3_EMIF_SDRAM_CONFIG		0x61C011B2
#define DDR3_EMIF_SDRAM_ZQCR		0x50074BE1
#endif

#if 0

/*
 * TI814X PG1.0 DMM LISA MAPPING
 * Two 256MB sections with 128-byte interleaved(hole in b/w)
 */
#define PG1_0_DMM_LISA_MAP__0		0x0
#define PG1_0_DMM_LISA_MAP__1		0x0
#define PG1_0_DMM_LISA_MAP__2		0x805C0300
#define PG1_0_DMM_LISA_MAP__3		0xA05C0300

#endif

//#define DDR_MEM_512M    // For McFW default configuration of 512 MB
#ifdef  DDR_MEM_512M
/*
 * TI814X PG2.1 DMM LISA MAPPING
 * 512 section 
 */
#define PG2_1_DMM_LISA_MAP__0		0
#define PG2_1_DMM_LISA_MAP__1		0
#define PG2_1_DMM_LISA_MAP__2		0x805C0300
#define PG2_1_DMM_LISA_MAP__3		0xA05C0300
#else
/*
 * TI814X PG2.1 DMM LISA MAPPING
 * 1G contiguous section with 128-byte interleaving
 */


#define PG2_1_DMM_LISA_MAP__0_512M		0x0
#define PG2_1_DMM_LISA_MAP__1_512M		0x0
#define PG2_1_DMM_LISA_MAP__2_512M		0x805C0300
#define PG2_1_DMM_LISA_MAP__3_512M		0xA05C0300


#define PG2_1_DMM_LISA_MAP__0_1G		0x0
#define PG2_1_DMM_LISA_MAP__1_1G		0x0
#define PG2_1_DMM_LISA_MAP__2_1G		0x0
#define PG2_1_DMM_LISA_MAP__3_1G		0x806C0300 //0x80640300



#endif

#endif  /* _DDR_DEFS_TI814X_H */

