/*
 * (C) Copyright 2002-2006
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * To match the U-Boot user interface on ARM platforms to the U-Boot
 * standard (as on PPC platforms), some messages with debug character
 * are removed from the default U-Boot build.
 *
 * Define DEBUG here if you want additional info as shown below
 * printed upon startup:
 *
 * U-Boot code: 00F00000 -> 00F3C774  BSS: -> 00FC3274
 * IRQ Stack: 00ebff7c
 * FIQ Stack: 00ebef7c
 */

#include <common.h>
#include <command.h>
#include <malloc.h>
#include <stdio_dev.h>
#include <timestamp.h>
#include <version.h>
#include <net.h>
#include <serial.h>
#include <nand.h>
#include <onenand_uboot.h>
#include <mmc.h>

#include <asm/io.h>

#ifdef CONFIG_TI8148_IPNC
#include <asm/arch/ddr_defs.h>
#include <asm/arch/ddr_defs_ti814x.h>
#include <asm/arch/cpu.h>

#include <spi.h>
#include <asm/io.h>
#include <asm/arch/omap3_spi.h>
#include <spi_flash.h>



#define DDR0_PHY_BASE_ADDR		0x47C0C400
#define DDR1_PHY_BASE_ADDR		0x47C0C800
#endif

#ifdef CONFIG_BITBANGMII
#include <miiphy.h>
#endif

#ifdef CONFIG_DRIVER_SMC91111
#include "../drivers/net/smc91111.h"
#endif
#ifdef CONFIG_DRIVER_LAN91C96
#include "../drivers/net/lan91c96.h"
#endif

DECLARE_GLOBAL_DATA_PTR;

ulong monitor_flash_len;
extern int sys_sync(void);

#ifdef CONFIG_HAS_DATAFLASH
extern int  AT91F_DataflashInit(void);
extern void dataflash_print_info(void);
#endif

#ifdef CONFIG_CMD_SYNC
extern int do_sync_uboot(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[]);
#endif

#ifndef CONFIG_IDENT_STRING
#define CONFIG_IDENT_STRING ""
#endif

const char version_string[] =
	U_BOOT_VERSION" (" U_BOOT_DATE " - " U_BOOT_TIME ")"CONFIG_IDENT_STRING;

#ifdef CONFIG_DRIVER_RTL8019
extern void rtl8019_get_enetaddr (uchar * addr);
#endif

#if defined(CONFIG_HARD_I2C) || \
    defined(CONFIG_SOFT_I2C)
#include <i2c.h>
#endif


/************************************************************************
 * Coloured LED functionality
 ************************************************************************
 * May be supplied by boards if desired
 */
void inline __coloured_LED_init (void) {}
void coloured_LED_init (void) __attribute__((weak, alias("__coloured_LED_init")));
void inline __red_LED_on (void) {}
void red_LED_on (void) __attribute__((weak, alias("__red_LED_on")));
void inline __red_LED_off(void) {}
void red_LED_off(void) __attribute__((weak, alias("__red_LED_off")));
void inline __green_LED_on(void) {}
void green_LED_on(void) __attribute__((weak, alias("__green_LED_on")));
void inline __green_LED_off(void) {}
void green_LED_off(void) __attribute__((weak, alias("__green_LED_off")));
void inline __yellow_LED_on(void) {}
void yellow_LED_on(void) __attribute__((weak, alias("__yellow_LED_on")));
void inline __yellow_LED_off(void) {}
void yellow_LED_off(void) __attribute__((weak, alias("__yellow_LED_off")));
void inline __blue_LED_on(void) {}
void blue_LED_on(void) __attribute__((weak, alias("__blue_LED_on")));
void inline __blue_LED_off(void) {}
void blue_LED_off(void) __attribute__((weak, alias("__blue_LED_off")));

/************************************************************************
 * Init Utilities							*
 ************************************************************************
 * Some of this code should be moved into the core functions,
 * or dropped completely,
 * but let's get it working (again) first...
 */

#if defined(CONFIG_ARM_DCC) && !defined(CONFIG_BAUDRATE)
#define CONFIG_BAUDRATE 115200
#endif
static int init_baudrate (void)
{
	char tmp[64];	/* long enough for environment variables */
	int i = getenv_r ("baudrate", tmp, sizeof (tmp));
	gd->bd->bi_baudrate = gd->baudrate = (i > 0)
			? (int) simple_strtoul (tmp, NULL, 10)
			: CONFIG_BAUDRATE;

	return (0);
}

extern void reConfig_DDR(void);


static int display_banner (void)
{
#ifdef CONFIG_TI8148_IPNC
	if(__raw_readl(0x48140E04) == DDR0_IO_CTRL_DEFINE_J)   
		printf ("\n\n%s  <J> Type Board\n\n", version_string);
	else
		printf ("\n\n%s  <T> Type Board\n\n", version_string);
#else
	printf ("\n\n%s\n", version_string);
#endif
	debug ("U-Boot code: %08lX -> %08lX  BSS: -> %08lX\n",
	       _armboot_start, _bss_start, _bss_end);
#ifdef CONFIG_MODEM_SUPPORT
	debug ("Modem Support enabled\n");
#endif
#ifdef CONFIG_USE_IRQ
	debug ("IRQ Stack: %08lx\n", IRQ_STACK_START);
	debug ("FIQ Stack: %08lx\n", FIQ_STACK_START);
#endif

	return (0);
}

/*
 * WARNING: this code looks "cleaner" than the PowerPC version, but
 * has the disadvantage that you either get nothing, or everything.
 * On PowerPC, you might see "DRAM: " before the system hangs - which
 * gives a simple yet clear indication which part of the
 * initialization if failing.
 */
static int display_dram_config (void)
{
	int i;

#ifdef DEBUG
	puts ("RAM Configuration:\n");

	for(i=0; i<CONFIG_NR_DRAM_BANKS; i++) {
		printf ("Bank #%d: %08lx ", i, gd->bd->bi_dram[i].start);
		print_size (gd->bd->bi_dram[i].size, "\n");
	}
#else
	ulong size = 0;

	for (i=0; i<CONFIG_NR_DRAM_BANKS; i++) {
		size += gd->bd->bi_dram[i].size;
	}
	puts("DRAM:  ");
	print_size(size, "\n");
#endif

	return (0);
}

#ifndef CONFIG_SYS_NO_FLASH
static void display_flash_config (ulong size)
{
	puts ("Flash: ");
	print_size (size, "\n");
}
#endif /* CONFIG_SYS_NO_FLASH */

#if defined(CONFIG_HARD_I2C) || defined(CONFIG_SOFT_I2C)
static int init_func_i2c (void)
{
	puts ("I2C:   ");
	i2c_init (CONFIG_SYS_I2C_SPEED, CONFIG_SYS_I2C_SLAVE);
	puts ("ready\n");
	return (0);
}
#endif

#if defined(CONFIG_CMD_PCI) || defined (CONFIG_PCI)
#include <pci.h>
static int arm_pci_init(void)
{
	pci_init();
	return 0;
}
#endif /* CONFIG_CMD_PCI || CONFIG_PCI */

/*
 * Breathe some life into the board...
 *
 * Initialize a serial port as console, and carry out some hardware
 * tests.
 *
 * The first part of initialization is running from Flash memory;
 * its main purpose is to initialize the RAM so that we
 * can relocate the monitor code to RAM.
 */

/*
 * All attempts to come up with a "common" initialization sequence
 * that works for all boards and architectures failed: some of the
 * requirements are just _too_ different. To get rid of the resulting
 * mess of board dependent #ifdef'ed code we now make the whole
 * initialization sequence configurable to the user.
 *
 * The requirements for any new initalization function is simple: it
 * receives a pointer to the "global data" structure as it's only
 * argument, and returns an integer return code, where 0 means
 * "continue" and != 0 means "fatal error, hang the system".
 */
typedef int (init_fnc_t) (void);

int print_cpuinfo (void);

init_fnc_t *init_sequence[] = {
#if defined(CONFIG_ARCH_CPU_INIT)
	arch_cpu_init,		/* basic arch cpu dependent setup */
#endif
	board_init,		/* basic board dependent setup */
#if defined(CONFIG_USE_IRQ)
	interrupt_init,		/* set up exceptions */
#endif
	timer_init,		/* initialize timer */
#ifdef CONFIG_FSL_ESDHC
	get_clocks,
#endif
	env_init,		/* initialize environment */
	init_baudrate,		/* initialze baudrate settings */
	serial_init,		/* serial communications setup */
	console_init_f,		/* stage 1 init of console */
	display_banner,		/* say that we are here */
#if defined(CONFIG_DISPLAY_CPUINFO)
	print_cpuinfo,		/* display cpu info (and speed) */
#endif
#if defined(CONFIG_DISPLAY_BOARDINFO)
	checkboard,		/* display board info */
#endif
#if defined(CONFIG_HARD_I2C) || defined(CONFIG_SOFT_I2C)
	init_func_i2c,
#endif
	dram_init,		/* configure available RAM banks */
#if defined(CONFIG_CMD_PCI) || defined (CONFIG_PCI)
	arm_pci_init,
#endif
	display_dram_config,
#ifdef CONFIG_A5S_WATCHDOG
    watchdog_init,
#endif
	NULL,
};


#ifdef CONFIG_TI8148_IPNC
/****************************************************************
     δҪ  ϵFPGA  0xEF ַ
     ȡDSP ͣ Ϊ0x01 ˵ ջ(J)壻
     0x0,  ˵ T Ͱ壬 ְӵ DDR 
     һ
****************************************************************/
/*ʼSPI 1 CS3*/

#define    SPI1_PINMUX_CS3            0x4814091C
#define    SPI1_PINMUX_SCLK          0x48140954
#define    SPI1_PINMUX_D1              0x48140958
#define    SPI1_PINMUX_D0              0x4814095C

#define    SPI1_BASE                           0x481A0100
#define    SPI1_SYSCONFIG               (SPI1_BASE + 0x10)
#define    SPI1_SYSSTATUS               (SPI1_BASE + 0x14)
#define    SPI1_WAKEUPENABLE        (SPI1_BASE + 0x20)
#define    SPI1_MODULECTRL             (SPI1_BASE + 0x28)

#define    SPI1_CH1CONF                   (SPI1_BASE + 0x68)
#define    SPI1_CH1STAT                    (SPI1_BASE + 0x6C)
#define    SPI1_CH1CTRL		      (SPI1_BASE + 0x70)
#define    SPI1_CH1TX1                             (SPI1_BASE + 0x74)
#define    SPI1_CH1RX1                             (SPI1_BASE + 0x78)
#define    TIME_OUT                              0xa000000
#define    RAM_ADDR                              0x4031ff00

#define reverse_bits(num)  ({ \
						u8 val; \
						val = ((num & 0x80) >> 7) | ((num & 0x01) << 7); \
						val |=((num & 0x40) >> 5) |((num & 0x02) << 5); \
						val |= ((num & 0x20) >> 3) | ((num & 0x4) << 3); \
						val |= ((num & 0x10) >> 1) | ((num & 0x8) << 1); \
						val;}) 

static void ddr_dog_detect(void)
{
	 u32 tmp, count; 
	 
	/*pinmux*/
	tmp = readl(SPI1_PINMUX_CS3); 
	writel((tmp & (~0xff)) | 0x10, SPI1_PINMUX_CS3); 
	tmp = readl(SPI1_PINMUX_SCLK); 
	writel((tmp & (~0xff)) | 0x01, SPI1_PINMUX_SCLK);
	tmp = readl(SPI1_PINMUX_D1); 
	writel((tmp & (~0xff)) | 0x01, SPI1_PINMUX_D1); 
	tmp = readl(SPI1_PINMUX_D0); 
	writel((tmp & (~0xff)) | 0x01, SPI1_PINMUX_D0); 

	/*config spi*/
	writel(OMAP3_MCSPI_SYSCONFIG_SOFTRESET, SPI1_SYSCONFIG); 
	do { 
		tmp = readl(SPI1_SYSSTATUS); 
	} while (!(tmp & OMAP3_MCSPI_SYSSTATUS_RESETDONE)); 

	
	writel(OMAP3_MCSPI_SYSCONFIG_AUTOIDLE | 
	       OMAP3_MCSPI_SYSCONFIG_ENAWAKEUP | 
	       OMAP3_MCSPI_SYSCONFIG_SMARTIDLE, 
	       SPI1_SYSCONFIG); 
	writel(OMAP3_MCSPI_WAKEUPENABLE_WKEN,  SPI1_WAKEUPENABLE); 
	tmp = readl(SPI1_MODULECTRL); 
	tmp &= ~(OMAP3_MCSPI_MODULCTRL_STEST | OMAP3_MCSPI_MODULCTRL_MS); 
	tmp |= OMAP3_MCSPI_MODULCTRL_SINGLE; 
	writel(tmp, SPI1_MODULECTRL); 
	tmp = (OMAP3_MCSPI_CHCONF_DPE0 | ((8 - 1) << 7) | OMAP3_MCSPI_CHCONF_EPOL |
			OMAP3_MCSPI_CHCONF_POL |OMAP3_MCSPI_CHCONF_PHA | 0x02 << 2 | 
			 OMAP3_MCSPI_CHCONF_TCS | OMAP3_MCSPI_CHCONF_FFEW | 
			OMAP3_MCSPI_CHCONF_FFER |OMAP3_MCSPI_CHCONF_TRM_RX_ONLY); 
	writel(tmp, SPI1_CH1CONF); 
	writel(OMAP3_MCSPI_CHCTRL_EN,  SPI1_CH1CTRL); 

	/*enable spi and cs*/
	writel((readl(SPI1_CH1CONF) | (0x00100000)),SPI1_CH1CONF); 
	while ((readl(SPI1_CH1STAT) & OMAP3_MCSPI_CHSTAT_TXS) == 0); 
	
	writel(reverse_bits(0xEF), SPI1_CH1TX1); 
	count = 0; 
	while((readl(SPI1_CH1STAT) & OMAP3_MCSPI_CHSTAT_RXS) == 0){ 
		if(count >= TIME_OUT){ 
			__raw_writel(0x01, RAM_ADDR);
			return;
		} 
		count++; 
	} 
	tmp = readl(SPI1_CH1RX1); 
	while ((readl(SPI1_CH1STAT)& OMAP3_MCSPI_CHSTAT_TXS) == 0); 
	writel(0x00, SPI1_CH1TX1); 
	count = 0; 
	while((readl(SPI1_CH1STAT) & OMAP3_MCSPI_CHSTAT_RXS) == 0){ 
		if(count >= TIME_OUT){ 
			__raw_writel(0x01, RAM_ADDR);
			return;
		} 
		count++; 
	} 
	tmp = readl(SPI1_CH1RX1); 
	tmp = reverse_bits(tmp & 0xff); 

	/*diable*/
	writel(0, SPI1_CH1CTRL); 
	writel((readl(SPI1_CH1CONF) & (~0x00100000)),SPI1_CH1CONF); 

	
	__raw_writel((tmp & 0x07), RAM_ADDR);
}

static void re_data_macro_config(u32 macro_num, u32 phy_num, u32 rd_dqs_cs0,
		u32 wr_dqs_cs0, u32 fifo_we_cs0, u32 wr_data_cs0)
{
	/* 0xA4 is size of each data macro mmr region.
	 * phy1 is at offset 0x400 from phy0
	 */
	u32 base = (macro_num * 0xA4) + (phy_num * 0x400);

	__raw_writel(((rd_dqs_cs0 << 10) | rd_dqs_cs0),
		(DATA0_REG_PHY0_RD_DQS_SLAVE_RATIO_0 + base));
	__raw_writel(((wr_dqs_cs0 << 10) | wr_dqs_cs0),
		(DATA0_REG_PHY0_WR_DQS_SLAVE_RATIO_0 + base));
	__raw_writel(((PHY_WRLVL_INIT_CS1_DEFINE << 10) |
		PHY_WRLVL_INIT_CS0_DEFINE),
		(DATA0_REG_PHY0_WRLVL_INIT_RATIO_0 + base));
	__raw_writel(((PHY_GATELVL_INIT_CS1_DEFINE << 10) |
		PHY_GATELVL_INIT_CS0_DEFINE),
		(DATA0_REG_PHY0_GATELVL_INIT_RATIO_0 + base));
	__raw_writel(((fifo_we_cs0 << 10) | fifo_we_cs0),
		(DATA0_REG_PHY0_FIFO_WE_SLAVE_RATIO_0 + base));
	__raw_writel(((wr_data_cs0 << 10) | wr_data_cs0),
		(DATA0_REG_PHY0_WR_DATA_SLAVE_RATIO_0 + base));
	__raw_writel(PHY_DLL_LOCK_DIFF_DEFINE,
		(DATA0_REG_PHY0_DLL_LOCK_DIFF_0 + base));
}


void reConfig_DDR(void)
{
	int phy_num, macro;
	for (macro = 0; macro <= DATA_MACRO_3; macro++) {
			re_data_macro_config(macro, phy_num,
				DDR3_PHY_RD_DQS_CS0_DEFINE_T, 
				DDR3_PHY_WR_DQS_CS0_DEFINE_T, 
				DDR3_PHY_RD_DQS_GATE_CS0_DEFINE_T, 
				DDR3_PHY_WR_DATA_CS0_DEFINE_T); 
	}

	__raw_writel(DDR0_IO_CTRL_DEFINE_T, DDR0_IO_CTRL);
	__raw_writel(DDR1_IO_CTRL_DEFINE_T, DDR1_IO_CTRL);
}


/************************************************
*        ϵʱ NCONFIG ܽͣ
*        ߣ ֤FPGA ܹ FLASH ٴ
*        س
************************************************/
#define  NCONFIG_GPIO                            (32*0 + 2)
#define  NCONFIG_PINMUX_ADDR            (0x48140820)
#define  NCONFIG_GPIO_BASE                 (0x48032000)

void reConfig_FPGA_Loading(void)
{
	volatile u32 reg;
	u32 count = 0xffffff;

	reg = __raw_readl(NCONFIG_PINMUX_ADDR);
	reg &= ~0xff;
	reg |= 0x80;
	__raw_writel(reg, NCONFIG_PINMUX_ADDR);

	/*ctrl*/
	reg = __raw_readl(NCONFIG_GPIO_BASE + 0x130);
	reg &= 0xFFFFFFFE;
	__raw_writel(reg, NCONFIG_GPIO_BASE + 0x130);

	/*output*/
	reg = __raw_readl(NCONFIG_GPIO_BASE + 0x134);
	reg &= ~(1 << NCONFIG_GPIO);
	__raw_writel(reg, NCONFIG_GPIO_BASE + 0x134);

	/*Low output*/
	reg = (1 << NCONFIG_GPIO);
	__raw_writel(reg,  NCONFIG_GPIO_BASE + 0x190);

	//do{
	//	count--;
	//
	//}while(count);
	udelay(50);
	
	/*High output*/
	reg = (1 << NCONFIG_GPIO);
	__raw_writel(reg,  NCONFIG_GPIO_BASE + 0x194);

}
#endif

#ifdef CONFIG_PARTS	
/************************************************
*        ӷϢжȡϢ
*		 gt->mtd_partsСϢ
*		 ļϵͳʽΪcramfs
************************************************/
extern int cramfs_load_with_name(void *loadoffset, char *filename, \
                u32 part_offset);

/* ȥַеĿոTAB */
static char *trim_str(char *str)
{
    char *p = NULL;
    
    while(*str)
    {
        if ((*str == ' ') || (*str == '\t'))
        {
            str++;
        }
        else
        {
            p = str++;
            break;
        }
    }

    while(*str)
    {
        if ((*str == ' ') || (*str == '\t'))
        {
            *str = 0;
            break;
        }
        else
        {
            ++str;
        }
    }
    
    return p;
}

/* Ϣַ */
#ifdef CONFIG_SPI_FLASH
extern unsigned int spi_flash_size;
#endif
static int parse_partinfo_line(char *buf, struct boot_mtd_partition *part)
{
    int len;
    char *p;
    
    p = strtok(buf, ",");
    if (!p)
    {
        return -1;
    }
    p = trim_str(p);
    len = strlen(p);
    if (len >= PART_NAME_LEN)
    {
        printf("fail to parse name\n");
        return -1;
    }
    strcpy(part->name, p);
    
    p = strtok(NULL, ",");
    if (!p)
    {
        printf("fail to parse cs\n");
        return -1;
    }
    p = trim_str(p);
    part->cs = (int)simple_strtoul(p, NULL, 10);
    
    p = strtok(NULL, ",");
    if (!p)
    {
        printf("fail to parse offset\n");
        return -1;
    }
    p = trim_str(p);
    part->offset = simple_strtoul(&p[2], NULL, 16);
    
    p = strtok(NULL, ",");
    if (!p)
    {
        printf("fail to parse size\n");
        return -1;
    }
    p = trim_str(p);
    part->size = simple_strtoul(&p[2], NULL, 16);
    
    p = strtok(NULL, ",");
    if (!p)
    {
        printf("fail to parse mask_flags\n");
        return -1;
    }
    p = trim_str(p);
    len = strlen(p);
    if ((len == 1) && !strcmp(p, "R"))
    {
        part->mask_flags = MTD_WRITEABLE;
    }
    else if ((len == 2) && !strcmp(p, "RW"))
    {
        part->mask_flags = 0;        
    }
    else
    {
        printf("fail to parse mask_flags\n");
        return -1;
    }
   
#ifdef CONFIG_SPI_FLASH 
    if(memcmp(part->name, "user", 4) == 0 && part->cs == 1 &&
        part->offset == 0 && spi_flash_size > 0x1000000){
        part->cs = 0;
        part->offset = 0x1000000;
    }
#endif

    return 0;
}

/* ļжȡһ */
static char *get_line(char **str)
{
    char *p;
    char *pStr;

    /* Ƿָ */
    if ((str == NULL) || (*str == NULL))
    {
        return NULL;
    }

    /* ַ */
    if (**str == 0)
    {
        return NULL;
    }
    
    p = pStr = *str;
    do
    {
        if ((*pStr == '\n') 
		     || ((*pStr == '\r') && (*(pStr + 1) == '\n')))
        {
            *pStr = 0;
            pStr++;
            break;
        }

        pStr++;
    } while (*pStr);
    *str = pStr;

    return p;
}


/* Ϣ */
static int parse_partinfo(char *partinfo, struct boot_mtd_partition *mtd_parts)
{
    int len;
    char *new_line, *p;
    char buf[128];
    
    new_line = get_line(&partinfo);
    while (new_line)
    {           
        if (new_line[0] == '#')
        {
            new_line = get_line(&partinfo);
            continue;
        }

        p = strstr(new_line, PARTINFO_FILE_END);
        if (p)
        {
            mtd_parts->name[0] = 0;
            break;
        }
        
        len = strlen(new_line);
        if ((len < MIN_PARTINFO_LEN) || (len >= MAX_PARTINFO_LEN))
        {
            new_line = get_line(&partinfo);
            continue;
        }

        strcpy(buf, new_line);
        if (parse_partinfo_line(buf, mtd_parts) < 0)
        {
            printf("fail to parse partinfo line\n");
            return -1;
        }            
        mtd_parts++;

        new_line = get_line(&partinfo);
    }

    return 0;
}

/* ӷϢжȡϢϢ */
int get_partinfo(struct boot_mtd_partition *mtd_parts, u32 offset)
{
    char *buf;
    int ret = 0;
    
    buf = malloc(PARTINFO_FILE_SIZE);
    if (!buf)
    {
        printf("fail to malloc partinfo buffer\n");
        return -1;
    }
    memset(buf, 0, PARTINFO_FILE_SIZE);
    
    if (cramfs_load_with_name(buf, PARTINFO_FILE_PATH, offset) < 0)
    {
        printf("fail to load partition.txt\n");
        ret = -1;
    }
    
    if (parse_partinfo(buf, mtd_parts) < 0)
    {
        printf("fail to parse partinfo\n");
        ret = -1;
        goto free_buf;
    }
    
free_buf:
    free(buf);
    
    return ret;
}
#endif

void start_armboot (void)
{
	init_fnc_t **init_fnc_ptr;
	char *s;
	
#if defined(CONFIG_VFD) || defined(CONFIG_LCD)
	unsigned long addr;
#endif

	/* Pointer is writable since we allocated a register for it */
	gd = (gd_t*)(_armboot_start - CONFIG_SYS_MALLOC_LEN - sizeof(gd_t));
	/* compiler optimization barrier needed for GCC >= 3.4 */
	__asm__ __volatile__("": : :"memory");

	memset ((void*)gd, 0, sizeof (gd_t));
	gd->bd = (bd_t*)((char*)gd - sizeof(bd_t));
	memset (gd->bd, 0, sizeof (bd_t));

	gd->flags |= GD_FLG_RELOC;

#ifdef CONFIG_TI8148_IPNC
	/*SPI FPGA ֵ*/
	ddr_dog_detect();
	udelay(1000);
	//while(cnt){
	//	cnt--;
	//}

	/*detect ddr*/
	if((__raw_readl(0x4031ff00) & 0xff) == 0){
		reConfig_DDR();
	}
	

	s_init_later(1);
#endif
	
	monitor_flash_len = _bss_start - _armboot_start;

	for (init_fnc_ptr = init_sequence; *init_fnc_ptr; ++init_fnc_ptr) {
		if ((*init_fnc_ptr)() != 0) {
			hang ();
		}
	}


	/*¼FPGA*/
	//reConfig_FPGA_Loading();

	/* armboot_start is defined in the board-specific linker script */
	mem_malloc_init (_armboot_start - CONFIG_SYS_MALLOC_LEN,
			CONFIG_SYS_MALLOC_LEN);

#ifdef CONFIG_TI8148_IPNC
	if(CPU_SPEC_PLL){
		printf("SATA Enable\n");
	}else{
		printf("SATA Disable\n");
	}
#endif

#ifndef CONFIG_SYS_NO_FLASH
	/* configure available FLASH banks */
	display_flash_config (flash_init ());
#endif /* CONFIG_SYS_NO_FLASH */

#ifdef CONFIG_VFD
#	ifndef PAGE_SIZE
#	  define PAGE_SIZE 4096
#	endif
	/*
	 * reserve memory for VFD display (always full pages)
	 */
	/* bss_end is defined in the board-specific linker script */
	addr = (_bss_end + (PAGE_SIZE - 1)) & ~(PAGE_SIZE - 1);
	vfd_setmem (addr);
	gd->fb_base = addr;
#endif /* CONFIG_VFD */

#ifdef CONFIG_LCD
	/* board init may have inited fb_base */
	if (!gd->fb_base) {
#		ifndef PAGE_SIZE
#		  define PAGE_SIZE 4096
#		endif
		/*
		 * reserve memory for LCD display (always full pages)
		 */
		/* bss_end is defined in the board-specific linker script */
		addr = (_bss_end + (PAGE_SIZE - 1)) & ~(PAGE_SIZE - 1);
		lcd_setmem (addr);
		gd->fb_base = addr;
	}
#endif /* CONFIG_LCD */

#if defined(CONFIG_CMD_NAND)
	puts ("NAND:  ");
	nand_init();		/* go init the NAND */
#endif

#ifdef CONFIG_CMD_SYNC
	do_sync_uboot(0,0,0,0);
#endif

#if defined(CONFIG_CMD_ONENAND)
	onenand_init();
#endif

#ifdef CONFIG_HAS_DATAFLASH
	AT91F_DataflashInit();
	dataflash_print_info();
#endif

	/* initialize environment */
	env_relocate ();
        sys_sync();
	
#ifdef CONFIG_IPNC_BOOT
	/*protect U-Boot-min sector---hujg@20120615*/
	protect_boot_sector();
#endif

#ifdef CONFIG_VFD
	/* must do this after the framebuffer is allocated */
	drv_vfd_init();
#endif /* CONFIG_VFD */

#ifdef CONFIG_SERIAL_MULTI
	serial_initialize();
#endif

	/* IP Address */
	gd->bd->bi_ip_addr = getenv_IPaddr ("ipaddr");

	stdio_init ();	/* get the devices list going. */

	jumptable_init ();

#if defined(CONFIG_API)
	/* Initialize API */
	api_init ();
#endif

	console_init_r ();	/* fully init console as a device */

#if defined(CONFIG_ARCH_MISC_INIT)
	/* miscellaneous arch dependent initialisations */
	arch_misc_init ();
#endif
#if defined(CONFIG_MISC_INIT_R)
	/* miscellaneous platform dependent initialisations */
	misc_init_r ();
#endif

	/* enable exceptions */
	enable_interrupts ();

	/* Perform network card initialisation if necessary */
#ifdef CONFIG_DRIVER_TI_EMAC
	/* XXX: this needs to be moved to board init */
extern void davinci_eth_set_mac_addr (const u_int8_t *addr);
	if (getenv ("ethaddr")) {
		uchar enetaddr[6];
		eth_getenv_enetaddr("ethaddr", enetaddr);
		davinci_eth_set_mac_addr(enetaddr);
	}
#endif

#if defined(CONFIG_DRIVER_SMC91111) || defined (CONFIG_DRIVER_LAN91C96)
	/* XXX: this needs to be moved to board init */
	if (getenv ("ethaddr")) {
		uchar enetaddr[6];
		eth_getenv_enetaddr("ethaddr", enetaddr);
		smc_set_mac_addr(enetaddr);
	}
#endif /* CONFIG_DRIVER_SMC91111 || CONFIG_DRIVER_LAN91C96 */

	/* Initialize from environment */
	if ((s = getenv ("loadaddr")) != NULL) {
		load_addr = simple_strtoul (s, NULL, 16);
	}
#if defined(CONFIG_CMD_NET)
	if ((s = getenv ("bootfile")) != NULL) {
		copy_filename (BootFile, s, sizeof (BootFile));
	}
#endif

#ifdef BOARD_LATE_INIT
	board_late_init ();
#endif

#ifdef CONFIG_GENERIC_MMC
	puts ("MMC:   ");
	mmc_initialize (gd->bd);
#endif

#ifdef CONFIG_BITBANGMII
	bb_miiphy_init();
#endif
#if defined(CONFIG_CMD_NET)
#if defined(CONFIG_NET_MULTI)
	puts ("Net:   ");
#endif
	eth_initialize(gd->bd);
#if defined(CONFIG_RESET_PHY_R)
	debug ("Reset Ethernet PHY\n");
	reset_phy();
#endif
#endif

    s = getenv("autocmd");
    if(s)
    {
        run_command(s,0);
    }

	/* main_loop() can return to retry autoboot, if so just run it again. */
	for (;;) {
		main_loop ();
	}

	/* NOTREACHED - no way out of command loop except booting */
}

void hang (void)
{
	puts ("### ERROR ### Please RESET the board ###\n");
	for (;;);
}
