#include <common.h>
#include <malloc.h>
#include <nand.h>
#include <updater.h>

#include <image.h>
#include <hush.h>

#ifdef CONFIG_DVR_CMD
// --> liu_hongcong update 20110804
/*rdb modify for nand 2012.12.14*/


# define ERR_OK				0
# define ERR_TIMOUT			1
# define ERR_NOT_ERASED			2
# define ERR_PROTECTED			4
# define ERR_INVAL			8
# define ERR_ALIGN			16
# define ERR_UNKNOWN_FLASH_VENDOR	32
# define ERR_UNKNOWN_FLASH_TYPE		64
# define ERR_PROG_ERROR			128
# define ERR_OVERFLOW_PART		256

#define DATA_ALIGN_SZ			0x20000
#define UBOOT_FLASH_REGION 		0x100000


extern uchar updater_mode;
extern short updater_progress;
extern int update_start(void);
extern int update_end(void);
static int __do_check_image(ulong addr);


/* ļжȡһ */
static char *get_line(char **str)
{
    char *p;
    char *pStr;

    /* Ƿָ */
    if ((str == NULL) || (*str == NULL))
    {
        return NULL;
    }

    /* ַ */
    if (**str == 0)
    {
        return NULL;
    }
    
    p = pStr = *str;
    do
    {
        if ((*pStr == '\n') 
		     || ((*pStr == '\r') && (*(pStr + 1) == '\n')))
        {
            *pStr = 0;
            pStr++;
            break;
        }

        pStr++;
    } while (*pStr);
    *str = pStr;

    return p;
}

/* ִýű */
static int __do_script(ulong img_addr)
{
    char *img_data, *new_line, *buf;
    ulong len, img_size;

    /* 龵ļ */
    if (__do_check_image(img_addr)) 
    {
        printf ("   Bad Image Info\n");
        return 1;
    }

    /* ȡϢ */
    img_data = (char *)image_get_data ((image_header_t *)img_addr);   
    img_size = image_get_data_size ((image_header_t *)img_addr);

    buf  = malloc(img_size + 4);
    if (!buf)
    {
        printf ("Fail to malloc buffer for CmdScript!\n");
        return 1;
    }
    memcpy(buf, img_data, img_size);
    buf[img_size] = 0;
    img_data = buf;

    printf ("exce update config script start!\n");
    
    /* ִýű */
    new_line = get_line(&img_data);
    while (new_line)
    {
        if (new_line[0] == '#')
        {
            new_line = get_line(&img_data);
            continue;
        }
        
        if (strstr(new_line, SCRIPT_FILE_END))
        {
            break;
        }

        len = strlen(new_line);
        if ((len < MIN_SCRIPT_LEN) || (len >= MAX_SCRIPT_LEN))
        {
            new_line = get_line(&img_data);
            continue;
        }

        printf ("%s\n", new_line);
        # ifndef CONFIG_SYS_HUSH_PARSER
        run_command (new_line, 0);
        # else
        parse_string_outer(new_line, FLAG_PARSE_SEMICOLON |
                    FLAG_EXIT_FROM_LOOP);
        # endif

        new_line = get_line(&img_data);
    }

    free(buf);
    
    printf ("exce update config script complete!\n");
    return 0;
}


void flash_perror (int err)
{
	switch (err) {
	case ERR_OK:
		break;
	case ERR_TIMOUT:
		puts ("Timeout writing to Flash\n");
		break;
	case ERR_NOT_ERASED:
		puts ("Flash not Erased\n");
		break;
	case ERR_PROTECTED:
		puts ("Can't write to protected Flash sectors\n");
		break;
	case ERR_INVAL:
		puts ("Outside available Flash\n");
		break;
	case ERR_ALIGN:
		puts ("Start and/or end address not on sector boundary\n");
		break;
	case ERR_UNKNOWN_FLASH_VENDOR:
		puts ("Unknown Vendor of Flash\n");
		break;
	case ERR_UNKNOWN_FLASH_TYPE:
		puts ("Unknown Type of Flash\n");
		break;
	case ERR_PROG_ERROR:
		puts ("General Flash Programming Error\n");
		break;
	case ERR_OVERFLOW_PART:
		puts("Overflow Flash Part,Check packshop\n");
		break;
	default:
		printf ("%s[%d] FIXME: rc=%d\n", __FILE__, __LINE__, err);
		break;
	}
}

static int __do_write_flash(ulong img_addr, ulong flash_addr)
{
	image_header_t header;
	void *data_addr = NULL;
	int data_len = 0;
	
	void *read_buf = NULL;
	void *src_buf = NULL;
	void *temp_buf = NULL;
	u32 offset = 0;
	int i;
	long int start_sect, data_sects;
	nand_info_t *nand;
	u32 part_start;
	u32 part_end;
	size_t len;
	size_t tmp;
	int ret = 0;
	int bad_block;
	//u32 erase_size;
	
	memcpy(&header, (void *)img_addr, sizeof(image_header_t));
	data_addr = (void *)img_addr + sizeof(image_header_t);
	data_len = be32_to_cpu((&header)->ih_size);
	part_end = be32_to_cpu((&header)->ih_ep);
	part_start = be32_to_cpu(header.ih_load);

	//printf("load:%08x,entry:%08x,size:%08x\n",data_load,data_end,data_len);

    nand = &nand_info[nand_curr_device];
	if(!nand){
	    return 1;
	}
	
	if ((flash_addr + data_len) > part_end){
		flash_perror (ERR_OVERFLOW_PART);
		return -1;
	}

	if ((flash_addr + data_len) > (CONFIG_SYS_FLASH_BASE + nand->size)) {
		printf("data lenght error.\n");
		flash_perror (ERR_INVAL);
		return 1;
	}

    /* if image is ok, now we write to flash */
    start_sect = (flash_addr - CONFIG_SYS_FLASH_BASE) / nand->erasesize;
	data_sects = ((data_len - 1) / nand->erasesize) + 1;
    
	read_buf = malloc(nand->erasesize);
	if (!read_buf){
		printf("malloc failed\n");
		return 1;
	}

	temp_buf = malloc(nand->erasesize);
	if (!temp_buf){
		printf("malloc failed\n");
		return 1;
	}

    offset = part_start;
    
    memset(temp_buf, 0xff, nand->erasesize);
    printf("\rerase : 0%%");
    for (;offset < part_end;){
        tmp = nand->erasesize;
        if (nand_block_isbad (nand, offset & ~(nand->erasesize - 1))) {
            printf ("Skip bad block 0x%08x\n",offset);
            offset += nand->erasesize; 
            continue;
        }
        
        nand_read_skip_bad(nand, offset, &tmp, read_buf);
        if (memcmp(read_buf, temp_buf, nand->erasesize)){
            nand_erase(nand,offset,nand->erasesize);
        }
        offset += nand->erasesize;
        printf("\rerase : %d%%",(offset - part_start) * 100 /\
        (part_end - part_start));
    }
	printf("\rerase : 100%%");
	 
	/* write to flash one sector by one sector */
	printf("\rwrite :  0%%");

	bad_block =0;
	for(i=start_sect; i<(data_sects + start_sect); i++) {
	
	    while(1){
	        offset = ((i + bad_block)* nand->erasesize );
    	    if (nand_block_isbad (nand, offset)){
                printf ("Skip bad block 0x%08x \n",offset);
                bad_block++;
                continue;
            }
            break;
        }
        
		if(i == (data_sects+start_sect -1)){ /*only copy available data for last sector */ 
			memset(temp_buf, 0xff, nand->erasesize);
			memcpy(temp_buf, data_addr + (i - start_sect) * nand->erasesize, \
			       data_len -(data_sects-1)*nand->erasesize );
			src_buf = temp_buf;
		}
		else{
			src_buf = data_addr + (i - start_sect) * nand->erasesize;
			//printf(".\n");
		}
		
		
		len = nand->erasesize;
		//printf("src_buf:0x%08x offset:0x%08x\n", src_buf, offset);
		 

        ret = nand_write(nand,offset,&len,src_buf);
		if (ret) 
			goto err_done;
		
        len = nand->erasesize;
        ret =nand_read(nand, offset, &len, read_buf);
        if (memcmp(read_buf,src_buf,nand->erasesize)){
            printf("write err at %08x\n",offset);
            ret = -1;
            goto err_done;
        }

		UpdaterSendProgress(0xffff,(i - start_sect) * 100 / data_sects);
		printf("\rwrite :  %02ld%%", (i - start_sect) * 100 / data_sects);
	}

	updater_progress = 100;
	UpdaterSendProgress(0xffff,100);
	printf("\rwrite : %ld%%\ndone\n", (i - start_sect) * 100 / data_sects);
	 
	free(read_buf);
	read_buf = NULL;

	free(temp_buf);
	temp_buf = NULL;

	/* set enviroment to default */
	if (start_sect < (UBOOT_FLASH_REGION/nand->erasesize)) {
		//setenv("restore", "1");  // set restore flag
		//return saveenv();
	}
	
	return 0;

err_done:
	printf("%s: error!\n",__func__);
	free(read_buf);
	read_buf = NULL;

	if(temp_buf !=NULL)
	{
		free(temp_buf);
		temp_buf = NULL;
	}
	
	return 1;
}

static int __do_check_image(ulong addr)
{
	void *hdr = (void *)addr;

	printf ("\n## Checking Image at %08lx ...\n", addr);

	switch (genimg_get_format (hdr)) {
	case IMAGE_FORMAT_LEGACY:
		puts ("   Legacy image found\n");
		if (!image_check_magic (hdr)) {
			puts ("   Bad Magic Number\n");
			return 1;
		}

		if (!image_check_hcrc (hdr)) {
			puts ("   Bad Header Checksum\n");
			return 1;
		}

		image_print_contents (hdr);

		puts ("   Verifying Checksum ... ");
		if (!image_check_dcrc (hdr)) {
			puts ("   Bad Data CRC\n");
			return 1;
		}
		puts ("OK\n");
		return 0;
#if defined(CONFIG_FIT)
	case IMAGE_FORMAT_FIT:
		puts ("   FIT image found\n");

		if (!fit_check_format (hdr)) {
			puts ("Bad FIT image format!\n");
			return 1;
		}

		fit_print_contents (hdr);

		if (!fit_all_image_check_hashes (hdr)) {
			puts ("Bad hash in FIT image!\n");
			return 1;
		}

		return 0;
#endif
	default:
		puts ("Unknown image format!\n");
		break;
	}

	return 1;

}


static int __do_check_addr(unsigned long addr)
{
	int rc = ERR_OK;

	if ((addr < CONFIG_SYS_FLASH_BASE) 
		|| (addr >= (CONFIG_SYS_FLASH_BASE+CONFIG_FLASH_SIZE)))
	{
		printf("Dest address:0x%lx invalid!\n", addr);
		rc = ERR_INVAL;
		goto err_out;
	}

	/* "run da"=CONFIG_SYS_FLASH_BASE, so here is right */
	if ((addr > CONFIG_SYS_FLASH_BASE)
             && (addr < (CONFIG_SYS_FLASH_BASE + UBOOT_SZ)))
	{
		rc = ERR_PROTECTED;
		goto err_out;
	}

	/* align 256KB  */
	if (addr % DATA_ALIGN_SZ)
	{
		rc = ERR_ALIGN;
		goto err_out;
	}

	return rc;

err_out:
	flash_perror (rc);
	return rc;
}

int __do_flwrite (cmd_tbl_t * cmdtp, ulong img_addr, int argc, char *argv[])
{
	ulong flash_baseaddr; //Ҫдλ
	
	/* Flash writing address */
	if (argc == 1) {
		image_header_t hdr; //imgļheader
		/* copy image hader */
		memcpy (&hdr, (char *)img_addr, sizeof (image_header_t));
		flash_baseaddr = be32_to_cpu((&hdr)->ih_load);
	} else {/* argc > 1 */
		flash_baseaddr = simple_strtoul (argv[1], NULL, 16);
	}
	
	/* check flash address */
	if (__do_check_addr(flash_baseaddr)) {
		return 1;
	}

	/* check image data */
	if (__do_check_image(img_addr)) {
		printf ("   Bad Image Info\n");
		return 1;
	}

	/* write data to flash */
	printf("Programing start at: 0x%08lx\n", flash_baseaddr);
	__do_write_flash(img_addr, flash_baseaddr);
	
	return 0;
} /* end __do_flwrite */

int do_flwrite (cmd_tbl_t * cmdtp, int flag, int argc, char *argv[])
{
    header_t *phdr = NULL;
    int total_len, head_len, img_len;
    ulong data;
    int ret;

    phdr = (header_t*)load_addr;

    /* special update file, ex: romfs-x.cramfs.img */
    ret = strncmp((char *)phdr->id, PACK_ID, strlen(PACK_ID));
    if (ret != 0)
    {
        ret = __do_flwrite(cmdtp, load_addr, argc, argv);
        if (ret) printf("flwrite error 1!\n");
        goto out;
    }

    total_len = phdr->total_len;
    head_len = phdr->head_len;
    img_len = 0;

    update_start();//־λ׼ʼʧܣϵͳָ
    /* deal every image in update.img */
    for (data = load_addr + head_len;
    data < load_addr + total_len;
    data += img_len)
    {
        img_len = be32_to_cpu(((image_header_t *)data)->ih_size) + sizeof(image_header_t);

        /* check Ctrl-C */
        ctrlc();
        if ((had_ctrlc())) {
            goto out;
        }

        if (strncmp(SCRIPT_IMG_NAME, image_get_name((image_header_t *)data), 
                sizeof(SCRIPT_IMG_NAME)) == 0)
        {
            if (__do_script(data))
            {
                printf("flwrite fail to run config script\n");
                ret = 1;
                goto out;
            }
        } 
        else
        {
            ret = __do_flwrite(cmdtp, data, argc, argv);
            if (ret)
            {
                printf("flwrite error 2!\n");
                ret = 1;
                goto out;			
            }
        }
	}
	update_end();
out:

#ifdef UBOOT_UPDATE
if(ret){
//ʧ
UpdaterSendProgress(UP_FAILD, 0);
}else{
//ɹ
UpdaterSendProgress(UP_COMPLETE, UP_COMPLETE);
}
#endif
return ret;
}


U_BOOT_CMD(
	flwrite,	2,	1,	do_flwrite,
	"flwrite - write data into FLASH memory\n",
	"DestAddr\n"
	"    - write data into DestAddr(0xA0000000~0xA4000000)\n"
);
#endif
// <-- liu_hongcong update
