/*******************************************************************************
 * cmd_loadk.c
 *
 * Copyright (C) 2011-2013 ZheJiang Dahua Technology CO.,LTD.
 *
 * Author : Ķ <rao_dongbo@dahuatech.com>
 * Version: V1.0.0  2013814 Create
 *
 * Description:
 *
 *       1. Ӳ˵
 *          ޡ
 *
 *       2. ṹ˵
 *          ޡ
 *
 *       3. ʹ˵
 *          ޡ
 *
 *       4. ˵
 *          ޡ
 *
 *       5. ˵
 *          ޡ
 *
 * Modification:
 *    Date     :
 *    Revision :
 *    Author   :
 *    Contents :
 *******************************************************************************/


/* ========================================================================== */
/*                             ͷļ                                       */
/* ========================================================================== */
#include <common.h>
#include <command.h>
#include <image.h>
#include <nand.h>
#include <asm/byteorder.h>
#include <exports.h>


/* ========================================================================== */
/*                           Ͷ                                   */
/* ========================================================================== */


/* ========================================================================== */
/*                          ݽṹ                                    */
/* ========================================================================== */
DECLARE_GLOBAL_DATA_PTR;


/* ========================================================================== */
/*                                                                  */
/* ========================================================================== */

extern int get_partinfo(struct boot_mtd_partition *mtd_parts, u32 offset);


/*******************************************************************************
*   : UBOOT_loadKernel
*     :
*     : - pCmdtp  :
*         : - flag    :
*         : - argc    :
*         : - ppArgv[]:
*     : 
* ֵ  : OSA_SOK  : ɹ
*           OSA_EFAIL: ʧ
*******************************************************************************/
int UBOOT_loadKernel(cmd_tbl_t *pCmdtp, int flag, int argc, char *ppArgv[])
{
    int          ret;
    unsigned int size;
    size_t       len;
    nand_info_t  *pNand;
    struct boot_mtd_partition *pPart;
    
    char           *pName     = "Kernel";
    u_char         *pDest     = (u_char *) CONFIG_SYS_LOAD_ADDR;
    image_header_t *img_heard = (image_header_t *)CONFIG_SYS_LOAD_ADDR; 

    if(argc >= 3)
    {
        pName = ppArgv[2];
    }

    if(!gd->mtd_parts)
    {
        gd->mtd_parts = malloc(sizeof(struct boot_mtd_partition) * PART_NUM);
    }
    memset(gd->mtd_parts, 0, sizeof(struct boot_mtd_partition) * PART_NUM);
    
    ret = get_partinfo(gd->mtd_parts, PARTITION_DATA_OFFSET);

    if(ret < 0)
    {
        printf("fail to get partinfo\n");
        return -1;
    }

    pPart = gd->mtd_parts;
    for(; pPart->name[0] != '\0'; pPart++)
    {
        if(!strcmp(pPart->name, pName))
        {
            break;
        }
    }

    if('\0' == pPart->name[0])
    {
        printf("can't find partation %s\n", pName);
        return -1;
    }

    if(nand_curr_device < 0 || !(&nand_info[nand_curr_device]))
    {
        printf("can't find flash devices\n");
        return -1;
    }

    pNand = &nand_info[nand_curr_device];
    len = sizeof(image_header_t);
    ret = nand_read_skip_bad(pNand, pPart->offset, &len, (u_char *) img_heard);

    if(sizeof(image_header_t) != len)
    {
        printf("read head error\n");
        return -1;
    }

    if(be32_to_cpu(img_heard->ih_magic) != IH_MAGIC)
    {
        printf("can't find uImage\n");
        return -1;
    }

    size = be32_to_cpu(img_heard->ih_size);

    if(argc >= 2)
    {
        pDest = (char *)simple_strtoul(ppArgv[1], NULL, 16);
    }
    else
    {
        pDest = (char *)CONFIG_SYS_LOAD_ADDR;
    }

    len = be32_to_cpu(img_heard->ih_size) + sizeof(image_header_t);
    ret = nand_read_skip_bad(pNand, pPart->offset, &len, pDest);
    return ret;
}

U_BOOT_CMD(
    kload,  3,  0,  UBOOT_loadKernel,
    "kload  - load uImage file from parttion\n",
    "[ partation DramDest ]\n"
    "    - load binary file from flash bank\n"
    "      with offset 'off' to DRAM Destination\n"
);

