/*
 * Command for partition
 *
 * Copyright (C) 2008 Atmel Corporation
 * Licensed under the GPL-2 or later.
 */


#include <common.h>
#include <command.h>
#include <asm/setup.h>
#include <malloc.h>

int get_partinfo(struct boot_mtd_partition *mtd_parts, u32 offset);

DECLARE_GLOBAL_DATA_PTR;

int do_partition(cmd_tbl_t * cmdtp, int flag, int argc, char *argv[])
{
    int ret;
    int i = 0;
    struct boot_mtd_partition *pMtdParts;

    if ( NULL == gd->mtd_parts)
    {
        gd->mtd_parts = malloc(sizeof(struct boot_mtd_partition) * PART_NUM);
        if ( NULL == gd->mtd_parts )
        {
            printf("can't get memory\n");
            return -1;
        }
    }

    pMtdParts  = gd->mtd_parts;
    memset(pMtdParts, 0, sizeof(struct boot_mtd_partition) * PART_NUM);
    ret = get_partinfo(pMtdParts, PARTITION_DATA_OFFSET);
    if ( ret )
    {
        printf("fail to get partinfo\n");
		gd->mtd_parts = NULL;
        free(pMtdParts);
        return -1;
    }
 
    printf("name             cs   offset             size               flag\n");
    for (i=0; i<PART_NUM; i++)
    {
        if (!pMtdParts[i].name[0])
        {
            break;
        }

        printf("%16s %4d 0x%016llx 0x%016llx 0x%08x\n",
            pMtdParts[i].name, pMtdParts[i].cs,
            pMtdParts[i].offset, pMtdParts[i].size, 
            pMtdParts[i].mask_flags);
    }

	return 0;
}

U_BOOT_CMD(
	partition,	1,	1,	do_partition,
	"print partition information",
	"partition\n"
	" - print partition information"
);

