/*******************************************************************************
* cmd_uart.c
*
* Copyright (C) 2011-2013 ZheJiang Dahua Technology CO.,LTD.
*
* Author : Liu Fanghua <liu_fanghua@dahuatech.com>
* Version: V1.0.0  2013-03-20 Create
*
* Description:
*
*       1.  Ӳ˵
*            
*       2.  ṹ˵
*           
*       3.  ʹ˵
*           
*       4.  ˵
*           
*       5.  ˵
*            
* Modification:
*    Date    :
*    Revision:
*    Author  :
*    Contents:
*******************************************************************************/
 
 
/* =================================================================== */
/*                              ͷļ                               */
/* =================================================================== */

#include <common.h>
#include <command.h>
#include <net.h>
#include <ns16550.h>
#include <exports.h>
#include <osa_types.h>


/* ========================================================================== */
/*                           Ͷ                                   */
/* ========================================================================== */

/*ڷ͸̨ߴ̨յЭֶ*/
#define AUF_UART_UMAPP_SUCCESS       "~UMAPPLS"
#define AUF_UART_UMAPP_FAILED        "~UMAPPLF"
#define AUF_UART_MAINBOOT            "~MNBBOOT"
#define AUF_UART_MAINAPP             "~MNBAPPL"
#define AUF_UART_ALARMBOOT           "~ALMBOOT"
#define AUF_UART_ALARMAPP            "~ALMAPPL"
#define AUF_UART_CAMBOOT             "~CMRBOOT"
#define AUF_UART_CAMAPP              "~CMRAPPL"
#define AUF_UART_CAMENV              "~CMRENVI"
#define AUF_UART_CAMFONT             "~CMRFONT"	
#define AUF_UART_CAMFPGA             "~CMRFPGA"
#define AUF_UART_UPDATE_CMD          "~SYSUPDT"
#define AUF_UART_ERASE_CMD           "~ERADRNS"
#define AUF_UART_FRAMEEND_CMD        "~FRAMEND"
#define AUF_UART_BOOTMEN	         "~BOOTMEN"
#define AUF_UART_IINBOOT		     "~IINBOOT"
#define AUF_UART_ERRFILE		     "~ERRFILE"
#define AUF_UART_PREPROK	         "~PREPROK"
#define AUF_UART_ERSSUCC		     "~ERSSUCC"
#define AUF_UART_ERSFAIL		     "~ERSFAIL"
#define AUF_UART_SECNERR	         "~SECNERR"
#define AUF_UART_ERRCSUM	         "~ERRCSUM"
#define AUF_UART_DATASUC	         "~DATASUC"
#define AUF_UART_DATAERR	         "~DATAERR"
#define AUF_UART_PRGFAIL		     "~PRGFAIL"
#define AUF_UART_CAMREBOOT           "~REBOOT0"

#define AUF_PTZ_BAUDRATE     		 38400
#define AUF_FRAME_LEN                1032
#define UPDATE_PROTOCOL_LEN 	     8
#define UPDATE_PRE_HEAD_LEN 	     8
#define UPDATE_RETRY_TIMES      	 5
#define AUF_MAX_UART_NUM             2
#define UART_WAIT_100MS              100000
#define UART_PACKAGE_SIZE	         (32*1024)

#define AUF_UART_CLK               	 A5S_UART1_CLK
#define AUF_UART_ADDR         		 A5S_UART1_BASE

#define AUF_UART_LSR			     (*(Uint32L *)(AUF_UART_ADDR+0x14))
#define AUF_UART_RHR         		 (*(Uint32L *)(AUF_UART_ADDR))
#define AUF_UART_THR         		 (*(Uint32L *)(AUF_UART_ADDR))

#define A5S_UART1_BASE               0x7001f000
#define A5S_UART1_CLK                24000000

#define LSR_THRE 		0x20
#define LSR_DR          0x01
extern  Uint32L  load_addr;


/* ========================================================================== */
/*                          ݽṹ                                    */
/* ========================================================================== */
/**/
typedef enum
{
	UPDATE_NONE,
	UPDATE_MAINBOOT,
	UPDATE_MAINAPPL,
	UPDATE_ALARMBOOT,
	UPDATE_ALARMAPPL,
	UPDATE_CAMBOOT,
	UPDATE_CAMAPP,
	UPDATE_CAMENV,
	UPDATE_CAMFONT,
	UPDATE_CAMSOF
}UPDateTye;

/* ̨ͷ */
typedef struct 
{
	Char ID[UPDATE_PROTOCOL_LEN];
	Uint32  BaseAddr;
	Uint32  GeneralSectorSize;
	Uint32  CodeLen;
	Uint32  TotalLen;
	Uint32  Crc;
}AUF_UartPackageHead;

/* ״̬ */
typedef enum
{
	UPDATE_PREPARING = 0,
	UPDATE_PREPARED,
	UPDATE_COMMAND_RESPONS,
	UPDATE_TYPE_RESPONS,
	UPDATE_ERASE_SUCESS,
	UPDATE_DATA_SENDING,
	UPDATE_DATA_PRGSUCCESS,
	UPDATE_SUCCESS,
	UPDATE_FAILED,
}AUF_updateState;

/* CRC */
static const Uint32 crc32_table[256] =
{
     0x00000000L, 0x77073096L, 0xee0e612cL, 0x990951baL, 0x076dc419L,
     0x706af48fL, 0xe963a535L, 0x9e6495a3L, 0x0edb8832L, 0x79dcb8a4L,
     0xe0d5e91eL, 0x97d2d988L, 0x09b64c2bL, 0x7eb17cbdL, 0xe7b82d07L,
     0x90bf1d91L, 0x1db71064L, 0x6ab020f2L, 0xf3b97148L, 0x84be41deL,
     0x1adad47dL, 0x6ddde4ebL, 0xf4d4b551L, 0x83d385c7L, 0x136c9856L,
     0x646ba8c0L, 0xfd62f97aL, 0x8a65c9ecL, 0x14015c4fL, 0x63066cd9L,
     0xfa0f3d63L, 0x8d080df5L, 0x3b6e20c8L, 0x4c69105eL, 0xd56041e4L,
     0xa2677172L, 0x3c03e4d1L, 0x4b04d447L, 0xd20d85fdL, 0xa50ab56bL,
     0x35b5a8faL, 0x42b2986cL, 0xdbbbc9d6L, 0xacbcf940L, 0x32d86ce3L,
     0x45df5c75L, 0xdcd60dcfL, 0xabd13d59L, 0x26d930acL, 0x51de003aL,
     0xc8d75180L, 0xbfd06116L, 0x21b4f4b5L, 0x56b3c423L, 0xcfba9599L,
     0xb8bda50fL, 0x2802b89eL, 0x5f058808L, 0xc60cd9b2L, 0xb10be924L,
     0x2f6f7c87L, 0x58684c11L, 0xc1611dabL, 0xb6662d3dL, 0x76dc4190L,
     0x01db7106L, 0x98d220bcL, 0xefd5102aL, 0x71b18589L, 0x06b6b51fL,
     0x9fbfe4a5L, 0xe8b8d433L, 0x7807c9a2L, 0x0f00f934L, 0x9609a88eL,
     0xe10e9818L, 0x7f6a0dbbL, 0x086d3d2dL, 0x91646c97L, 0xe6635c01L,
     0x6b6b51f4L, 0x1c6c6162L, 0x856530d8L, 0xf262004eL, 0x6c0695edL,
     0x1b01a57bL, 0x8208f4c1L, 0xf50fc457L, 0x65b0d9c6L, 0x12b7e950L,
     0x8bbeb8eaL, 0xfcb9887cL, 0x62dd1ddfL, 0x15da2d49L, 0x8cd37cf3L,
     0xfbd44c65L, 0x4db26158L, 0x3ab551ceL, 0xa3bc0074L, 0xd4bb30e2L,
     0x4adfa541L, 0x3dd895d7L, 0xa4d1c46dL, 0xd3d6f4fbL, 0x4369e96aL,
     0x346ed9fcL, 0xad678846L, 0xda60b8d0L, 0x44042d73L, 0x33031de5L,
     0xaa0a4c5fL, 0xdd0d7cc9L, 0x5005713cL, 0x270241aaL, 0xbe0b1010L,
     0xc90c2086L, 0x5768b525L, 0x206f85b3L, 0xb966d409L, 0xce61e49fL,
     0x5edef90eL, 0x29d9c998L, 0xb0d09822L, 0xc7d7a8b4L, 0x59b33d17L,
     0x2eb40d81L, 0xb7bd5c3bL, 0xc0ba6cadL, 0xedb88320L, 0x9abfb3b6L,
     0x03b6e20cL, 0x74b1d29aL, 0xead54739L, 0x9dd277afL, 0x04db2615L,
     0x73dc1683L, 0xe3630b12L, 0x94643b84L, 0x0d6d6a3eL, 0x7a6a5aa8L,
     0xe40ecf0bL, 0x9309ff9dL, 0x0a00ae27L, 0x7d079eb1L, 0xf00f9344L,
     0x8708a3d2L, 0x1e01f268L, 0x6906c2feL, 0xf762575dL, 0x806567cbL,
     0x196c3671L, 0x6e6b06e7L, 0xfed41b76L, 0x89d32be0L, 0x10da7a5aL,
     0x67dd4accL, 0xf9b9df6fL, 0x8ebeeff9L, 0x17b7be43L, 0x60b08ed5L,
     0xd6d6a3e8L, 0xa1d1937eL, 0x38d8c2c4L, 0x4fdff252L, 0xd1bb67f1L,
     0xa6bc5767L, 0x3fb506ddL, 0x48b2364bL, 0xd80d2bdaL, 0xaf0a1b4cL,
     0x36034af6L, 0x41047a60L, 0xdf60efc3L, 0xa867df55L, 0x316e8eefL,
     0x4669be79L, 0xcb61b38cL, 0xbc66831aL, 0x256fd2a0L, 0x5268e236L,
     0xcc0c7795L, 0xbb0b4703L, 0x220216b9L, 0x5505262fL, 0xc5ba3bbeL,
     0xb2bd0b28L, 0x2bb45a92L, 0x5cb36a04L, 0xc2d7ffa7L, 0xb5d0cf31L,
     0x2cd99e8bL, 0x5bdeae1dL, 0x9b64c2b0L, 0xec63f226L, 0x756aa39cL,
     0x026d930aL, 0x9c0906a9L, 0xeb0e363fL, 0x72076785L, 0x05005713L,
     0x95bf4a82L, 0xe2b87a14L, 0x7bb12baeL, 0x0cb61b38L, 0x92d28e9bL,
     0xe5d5be0dL, 0x7cdcefb7L, 0x0bdbdf21L, 0x86d3d2d4L, 0xf1d4e242L,
     0x68ddb3f8L, 0x1fda836eL, 0x81be16cdL, 0xf6b9265bL, 0x6fb077e1L,
     0x18b74777L, 0x88085ae6L, 0xff0f6a70L, 0x66063bcaL, 0x11010b5cL,
     0x8f659effL, 0xf862ae69L, 0x616bffd3L, 0x166ccf45L, 0xa00ae278L,
     0xd70dd2eeL, 0x4e048354L, 0x3903b3c2L, 0xa7672661L, 0xd06016f7L,
     0x4969474dL, 0x3e6e77dbL, 0xaed16a4aL, 0xd9d65adcL, 0x40df0b66L,
     0x37d83bf0L, 0xa9bcae53L, 0xdebb9ec5L, 0x47b2cf7fL, 0x30b5ffe9L,
     0xbdbdf21cL, 0xcabac28aL, 0x53b39330L, 0x24b4a3a6L, 0xbad03605L,
     0xcdd70693L, 0x54de5729L, 0x23d967bfL, 0xb3667a2eL, 0xc4614ab8L,
     0x5d681b02L, 0x2a6f2b94L, 0xb40bbe37L, 0xc30c8ea1L, 0x5a05df1bL,
     0x2d02ef8dL

};

/******************************************************************************* 
*      : AUF_initUart1
*        : ʼ1
*        : 
*        : 
*  ֵ    :   
*******************************************************************************/   
static void AUF_initUart1(Int32 clockDivisor)
{
	
	udelay(UART_WAIT_100MS);
	NS16550_init((NS16550_t)AUF_UART_ADDR, clockDivisor);

}


/******************************************************************************* 
*      : AUF_initUart
*        : ʼĴ
*        : 
*        : 
*  ֵ    :  
*******************************************************************************/   
static Int32 AUF_initUart(Int32 argc, Char *argv[])
{
	Int32 clockDivisor;
	Int32 uartNum = 0;

        if (argc > 1)
        {
            uartNum = simple_strtoul(argv[1], NULL, 10);
        }

	clockDivisor = (AUF_UART_CLK) /(16 * AUF_PTZ_BAUDRATE);		
	if(argc == 1)
	{
		printf("argc == 1\n");
		AUF_initUart1(clockDivisor);
	}
	else if(OSA_isTrue(argc == 2) && 
			OSA_isTrue(uartNum <= AUF_MAX_UART_NUM))
	{
		/* ƽ̨ */
	}
	else
	{
		OSA_printf("Invalied parameter!\n");
		return OSA_EFAIL;
	}

	return OSA_SOK;
}


/******************************************************************************* 
*      : AUF_serialPuts
*        : ͨڷ
*        : Ҫ͵ݺͳ
*        : 
*  ֵ    :  
*******************************************************************************/   
static void AUF_serialPuts (const  Char * pStr, Uint32 cout)
{
	Char c;

	while (cout--)
	{
		c = *pStr++;	
		while (OSA_isSuccess((AUF_UART_LSR) & LSR_THRE))
		{
		
		}
		AUF_UART_THR = c;
	}
}


/******************************************************************************* 
*      : AUF_serialGetc
*        : ͨڽһַ
*        : 
*        : յַ
*  ֵ    : յַ
*******************************************************************************/   
static Char AUF_serialGetc (void)
{
	Int32 timeLeft;
	
	while (OSA_isSuccess((AUF_UART_LSR) & LSR_DR))
	{
		/* ǰʣιʱС60sι */
		//timeLeft = time_to_wdt_reset() ;
		if((timeLeft <= 60) && (timeLeft >= 0))
		{
			//feed_wdt();
		}
	}
	return AUF_UART_RHR;
}


/******************************************************************************* 
*      : AUF_serialTstc
*        : Ե㴮Ƿ
*        : 
*        : Ƿ
*  ֵ    : Ƿ
*******************************************************************************/  
static Int32 AUF_serialTstc(void)
{
	return NS16550_tstc((NS16550_t)AUF_UART_ADDR);
}


/******************************************************************************* 
*      : AUF_crc32
*        : crc
*        : Ҫcrcݺͳ
*        : crcֵ
*  ֵ    : crcֵ
*******************************************************************************/  
static Uint32 AUF_crc32(Uint32 val, const void *pBuf, Int32 len)
{
     const Char *pStr = (const Char *)pBuf;
     Int32      i     = 0;

     for (i = 0; i < len; i++)
     {
         val = crc32_table[(val ^ *pStr++) & 0xff] ^ (val >> 8);
     }   

     return val;
}


/******************************************************************************* 
*      : AUF_readApply
*        : Ӵڶȡ̨ظϢ
*        : ݴŵbufcheckHead:ǷҪжͷ
*        : 
*  ֵ    : 
*******************************************************************************/  
static void AUF_readApply(Char *pRecvBuf,  Int32 checkHead)
{
	Int32 recvByteIndex  = 0;
	Int32 recvTryTimes   = 0;
	Int32 invalidCharNum = 0;
	
	while(1)  
	{
		if(AUF_serialTstc())
		{       
			pRecvBuf[recvByteIndex] = AUF_serialGetc(); 
			if((OSA_isSuccess(recvByteIndex)) 
				&& (pRecvBuf[recvByteIndex] != '~'))
			{             
				/* Ҫжͷ
				*ҪΪ˷ֹͨѶϵŶ
				*/
				if(checkHead)
				{
					invalidCharNum++;	
					if(invalidCharNum>= UPDATE_RETRY_TIMES -1)
					{
						invalidCharNum = 0;
						recvTryTimes++;
					}
				}
				recvByteIndex = 0;
			}                                                                                       
			else
			{
				recvByteIndex++;
			}
		}
		else
		{
			udelay(UART_WAIT_100MS * 2);	
			recvTryTimes++;
		}
		if((recvByteIndex >= UPDATE_PROTOCOL_LEN) 
			|| (recvTryTimes >= UPDATE_RETRY_TIMES))
		{
			break;
		}
	}
}


/******************************************************************************* 
*      : AUF_runUartUpgrade
*        : ̨ͨ򣬰Эһһִ
*        : 
*        : Ƿɹ
*  ֵ: 
*    OSA_SOK   : ɹ 
*    OSA_EFAIL : ʧܡ 
*******************************************************************************/  
static Int32 AUF_runUartUpgrade(void)
{
	/* ͨtftp */
	Char*                pDataBuf            = (Char *)load_addr;
	
	
	/* ȡݰͷ */
	AUF_UartPackageHead* pAufUartPackageHead = (AUF_UartPackageHead *)
                                                   (pDataBuf + UPDATE_PRE_HEAD_LEN);

	Char*                pUpdateBuf          = (Char *)(pAufUartPackageHead + 1);
	Uint32L              length              = NetBootFileXferSize;
	Char*                pFrameBuf           = NULL;
	Int32                curUpdateState      = UPDATE_PREPARING;
	Char                 UpdateSuccess[UPDATE_PROTOCOL_LEN];
	Char                 UpdateFailed[UPDATE_PROTOCOL_LEN];
	Char                 sendBuf[UPDATE_PROTOCOL_LEN];
	Char                 recvBuf[UPDATE_PROTOCOL_LEN + 2];
	Int32                i, j, k = 0;
	Uint32               packageTotalNum, packetFrameNum;
	Uint32               originAddr, currAddr;

	Uint32               Progress;
	Uint32               crcVal, crcCalc;	
	Uint16               checkSum;
	Uint32               CurUpdateType;
	/* CRCУ */
	crcVal   = pAufUartPackageHead->Crc;
	pAufUartPackageHead->Crc = 0;
	crcCalc  = AUF_crc32(0, (Char *)(pDataBuf + UPDATE_PRE_HEAD_LEN),
							         length - UPDATE_PRE_HEAD_LEN);
	if(crcVal != crcCalc)
	{
		OSA_printf("check crc error!\n");
		return OSA_EFAIL;
	}

	/* ȷΪֻ̨Ҫ̨֧ */
	if(OSA_isSuccess(memcmp(pAufUartPackageHead->ID, 
					AUF_UART_MAINAPP, sizeof(AUF_UART_MAINAPP)) ))
	{
		OSA_printf("Update MainApp!\n");
	}
	if(OSA_isSuccess(memcmp(pAufUartPackageHead->ID, AUF_UART_MAINBOOT, UPDATE_PROTOCOL_LEN)))
	{
		OSA_printf("Update MainBoot!\n");
		CurUpdateType = UPDATE_MAINBOOT;
		memcpy(UpdateSuccess, "~UMBOOTS", 8);
		memcpy(UpdateFailed, "~UMBOOTF", 8);
	}
	else if(OSA_isSuccess(memcmp(pAufUartPackageHead->ID, AUF_UART_MAINAPP, UPDATE_PROTOCOL_LEN)))
	{
		OSA_printf("Update MainApp!\n");
		CurUpdateType = UPDATE_MAINAPPL;
		memcpy(UpdateSuccess, "~UMAPPLS", 8);
		memcpy(UpdateFailed, "~UMAPPLF", 8);
	}
	else if(OSA_isSuccess(memcmp(pAufUartPackageHead->ID, AUF_UART_ALARMBOOT, UPDATE_PROTOCOL_LEN)))
	{
		OSA_printf("Update AlarmBoot!\n");
		CurUpdateType = UPDATE_ALARMBOOT;
		memcpy(UpdateSuccess, "~UABOOTS", 8);
		memcpy(UpdateFailed, "~UABOOTF", 8);
	}
	else if(OSA_isSuccess(memcmp(pAufUartPackageHead->ID, AUF_UART_ALARMAPP, UPDATE_PROTOCOL_LEN)))
	{
		OSA_printf("Update AlarmApp!\n");
		CurUpdateType = UPDATE_ALARMAPPL;
		memcpy(UpdateSuccess, "~UAAPPLS", 8);
		memcpy(UpdateFailed, "~UAAPPLF", 8);
	}
	/*ӶԴ󻪻о֧ */
	else if(OSA_isSuccess(memcmp(pAufUartPackageHead->ID, AUF_UART_CAMBOOT, UPDATE_PROTOCOL_LEN)))
	{
		OSA_printf("Update CamBoot!\n");
		CurUpdateType = UPDATE_CAMBOOT;
		memcpy(UpdateSuccess, "~UCBOOTS", 8);
		memcpy(UpdateFailed, "~UCBOOTF", 8);
	}
	else if(OSA_isSuccess(memcmp(pAufUartPackageHead->ID, AUF_UART_CAMAPP, UPDATE_PROTOCOL_LEN)))
	{
		OSA_printf("Update CamApp!\n");
		CurUpdateType = UPDATE_CAMAPP;
		memcpy(UpdateSuccess, "~UCAPPLS", 8);
		memcpy(UpdateFailed, "~UCAPPLF", 8);
	}
	else if(OSA_isSuccess(memcmp(pAufUartPackageHead->ID, AUF_UART_CAMENV, UPDATE_PROTOCOL_LEN)))
	{
		OSA_printf("Update CamEnv!\n");
		CurUpdateType = UPDATE_CAMENV;
		memcpy(UpdateSuccess, "~UCENVIS", 8);
		memcpy(UpdateFailed, "~~UCENVIF", 8);
	}
	else if(OSA_isSuccess(memcmp(pAufUartPackageHead->ID, AUF_UART_CAMFONT, UPDATE_PROTOCOL_LEN)))
	{
		OSA_printf("Update CamFont!\n");
		CurUpdateType = UPDATE_CAMFONT;
		memcpy(UpdateSuccess, "~UCFONTS", 8);
		memcpy(UpdateFailed, "~UCFONTF", 8);
	}
	else if(OSA_isSuccess(memcmp(pAufUartPackageHead->ID, AUF_UART_CAMFPGA, UPDATE_PROTOCOL_LEN)))
	{
		OSA_printf("Updata CamSOF!\n");
		CurUpdateType = UPDATE_CAMSOF;
		memcpy(UpdateSuccess, "~UCFPGAS", 8);
		memcpy(UpdateFailed, "~UCFPGAF", 8);
	}
	else
	{
		CurUpdateType = UPDATE_NONE;
		OSA_printf("Unknown upgrade type:%s\n", pAufUartPackageHead->ID);
		goto error;
	}

	curUpdateState = UPDATE_PREPARED;

	/*  */
	memcpy(sendBuf, AUF_UART_UPDATE_CMD, UPDATE_PROTOCOL_LEN);
	
	/* ĵַʱȫʹ1 */
	sendBuf[1] = 1;	
	
	for(i = 0; i<20; i++)
	{
		OSA_printf("Send update command\n");
		memset(recvBuf, 0, sizeof(recvBuf));

		/*  */
		AUF_serialPuts(sendBuf, UPDATE_PROTOCOL_LEN);

		OSA_printf("Send finished!\n");
		
		/* ʱ200ms */
		udelay(UART_WAIT_100MS*2);	

		/* ջظ */
		AUF_readApply(recvBuf, 1);
		recvBuf[UPDATE_PROTOCOL_LEN] = 0;
		if(OSA_isSuccess(strncmp(recvBuf, AUF_UART_BOOTMEN, 
										UPDATE_PROTOCOL_LEN) ))
		{
			/* ĿӦóУȴBOOTط */
			udelay(UART_WAIT_100MS*5);	
		}
		else if(OSA_isSuccess(strncmp(recvBuf, AUF_UART_IINBOOT, 
											UPDATE_PROTOCOL_LEN)))
		{
			curUpdateState = UPDATE_COMMAND_RESPONS;
			break;
		}
		else
		{
			OSA_printf("receive data:%s!\n", recvBuf);
			/* ȴط */
		}		
	}

	if(curUpdateState != UPDATE_COMMAND_RESPONS)
	{
		goto error;
	}
	
	/*  */
	OSA_printf("send update  type command!\n");

	AUF_serialPuts(pAufUartPackageHead->ID, UPDATE_PROTOCOL_LEN);

	for(i = 0; i < 20; i++)
	{
		memset(recvBuf, 0, sizeof(recvBuf));

		udelay(UART_WAIT_100MS*10);
		/* ջظ */
		AUF_readApply(recvBuf, 0);
		
		recvBuf[UPDATE_PROTOCOL_LEN] = 0;
		if(OSA_isSuccess(strncmp(recvBuf, AUF_UART_ERRFILE,
					UPDATE_PROTOCOL_LEN)))
		{
			OSA_printf("Receive:%s!\n", recvBuf);
		}
		else if(OSA_isSuccess(strncmp(recvBuf, 
					AUF_UART_PREPROK, UPDATE_PROTOCOL_LEN)))
		{
			curUpdateState = UPDATE_TYPE_RESPONS;
			break;
		}
		else
		{
			OSA_printf("receive data:%s!\n", recvBuf);
		}		
	}
	
	if(curUpdateState != UPDATE_TYPE_RESPONS)
	{
		goto error;
	}

	/*3Ͳ*/
	/*׼	*/
	OSA_printf("send erase command!\n");
	originAddr = pAufUartPackageHead->BaseAddr;
	checkSum   = 0;

	memcpy(sendBuf, AUF_UART_ERASE_CMD, sizeof(AUF_UART_ERASE_CMD));

	sendBuf[3] = originAddr & 0xff;
	sendBuf[4] = ((originAddr>>8) & 0xff);
		/*ǻоflash ַֽڸΪֽ֡*/
	if ((CurUpdateType==UPDATE_CAMBOOT)||(CurUpdateType==UPDATE_CAMAPP)
		||(CurUpdateType==UPDATE_CAMENV)||(CurUpdateType==UPDATE_CAMFONT)
		||(CurUpdateType == UPDATE_CAMSOF))
	{
		sendBuf[5] = (Char)(((pAufUartPackageHead->CodeLen / pAufUartPackageHead->GeneralSectorSize)>>8) & 0x00ff);
		sendBuf[6] = (Char)((pAufUartPackageHead->CodeLen / pAufUartPackageHead->GeneralSectorSize)&0x00ff);
		packetFrameNum = pAufUartPackageHead->CodeLen / pAufUartPackageHead->GeneralSectorSize;	
	}
	else
	{
		sendBuf[5] = (originAddr>>16) & 0xff;
		sendBuf[6] = pAufUartPackageHead->CodeLen / pAufUartPackageHead->GeneralSectorSize;
		packetFrameNum = sendBuf[6];
	}
	

	for(i = 0; i < 7; i++)
	{
		checkSum += sendBuf[i];
	}
	sendBuf[7] = checkSum ^ 0xff;

	/*  */
	AUF_serialPuts(sendBuf, UPDATE_PROTOCOL_LEN);

	for(i = 0; i < 1000; i++)
	{
		memset(recvBuf, 0, sizeof(recvBuf));

		udelay(UART_WAIT_100MS);

		/* ջظ */
		AUF_readApply(recvBuf, 0);
		
		recvBuf[UPDATE_PROTOCOL_LEN] = 0;

		if(OSA_isSuccess(strncmp(recvBuf, AUF_UART_ERSSUCC, 
						UPDATE_PROTOCOL_LEN)))
		{
			curUpdateState = UPDATE_ERASE_SUCESS;
			OSA_printf("recv ~ERSSUCC\n");
			break;
		}
		else if(OSA_isSuccess(strncmp(recvBuf, 
							AUF_UART_ERSFAIL, UPDATE_PROTOCOL_LEN)) ||
			    OSA_isSuccess(strncmp(recvBuf, 
								AUF_UART_SECNERR, UPDATE_PROTOCOL_LEN)))
		{
			OSA_printf("rec :%s\n", recvBuf);
			goto error;
		}
		else if(OSA_isSuccess(strncmp(recvBuf, AUF_UART_ERRCSUM, 
								UPDATE_PROTOCOL_LEN)))
		{
			AUF_serialPuts(sendBuf, UPDATE_PROTOCOL_LEN);
		}
		else
		{
			OSA_printf("receive data:%s!\n", recvBuf);
		}		
	}

	if(curUpdateState != UPDATE_ERASE_SUCESS)
	{
		goto error;
	}
	/* 4֡ */
	OSA_printf("send data frame!\n");
	pFrameBuf  = (Char *)malloc(AUF_FRAME_LEN);

	originAddr = pAufUartPackageHead->BaseAddr;

	/* ȡȡܵİ */
	if(length%UART_PACKAGE_SIZE)
	{
		packageTotalNum =  length/UART_PACKAGE_SIZE;
	}
	else
	{
		packageTotalNum =  length/UART_PACKAGE_SIZE + 1;
	}
	
	/* ѭ֡ÿѭһ֡ */
	for(i = 0; i < packetFrameNum; i++)
	{
		curUpdateState = UPDATE_DATA_SENDING;
		memset(pFrameBuf, 0xff, AUF_FRAME_LEN);
		
		currAddr = i * pAufUartPackageHead->GeneralSectorSize + originAddr;

		pFrameBuf[0] = ':';
		pFrameBuf[1] = currAddr & 0xff;
		pFrameBuf[2] = (currAddr >>8) & 0xff;
		pFrameBuf[3] = (currAddr>>16) & 0xff;
		
		checkSum     = 0;
		checkSum    += ':';
		checkSum    += pFrameBuf[1];
		checkSum    += pFrameBuf[2];
		checkSum    += pFrameBuf[3];

		for(j = 0; j < pAufUartPackageHead->GeneralSectorSize; j++)
		{
			pFrameBuf[4 + j] = *pUpdateBuf;
			checkSum        += *pUpdateBuf;
			pUpdateBuf++;
			
			/* 8ΪDH-UPMCU  28: Head size */
			if (OSA_isSuccess((i*1024+j+1+8+28)%UART_PACKAGE_SIZE))  
			{
				k++;
				pUpdateBuf = pDataBuf +UART_PACKAGE_SIZE * k;

				if (k > (packageTotalNum))
				{
					OSA_printf("k=%d > PackageTotalNum=%d Error!\n",
								k, packageTotalNum);
					goto error;
				}
			}
		}
		pFrameBuf[1028] = checkSum & 0xff;
		pFrameBuf[1029] = (checkSum & 0xff00)>>8;
		AUF_serialPuts(pFrameBuf, 1030);
		for(j = 0; j < 10; j++)
		{
			memset(recvBuf, 0, sizeof(recvBuf));

			udelay(UART_WAIT_100MS);
			/* ջظ */
			AUF_readApply(recvBuf, 0);
			recvBuf[UPDATE_PROTOCOL_LEN] = 0;
			if(OSA_isSuccess(strncmp(recvBuf, AUF_UART_DATASUC, 
							UPDATE_PROTOCOL_LEN)))
			{
				/*  */
				Progress = (i + 1) * 1024;
				curUpdateState = UPDATE_DATA_PRGSUCCESS;
				OSA_printf("upgrade:%ld%%!\n", ((Progress)* 100)/length);
				break;
			}
			else if(OSA_isSuccess(strncmp(recvBuf, AUF_UART_DATAERR, 
								UPDATE_PROTOCOL_LEN)))
			{
				OSA_printf("the %dth frame check err resend!\n", i+1);
				AUF_serialPuts(pFrameBuf, 1030);
			}
			else if(OSA_isSuccess(strncmp(recvBuf, AUF_UART_PRGFAIL,
								UPDATE_PROTOCOL_LEN)))
			{
				OSA_printf("the %dth frame program failed!\n", i+1);
				free(pFrameBuf);
				goto error;
			}
			else
			{
				OSA_printf("receive data:%s!\n", recvBuf);
			}
		}
		if(curUpdateState != UPDATE_DATA_PRGSUCCESS)
		{
			free(pFrameBuf);
			goto error;
		}	
	}
	
	/* ͷڴ */
	free(pFrameBuf);

	/* 5 */
	fprintf(stderr, "send update end command!\n");

	AUF_serialPuts(AUF_UART_FRAMEEND_CMD, UPDATE_PROTOCOL_LEN);
	for(i = 0; i < 5; i++)  
	{
		memset(recvBuf, 0, sizeof(recvBuf));

		udelay(UART_WAIT_100MS*10);

		/* ջظ */
		AUF_readApply(recvBuf, 0);
		
		recvBuf[UPDATE_PROTOCOL_LEN] = 0;
		if(OSA_isSuccess(strncmp(recvBuf, 
						UpdateSuccess, UPDATE_PROTOCOL_LEN)))
		{
			curUpdateState = UPDATE_SUCCESS;
			OSA_printf("send frames success, receive data:%s!\n", recvBuf);
			break;
		}
		else if(OSA_isSuccess(strncmp(recvBuf, 
							UpdateFailed, UPDATE_PROTOCOL_LEN)))
		{
			OSA_printf("update failed!\n");
			goto error;
		}
		else
		{
			OSA_printf("receive data:%s!\n", recvBuf);
		}
	}
	
	if(curUpdateState != UPDATE_SUCCESS)
	{
		goto error;
	}
	
	if ((CurUpdateType==UPDATE_CAMBOOT)||(CurUpdateType==UPDATE_CAMAPP)
		||(CurUpdateType==UPDATE_CAMENV)||(CurUpdateType==UPDATE_CAMFONT)
		||(CurUpdateType == UPDATE_CAMSOF))
	{
		udelay(UART_WAIT_100MS*10);
		AUF_serialPuts(AUF_UART_CAMREBOOT, UPDATE_PROTOCOL_LEN);
	}

	OSA_printf("uart update success!wait 5s for MCU restart!!!\n");
	udelay(UART_WAIT_100MS*50);
	return OSA_SOK;

error:
	OSA_printf("Uart upgrade error!\n");
	return OSA_EFAIL;
	
}


/******************************************************************************* 
*      : AUF_upgradeUart
*        : ̨
*        : 
*        : Ƿɹ
*  ֵ: 
*    OSA_SOK   : ɹ 
*    OSA_EFAIL : ʧܡ
*******************************************************************************/   
static Int32 AUF_upgradeUart(cmd_tbl_t *cmdtp,  Int32 argc, Char *argv[])
{
	Int32 status;
	AUF_initUart(argc, argv);
	status = AUF_runUartUpgrade();
	if(status < 0)
	{
		OSA_printf("Upgrade to uart error!\n");	
		return OSA_EFAIL;
	}
	
	return OSA_SOK;
}


/******************************************************************************* 
*      : do_uartUp
*        : uartUpʵֺ
*        : 
*        : Ƿɹ
*  ֵ: 
*    OSA_SOK   : ɹ 
*    OSA_EFAIL : ʧܡ
*******************************************************************************/   
Int32 Auf_uartUp (cmd_tbl_t *pCmdtp, Int32 flag, Int32 argc, Char *argv[])
{
	return AUF_upgradeUart (pCmdtp, argc, argv);
}


U_BOOT_CMD
(
	uartUp,	2,	1,	Auf_uartUp,
	"uartUp- update image via uart using uart4\n",
	"uartUp uartNum\n"
);

