/**
 * system/src/bld/cmd_usbdl.c
 *
 * History:
 *    2005/09/27 - [Arthur Yang] created file
 *
 * Copyright (C) 2004-2005, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */
 
 /* ========================================================================== */
 /*                              ͷļ                                      */
 /* ========================================================================== */
#include <common.h>
#include <command.h>
#include <net.h>
#include <miiphy.h>
#include <malloc.h>
#include <net.h>
#include <netdev.h>
#include <asm/errno.h>
#include <asm/io.h>
#include <miiphy.h>

#include <config.h>
#include <asm/arch/ambhw/chip.h>
#include <asm/arch/basedef.h>
#include <asm/arch/ambhw/eth.h>
#include <asm/arch/netdev/tftp.h>
#include <asm/arch/bldnet.h>
#include <asm/arch/bldfunc.h>
#include <asm/arch/hwusbreg.h>
#include <asm/arch/hwusbcfg.h>
#include <asm/arch/ambhw/ambhw.h>
#include <asm/arch/fio/firmfl.h>
#include <asm/arch/fio/firmfl_api.h>
#include <asm/arch/mem_map.h>

/* ========================================================================== */
/*                           Ͷ                                   */
/* ========================================================================== */

#define __FLDRV_IMPL__
#define DEFAULT_ADDR	CONFIG_SYS_LOAD_ADDR


/* ========================================================================== */
/*                          ݽṹ                                    */
/* ========================================================================== */

/* ========================================================================== */
/*                          ȫֱ                                    */
/* ========================================================================== */

extern int changed_to_ext_pll;


/* ========================================================================== */ 
/*                                                                  */ 
/* ========================================================================== */
extern void init_usb_pll(void);


/* ========================================================================== */
/*                                                                  */
/* ========================================================================== */ 
/******************************************************************************* 
*     : cmd_usbdl
*       : usb
*       : cmdtp: ubootṹ
*           : flag1:
*           : argc: usb
*           : argv: usb
*       : ޡ
*  ֵ   : 0: ɹ 0:ʧ
*******************************************************************************/
static int CMD_usbdl(cmd_tbl_t * cmdtp, int flag1,
                         int argc, char *argv[])
{
    u32 addr = DEFAULT_ADDR;
    int len;
    int flag = 0;
    int exec = 0;

    /* Parameters parsing */
    if ((argc == 2) || (argc == 3))
    {
        /* Check argv[1] */
        if (strcmp(argv[1], "fwprog") == 0) 
        {
            exec = 1;
            flag |= USB_FLAG_FW_PROG;
        } 
        else if(strcmp(argv[1], "ext") == 0) 
        {
            printf("Using external osc for USB\r\n");
            changed_to_ext_pll = 1;
            return 0;
        } 
        else if(strcmp(argv[1], "kernel") == 0)
        {
            exec = 1;
            flag |= USB_FLAG_KERNEL;
        } 
        else if(strcmp(argv[1], "upload") == 0) 
        {
            flag |= USB_FLAG_UPLOAD;
        } 
        else if(strcmp(argv[1], "test") == 0) 
        {
            /* Check argv[2] */
            if (argc == 2)
            {
                flag |= USB_FLAG_TEST_DOWNLOAD;
            }
            else 
            {
                if (strcmp(argv[2], "download") == 0)
                {
                    flag |= USB_FLAG_TEST_DOWNLOAD;
                }
                else if(strcmp(argv[2], "pll") == 0)
                {
                    flag |= USB_FLAG_TEST_PLL;
                }
                else 
                {
                    printf("Invalid test\r\n");
                    return -1;
                }
            }
        } 
        else 
        {

            addr = simple_strtoul(argv[1],NULL,0);
            if ((addr < DRAM_START_ADDR
)
                || (addr >= DRAM_START_ADDR + DRAM_SIZE))
            {
                printf("Invalid hex address\r\n");
                return -2;
            }
            if ((argc == 3) && ((strcmp(argv[2], "exec") == 0) 
                    || (strcmp(argv[2], "1") == 0)))
            {
                exec = 1;
            }
            flag |= USB_FLAG_MEMORY;
        }
    } 
    else if (argc == 1) 
    {
        flag |= USB_FLAG_MEMORY;
    }
    else
    {
        printf("Invalid parameter\r\n");
        return -3;
    }

    /* TIMER1 ISR seems to corrupt usb xmit/recv
    * disable TIMER1 during running USB task */

    vic_disable(TIMER1_INT_VEC);

    init_usb_pll();
    len = USB_download((void *)addr, exec, flag);

    vic_enable(TIMER1_INT_VEC);

    if (len < 0) 
    {
        printf("\r\ntransfer failed!\r\n");
        return len;
    }

	return 0;
}


U_BOOT_CMD(
	usbdl,	3,	1,	CMD_usbdl,
	"The command execute actions over USB\r\n",
	"usbdl (Perform actions controlled by Host)\r\n"
	"usbdl ADDRESS exec (Download image to target address and execute it)\r\n"
	"usbdl fwprog (Download firware and program it into flash)\r\n"
	"usbdl ext (Turn on USB external clock)\r\n"
	"usbdl kernel (Download kernel files and execute it)\r\n"
	"usbdl upload (Upload data to Host by host's request)\r\n"
	"usbdl test [download | pll] (Test download or dll power-on/off)\r\n"
);



