/**
 * system/src/bld/eth.c
 *
 * Networking support in AMBoot.
 *
 * History:
 *    2006/10/18 - [Charles Chiou] created file
 *
 * Copyright (C) 2004-2006, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#include <common.h>
#include <command.h>
#include <net.h>
#include <miiphy.h>
#include <malloc.h>
#include <net.h>
#include <netdev.h>
#include <asm/errno.h>
#include <asm/io.h>
#include <miiphy.h>

#include <config.h>
#include <asm/arch/ambhw/chip.h>
#include <asm/arch/basedef.h>
#include <asm/arch/ambhw/eth.h>
#include <asm/arch/netdev/tftp.h>
#include <asm/arch/bldnet.h>
#include <asm/arch/bldfunc.h>
#include <asm/arch/ambhw/intvec.h>
#include <osa_types.h>

DECLARE_GLOBAL_DATA_PTR;

#define RESET_7221_GPIO           (32)


#define SWITCH_88E6240_ID         (0x240)
#define SWITCH_ID_ADDR            (0x10)
#define SWITCH_ID_REG             (3)
#define SWITCH_ID_OFFSET          (4)
#define SWITCH_PORT_FWD           (0x3)
#define SWITCH_88E6240_MAX_PORT   (7)
#define SWITCH_88E6240_PORT_BASE  (0x10)
#define SWITCH_88E6240_PAGE_REG   (0x16)
#define SWITCH_88E6240_PORT_STATE   (0x4)

#define SWITCH_PORT_CTRL   (0x1)
#define SWITCH_LINK_SPEED_DUPLEX (BIT0 | BIT1 | BIT2 | BIT3 | BIT4 | BIT5)
#define SWITCH_SPEED_100         (BIT0)
#define SWITCH_SPEED_1000        (BIT1)
#define SWITCH_FORCE_LINK        (BIT4)
#define SWITCH_FORCE_LINK_UP     (BIT5)
#define SWITCH_FORCE_DUPLEX      (BIT2)
#define SWITCH_FORCE_DUPLEX_FULL (BIT3)




#define SWITCH_88E6240_PORT4_PHY_ADDR  (0xF)
#define SWITCH_88E6240_PORT4_UP        (BIT11)


extern void NetReceive(volatile uchar * inpkt, int len);

extern int amb_gpio_direction_output(int gpio, int value);
extern int amb_gpio_set(int gpio, int value);


#define regw32(off,v) writel(v, dev->regbase + off)

bld_net_if_t net_if __attribute__ ((aligned(32)));
static bld_eth_dev_t *G_eth_dev = NULL;

static Bool gIsReset7221Flag = OSA_FALSE;
#if 0
/**
 * Interrupt handler
 */
void eth_handler(void)
{
	bld_eth_dev_t *dev = G_eth_dev;
	u32 status;

	if (dev == NULL)
		return;

	vic_disable(dev->irq);

	status = readl(dev->regbase + ETH_DMA_STATUS_OFFSET);

	if (status & ETH_DMA_STATUS_FBI) {
		/* Fatal bus error */
		dev->isr.fbi++;
	}

	if (status & ETH_DMA_STATUS_RI) {
		/* Normal receive interrupt */
		int i;
		int fp, lp;
		ethhdr_t *ethhdr;
		int ep_len;

		dev->isr.rx++;

		fp = dev->rx_cur;
		lp = (fp - 1 + BOARD_ETH_RX_FRAMES) % BOARD_ETH_RX_FRAMES;


		for (i = fp; i != lp; i = (i + 1) % BOARD_ETH_RX_FRAMES) {
			dev->rx_cur = i;

			_clean_flush_d_cache();

			if ((dev->rxd[i].status & ETH_RDES0_OWN) == 0x0) {
				ethhdr = (ethhdr_t *) dev->rxd[i].buffer1;
				ep_len = ETH_RDES0_FL(dev->rxd[i].status);
				ep_len -= 4;  /* Strip the 4 byte CRC */

				switch (ntohs(ethhdr->type)) {
				case 0x0806:	/* ARP */
					dev->nif->handle_arp(dev->nif,
						ethhdr, ep_len);
					break;
				case 0x0800:	/* IP */
					dev->nif->handle_ip(dev->nif,
						ethhdr, ep_len);
					break;
				default:
					break;
				}

				dev->rxd[i].status = ETH_RDES0_OWN;
				_clean_d_cache();
			} else {
				/* Break the loop if next descriptor is owned
				by DMA */
				break;
			}
		}
	}

	if (status & ETH_DMA_STATUS_RU) {
		/* Receive underflow */
		int i;

		dev->isr.ru++;
		for (i = 0; i < BOARD_ETH_RX_FRAMES; i++) {
			dev->rxd[i].status = ETH_RDES0_OWN;
		}
		_clean_flush_d_cache();
	}

	if (status & (ETH_DMA_STATUS_ERI | ETH_DMA_STATUS_RWT |
		ETH_DMA_STATUS_OVF)) {
		/* Abnormal receive interrupt */
		dev->isr.rerr++;
	}

	if (status & ETH_DMA_STATUS_RPS) {
		/* Receiver stoppped */
	}

	if (status & ETH_DMA_STATUS_TI) {
		/* Normal transmit interrupt */
		dev->isr.tx++;
	}

	if (status & ETH_DMA_STATUS_TU) {
		/* Transmit underflow interrupt */
		dev->isr.tu++;
	}

	if (status & (ETH_DMA_STATUS_ETI | ETH_DMA_STATUS_UNF |
		ETH_DMA_STATUS_TJT)) {
		/* Abnormal transmit interrupt */
		dev->isr.terr++;
	}

	if (status & ETH_DMA_STATUS_TPS) {
		/* Transmit stopped */
	}

	regw32(ETH_DMA_STATUS_OFFSET, status);
	vic_ackint(dev->irq);
	vic_enable(dev->irq);
}

static void *eth_get_tx_frame_buf(struct bld_eth_dev_s *dev)
{
	if (dev == NULL)
		return NULL;

	return dev->tx[dev->tx_cur].buf;
}
#endif


extern int amb_gpio_direction_output(int gpio, int value);

/*******************************************************************************
*   : SW_enable
*     : ʹswitch
*     : - void:
*     : 
* ֵ  : OSA_SOK  : ɹ
*           OSA_EFAIL: ʧ
*******************************************************************************/
static int SW_enable(void)
{
    int i;
    int ret = 0;
    unsigned short	val   = 0;
    char		    *pDev = NULL;

    /* use current device */
	pDev = miiphy_get_current_dev();

    /* ʹÿ˿ */
    for (i = 0; i < SWITCH_88E6240_MAX_PORT; i++)
    {
        ret |= SMI_read(pDev, SWITCH_88E6240_PORT_BASE + i, 
                            SWITCH_88E6240_PORT_STATE, &val);

        val &= (~SWITCH_PORT_FWD);
        val |= SWITCH_PORT_FWD;
        ret |= SMI_write(pDev, SWITCH_88E6240_PORT_BASE + i, 
                            SWITCH_88E6240_PORT_STATE, val);

        /* Ϊ5ſڵPHYܽPHY״̬ͬ5ſڵMAC㣬ǿƽUP,˫ǧ */
        if (5 == i)
        {
            ret |= SMI_read(pDev, SWITCH_88E6240_PORT_BASE + i, 
                            SWITCH_PORT_CTRL, &val);

            val &= (~SWITCH_LINK_SPEED_DUPLEX);
            val |= SWITCH_SPEED_1000 | SWITCH_FORCE_LINK | 
                   SWITCH_FORCE_LINK_UP | SWITCH_FORCE_DUPLEX | 
                   SWITCH_FORCE_DUPLEX_FULL;
            
            ret |= SMI_write(pDev, SWITCH_88E6240_PORT_BASE + i, 
                                SWITCH_PORT_CTRL, val);
        }

        /* Ϊ6ſڵPHYܽPHY״̬ͬ6ſڵMAC㣬ǿƽUP,˫ */
        if (6 == i)
        {
            ret |= SMI_read(pDev, SWITCH_88E6240_PORT_BASE + i, 
                            SWITCH_PORT_CTRL, &val);

            val &= (~SWITCH_LINK_SPEED_DUPLEX);
            val |= SWITCH_SPEED_100 | SWITCH_FORCE_LINK | 
                   SWITCH_FORCE_LINK_UP | SWITCH_FORCE_DUPLEX | 
                   SWITCH_FORCE_DUPLEX_FULL;
            
            ret |= SMI_write(pDev, SWITCH_88E6240_PORT_BASE + i, 
                                SWITCH_PORT_CTRL, val);
        }
    }

    /* 4ſĬdownUP */
    /* ģpage 1pageĴд1 */
    ret |= SMI_writePhy(pDev, SWITCH_88E6240_PORT4_PHY_ADDR, 
                        SWITCH_88E6240_PAGE_REG, 0x1);

    /* ƼĴ0żĴ */
    ret |= SMI_readPhy(pDev, SWITCH_88E6240_PORT4_PHY_ADDR, 0x0, &val);

    val &= (~SWITCH_88E6240_PORT4_UP);
    ret |= SMI_writePhy(pDev, SWITCH_88E6240_PORT4_PHY_ADDR, 0x0, val);

    /* PAGEĴԭΪ0 */
    ret |= SMI_writePhy(pDev, SWITCH_88E6240_PORT4_PHY_ADDR, 
                        SWITCH_88E6240_PAGE_REG, 0x0);

    if (0 != ret)
    {
        return -1;
    }

    return 0;

    
}

/*******************************************************************************
*   : SW_initPort5Phy
*     : ӵ6240 switchʱҪP5ڽ⴦
*     : - void:
*     : 
* ֵ  : OSA_SOK  : ɹ
*           OSA_EFAIL: ʧ
*******************************************************************************/
static int SW_initPort5Phy(void)
{
    unsigned short	reg   = 0;
    char		    *pDev = NULL;

    /* use current device */
	pDev = miiphy_get_current_dev();
    
    /*PHY Init*/    
    miiphy_write(pDev, 1, 22, 0x00FF);
    
    miiphy_write(pDev, 1, 17, 0x214B);
    
    miiphy_write(pDev, 1, 16, 0x2144);
    
    miiphy_write(pDev, 1, 17, 0x0C28);
    
    miiphy_write(pDev, 1, 16, 0x2146);
    
    miiphy_write(pDev, 1, 17, 0xB233);
    
    miiphy_write(pDev, 1, 16, 0x214D);
    
    miiphy_write(pDev, 1, 17, 0xCC0C);
    
    miiphy_write(pDev, 1, 16, 0x2159);
    
    miiphy_write(pDev, 1, 22, 0);
    
     
    
    /*RGMII RX_CLK improviment if using internal regulator*/
    
    miiphy_write(pDev, 1, 22, 0x0012);
    
    miiphy_write(pDev, 1, 20, 0x0820);
    
    miiphy_write(pDev, 1, 22, 0x0000);
    
    miiphy_write(pDev, 1, 9,  0x1F00);
    
    miiphy_write(pDev, 1, 0,  0x9140);
    
    miiphy_write(pDev, 1, 22, 0x00FA);
    
    miiphy_write(pDev, 1, 7,  0x020A);
    
    miiphy_write(pDev, 1, 25, 0x80FF);
    
    miiphy_write(pDev, 1, 26, 0x80FF);
    
    miiphy_write(pDev, 1, 22, 0x00FB);
    
    miiphy_write(pDev, 1, 6,  0x008F);
    
    miiphy_write(pDev, 1, 22, 0x00FC);
    
    miiphy_write(pDev, 1, 11, 0x0039);
    
    miiphy_write(pDev, 1, 22, 0x0000);
    
     
    
    /* Set RGMII delay */
    
    miiphy_write(pDev,  1, 22, 2);
    
    miiphy_read(pDev,  1, 21, &reg);
    
    reg |= (BIT5 | BIT4);
    
    miiphy_write(pDev, 1, 21, reg);
    
    miiphy_write(pDev, 1, 22, 0);
    
     
    
    /* Set Mode to 010 */
    
    miiphy_write(pDev, 1, 22, 0x0012);
    
    miiphy_write(pDev, 1, 20, 0x0002);
    
    miiphy_write(pDev, 1, 20, 0x8002);
    
    miiphy_write(pDev, 1, 22, 0);
    
     
    
    /* reset the phy */
    
    miiphy_write(pDev, 1, 22, 1);
    
    miiphy_read(pDev, 1, 0, &reg);
    
    reg |= BIT15;
    
    miiphy_write(pDev,  1, 0, reg);

    miiphy_write(pDev, 1, 22, 0);

    return 0;
    
}


/*******************************************************************************
*   : SW_is6240
*     : жǲǽӵ6240Sitch
*     : - void:
*     : 
* ֵ  : OSA_SOK  : ɹ
*           OSA_EFAIL: ʧ
*******************************************************************************/
static int SW_is6240(void)
{
    int             ret;
    char            *pDev   = NULL;
    unsigned short	data    = 0;

    pDev = miiphy_get_current_dev();
    ret = SMI_read(pDev, SWITCH_ID_ADDR, SWITCH_ID_REG, &data);
    if ((0 == ret) && (SWITCH_88E6240_ID == (data >> SWITCH_ID_OFFSET)))
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

static int eth_is_miitoswitch(void)
{
    int             ret;
    char            *env    = NULL;
    
    env = getenv("HWID");

    if ((env) && (NULL != strstr(env, "IPC-KW100A-R")))
    {
        if (OSA_FALSE == gIsReset7221Flag)
        {
            ret = amb_gpio_direction_output(RESET_7221_GPIO, 0);

            /* 20ms */
            udelay(20000); 
            ret += amb_gpio_set(RESET_7221_GPIO, 1);
            if (ret)
            {
                printf("reset 7221 failed!\n");
            }

            gIsReset7221Flag = OSA_TRUE;

            printf("reset 7221 success!\r\n");
        
            /* ʱ3֣phyЭ */
            udelay(3000000);
        }
        
        return 1;
    }
    else if (SW_is6240())
    {
        return 1;       
    }
    else
    {
        return 0;
    }
}

static int eth_send_frame(struct bld_eth_dev_s *dev, int framelen)
{
	if (dev == NULL)
		return -1;

	dev->txd[dev->tx_cur].status |= ETH_TDES0_OWN;
	dev->txd[dev->tx_cur].length &= (~0x7ff);
	dev->txd[dev->tx_cur].length |= ETH_TDES1_TBS1(framelen);

	_clean_flush_d_cache();

	regw32(ETH_DMA_TX_POLL_DMD_OFFSET, 0x1);

	dev->tx_cur = (dev->tx_cur + 1) % BOARD_ETH_TX_FRAMES;

	return 0;
}

static void eth_stop_rx_tx(struct bld_eth_dev_s *dev)
{
	u32					dma_status;
	u32					i = 120000;

	regw32(ETH_MAC_CFG_OFFSET,
		(readl(dev->regbase + ETH_MAC_CFG_OFFSET) & ~ETH_MAC_CFG_RE));
	regw32(ETH_DMA_OPMODE_OFFSET,
		(readl(dev->regbase + ETH_DMA_OPMODE_OFFSET) &
		~(ETH_DMA_OPMODE_SR | ETH_DMA_OPMODE_ST)));
	do {
		dma_status = readl(dev->regbase + ETH_DMA_STATUS_OFFSET);
	} while ((dma_status & (ETH_DMA_STATUS_TS_MASK |
		ETH_DMA_STATUS_RS_MASK)) && --i);
	regw32(ETH_MAC_CFG_OFFSET,
		(readl(dev->regbase + ETH_MAC_CFG_OFFSET) & ~ETH_MAC_CFG_TE));
}

static void eth_reset_dma(struct bld_eth_dev_s *dev)
{
	u32					dma_busmode;
	u32					i = 3000;

	regw32(ETH_DMA_BUS_MODE_OFFSET, ETH_DMA_BUS_MODE_SWR);
	do {
		dma_busmode = readl(dev->regbase + ETH_DMA_BUS_MODE_OFFSET);
	} while ((dma_busmode & ETH_DMA_BUS_MODE_SWR) && --i);
}

static int amb_mdio_read(char *devname, unsigned char addr,
			  unsigned char phy_reg, unsigned short *data)
{
    
	u32 val;
	u32 retry_counter = 1000;

	val = (ETH_MAC_GMII_ADDR_PA(addr) | ETH_MAC_GMII_ADDR_GR(phy_reg) |
		ETH_MAC_GMII_ADDR_CR_250_300MHZ |
		ETH_MAC_GMII_ADDR_GB);
	writel(val,ETH_BASE + ETH_MAC_GMII_ADDR_OFFSET);

	do {
		val = readl(ETH_BASE + ETH_MAC_GMII_ADDR_OFFSET);
		if (retry_counter == 0)
			return -1;
		retry_counter--;
	} while ((val & ETH_MAC_GMII_ADDR_GB) == ETH_MAC_GMII_ADDR_GB);
	
	*data = (readl(ETH_BASE + ETH_MAC_GMII_DATA_OFFSET) & 0xffff);
    return 0;
}

static int amb_mdio_write(char *devname, unsigned char addr,
			   unsigned char phy_reg, unsigned short data)
{
    u32 val;
	u32 retry_counter = 1000;

	val = data & 0xffff;
	writel(val, ETH_BASE + ETH_MAC_GMII_DATA_OFFSET);
	val = (ETH_MAC_GMII_ADDR_PA(addr) | ETH_MAC_GMII_ADDR_GR(phy_reg) |
		ETH_MAC_GMII_ADDR_CR_250_300MHZ |
		ETH_MAC_GMII_ADDR_GW |
		ETH_MAC_GMII_ADDR_GB);
	writel(val,ETH_BASE + ETH_MAC_GMII_ADDR_OFFSET);

	do {
		val = readl(ETH_BASE + ETH_MAC_GMII_ADDR_OFFSET);
		if (retry_counter == 0)
			return -1;
		retry_counter--;
		udelay(10);
	} while ((val & ETH_MAC_GMII_ADDR_GB) == ETH_MAC_GMII_ADDR_GB);
    return 0;
}


#if 0
static u16 eth_mii_read(struct bld_eth_dev_s *dev, u8 addr, u8 reg)
{
    short int data;
	if (amb_mdio_read(NULL,addr, reg, &data) == 0)
	    return data;
	return 0xffff;
}

static void eth_mii_write(struct bld_eth_dev_s *dev, u8 addr, u8 reg, u16 data)
{
	amb_mdio_write(NULL,addr,reg,data);
}

#endif

static int eth_scan_phy(void)
{
    int i = 1;
    u16 phy_reg;
    u32 phy_id;

    if (SW_is6240())
    {
        /* switchַ */
        return 2;
    }

    for (i = 0; i < 32; i++) {
        amb_mdio_read( NULL, i,PHY_PHYIDR1,&phy_reg);	//PHYSID1
        phy_id = (phy_reg & 0xffff) << 16;
        amb_mdio_read( NULL, i,PHY_PHYIDR2,&phy_reg);	//PHYSID1	//PHYSID2
        phy_id |= (phy_reg & 0xffff);
        
        if((phy_id !=0xffffffff) && ( phy_id != 0x00))
        {
            printf("PHY:0x%08x,addr:0x%02x\n",phy_id,i);
            return i;
        }
    }

	if (eth_is_miitoswitch())
	{
    	phy_id = 0x00221513;
    	i = 0;

    	printf("Virtual Phy:0x%08x,addr:0x%02x\n", phy_id, i);
	}
    return i;
}

static int eth_is_link_up(struct eth_device* dev)
{
    int phy_addr;
    struct amb_eth_priv	*priv;
    char *name = dev->name;
    unsigned short reg;

    priv = (struct amb_eth_priv *)dev->priv;
    phy_addr = priv->data.phy_addr;

    if (eth_is_miitoswitch())
	{
		return 1;
	}

    if (miiphy_read(name, phy_addr, PHY_BMSR, &reg))
    {
        return 0; /* could not read, assume no link */   
    }

    if (reg & PHY_BMSR_LS) /* link up */
    {
        return 1;
    }
    return 0;
}

static int eth_reset(struct bld_eth_dev_s *dev)
{
	eth_stop_rx_tx(dev);
	eth_reset_dma(dev);
	return 0;
}

static void ambhw_set_link_mode_speed(struct bld_eth_dev_s *dev)
{
	u32	val;
	val = readl(dev->regbase + ETH_MAC_CFG_OFFSET);

    /* 11, 14,15 bit1 */
    val |= ETH_MAC_CFG_FES | ETH_MAC_CFG_DM | ETH_MAC_CFG_PS;

	regw32(ETH_MAC_CFG_OFFSET, val);


    return;
}

/**
 * Initialize the ethernet controller.
 */
static void amb_mac_init(bld_net_if_t *nif)
{
	int i;
    bld_eth_dev_t *dev = &nif->dev;
    const u8 *hwaddr = nif->hwaddr;

	vic_disable(dev->irq);
	eth_reset_dma(dev);
	for (i = 0; i < BOARD_ETH_TX_FRAMES; i++) {
		dev->txd[i].status = 0;
		dev->txd[i].length = ETH_TDES1_IC | ETH_TDES1_LS |
			ETH_TDES1_FS | ETH_TDES1_TCH;
		dev->txd[i].buffer1 = (u32) dev->tx[i].buf;
		dev->txd[i].buffer2 = (u32) &dev->txd[(i + 1) % BOARD_ETH_TX_FRAMES];
	}

	for (i = 0; i < BOARD_ETH_RX_FRAMES; i++) {
		dev->rxd[i].status = ETH_RDES0_OWN;
		dev->rxd[i].length = ETH_RDES1_RCH |
			ETH_RDES1_RBS1x(BOARD_ETH_FRAMES_SIZE);
		dev->rxd[i].buffer1 = (u32) dev->rx[i].buf;
		dev->rxd[i].buffer2 = (u32) &dev->rxd[(i + 1) % BOARD_ETH_RX_FRAMES];
	}

	_clean_flush_d_cache();

	//dev->get_tx_frame_buf = eth_get_tx_frame_buf;
	//dev->send_frame = eth_send_frame;
	//dev->is_link_up = eth_is_link_up;
	dev->reset = eth_reset;
	dev->nif = nif;

    
    regw32(ETH_MAC_MAC0_HI_OFFSET,
            (hwaddr[5] << 8) | hwaddr[4]);
    regw32(ETH_MAC_MAC0_LO_OFFSET,
            (hwaddr[3] << 24) | (hwaddr[2] << 16) |
            (hwaddr[1] <<  8) | hwaddr[0]);
	#if 0
	regw32(ETH_MAC_MAC0_HI_OFFSET,
		(hwaddr[5] << 8) | hwaddr[4]);
	regw32(ETH_MAC_MAC0_LO_OFFSET,
		(hwaddr[3] << 24) | (hwaddr[2] << 16) |
		(hwaddr[1] <<  8) | hwaddr[0]);
	#endif	

	regw32(ETH_DMA_TX_DESC_LIST_OFFSET, (u32)dev->txd);
	regw32(ETH_DMA_RX_DESC_LIST_OFFSET, (u32)dev->rxd);

	regw32(ETH_MAC_FRAME_FILTER_OFFSET, 0x00000000);
	regw32(ETH_DMA_INTEN_OFFSET,
		ETH_DMA_INTEN_NIE | ETH_DMA_INTEN_AIE |
		ETH_DMA_INTEN_FBE | ETH_DMA_INTEN_RWE | ETH_DMA_INTEN_RUE |
		ETH_DMA_INTEN_RIE | ETH_DMA_INTEN_UNE | ETH_DMA_INTEN_OVE |
		ETH_DMA_INTEN_TJE | ETH_DMA_INTEN_TUE | ETH_DMA_INTEN_TIE);
	regw32(ETH_DMA_BUS_MODE_OFFSET, ETH_DMA_BUS_MODE_FB |
		ETH_DMA_BUS_MODE_PBL_16 | ETH_DMA_BUS_MODE_DA_RX);
	regw32(ETH_DMA_OPMODE_OFFSET, ETH_DMA_OPMODE_TTC_256 |
		ETH_DMA_OPMODE_RTC_64 | ETH_DMA_OPMODE_SR | ETH_DMA_OPMODE_ST);

	disable_interrupts();
	vic_set_type(dev->irq, VIRQ_LEVEL_HIGH);
	G_eth_dev = dev;
	regw32(ETH_MAC_CFG_OFFSET, ETH_MAC_CFG_RE |
		ETH_MAC_CFG_TE | ETH_MAC_CFG_DM | ETH_MAC_CFG_PS);
	regw32(ETH_DMA_STATUS_OFFSET,
		readl(dev->regbase + ETH_DMA_STATUS_OFFSET));
	vic_enable(dev->irq);
	//enable_interrupts();

	regw32(ETH_DMA_RX_POLL_DMD_OFFSET, 0x1);
}

void eth_filter_source_address(struct bld_eth_dev_s *dev, u8 *hwaddr)
{
	regw32(ETH_MAC_MAC1_HI_OFFSET,
		(0x3 << 30) |
		(hwaddr[5] << 8) | hwaddr[4]);
	regw32(ETH_MAC_MAC1_LO_OFFSET,
		(hwaddr[3] << 24) | (hwaddr[2] << 16) |
		(hwaddr[1] <<  8) | hwaddr[0]);
	regw32(ETH_MAC_FRAME_FILTER_OFFSET,
		ETH_MAC_FRAME_FILTER_SAF);
}

void eth_pass_source_address(struct bld_eth_dev_s *dev)
{
	regw32(ETH_MAC_MAC1_HI_OFFSET, 0x0000ffff);
	regw32(ETH_MAC_MAC1_LO_OFFSET, 0xffffffff);
	regw32(ETH_MAC_FRAME_FILTER_OFFSET, 0x00000000);
}

netdev_t dev_T;
static int amb_eth_init(struct eth_device* dev, bd_t * bis)
{
    struct amb_eth_priv	*priv = dev->priv;
    bld_net_if_t *nif = &net_if;
    int retry = 100;

    #if 0
    if (!rct_is_eth_enabled()) {
        printf("Eth isn't enabled by power on config!\r\n");
		return;
	}
	#endif
	 if (!eth_getenv_enetaddr("ethaddr", nif->hwaddr)) {
		//memcpy(&amb_eth_data.mac_addr,mac_addr,sizeof(mac_addr));
		memcpy(nif->hwaddr, priv->data.mac_addr, 6);
	}
	else
	{
	    memcpy(nif->hwaddr, priv->data.mac_addr, 6);
	}
	
	memset(&nif->dev, 0,sizeof(nif->dev));
	//nif->dev.link_speed = SPEED_100;
	//nif->dev.link_duplex = DUPLEX_FULL;
	nif->dev.regbase = priv->data.mac_base;
	nif->dev.irq = priv->data.irq;
	amb_mac_init(nif);
	if (eth_is_miitoswitch())
	{
    	ambhw_set_link_mode_speed(&(nif->dev));
	}
	/* ȴ3룬ԱPHYЭ */
	while((!eth_is_link_up(dev))&& (--retry))
	{
		udelay(30*1000);
	}

    /* ûнϻûнͨԭµЭʧʱֱ˳ */
	if (!retry)
	{
	    printf("link down\n");
	    return -1;
	}

	//eth_filter_source_address(&nif->dev,active_eth->mac);
	//eth_pass_source_address(&nif->dev);
    return 0;
}

static int amb_eth_send(struct eth_device* dev, volatile void* packet, int length)
{
    u32 status;
    int retry = 100;

    while((!eth_is_link_up(dev))&& (--retry))
    {
        udelay(30*1000);
    }
 
    if (!retry)
    {
        return -EIO;
    }
    
    G_eth_dev->txd[G_eth_dev->tx_cur].buffer1 = (u32)packet;
    eth_send_frame(G_eth_dev, length);

    retry = 10;
    status = readl(ETH_BASE + ETH_DMA_STATUS_OFFSET);
    while ((0 == (status & ETH_DMA_STATUS_TI)) && (--retry))
    {
        udelay(10*1000);
        status = readl(ETH_BASE + ETH_DMA_STATUS_OFFSET);
        if (ctrlc()) 
        {
			return -EIO;
		}        
    }

    if (!retry)
    {
        return -EIO;
    }
    
    return 0;
}

static int amb_eth_recv(struct eth_device* dev_eth)
{	
	int i;
    int fp;
    int lp;
    int ep_len;
    u32 status;
    char *p;
    int retry = 100;
    bld_eth_dev_t *dev = G_eth_dev;

    if (dev == NULL){
        return -1;
    }

    while((!eth_is_link_up(dev_eth))&& (--retry))
    {
        udelay(30*1000);
    }
 
    if (!retry)
    {
        return -EIO;
    }
    //vic_disable(dev->irq);
    
    status = readl(dev->regbase + ETH_DMA_STATUS_OFFSET);

    if (status & ETH_DMA_STATUS_RI) {
        /* Normal receive interrupt */
        dev->isr.rx++;
        fp = dev->rx_cur;
        lp = (fp - 1 + BOARD_ETH_RX_FRAMES) % BOARD_ETH_RX_FRAMES;
        for (i = fp; i != lp; i = (i + 1) % BOARD_ETH_RX_FRAMES) {
            dev->rx_cur = i;
            _clean_flush_d_cache();
            if ((dev->rxd[i].status & ETH_RDES0_OWN) == 0x0) {
            p = (char *) dev->rxd[i].buffer1;
            ep_len = ETH_RDES0_FL(dev->rxd[i].status);
            ep_len -= 4;  /* Strip the 4 byte CRC */

            NetReceive(p, ep_len);

            dev->rxd[i].status = ETH_RDES0_OWN;
            _clean_d_cache();
            } else {
                /* Break the loop if next descriptor is ownedby DMA */
                break;
            }
        }
    }

    if (status & ETH_DMA_STATUS_RU) {
        /* Receive underflow */
        dev->isr.ru++;
        for (i = 0; i < BOARD_ETH_RX_FRAMES; i++) {
            dev->rxd[i].status = ETH_RDES0_OWN;
        }
        _clean_flush_d_cache();
    }
    
#if 0
    if (status & ETH_DMA_STATUS_FBI) {
        /* Fatal bus error */
        dev->isr.fbi++;
    }
    
    if (status & (ETH_DMA_STATUS_ERI | ETH_DMA_STATUS_RWT |
    ETH_DMA_STATUS_OVF)) {
        /* Abnormal receive interrupt */
        dev->isr.rerr++;
    }

    if (status & ETH_DMA_STATUS_RPS) {
    /* Receiver stoppped */
    }

    if (status & ETH_DMA_STATUS_TI) {
        /* Normal transmit interrupt */
        dev->isr.tx++;
    }

    if (status & ETH_DMA_STATUS_TU) {
        /* Transmit underflow interrupt */
        dev->isr.tu++;
    }

    if (status & (ETH_DMA_STATUS_ETI | ETH_DMA_STATUS_UNF |
    ETH_DMA_STATUS_TJT)) {
        /* Abnormal transmit interrupt */
        dev->isr.terr++;
    }

    if (status & ETH_DMA_STATUS_TPS) {
        /* Transmit stopped */
    }
#endif
    regw32(ETH_DMA_STATUS_OFFSET, status);
    vic_ackint(dev->irq);
    vic_enable(dev->irq);

    return 0;
}

static void amb_eth_halt(struct eth_device* dev)
{
    if (G_eth_dev)
        eth_reset(G_eth_dev);
    return;
}

static void amb_mdio_init(char *name)
{
	miiphy_register(name, amb_mdio_read, amb_mdio_write);
}

int amb_eth_register(struct amb_eth_platform_data *data)
{
    int ret;
    Char            *pEnv    = NULL;
	struct amb_eth_priv	*priv;
	struct eth_device	*eth_dev;

	eth_dev = malloc(sizeof(*eth_dev));
	if (!eth_dev)
		return -ENOMEM;
	memset(eth_dev, 0, sizeof(*eth_dev));

	priv = malloc(sizeof(*priv));
	if (!priv) {
		free(eth_dev);
		return -ENOMEM;
	}
	memset(priv, 0, sizeof(*priv));
    memcpy(&priv->data,data,sizeof(struct amb_eth_platform_data));
	priv->dev  = eth_dev;

	strcpy(eth_dev->name, "ambarella mac");
	eth_dev->init	= amb_eth_init;
	eth_dev->halt	= amb_eth_halt;
	eth_dev->send	= amb_eth_send;
	eth_dev->recv	= amb_eth_recv;
	eth_dev->priv	= priv;
	amb_mdio_init(eth_dev->name);
    data->phy_addr = eth_scan_phy();
    if ((data->phy_addr >= 0) && (data->phy_addr < 32))
    {
        data->phy_init(eth_dev->name,data->phy_addr);
    }
    else if (data->phy_addr == 32)
    {
        return -1;
    }
    else
    {
        printf("wrong addr.\n");
    }

	eth_register(eth_dev);

    pEnv = getenv("HWID");
    if ((pEnv) && (NULL != strstr(pEnv, "IPC-HD3532C")))
    {   
        /* physwitchиλ */
        amb_gpio_direction_output(20, 0);
        udelay(50000); 
        amb_gpio_set(20, 1);
        udelay(50000);

        printf("reset switch success!\r\n");
    }
	
	/* 6240switch豸ȳʼP5ڵPHYоƬ */
    if (SW_is6240())
    {
        ret = SW_initPort5Phy();
        ret |= SW_enable();
        if (0 != ret)
        {
            return -1;
        }

        printf("Init switch success!\r\n");
    }
    
	return 1;
}

