#include <common.h>
#include <watchdog.h>

#include <asm/io.h>
#include <asm/arch/ambhw/chip.h>
#include <asm/arch/ambhw.h>
#include <asm/arch/bldfunc.h>

/* Źʱʱ */
#define WDT_MAX_TIMEOUT         44739  

/*******************************************************************************
*     : a5s_wdt_settimeout
*       : ÿŹʱʱ
*       : - timeout: Źʱʱ䣬λms
*       : 
*  ֵ   : 0: ɹ
*             -1: ʧ
*******************************************************************************/
static int a5s_wdt_settimeout(unsigned int timeout)
{
    unsigned int val;

    if (timeout > WDT_MAX_TIMEOUT)
    {
        timeout = WDT_MAX_TIMEOUT;
    }
    
    val = get_apb_bus_freq_hz()/1000*timeout;
    writel(val, WDOG_RELOAD_REG);
    writel(WDT_RESTART_VAL, WDOG_RESTART_REG);
    
	return 0;
}


/*******************************************************************************
*     : watchdog_reset
*       : Ź
*       : 
*       : 
*  ֵ   : 
*******************************************************************************/
void watchdog_reset(void)
{
    writel(0, WDOG_CLR_TMO_REG);

    writel(RCT_WDT_RESET_VAL, WDT_RST_L_REG);
    writel(0x2, SOFT_RESET_REG);

    writel(WDOG_CTR_EN | WDOG_CTR_RST_EN, WDOG_CONTROL_REG);
}


/*******************************************************************************
*     : watchdog_init
*       : Źʼ
*       : 
*       : 
*  ֵ   : 0: ɹ
*             -1: ʧ
*******************************************************************************/
int watchdog_init(void)
{
    a5s_wdt_settimeout(WDT_MAX_TIMEOUT);
    
    return 0;
}

