/*******************************************************************************
* crypt.h
*
* Copyright (C) 2011-2013 ZheJiang Dahua Technology CO.,LTD.
*
* Author : DAHUA
* Version: V1.0.0  2013-3-6 Create
*
* Description:A5Sƽ̨ ubootдоƬ
*       1.  Ӳ˵
*           ڼAT88SCоƬ
*
*       2.  ṹ˵
*
*       3.  ʹ˵
*
*       4.  ˵
*
*       5.  ˵
*         
* 
* Modification:
*    Date    :   2013-3-6
*    Revision:   
*    Author  :  
*    Contents:
*******************************************************************************/

#include <common.h>
#include "../include/asm/io.h"
#include "../include/asm/string.h"
#include "malloc.h"
#include "crypt.h"

#define GPIO_BASE       (0x70009000)
#define GPIO_DATA       (0x00)
#define GPIO_DIR        (0x04)
#define GPIO_AFSEL      (0x18)
#define GPIO_MASK       (0x28)
#define GPIO_ENABLE     (0x2C)

#define AT88SC_SDA  5
#define AT88SC_SCL  6

#define mdelay(a)  udelay(a*1000)

static unsigned char rwdata[0xff];

/* a5sƽ̨ gpio ʼ */
static int gpio_init(void)
{
    volatile unsigned long reg = 0x00;

    reg = 1;
    writel(reg, GPIO_BASE + GPIO_ENABLE);

    reg = readl(GPIO_BASE + GPIO_MASK);
    reg |= (1<<AT88SC_SDA);
    reg |= (1<<AT88SC_SCL);
    writel(reg, GPIO_BASE + GPIO_MASK);

    reg = readl(GPIO_BASE + GPIO_AFSEL);
    reg &= ~(1<<AT88SC_SDA);
    reg &= ~(1<<AT88SC_SCL);
    writel(reg, GPIO_BASE + GPIO_AFSEL);
    
    return 0;
}


static void gpio_write(unsigned int gpio, unsigned int value)
{
    volatile unsigned long reg = 0x00;
    
    if(gpio > 31)
    {
        printf("error: gpio_write wrong gpio!\n");
        return ;
    }
        
    reg = readl(GPIO_BASE + GPIO_DIR);
    reg |= (1<<gpio);
    writel(reg, GPIO_BASE + GPIO_DIR);

    if (value == 0)
    {
        reg = readl(GPIO_BASE + GPIO_DATA);
        reg &= ~(1<<gpio);
        writel(reg, GPIO_BASE + GPIO_DATA);
    }
    else
    {
        reg = readl(GPIO_BASE + GPIO_DATA);
        reg |= (1<<gpio);
        writel(reg, GPIO_BASE + GPIO_DATA);
    }    
    return ;
}


static void gpio_dir_input(unsigned int gpio) 
{
	volatile unsigned long reg = 0x00;

    if(gpio > 31)
    {
        printf("error: gpio_dir_input wrong gpio!\n");
        return;
    }
    
    reg = readl(GPIO_BASE + GPIO_DIR);
    reg &= ~(1<<gpio);
    writel(reg, GPIO_BASE + GPIO_DIR);

    return;
}


static int gpio_read(unsigned int gpio)
{
    volatile unsigned long reg = 0x00;

    if(gpio > 31)
    {
        return -1;
    }
        
    reg = readl(GPIO_BASE + GPIO_DATA);
    reg &= (1<<gpio);
        
	return (reg?1:0);
}


static int crypt_getChipID(unsigned char *key1, 
                               unsigned char *key2, 
                               unsigned int key_len)
{
    int retVal = 0;

    return retVal;
}


static int crypt_gpioInit(void)
{
    return gpio_init();
}


static void crypt_sclSet(void)
{
    gpio_write(AT88SC_SCL, 1);

    return;
}


static void crypt_sclClr(void)
{
    gpio_write(AT88SC_SCL, 0);

    return;
}


static void crypt_sdaSet(void)
{
    gpio_write(AT88SC_SDA, 1);

    return;
}


static void crypt_sdaClr(void)
{
    gpio_write(AT88SC_SDA, 0);

    return;
}


static void crypt_sdaIn(void)
{
    gpio_dir_input(AT88SC_SDA); 

    return;
}


static int crypt_sdaRead(void)
{
    int retVal = 0;
    crypt_sdaIn();
    udelay(5);
    retVal = gpio_read(AT88SC_SDA);
    return retVal;
}


static void crypt_udelay(unsigned long us)
{
    udelay(us);
}


static void* crypt_malloc(unsigned int len)
{
    return malloc(len);
}


static void crypt_free(void *ptr)
{
    free(ptr);

    return;
}


static int crypt_optInit(CRYPT_Operations* pOps)
{
    if(!pOps)
    {
        return -1;
    }
    
    pOps->OpGetChipId  = crypt_getChipID;
    pOps->OpInitGpio   = crypt_gpioInit;
    pOps->OpSetScl     = crypt_sclSet;
    pOps->OpClrScl     = crypt_sclClr;
    pOps->OpSetSda     = crypt_sdaSet;
    pOps->OpClrSda     = crypt_sdaClr;
    pOps->OpSetSdaIn   = crypt_sdaIn;
    pOps->OpReadSda    = crypt_sdaRead;
    pOps->OpUdelay     = crypt_udelay;
    pOps->OpMalloc     = crypt_malloc;
    pOps->OpFree       = crypt_free;

    return 0;
}


/*
*	func:	i2c_start-:I2C
*/
static void i2c_start(void)
{
	
	int i;
	gpio_write(AT88SC_SDA, 1);
	udelay(10);
	gpio_write(AT88SC_SCL, 0);
	udelay(10);


	/*Ҫ5*/
	for (i = 0; i < 5; i++) {
		gpio_write(AT88SC_SCL, 1);
		udelay(10);
		gpio_write(AT88SC_SCL, 0);
		udelay(10);
	}

	gpio_write(AT88SC_SCL, 1);
	udelay(10);
	gpio_write(AT88SC_SDA, 1);
	udelay(10);
	gpio_write(AT88SC_SDA, 0);
	udelay(10);
	gpio_write(AT88SC_SCL, 0);
	udelay(10);	
}


/*
*	func:	i2c_stop-:ֹͣI2C
*/
static void i2c_stop(void)
{
	udelay(10);
	gpio_write(AT88SC_SCL, 1);
	udelay(10);
	gpio_write(AT88SC_SDA, 0);
	udelay(10);
	gpio_write(AT88SC_SDA, 1);
	udelay(10);
	//gpio_write(AT88SC_SCL, 0);
	//udelay(10);	
}


/*
*	func: write_byte--write one byte
* 	param:   value--need write value
*	return :  0--success,  1---failed
*/
static int write_byte(unsigned char value)
{
	int i;
	int send_counter = 0;
	unsigned char temp;
	int retval = 0;

	temp = value;

	do {
		for(i = 0; i < 8; i++) {
			 if ((temp&0x80)==0x80) {
			 	gpio_write(AT88SC_SDA, 1);
			} else {
				gpio_write(AT88SC_SDA, 0);
			}
			udelay(10);
			gpio_write(AT88SC_SCL, 1);
			udelay(10);
			gpio_write(AT88SC_SCL, 0);
			udelay(10);
			temp=temp<<1;
		}
		//gpio_write(AT88SC_SDA, 1);		
		gpio_dir_input(AT88SC_SDA);
		udelay(10);		
		gpio_write(AT88SC_SCL, 1);
		udelay(10);		
		retval = gpio_read(AT88SC_SDA);
		gpio_write(AT88SC_SCL, 0);
		udelay(20);	
		if(retval ==0) {	
			break;
		} else {	
			//printf("count ++\n");
			i2c_stop();
			udelay(10);
			i2c_start();
			temp=value;			
			send_counter++;
		}
	} while (send_counter < 8);

	if (send_counter >= 8) {
		printf("error: write byte error\n");
		return -1;
	} 
	udelay(10);		
	return 0;

}


/*
*	func:	write_nbytes-at88scxxд
*	param:	buf-д飬len-д볤
*	return:	0-success, -1-failed
*/
static int write_nbytes(unsigned char  *buf, unsigned int len)
{
	unsigned int i = 0;
	i2c_start();

	for (i = 0; i < len; i++) {
		if (write_byte(buf[i])) {
			//printf("buf[%d] = %d\n", i, buf[i]);
			break;
		}
	}

	i2c_stop();
	if (i != len) {
		return -1;
	}
	return 0;
}


/*
*	func:	write_paintext-д()
*	param:	rd_cmd:0xb0 дû /0xb4 д  
*					/0xb4 0x01 ID 0x00  д˿
*			A1A    :ֽڵַ
*			A2A    :ֽڵַ
*			N     :ȡݸ
*	return: 0-success, -1-failed
*	ע⣺ն˿ʱֻܴID=0x06=>0x04=>0x00
*/
static int write_paintext(unsigned char wr_cmd,unsigned char A1A,unsigned char A2A,
													unsigned char N)
{	
	int ret;
	rwdata[0]=wr_cmd;//0xb0  0xb4
	rwdata[1]=A1A;    //A1A
	rwdata[2]=A2A;    //A2A
	rwdata[3]=N;     //N
	ret = write_nbytes(rwdata, 4+N);
	return ret;
}


/*
*	func:	read_nbytes-at88scxx
*	param:	buf-飬len-ĳ
*	return:	0-success, -1-failed
*/
static int read_nbytes(unsigned char *buf, unsigned int len)
{
	unsigned char temp = 0;
	unsigned char cmd_send_counter;
	unsigned char bytecounter;
	unsigned int counter = 0;
	int i;

	bytecounter=0;
	cmd_send_counter=0;
	i2c_start();

	for (i = 0; i < 4; i++) {
		if (write_byte(buf[i])) {
			break;
		}
	}

	if (i != 4) {
		return -1;
	}

	//rev byte
	gpio_write(AT88SC_SDA, 1);
	
	for (counter = 0; counter < len; counter++) {
		gpio_dir_input(AT88SC_SDA);
		udelay(10);
		for (i = 0; i < 8; i++) {
			gpio_write(AT88SC_SCL, 1);
			udelay(10);

			if (gpio_read(AT88SC_SDA)) {
				temp=temp|0x01;
			} else {
				temp=(temp&0xfe);
			}

			if (i < 7) {
				temp=temp<<1;
			} 
			gpio_write(AT88SC_SCL, 0);
			udelay(10);
		}
		gpio_write(AT88SC_SDA, 0);
		udelay(10);
		gpio_write(AT88SC_SCL, 1);
		udelay(10);
		gpio_write(AT88SC_SCL, 0);
		udelay(10);
		gpio_write(AT88SC_SDA, 1);
		udelay(10);		
		buf[counter +4]=temp;
	}
	i2c_stop();
	return 0;
}

/*
*	func:	read_paintext-()
*	param:	rd_cmd-0xb2 û /0xb6  
*				/0xb6 0x01 0x00 0x01 ˿
*			A1A    :ֽڵַ
*			A2A    :ֽڵַ
*			N     :ȡݸ
*	return: 0-success, -1-failed
*/
static int read_paintext(unsigned char rd_cmd,unsigned char A1A,unsigned char A2A,
													unsigned char N)
{
	int ret;
	rwdata[0]=rd_cmd;//0xb2  0xb6
	rwdata[1]=A1A;    //A1A
	rwdata[2]=A2A;    //A2A
	rwdata[3]=N;     //N
	ret = read_nbytes(rwdata, N);
	return ret;
}


static int crypt_zoneTest(void)
{
    int ret = 0;
    rwdata[4]=0x33;
    rwdata[5]=0x44;                            
    ret = write_paintext(0xb4,0x00,0x0a,0x02);       
    if (ret < 0) 
    {
        printf("error: write_paintext failed\n");
        return -1;
    }
    mdelay(1);
    rwdata[4]=0x0;
    rwdata[5]=0x0;                          
    ret = read_paintext(0xb6,0x00,0x0a,0x02);     
    if (ret < 0) 
    {
        printf("error: read_paintext failed\n");
        return -1;
    }
    printf("rwdate = %x, %x\n", rwdata[4], rwdata[5]);
    if ((rwdata[4] == 0x33) && (rwdata[5] == 0x44)) 
    {
        return 0;
    } 
    else 
    {
        printf("error: wite\\read test failed\n");
        return -1;
    }

}
/*
*	func: at88sc д
*	param:	ram_addr-Ҫдݵĵַ
*	return:  0:success, -1:failed
*/
int encrypt_at88sc(unsigned long ram_addr)
{
    int retVal = 0;
    CRYPT_Operations cryptOpt;

    /* صʼ */
    memset(&cryptOpt ,0, sizeof(cryptOpt));
    printf("crypt_optInit ......\n");
    retVal = crypt_optInit(&cryptOpt);
    if(retVal < 0)
    {
        printf("crypt_optInit failed! \n");
        return retVal;
    }

    /* IOʼ */
    printf("gpio_init ...... \n");
    gpio_init();

    /* ͨǷɹ */
    printf("crypt_zoneTest ......\n");
    retVal = crypt_zoneTest();
    if(retVal < 0)
    {
        printf("crypt_zoneTest failed! \n");
        return retVal;
    }
    
    /* ע */
    printf("CRYPT_setChipOps ......\n");
    retVal = CRYPT_setChipOps(&cryptOpt);
    if(retVal < 0)
    {
        printf("CRYPT_setChipOps failed! \n");
        return retVal;
    }

    /* доƬ */
    printf("CRYPT_fireToChip ......\n");
    retVal = CRYPT_fireToChip((char*)ram_addr, 512);
    if(retVal < 0)
    {
        printf("CRYPT_fireToChip failed! \n");
        return retVal;
    }

    /*  дɹһ֤ */
    printf("CRYPT_authenticate ......\n");
    retVal = CRYPT_authenticate();
    if(retVal < 0)
    {
        printf("CRYPT_authenticate failed! \n");
        return retVal;
    }

    return retVal;
}




