/*
 * Copyright (C) 2009, Texas Instruments, Incorporated
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __CONFIG_TI8148_IPNC_H
#define __CONFIG_TI8148_IPNC_H

/*
 *#define CONFIG_TI814X_NO_RUNTIME_PG_DETECT
 */

/* Display CPU info */
#define CONFIG_DISPLAY_CPUINFO		1
#define CONFIG_TI8148_IPNC          1


//#define CONFIG_DDR_SPEED_400
#define CONFIG_DDR_SPEED_533              
#define CONFIG_IPNC_BOOT

//#define BOARD_J   1    /*ջİ*/

/* In the 1st stage we have just 110K, so cut down wherever possible */
#ifdef CONFIG_TI814X_MIN_CONFIG

# define CONFIG_CMD_MEMORY	/* for mtest */
# undef CONFIG_GZIP
# undef CONFIG_ZLIB
//# undef CONFIG_BOOTM_LINUX
//# undef CONFIG_BOOTM_NETBSD
//# undef CONFIG_BOOTM_RTEMS
//# undef CONFIG_SREC
//# undef CONFIG_XYZMODEM
# undef CONFIG_SYS_HUSH_PARSER
# define CONFIG_CMD_LOADB	/* loadb			*/
# define CONFIG_CMD_LOADY	/* loady */
# define CONFIG_SETUP_PLL
# define CONFIG_TI814X_CONFIG_DDR
# define CONFIG_TI814X_EVM_DDR3
/*
 * # define CONFIG_TI814X_EVM_DDR2
 */ 
# define CONFIG_ENV_SIZE			0x400
# define CONFIG_SYS_MALLOC_LEN		(CONFIG_ENV_SIZE + (8 * 1024))
# define CONFIG_SYS_PROMPT		"MIN#"
# define CONFIG_BOOTDELAY		3	/* set to negative value for no autoboot */
# if defined(CONFIG_SPI_BOOT)		/* Autoload the 2nd stage from SPI */
#  define CONFIG_SPI			1
#  define CONFIG_EXTRA_ENV_SETTINGS \
	"verify=yes\0" \
	"bootcmd=sf probe 0; sf read 0x81000000 0x20000 0x40000; go 0x81000000\0" \

# elif defined(CONFIG_NAND_BOOT)		/* Autoload the 2nd stage from NAND */
#  define CONFIG_NAND			1
#  define CONFIG_EXTRA_ENV_SETTINGS \
	"verify=yes\0" \
	"bootcmd=nand read 0x81000000 0x20000 0x40000; go 0x81000000\0" \

# elif defined(CONFIG_SD_BOOT)		/* Autoload the 2nd stage from SD */
#  define CONFIG_MMC			1
#  define CONFIG_EXTRA_ENV_SETTINGS \
	"verify=yes\0" \
	"bootcmd=mmc init; fatload mmc 1 0x80800000 u-boot.bin; go 0x80800000\0" \

# endif

#else

# include <config_cmd_default.h>
//# define CONFIG_SKIP_LOWLEVEL_INIT	/* 1st stage would have done the basic init */
# define CONFIG_TI814X_CONFIG_DDR
# define CONFIG_TI814X_EVM_DDR3
# define CONFIG_SETUP_PLL
# define CONFIG_ENV_SIZE			0x40000
# define CONFIG_SYS_MALLOC_LEN		(9*512*1024)
# define CONFIG_ENV_OVERWRITE
# define CONFIG_SYS_LONGHELP
# define CONFIG_SYS_PROMPT		">"
# define CONFIG_SYS_HUSH_PARSER		/* Use HUSH parser to allow command parsing */
# define CONFIG_SYS_PROMPT_HUSH_PS2	"> "
# define CONFIG_CMDLINE_TAG        	1	/* enable passing of ATAGs  */
# define CONFIG_SETUP_MEMORY_TAGS  	1
# define CONFIG_INITRD_TAG	  	1	/* Required for ramdisk support */
# define CONFIG_BOOTPARA_TAGS   1
# define CONFIG_BOOTDELAY		3	/* set to negative value for no autoboot */
//#define CONFIG_CMD_AUTOTEST	/* for autotest */
/* By default, 2nd stage will have MMC, NAND, SPI and I2C support */
//# define CONFIG_MMC			1
//# define CONFIG_NAND			1
# define CONFIG_SPI			1
# define CONFIG_I2C			1


#endif

#define CONFIG_TIMESTAMP

#define CONFIG_SYS_GBL_DATA_SIZE	128	/* size in bytes reserved for
						   initial data */

#define CONFIG_MISC_INIT_R		1
#ifndef CONFIG_TI814X_MIN_CONFIG
//# define CONFIG_TI814X_ASCIIART		1	/* The centaur */
#endif
#define CONFIG_SYS_AUTOLOAD		"yes"
#define CONFIG_CMD_CACHE
#define CONFIG_CMD_ECHO

/*
 * Miscellaneous configurable options
 */

/* max number of command args */
#define CONFIG_SYS_MAXARGS		32
/* Console I/O Buffer Size */
#define CONFIG_SYS_CBSIZE		512
/* Print Buffer Size */
#define CONFIG_SYS_PBSIZE		(CONFIG_SYS_CBSIZE \
					+ sizeof(CONFIG_SYS_PROMPT) + 16)
/* Boot Argument Buffer Size */
#define CONFIG_SYS_BARGSIZE		CONFIG_SYS_CBSIZE
/* memtest works on 8 MB in DRAM after skipping 32MB from start addr of ram disk*/
#define CONFIG_SYS_MEMTEST_START	(PHYS_DRAM_1 + (64 *1024 *1024))
#define CONFIG_SYS_MEMTEST_END		(CONFIG_SYS_MEMTEST_START \
					+ (8 * 1024 * 1024))
#if defined(CONFIG_CMD_AUTOTEST)
#define CONFIG_SYS_MEMTEST_SIZE 0x10000000	/* autotest memory size*/
#endif
#undef  CONFIG_SYS_CLKS_IN_HZ				/* everything, incl board info, in Hz */
#define CONFIG_SYS_LOAD_ADDR		0x81000000  	/* Default load address */
#define CONFIG_SYS_HZ			1000        	/* 1ms clock */

/* Hardware related */

/**
 * Physical Memory Map
 */
#define CONFIG_NR_DRAM_BANKS		2		/* we have 2 banks of DRAM */
#define PHYS_DRAM_1			0x80000000	/* DRAM Bank #1 */
#define PHYS_DRAM_1_SIZE		0x40000000	/* 1 GB */
#define PHYS_DRAM_2			0xC0000000	/* DRAM Bank #2 */
#define PHYS_DRAM_2_SIZE		0x40000000	/* 1 GB */


/**
 * Platform/Board specific defs
 */
#define CONFIG_SYS_CLK_FREQ		27000000
#define CONFIG_SYS_TIMERBASE		0x4802E000

/*
 * NS16550 Configuration
 */
#define CONFIG_SYS_NS16550
#define CONFIG_SYS_NS16550_SERIAL
#define CONFIG_SYS_NS16550_REG_SIZE	(-4)
#define CONFIG_SYS_NS16550_CLK		(48000000)
#define CONFIG_SYS_NS16550_COM1		0x48020000	/* Base EVM has UART0 */

#define CONFIG_BAUDRATE		115200
#define CONFIG_SYS_BAUDRATE_TABLE	{ 110, 300, 600, 1200, 2400, \
4800, 9600, 14400, 19200, 28800, 38400, 56000, 57600, 115200 }

/*
 * select serial console configuration
 */
#define CONFIG_SERIAL1			1
#define CONFIG_CONS_INDEX		1
#define CONFIG_SYS_CONSOLE_INFO_QUIET

#if defined(CONFIG_NO_ETH)
# undef CONFIG_CMD_NET
#else
# define CONFIG_CMD_DHCP
# define CONFIG_CMD_PING
#endif

#if defined(CONFIG_CMD_NET)
# define CONFIG_DRIVER_TI_CPSW
# define CONFIG_MII
# define CONFIG_BOOTP_DEFAULT
# define CONFIG_BOOTP_DNS
# define CONFIG_BOOTP_DNS2
# define CONFIG_BOOTP_SEND_HOSTNAME
# define CONFIG_BOOTP_GATEWAY
# define CONFIG_BOOTP_SUBNETMASK
# define CONFIG_NET_RETRY_COUNT 	10
# define CONFIG_NET_MULTI
# define CONFIG_PHY_GIGE
# define CONFIG_CMD_MII
#endif

#if defined(CONFIG_SYS_NO_FLASH)
# define CONFIG_ENV_IS_NOWHERE
#endif

/* NAND support */
#ifdef CONFIG_NAND
#define CONFIG_CMD_NAND
#define CONFIG_NAND_TI81XX
#define GPMC_NAND_ECC_LP_x16_LAYOUT 	1
#define NAND_BASE			(0x08000000)
#define CONFIG_SYS_NAND_ADDR		NAND_BASE	/* physical address */
							/* to access nand */
#define CONFIG_SYS_NAND_BASE		NAND_BASE	/* physical address */
							/* to access nand at */
							/* CS0 */
#define CONFIG_SYS_MAX_NAND_DEVICE	1		/* Max number of NAND */
#endif							/* devices */

/* ENV in NAND */
#if defined(CONFIG_NAND_ENV)
# undef CONFIG_ENV_IS_NOWHERE
# define CONFIG_ENV_IS_IN_NAND		1
# ifdef CONFIG_ENV_IS_IN_NAND
#  define CONFIG_SYS_MAX_FLASH_SECT	520		/* max number of sectors in a chip */
#  define CONFIG_SYS_MAX_FLASH_BANKS	2		/* max number of flash banks */
#  define CONFIG_SYS_MONITOR_LEN	(256 << 10)	/* Reserve 2 sectors */
#  define CONFIG_SYS_FLASH_BASE		boot_flash_base
#  define CONFIG_SYS_MONITOR_BASE	CONFIG_SYS_FLASH_BASE
#  define MNAND_ENV_OFFSET		0x260000	/* environment starts here */
#  define CONFIG_SYS_ENV_SECT_SIZE	boot_flash_sec
#  define CONFIG_ENV_OFFSET		boot_flash_off
#  define CONFIG_ENV_ADDR		MNAND_ENV_OFFSET
# endif


# ifndef __ASSEMBLY__
extern unsigned int boot_flash_base;
extern volatile unsigned int boot_flash_env_addr;
extern unsigned int boot_flash_off;
extern unsigned int boot_flash_sec;
extern unsigned int boot_flash_type;
# endif
#endif /* NAND support */

/* SPI support */
#ifdef CONFIG_SPI
#define CONFIG_OMAP3_SPI
#define CONFIG_MTD_DEVICE
#define CONFIG_SPI_FLASH
#define CONFIG_SPI_FLASH_WINBOND
#define CONFIG_SPI_FLASH_SPANSION
#define CONFIG_CMD_SF
#define CONFIG_SF_DEFAULT_SPEED	(75000000)
#define CONFIG_CODEC_AIC26	1
#endif


/* ENV in SPI */
#if defined(CONFIG_SPI_ENV)
# undef CONFIG_ENV_IS_NOWHERE
# define CONFIG_ENV_IS_IN_SPI_FLASH	1
# ifdef CONFIG_ENV_IS_IN_SPI_FLASH
#  define CONFIG_SYS_FLASH_BASE		(0)
#ifdef CONFIG_SPI_FLASH_WINBOND
#  define SPI_FLASH_ERASE_SIZE		(4 * 1024) /* sector size of SPI flash */
#endif
#ifdef CONFIG_SPI_FLASH_SPANSION
#undef SPI_FLASH_ERASE_SIZE
#  define SPI_FLASH_ERASE_SIZE		(64* 1024) /* sector size of SPI flash */
#endif
#  define CONFIG_SYS_ENV_SECT_SIZE	(1 * SPI_FLASH_ERASE_SIZE) /* env size */
#  define CONFIG_ENV_SECT_SIZE		(CONFIG_SYS_ENV_SECT_SIZE)
#  define CONFIG_ENV_OFFSET		(768*1024)
#  define CONFIG_ENV_ADDR		(CONFIG_ENV_OFFSET)
#  define CONFIG_SPI_FLASH_SIZE	(0x02000000 + 0x1000000)  /* 32MB  + 16M(FPGA)*/
#  define CONFIG_SYS_MAX_FLASH_SECT	(1024) /* no of sectors in SPI flash */
#  define CONFIG_SYS_MAX_FLASH_BANKS	(1)
# endif
#endif /* SPI support */


/* NOR support */
#if defined(CONFIG_NOR_BOOT)
# undef CONFIG_CMD_NAND			/* Remove NAND support */
# undef CONFIG_NAND_TI81XX
# undef CONFIG_ENV_IS_NOWHERE
# ifdef CONFIG_SYS_MALLOC_LEN
#  undef CONFIG_SYS_MALLOC_LEN
# endif
# define CONFIG_SYS_FLASH_USE_BUFFER_WRITE 1
# define CONFIG_SYS_MALLOC_LEN		(0x100000)
# define CONFIG_SYS_FLASH_CFI
# define CONFIG_FLASH_CFI_DRIVER
# define CONFIG_FLASH_CFI_MTD
# define CONFIG_SYS_MAX_FLASH_SECT	512
# define CONFIG_SYS_MAX_FLASH_BANKS	1
# define CONFIG_SYS_FLASH_BASE		(0x08000000)
# define CONFIG_SYS_MONITOR_BASE	CONFIG_SYS_FLASH_BASE
# define CONFIG_ENV_IS_IN_FLASH	1
# define NOR_SECT_SIZE			(128 * 1024)
# define CONFIG_SYS_ENV_SECT_SIZE	(NOR_SECT_SIZE)
# define CONFIG_ENV_SECT_SIZE		(NOR_SECT_SIZE)
# define CONFIG_ENV_OFFSET		(2 * NOR_SECT_SIZE)
# define CONFIG_ENV_ADDR		(CONFIG_SYS_FLASH_BASE + CONFIG_ENV_OFFSET)
# define CONFIG_MTD_DEVICE
#endif	/* NOR support */


/* No I2C support in 1st stage */
#ifdef CONFIG_I2C

# define CONFIG_CMD_I2C
//# define CONFIG_CMD_DATE
# define CONFIG_I2C_MULTI_BUS
//# define CONFIG_SYS_RTC_BUS_NUM		0
//# define CONFIG_TPS65911_I2C		1
//# define CONFIG_RTC_TPS65911		1
//# define CONFIG_CODEC_AIC3104		1
//# define CONFIG_SENSOR_MT9J003		1
# define CONFIG_HARD_I2C			1
# define CONFIG_SYS_I2C_SPEED		100000
# define CONFIG_SYS_I2C_SLAVE		1
# define CONFIG_SYS_I2C_BUS		0
# define CONFIG_SYS_I2C_BUS_SELECT	1
# define CONFIG_DRIVER_TI81XX_I2C	1

#if 0
/* EEPROM definitions */
# define CONFIG_SYS_I2C_EEPROM_ADDR_LEN		3
# define CONFIG_SYS_I2C_EEPROM_ADDR		0x50
# define CONFIG_SYS_EEPROM_PAGE_WRITE_BITS	6
# define CONFIG_SYS_EEPROM_PAGE_WRITE_DELAY_MS	20
#endif

#endif

/* HSMMC support */
#ifdef CONFIG_MMC
# define CONFIG_OMAP3_MMC	1
# define CONFIG_CMD_MMC		1
# define CONFIG_DOS_PARTITION	1
# define CONFIG_CMD_FAT		1
#endif
/* U-boot Version */
//#define CONFIG_VERSION_VARIABLE

#define CONFIG_IDENT_STRING_J    "IPNC-1.8.0 (J)"

#define CONFIG_IDENT_STRING_T    "IPNC-1.8.0 (T)"


/* Unsupported features */
#undef CONFIG_USE_IRQ

#ifndef CONFIG_TI814X_MIN_CONFIG
#define CONFIG_DVR_CMD
#endif


#ifdef CONFIG_DVR_CMD
#define CONFIG_LOG_SERVER 127.0.0.1		
#define CONFIG_GATEWAYIP  10.45.0.1		/* gateway currently own */
#define CONFIG_NETMASK	  255.255.0.0		/* talk on MY local net */ 
#define CONFIG_IPADDR	  10.45.0.3		/* static IP I currently own */
#define CONFIG_SERVERIP	  10.36.45.8		/* current IP of tftp server ip */

#define	CONFIG_BOOTCOMMAND	"sf probe 0;bootf 0x001C0000"
#define	CONFIG_BOOTARGS "mem=150M, console=ttyO0,115200n8 rootfstype=squashfs "	\
						"root=/dev/mtdblock8 earlyprint "  \
						"vram=4M notifyk.vpssm3_sva=0xBFD00000"

#define	CONFIG_DH_KEYBOARD	"1"
#define	CONFIG_APPAUTO		"1"
#define	CONFIG_LOADMODULES      "1"
#define    CONFIG_LOGLEVEL            "4:4:4:4"  /*HOST:M3VPSS:M3VIDEO:DSP*/
#define	CONFIG_PRODUCT_ID	"000000000000000000"

//#define	CONFIG_UPDATE_DM	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" dhboot-min.bin.img; flwrite"
#define	CONFIG_UPDATE_DA	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" dhboot.bin.img; flwrite"
//#define	CONFIG_UPDATE_DB	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" dhboot-bak.bin.img; flwrite"
#define	CONFIG_UPDATE_DP	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" partition.squashfs.img; flwrite"
#define	CONFIG_UPDATE_DC	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" custom-x.squashfs.img; flwrite"
#define	CONFIG_UPDATE_DR	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" romfs-x.squashfs.img; flwrite"
#define	CONFIG_UPDATE_DK	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" kernel.img; flwrite"
#define	CONFIG_UPDATE_DW	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" web-x.squashfs.img; flwrite"
#define	CONFIG_UPDATE_DU	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" user-x.squashfs.img; flwrite"
#define	CONFIG_UPDATE_DD	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" dsp-x.squashfs.img; flwrite"
#define	CONFIG_UPDATE_DATA	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" data-x.squashfs.img; flwrite"
#define	CONFIG_UPDATE_FPGA	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" fpga.img; flwrite"
#define	CONFIG_UPDATE_UP	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" update.img; flwrite"
#define	CONFIG_TEST_KERNEL	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" uImage; bootm"

#define CONFIG_CMD_JFFS2 	1 /* fsload command */
#define CONFIG_CMD_CRAMFS
#define CONFIG_FSLOAD
#define UBOOT_SZ 		(0x00080000)
#define ROOTFS_SZ 		(0x00300000)

#define UBOOT_UPDATE 1
#define BOOT_FROM	    0x40300000
#define CONFIG_SPI_FLASH_SIZE	(0x02000000 + 0x01000000)  /* 32MB  + 16M(FPGA)*/
#endif

/* ÷ȡϢغ궨 */
/* ȡcramfsͷϢʱȡϢ */
#define CRAMFS_SUPER_READ_SIZE      (0x00001000)
/* ϢڵSPIߺ */
#define PARTITION_SPI_BUS           (0)
/* ϢFLASHƬֵ */
#define PARTITION_SPI_CS            (0)
/* ϢFLASHʱƵ */
#define PARTITION__SPI_MAX_HZ       (75000000)  
/* ϢFLASHĲģʽ */
#define PARTITION_SPI_MODE          SPI_MODE_3
/* ϢFLASHеƫƵַ */
#define PARTITION_DATA_OFFSET       (0x00100000)
/* ЧϢС */
#define MIN_PARTINFO_LEN    (32)
/* ЧϢ󳤶 */
#define MAX_PARTINFO_LEN    (256)
/* Ϣļ󳤶 */
#define PARTINFO_FILE_SIZE  (0x00001000)
/* Ϣļļϵͳе */
#define PARTINFO_FILE_PATH  "partition.txt"
/* Ϣļļβַ */
#define PARTINFO_FILE_END   "END"


/* ļغ궨 */
/* ļ */
#define SCRIPT_IMG_NAME     "CmdScript"
/* ļβַ */
#define SCRIPT_FILE_END     "SCRIPT_FILE_END"
/* ϢַС */
#define MIN_SCRIPT_LEN    (1)
/* Ϣַ󳤶 */
#define MAX_SCRIPT_LEN    (256)

#endif	  /* ! __CONFIG_TI8148_IPNC_H */

