/* Required to obtain the getline prototype from stdio.h */
#define _GNU_SOURCE 
#include <compiler.h>
#include <asm/types.h>
#include <config.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>
#include <sha1.h>
#include <ambimage.h>

extern unsigned int crc32 (unsigned int crc, const char *p, unsigned int len);

static int amb_a5s_image_nand(char ** in_file, char *out_file )
{
    uint32_t i; 
    uint32_t file_size;
    uint32_t img_size[16];

    char *data;
    char *buffer;
    FILE *in_fp[16];
    FILE *out_fp = NULL;
    struct amb_image *image_head;
    char *name[] = {"bst", "hal", "uboot",0};
 
    //printf("sizeof(amb_image_header):%d\n",sizeof(struct amb_image_header));
    //printf("sizeof(amb_image_header):%d\n",sizeof(struct amb_image));
    memset(in_fp,0,sizeof(in_fp));
    file_size = 0;
    for (i = 0; in_file[i]; i++){
        in_fp[i] = fopen(in_file[i], "r");
        if (!in_fp[i]){
            fprintf(stderr,"open %s",in_file[i]);
            perror("");
            goto out;
        }
        fseek(in_fp[i],0,SEEK_END);
        img_size[i] = (ftell( in_fp[i]) + 2047) &(~(2047U));
        file_size += img_size[i];
        fseek(in_fp[i],0,SEEK_SET);
    } 

    buffer   = calloc(1, file_size + sizeof(struct amb_image));
    
    if (!buffer ){
        goto out; 
    }

    data = buffer + sizeof(struct amb_image);
    image_head = (struct amb_image *)buffer; 
    for (i = 0; in_fp[i]; i++){
        if (fread(data, img_size[i], sizeof(char), in_fp[i]) <0)
            goto out;

        image_head->node[i].magic = UBOOT_MAGIC;
        image_head->node[i].version = (time(NULL));
        image_head->node[i].size = img_size[i];
        image_head->node[i].entry = 0xc2000000;
        strcpy(image_head->node[i].name,name[i]);
        data += img_size[i];
        printf("%s:\t\t%dKB\n",image_head->node[i].name,img_size[i]/1024);
    }

    data = buffer + sizeof(struct amb_image);
    image_head = (struct amb_image *)buffer;
    image_head->node_count = i;
    image_head->image_magic = (UBOOT_MAGIC);
    //image_head->header_crc32 = 0;
    image_head->data_crc32 = crc32(0,(const char *)data,file_size);
    image_head->data_size = file_size;
    image_head->version = (time(NULL)); 
    image_head->header_crc32 = crc32(0,(const char *)image_head,\
            sizeof(struct amb_image) );

    printf("version:\t0x%08x\n",image_head->version);
    printf("header_crc32:\t0x%08x\n",image_head->header_crc32);
    printf("data_crc32:\t0x%08x\n",image_head->data_crc32);
    printf("data_size:\t%dKB\n",image_head->data_size/1024);


    #if 0
    image_head->magic = cpu_to_le32(image_head->magic);
    image_head->version = cpu_to_le32(image_head->version);
    image_head->ubl_size = cpu_to_le32(image_head->ubl_size);
    image_head->ubl_entry = cpu_to_le32(image_head->ubl_entry);
    //image_head->ubl_crc32 = cpu_to_le32(image_head->ubl_crc32);
    image_head->uboot_load	= cpu_to_le32(image_head->uboot_load);
    image_head->uboot_entry= cpu_to_le32(image_head->uboot_entry);
    image_head->uboot_size = cpu_to_le32(image_head->uboot_size);
    image_head->image_crc32 =cpu_to_le32(image_head->image_crc32);
    #endif

    printf("file_size:\t%dKB\n",file_size/1024);
    out_fp = fopen(out_file, "w"); 
    fwrite(buffer, 1, file_size + sizeof(struct amb_image),out_fp);
    
out:    
    for (i = 0; in_file[i]; i++){
            fclose(in_fp[i]); 
        }
    fclose(out_fp);
    return 0;
}

static ssize_t read_file(char *path, char *buf)
{
    int fd;
    ssize_t size;
    struct stat fstat;
    
    fd = open(path,O_RDONLY);
    if (fd < 0){
        perror("open");
       return fd;
    }
    stat(path, &fstat);
    size = read(fd,buf,fstat.st_size);
    if (size != fstat.st_size){
       size = -1;
    }
    
    close(fd);
    return size;
}

static int amb_bst_image(int argc, char **argv)
{
    flpart_table_t tab;
    flpart_meta_t meta;
    int i = 0;
    int fd;
    off_t size;
    char *file_out;
    char *p;
    struct stat fstat;
    char ptb[8*1024];
    
    memset(&tab,0,sizeof(tab));
    memset(&meta,0,sizeof(meta));
 
    file_out = malloc(1024*1024);
    if (!file_out){
        printf("can't malloc mem\n");
    }

    stat(argv[3],&fstat);
    size = fstat.st_size; 
    
    for (i = 0;i < PART_MAX;i ++){
        tab.part[i].magic = cpu_to_le32(FLPART_MAGIC);
    }

    meta.part_info[0].sblk = cpu_to_le32(0);
    meta.part_info[0].nblk = cpu_to_le32(1);
    
    meta.part_info[1].sblk = cpu_to_le32(1);
    meta.part_info[1].nblk = cpu_to_le32(2);

    tab.part[2].ver_date = cpu_to_le32(time(NULL));
    tab.part[2].img_len = cpu_to_le32((size + 8*1024 + 128*1024 - 1)&(~0x1ffff));
    tab.part[2].mem_addr = cpu_to_le32(TEXT_BASE - 8*1024);
    //tab.part[2].crc32 = cpu_to_le32(crc32(0,file_buf,size));

    //tab.dev.magic = cpu_to_le32(FLPART_MAGIC);
    
    meta.part_info[2].sblk = cpu_to_le32(1);
    meta.part_info[2].nblk = cpu_to_le32((size + 8*1024 + 128*1024 - 1)/(128*1024));

    strcpy(meta.part_info[0].name,"bst");
    strcpy(meta.part_info[1].name,"ptb");
    strcpy(meta.part_info[2].name,"bld"); 

    /*B,BL:
           if CondittionPassed(cond) then
                if L == 1 then
                    LR = address of the instruction after the branch instruction
                PC = PC + (SignExtend(signed_immed_24)<<2)
     */
    /*|31-----28-|-27-26-25-|-24-|-23----------------------------0--|*/
    /*|   cond   | 1  0   1 | L  |       signed_immed_24            |*/
    /*|----------|----------|----|----------------------------------|*/
    tab.part[0].crc32 = cpu_to_le32(0x0e<<28 | 0x05<<25 | 0<<24 | \
                      (sizeof(ptb) - 8)>>2);/* opcode for 'b 0x4000 */

    for (i = 0;i < 3;i ++){
        meta.part_dev[i] = cpu_to_le32(1);
    }
    
    meta.crc32 = cpu_to_le32(crc32(0,(char *)&meta,sizeof(meta) - sizeof(int)));
    meta.magic = cpu_to_le32(PTB_META_MAGIC);
    memset(file_out,0xff,512*1024);
    
    p = file_out;
    size = read_file(argv[1], p);
    if (size <=0 || size>8*1024){
        goto err;
    }
    p += 8*1024;

    size = read_file(argv[2], p);
    if (size <=0 || size>120*1024){
        goto err;
    }
    p = file_out + 128*1024;
    
    memcpy(p,&tab,sizeof(tab));
    p += sizeof(tab);
    memcpy(p,&meta,sizeof(meta));
    p += sizeof(meta);
    p += (8*1024 - (sizeof(tab) + sizeof(meta)));

    size = read_file(argv[3],p);
    if (size <=0 || size>512*1024){
        goto err;
    }
    
    tab.part[2].crc32 = cpu_to_le32(crc32(0,p,size));
    meta.crc32 = cpu_to_le32(crc32(0,(char *)&meta,sizeof(meta) - sizeof(int)));
    p += size;
    
    fd = open("dhboot-min.bin",O_RDWR | O_CREAT | O_TRUNC,0666);
    write(fd,file_out,p - file_out);
    close(fd);
    fsync(fd);
    
#if 0
    for (i = 0;i < 3;i ++){
        printf("crc32:%08x  ",tab.part[i].crc32);
        printf("ver_num:%08x  ",tab.part[i].ver_num);
        printf("ver_date:%08x  ",tab.part[i].ver_date); 
        printf("img_len:%08x  ",tab.part[i].img_len); 
        printf("mem_addr:%08x  ",tab.part[i].mem_addr); 
        printf("flag:%08x  ",tab.part[i].flag); 
        printf("magic:%08x\n",tab.part[i].magic); 
    }

    for (i = 0;i < 3;i ++){
        printf("sblk:%08x  ",meta.part_info[i].sblk);
        printf("nblk:%08x  ",meta.part_info[i].nblk);
        printf("name:%s  ",meta.part_info[i].name);
        printf("part_dev:%08x\n",meta.part_dev[i]);
    }
   
    printf("magic:%08x  ",meta.magic);
    printf("crc32:%08x  ",meta.crc32);
    printf("calc crc32:%08x  ",crc32(0,(char *)&meta,sizeof(meta) - sizeof(int)));
    printf("model_name :%s\n",meta.model_name);
#endif

    return 0;
    
err:
    return -1;
}

int main(int argc, char **argv)
{
    char *in_file[] = {argv[1], argv[2], argv[3], 0};
    amb_bst_image(argc, argv);
    amb_a5s_image_nand(in_file, argv[5]);
    return 0;
}
