/*
 * tiimage.h
 *
 * mkimage extension for Texas Instruments
 *
 * Copyright (C) 2010, Texas Instruments, Incorporated
 *
 * Author:
 * Mansoor Ahamed  <mansoor.ahamed@ti.com>
 *
 * Referenced tools/imximage.h
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef _TIIMAGE_H_
#define _TIIMAGE_H_

struct ti_header {
	uint32_t image_size;
	uint32_t load_addr;
	/* ROM code always jumps to 0x40300000, we must resver 16byte for u-boot
	 * . Hence we are using a short jump and making the remaining
	 * portion of the header from this point to be*/
	uint32_t ldrpc;
	uint32_t loc;
	/* - 2 is for above 2 instructions */
	uint32_t reserved[(0x10/4) - 2];
};


struct uboot_header{
		unsigned int magic;
		unsigned int version;
		unsigned int ubl_crc32;
		unsigned int ubl_size;
		unsigned int ubl_entry;
		unsigned int load_addr;
		unsigned int entry_addr;
		unsigned int uboot_size;
		unsigned int uboot_crc32;
		unsigned int reserve[6];
		unsigned int header_crc32;
};

struct uboot{
	struct uboot_header uboot_head;
	unsigned char uboot_bin[256*1024 - sizeof(struct uboot_header)];
};

struct uboot_image{
	struct ti_header gp_header;
	unsigned char ubl[256*1024 - sizeof(struct ti_header)];
	struct uboot uboot_img[2];
};

#define UBOOT_MAGIC ('D'<<24 | 'H'<<16 | 'U'<<8 | 'B' <<0)
#endif /* _TIIMAGE_H_ */
