#!/usrbin/env python

import os, sys, shutil, stat, time
import ftplib
import tarfile, zipfile
from xml.dom.minidom import parse, getDOMImplementation, parseString
import string
import codecs

try :
	from Tkinter import *
except ImportError :
	pass


s_valid_targets_windows = [ "win32-vs2005-debug", "win32-vs2005-release",
	"win32-vs2005-debugmd", "win32-vs2005-releasemd", 
	"win32-vs2005-dllrelease", "win32-vs2005-dlldebug", 
	"win32-vs2005-dlldebugmd", "win32-vs2005-dllreleasemd"]
s_valid_targets_linux = [ "linux32-centos6-gcc-debug", "linux32-centos6-gcc-release",
	"linux64-centos6-gcc-debug", "linux64-centos6-gcc-release",
	"linux32-centos5-gcc-debug", "linux32-centos5-gcc-release",
	"sh4-linux-uclibc-gcc-debug", "sh4-linux-uclibc-gcc-release" ]
s_valid_targets_mac = [ "mac32-llvmgcc42-debug", "mac32-llvmgcc42-release" ]
s_valid_targets_all = s_valid_targets_windows + s_valid_targets_linux + s_valid_targets_mac


def on_rmtree_error( func, path, exec_info ) :
	if os.access( path, os.F_OK ) :
		os.chmod( path, stat.S_IREAD | stat.S_IWRITE )
		func( path )

def do_rmtree( path ) :
	for i in range(3) :
		try :
			shutil.rmtree( path, onerror = on_rmtree_error )
		finally :
			if not os.access( path, os.F_OK ) :
				return 0
		time.sleep(1)

	print "delete path [%s] failed" % path
	return 1

def read_local_svn_info() :
	local_svn_info = {}
	local_svn_info["modname"] = "Unknown"
	local_svn_info["path"] = "/NotFound"
	local_svn_info["version"] = "404"
	oldenv = os.getenv( "LC_ALL" )
	os.putenv( "LC_ALL", "C" )
	info = os.popen( "svn info .." ).read()
	if oldenv != None :
		os.putenv( "LC_ALL", oldenv )
	# URL: http://10.6.5.2/svnpl/BASPlatform/DSSModule/DssBaseLib/Trunk
	# Last Changed Rev: 54790
	for line in string.split( info, "\n" ) :
		if string.find( line, "URL:" ) == 0 :
			idx = line.find( "/", 12 )
			idx = line.find( "/", idx + 1 )
			local_svn_info["path"] = line[idx:]
			words = string.split( line, "/" )
			if words[-1] == "Trunk" :
				local_svn_info["modname"] = words[-2]
			else :
				local_svn_info["modname"] = words[-3]
		elif string.find( line, "Last Changed Rev:" ) == 0 :
			local_svn_info["version"] = str(int(line[18:]))

	return local_svn_info


class version_file :
	def __init__( self ) :
		self.dep = parse( "DependInfo.xml" )

	def create_depend_version( self, target_type) :
		if os.path.exists("Version.xml") == True :
			os.remove("Version.xml")

		self.local_svn_info = read_local_svn_info()
		print "local svn info is : %s " % self.local_svn_info

		fn_d = ""
		if target_type.find( "debug" ) >= 0 :
			fn_d = "_d"
		ret = 0
        
		impl = getDOMImplementation();
		dom  = impl.createDocument(None,"temp",None)
		root = dom.documentElement
		localModuleRoot = dom.createElement("Module")
		localModuleRoot.setAttribute("name", self.local_svn_info["modname"])
		localModuleRoot.setAttribute("version", self.local_svn_info["version"])
		localModuleRoot.setAttribute("path", self.local_svn_info["path"])

		# start read every depend module and version
		elemBaseFromParse = self.dep.documentElement
		elems = elemBaseFromParse.getElementsByTagName("Module")
		for elem in elems:
			#start read every sub depend module of the depend module,at frist find the version.xml of the depend module from dir
			versionFilePath = "./" + elem.getAttribute("name") + fn_d + "/" + "Version.xml"
			if os.path.exists(versionFilePath) == True :
				subDep = parse(versionFilePath)
				subRoot =  subDep.documentElement
				subElem = subRoot.getElementsByTagName("Module")[0]
				localModuleRoot.appendChild(subElem)
			else :
				print "Version.xml in "+elem.getAttribute("name")+fn_d+" is not exist"

		try :
			root.appendChild(localModuleRoot)
			verdom = impl.createDocument(None, 'Versioninfo', None)
			stringxml = dom.toxml().replace("\t", "").replace("\n", "").replace("\r", "")
			verdom.documentElement.appendChild(parseString(stringxml).documentElement.getElementsByTagName("Module")[0])
			f = codecs.open("Version.xml", "w", "utf-8")
			print "open ok"
			verdom.writexml(f, addindent="\t", newl="\n", encoding = "utf-8")
			f.close();
			print "create Version.xml ok"
			return 0
		except Exception, e :
			print "write failed, err : %s" % e
			return 1

def get_package( path, version, target_type, zipname ) :
	if os.access( zipname, os.F_OK ) :
		os.remove( zipname )

	pkgsvr = os.getenv( "DSLCT_PKGSVR", "ftp://10.24.5.46" )
	if pkgsvr[0:6] != "ftp://" :
		print "bak pkgsvr [%s]" % pkgsvr
		return 1

	host = pkgsvr[6:]
	port = 21
	user = "anonymous"
	passwd = "anonymous"
	path_prefix = "/"
	idx = host.find( "/" )
	if idx != -1 :
		path_prefix = host[idx:]
		host = host[0:idx]
	idx = host.find( "@" )
	if idx != -1 :
		user = host[0:idx]
		host = host[idx+1:]
	idx = host.find( ":" )
	if idx != -1 :
		port = int( host[idx+1:] )
		host = host[0:idx]
	idx = user.find( ":" )
	if idx != -1 :
		passwd = user[idx+1:]
		user = user[0:idx]

	try :
		hftp = ftplib.FTP()
		hftp.connect( host, port )
		hftp.login( user, passwd )
		# print "file : [%s][%s][%s]" % ( path_prefix, path, zipname )
		hftp.cwd( path_prefix )
		total_path = "./" + path + "/" + version + "/" + target_type
		hftp.cwd( total_path )
		fp = open( zipname, "wb" )
		hftp.retrbinary( "RETR " + zipname, fp.write )
		hftp.close()
		fp.close()
	except Exception, e :
		print "get ftp file [%s] failed, err %s" % ( zipname, e )
		return 1
	
	return 0

def do_update_depend( target_type ) :
	if not target_type in s_valid_targets_all :
		print "ERR : target type [ " + target_type + " ] not valid"
		return 1

	fn_d = ""
	if target_type.find( "debug" ) >= 0 :
		fn_d = "_d"

	# <1> parse DependInfo.xml
	try :
		dep = parse( "DependInfo.xml" )
		if dep.documentElement.tagName != "DependInfo" :
			print "bad DependInfo.xml, no DependInfo tag"
			return 1
	except Exception, e :
		print "parse DependInfo.xml failed, err %s" % e
		return 1

	# <2> find need update
	# TODO : optimise, if already exit, skip it, not always get new one
	# parse local info
	# local = parse_dep_xml( "local_dep.xml" )
	# local_new = {}
	# remove item in dep who is not changed
	
	# <3> remove old module
	nodes = dep.documentElement.getElementsByTagName( "Module" )
	for nd in nodes :
		modname = nd.getAttribute( "name" )
		print "[D]", modname + fn_d
		if do_rmtree( modname + fn_d ) != 0 :
			print "rmdir " + modname + fn_d + "failed"
			return 1

	# <4> get new module
	for nd in nodes :
		modname = nd.getAttribute( "name" )
		path = nd.getAttribute( "path" )
		version = nd.getAttribute( "version" )
		print "[G]", modname + fn_d, path, version, target_type

		if target_type[0:3] == "win" :
			zipname = modname + fn_d + ".zip"
		else :
			zipname = modname + fn_d + ".tar.gz"
		
		if get_package( path, version, target_type, zipname ) != 0 :
			print "get package failed"
			return 1

		try :
			if target_type[0:3] == "win" :
				zf = None
				zf = zipfile.ZipFile( zipname, "r" )
				zf.extractall()
				zf.close()
			else :
				# zf = tarfile.open( zipname, "r:gz" )
				if os.system( "tar xzf " + zipname ) != 0 :
					print "extract [%s] failed" % zipname
					return 1
				
		except Exception, e :
			print "extract [%s] failed, err %s" % ( zipname, e )
			return 1

		os.remove( zipname )

	# <5> create Version file
	try :
		vf = version_file();
		ret = vf.create_depend_version(target_type)
	except Exception, e :
		print "create Version file failed, err %s" % e
		return 1

	return ret 

class gui_updater :
	def __init__( self ) :
		top = Tk()
		self.top = top
		top.grid()

		lb1 = Label( top, text="TargetName" )
		lb1.grid( row=0, column=0, padx=7, pady=2 )
		self.var_target = StringVar()
		om1 = OptionMenu( top, self.var_target, *s_valid_targets_windows )
		self.var_target.set( "win32-vs2005-debug" )
		om1.grid( row=0, column=1 )

		btn = Button( top, text="Update Depend", command=self.do_btn_update )
		btn.grid( row=1, column=0, columnspan=2 )

		self.var_info = StringVar()
		self.label_info = Label( top, textvariable=self.var_info )
		self.label_info.grid( row=2, column=0, columnspan=2, pady=5 )

	def run( self ) :
		self.top.mainloop()

	def do_btn_update( self ) :
		self.var_info.set( "updating ... please wait!" )
		self.label_info.update()

		ret = do_update_depend( self.var_target.get() )
		if ret == 0 :
			self.var_info.set( "OK -- update depend success" )
		else :
			self.var_info.set( "ERR -- update depend failed" )

def console_update() :
	valid_target = s_valid_targets_linux + s_valid_targets_mac
	for i in range( len(valid_target) ) :
		print str(i+1) + " : " + valid_target[i]
	ret = raw_input( "Target [1] : " )
	if ret == "" :
		tg = valid_target[0]
	else :
		tg = valid_target[int(ret)-1]

	ret = do_update_depend( tg )
	if ret == 0 :
		print "OK -- update depend success"
	else :
		print "ERR -- update depend failed"

	sys.exit(ret)

if __name__ == '__main__' :
	if len( sys.argv ) >= 2 :
		ret = do_update_depend( sys.argv[1] )
		if ret == 0 :
			print "OK -- update depend success"
		else :
			print "ERR -- update depend failed" 
		sys.exit(ret)
	elif os.name == "nt" :
		gud = gui_updater()
		gud.run()
	else :
		console_update()

