/*
 * The poke table is a series of long words, in the format
 *
 *	opcode, address, operand, ...
 *
 * An opcode of 0 marks the table end
 */


/*
 * Only define the following if you want to use the "old"
 * poke loop table interpreter. This should *not* be
 * defined if you are now using the "romgen" tool to
 * generate contemporary poke tables. The latest generation
 * targetpacks may be incompatible with the old interpreter.
 */
#undef CONFIG_SH_OLD_POKE_LOOP_PARADIGM


#include "asm/stxh415reg.h"
#include "../../../cpu/sh/init_ram.S"


	.section .data.init, "a"

	.balign 32

__memory_setup_table:

	/*
	 * include the appropriate set of "GDB pokes", (usually) generated
	 * using the "romgen" utility, from a known good target-pack.
	 *
	 * This file may be regenerated by executing the following
	 * command (redirecting the output), *without* needing any
	 * access to either a MicroConnect or a target board:
	 *
	 * host% romgen --show-comment dummy:b2000stxh415:st40,se=0
	 *
	 * Where "dummy" need not correspond to any real IP address on
	 * your network.  In addition, note that "b2000stxh415" should
	 * substituted if you have a custom target-pack connect command.
	 *
	 * It should be noted that the above command explicitly includes
	 * the option "se=0", which disables SE (or 32-bit) mode. This is
	 * correct, even though you may be using 32-bit mode at run-time.
	 * The "GDB pokes" are presently always executed in a 29-bit context,
	 * hence the need to disable 32-bit mode when running "romgen".
	 */
#include "b2000-stxh415.romgen"

	END_MARKER

__memory_setup_table_end:

	.end
