/*
 * The poke table is a series of long words, in the format
 *
 *       opcode, address, operand, ...
 *
 * An opcode of 0 marks the table end
 */


/*
 * Only define the following if you want to use the "old"
 * poke loop table interpreter. This should *not* be
 * defined if you are now using the "romgen" tool to
 * generate contemporary poke tables. The latest generation
 * targetpacks may be incompatible with the old interpreter.
 */
#define CONFIG_SH_OLD_POKE_LOOP_PARADIGM	/* QQQ - DELETE */


#include "asm/stb7100reg.h"
#include "../../../cpu/sh/init_ram.S"


	.section .data.init, "a"

	.balign 32

__memory_setup_table:

	/*
	 * CLOCKGENA setup PLL0
	 */
	POKE_LONG(STB7100_CLOCKGENA_LOCK, 0xc0de)
	OR_LONG(STB7100_CLOCKGENA_PLL0_CFG, 0x00100000)
	UPDATE_LONG(STB7100_CLOCKGENA_PLL0_CFG, 0xfff7ffff, 0)
#if (INPUT_CLOCK_RATE == 30)
	UPDATE_LONG(STB7100_CLOCKGENA_PLL0_CFG, 0xfff80000, 0x14 | (0xb1 << 8) | (0x0 << 16))
#else
	UPDATE_LONG(STB7100_CLOCKGENA_PLL0_CFG, 0xfff80000, 0x06 | (0x3b << 8) | (0x0 << 16))
#endif
	OR_LONG(STB7100_CLOCKGENA_PLL0_CFG, 0x00080000)
	WHILE_NE(STB7100_CLOCKGENA_PLL0_STATUS, 0x00000001, 0x00000001)
	UPDATE_LONG(STB7100_CLOCKGENA_PLL0_CFG, 0xffefffff, 0)
	POKE_LONG(STB7100_CLOCKGENA_LOCK, 0x0)
	/*
	 * CLOCKGENA setup PLL1
	 */
	POKE_LONG(STB7100_CLOCKGENA_LOCK, 0xc0de)
	POKE_LONG(STB7100_CLOCKGENA_PLL1_BYPASS, 0x00000002)
	UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff7ffff, 0)
	IF_DEVID(STB7100_CUT1) /* 266 MHz */
#if (INPUT_CLOCK_RATE == 30)
	  UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x1e | (0x85 << 8) | (0x0 << 16))
#else
	  UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x1b | (0x85 << 8) | (0x0 << 16))
#endif
	ELSE
#if (INPUT_CLOCK_RATE == 30)   /* 384 MHz */
	  UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x0a | (0x80 << 8) | (0x1 << 16))
#else
	  UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x09 | (0x80 << 8) | (0x1 << 16))
#endif
	ENDIF
	IF_DEVID(STB7100_CUT3) /* 400MHz */
#if (INPUT_CLOCK_RATE == 30)
	  UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x1e | (0xc8 << 8) | (0x0 << 16))
#else
	  UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x1b | (0xc8 << 8) | (0x0 << 16))
#endif
	ENDIF
	IF_DEVID(STB7109_CUT2) /* 400MHz */
#if (INPUT_CLOCK_RATE == 30)
	  UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x1e | (0xc8 << 8) | (0x0 << 16))
#else
	  UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x1b | (0xc8 << 8) | (0x0 << 16))
#endif
	ENDIF
	IF_DEVID(STB7109_CUT3) /* 400MHz */
#if (INPUT_CLOCK_RATE == 30)
	  UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x1e | (0xc8 << 8) | (0x0 << 16))
#else
	  UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x1b | (0xc8 << 8) | (0x0 << 16))
#endif
	ENDIF
	OR_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0x00080000)
	WHILE_NE(STB7100_CLOCKGENA_PLL1_STATUS, 0x00000001, 0x00000001)
	POKE_LONG(STB7100_CLOCKGENA_PLL1_BYPASS, 0x00000000)
	POKE_LONG(STB7100_CLOCKGENA_LOCK, 0x0)
	/*
	 * SYSCONF setup
	 */
	POKE_LONG(STB7100_SYSCONF_SYS_CFG11, 0x0d7fd4ea)

	WHILE_NE(STB7100_SYSCONF_SYS_STA12, (1 << 9) | (1 << 19), (1 << 9) | (1 << 19))
	WHILE_NE(STB7100_SYSCONF_SYS_STA13, (1 << 9) | (1 << 19), (1 << 9) | (1 << 19))

	POKE_LONG(STB7100_SYSCONF_SYS_CFG12, 0x4000000f | (0xf << 12) | (0xf << 23))
	POKE_LONG(STB7100_SYSCONF_SYS_CFG13, 0x4000000f | (0xf << 12) | (0xf << 23))

	IF_DEVID(STB7100_CUT1)
	  POKE_LONG(STB7100_SYSCONF_SYS_CFG14, (1 << 18) | (0x5a << 20))
	  POKE_LONG(STB7100_SYSCONF_SYS_CFG15, (1 << 19) | (0xa9 << 20))
	  POKE_LONG(STB7100_SYSCONF_SYS_CFG20, (1 << 18) | (0x5a << 20))
	  POKE_LONG(STB7100_SYSCONF_SYS_CFG21, (1 << 19) | (0xa9 << 20))
	ENDIF

	/*
	 * LMI SYS setup
	 */
	POKE_LONG(ST40_LMI_MIM_0(SYS), 0x861a025f)
	POKE_LONG(ST40_LMI_MIM_1(SYS), 0x01010022)

	POKE_LONG(ST40_LMI_STR(SYS), 0x35b06455)

#if CONFIG_SH_HMP7100_128
	POKE_LONG(ST40_LMI_SDRA0(SYS), 0x0c001a00)
	POKE_LONG(ST40_LMI_SDRA1(SYS), 0x0c001a00)
#else
	POKE_LONG(ST40_LMI_SDRA0(SYS), 0x08001900)
	POKE_LONG(ST40_LMI_SDRA1(SYS), 0x08001900)
#endif

	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000001)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000003)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000001)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000002)

	POKE_LONG(ST40_LMI_SDMR0(SYS), 0x00000402)
	POKE_LONG(ST40_LMI_SDMR0(SYS), 0x00000133)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000002)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000004)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000004)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000004)
	POKE_LONG(ST40_LMI_SDMR0(SYS), 0x00000033)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000000)

	/*
	 * LMI VID setup
	 */
	POKE_LONG(ST40_LMI_MIM_0(VID), 0x861a025f)
	POKE_LONG(ST40_LMI_MIM_1(VID), 0x01010022)

	POKE_LONG(ST40_LMI_STR(VID), 0x35b06455)
	POKE_LONG(ST40_LMI_SDRA0(VID), 0x14001900)
	POKE_LONG(ST40_LMI_SDRA1(VID), 0x14001900)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000001)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000003)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000001)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000002)
	POKE_LONG(ST40_LMI_SDMR0(VID), 0x00000402)
	POKE_LONG(ST40_LMI_SDMR0(VID), 0x00000133)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000002)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000004)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000004)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000004)
	POKE_LONG(ST40_LMI_SDMR0(VID), 0x00000033)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000000)

#if CONFIG_SH_HMP7100_128
       POKE_LONG(SH4_CCN_CCR, 0x8000090d)
#endif

	/*
	 * EMI setup
	 */
	POKE_LONG(ST40_EMI_BANK_ENABLE, 0x00000005)

	POKE_LONG(ST40_EMI_BANK0_BASEADDRESS, 0x00000000)
#if 1	/* see https://bugzilla.stlinux.com/show_bug.cgi?id=9065#c27 */
	POKE_LONG(ST40_EMI_BANK1_BASEADDRESS, 0x00000008)
#else
	POKE_LONG(ST40_EMI_BANK1_BASEADDRESS, 0x00000004)
#endif
	POKE_LONG(ST40_EMI_BANK2_BASEADDRESS, 0x00000008)
	POKE_LONG(ST40_EMI_BANK3_BASEADDRESS, 0x0000000a)
	POKE_LONG(ST40_EMI_BANK4_BASEADDRESS, 0x0000000c)
	/* FLASH */
	POKE_LONG(ST40_EMI_BANK0_EMICONFIGDATA0, 0x001016d1)
	POKE_LONG(ST40_EMI_BANK0_EMICONFIGDATA1, 0x9d200000)
	POKE_LONG(ST40_EMI_BANK0_EMICONFIGDATA2, 0x9d220000)
	POKE_LONG(ST40_EMI_BANK0_EMICONFIGDATA3, 0x00000000)
	/* EPLD & LAN91C111 */
	POKE_LONG(ST40_EMI_BANK2_EMICONFIGDATA0, 0x042086f1)
	POKE_LONG(ST40_EMI_BANK2_EMICONFIGDATA1, 0x88112111)
	POKE_LONG(ST40_EMI_BANK2_EMICONFIGDATA2, 0x88112211)
	POKE_LONG(ST40_EMI_BANK2_EMICONFIGDATA3, 0x00000000)
	/* ATAPI */

	IF_DEVID(STB7100_CUT1)
	  POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA0, 0x00021791)
	  POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA1, 0x08004141)
	  POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA2, 0x08004141)
	ELSE
	  POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA0, 0x00200791)
	  POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA1, 0x0c006700)
	  POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA2, 0x0c006700)
	ENDIF
	POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA3, 0x00000000)

	/* Program other EMI registers */

	/* Program other EMI registers */
	IF_DEVID(STB7100_CUT1)
	  POKE_LONG(ST40_EMI_GENCFG, 0x00000010)
	ENDIF
	IF_DEVID(STB7100_CUT2)
	  POKE_LONG(ST40_EMI_GENCFG, 0x00000050)
	ENDIF
	IF_DEVID(STB7100_CUT3)
	  POKE_LONG(ST40_EMI_GENCFG, 0x00000050)
	ENDIF
	IF_DEVID(STB7109_CUT1)
	  POKE_LONG(ST40_EMI_GENCFG, 0x00000010)
	ENDIF
	IF_DEVID(STB7109_CUT2)
	  POKE_LONG(ST40_EMI_GENCFG, 0x00000010)
	ENDIF
	IF_DEVID(STB7109_CUT3)
	  POKE_LONG(ST40_EMI_GENCFG, 0x00000010)
	ENDIF

#if defined(CONFIG_SH_SE_MODE) && !defined(CONFIG_SH_STB7109_CUT2)
  /*
   * Note that we also manually need to move the System and Video LMI base
   * addresses to their 32-bit SE mode locations as defined in the datasheet.
   */
        UPDATE32(STB7100_SYSCONF_SYS_CFG36, 0xFF00FF00, 0x00600040)
#ifdef CONFIG_SH_HMP7100_128
        UPDATE32(ST40_LMI_SDRA0_0(SYS), 0x001FFFFF, (0x48000000 & 0xFFE00000))
        UPDATE32(ST40_LMI_SDRA1_0(SYS), 0x001FFFFF, (0x48000000 & 0xFFE00000))
#else
        UPDATE32(ST40_LMI_SDRA0_0(SYS), 0x001FFFFF, (0x44000000 & 0xFFE00000))
        UPDATE32(ST40_LMI_SDRA1_0(SYS), 0x001FFFFF, (0x44000000 & 0xFFE00000))
#endif
        UPDATE32(ST40_LMI_SDRA0_0(VID), 0x001FFFFF, (0x64000000 & 0xFFE00000))
        UPDATE32(ST40_LMI_SDRA1_0(VID), 0x001FFFFF, (0x64000000 & 0xFFE00000))

#endif	/* CONFIG_SH_SE_MODE */

	END_MARKER

__memory_setup_table_end:

	.end
