/*
 * The poke table is a series of long words, in the format
 *
 *       opcode, address, operand, ...
 *
 * An opcode of 0 marks the table end
 */


/*
 * Only define the following if you want to use the "old"
 * poke loop table interpreter. This should *not* be
 * defined if you are now using the "romgen" tool to
 * generate contemporary poke tables. The latest generation
 * targetpacks may be incompatible with the old interpreter.
 */
#define CONFIG_SH_OLD_POKE_LOOP_PARADIGM	/* QQQ - DELETE */


#include "asm/stb7100reg.h"
#include "../../../cpu/sh/init_ram.S"


	.section .data.init, "a"

	.balign 32

__memory_setup_table:

	/*
	 * CLOCKGENA setup PLL0
	 */

	POKE_LONG(STB7100_CLOCKGENA_LOCK, 0xc0de)
	OR_LONG(STB7100_CLOCKGENA_PLL0_CFG, 0x00100000)
	UPDATE_LONG(STB7100_CLOCKGENA_PLL0_CFG, 0xfff7ffff, 0)
	UPDATE_LONG(STB7100_CLOCKGENA_PLL0_CFG, 0xfff80000, 0x06 | (0x3b << 8) | (0x0 << 16))
	OR_LONG(STB7100_CLOCKGENA_PLL0_CFG, 0x00080000)
	WHILE_NE(STB7100_CLOCKGENA_PLL0_STATUS, 0x00000001, 0x00000001)
	UPDATE_LONG(STB7100_CLOCKGENA_PLL0_CFG, 0xffefffff, 0)
	POKE_LONG(STB7100_CLOCKGENA_LOCK, 0x0)

	/*
	 * CLOCKGENA setup PLL1
	 */

	POKE_LONG(STB7100_CLOCKGENA_LOCK, 0xc0de)
	POKE_LONG(STB7100_CLOCKGENA_PLL1_BYPASS, 0x00000002)
	UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff7ffff, 0)
#if CONFIG_SH_STB7100_V1_1
	UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x1b | (0x85 << 8) | (0x0 << 16))
#else
	UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x09 | (0x80 << 8) | (0x1 << 16)) /* 384MHz */
	IF_DEVID(STB7100_CUT3) /* 400MHz */
	  UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x1b | (0xc8 << 8) | (0x0 << 16))
	ENDIF
	IF_DEVID(STB7109_CUT2) /* 400MHz */
	  UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x1b | (0xc8 << 8) | (0x0 << 16))
	ENDIF
	IF_DEVID(STB7109_CUT3) /* 400MHz */
	  UPDATE_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0xfff80000, 0x1b | (0xc8 << 8) | (0x0 << 16))
	ENDIF
#endif
	OR_LONG(STB7100_CLOCKGENA_PLL1_CFG, 0x00080000)
	WHILE_NE(STB7100_CLOCKGENA_PLL1_STATUS, 0x00000001, 0x00000001)
	POKE_LONG(STB7100_CLOCKGENA_PLL1_BYPASS, 0x00000000)
	POKE_LONG(STB7100_CLOCKGENA_LOCK, 0x0)

	/*
	 * SYSCONF setup
	 */
	IF_DEVID(STB7109_CUT1)
	  POKE_LONG(STB7100_SYSCONF_SYS_CFG11, 0x0807fec0)
	ELSE
	  POKE_LONG(STB7100_SYSCONF_SYS_CFG11, 0x080780c0)
	  WHILE_NE(STB7100_SYSCONF_SYS_STA12, (1 << 9) | (1 << 19), (1 << 9) | (1 << 19))
	ENDIF
	WHILE_NE(STB7100_SYSCONF_SYS_STA13, (1 << 9) | (1 << 19), (1 << 9) | (1 << 19))

	POKE_LONG(STB7100_SYSCONF_SYS_CFG12, 0x4000000f | (0xf << 12) | (0xf << 23))
	POKE_LONG(STB7100_SYSCONF_SYS_CFG13, 0x4000000f | (0xf << 12) | (0xf << 23))

#ifdef  CONFIG_SH_STB7100_V1_1
	POKE_LONG(STB7100_SYSCONF_SYS_CFG14, (1 << 18) | (0x5a << 20))
	POKE_LONG(STB7100_SYSCONF_SYS_CFG15, (1 << 19) | (0xa9 << 20))
	POKE_LONG(STB7100_SYSCONF_SYS_CFG20, (1 << 18) | (0x5a << 20))
	POKE_LONG(STB7100_SYSCONF_SYS_CFG21, (1 << 19) | (0xa9 << 20))
#else
	IF_DEVID(STB7100_CUT1)
	  POKE_LONG(STB7100_SYSCONF_SYS_CFG14, (1 << 18) | (0x50 << 20))
	  POKE_LONG(STB7100_SYSCONF_SYS_CFG15, (1 << 19) | (0x40 << 20))
	  POKE_LONG(STB7100_SYSCONF_SYS_CFG20, (1 << 18) | (0x50 << 20))
	  POKE_LONG(STB7100_SYSCONF_SYS_CFG21, (1 << 19) | (0x40 << 20))
	ENDIF
#endif
	/*
	 * LMI SYS setup
	 */
#ifdef CONFIG_SH_STB7100_V1_1
	POKE_LONG(ST40_LMI_MIM_0(SYS), 0x061a0247)
	POKE_LONG(ST40_LMI_MIM_1(SYS), 0x01010000)
#else
	POKE_LONG(ST40_LMI_MIM_0(SYS), 0x061a0247)
	POKE_LONG(ST40_LMI_MIM_1(SYS), 0x01010022)
#endif
	POKE_LONG(ST40_LMI_STR(SYS), 0x35b06455)

	POKE_LONG(ST40_LMI_SDRA0(SYS), 0x08001900)
	POKE_LONG(ST40_LMI_SDRA1(SYS), 0x08001900)

	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000001)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000003)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000001)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000002)
	POKE_LONG(ST40_LMI_SDMR0(SYS), 0x00000402)
	POKE_LONG(ST40_LMI_SDMR0(SYS), 0x00000133)

	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000002)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000004)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000004)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000004)
	POKE_LONG(ST40_LMI_SDMR0(SYS), 0x00000033)
	POKE_LONG(ST40_LMI_SCR(SYS), 0x00000000)

	/*
	 * LMI VID setup
	 */
#ifdef CONFIG_SH_STB7100_V1_1
	POKE_LONG(ST40_LMI_MIM_0(VID), 0x061a0247)
	POKE_LONG(ST40_LMI_MIM_1(VID), 0x01010000)
#else
	POKE_LONG(ST40_LMI_MIM_0(VID), 0x061a0247)
	POKE_LONG(ST40_LMI_MIM_1(VID), 0x01010022)
#endif
	POKE_LONG(ST40_LMI_STR(VID), 0x35b06455)
	POKE_LONG(ST40_LMI_SDRA0(VID), 0x14001900)
	POKE_LONG(ST40_LMI_SDRA1(VID), 0x14001900)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000001)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000003)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000001)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000002)
	POKE_LONG(ST40_LMI_SDMR0(VID), 0x00000402)
	POKE_LONG(ST40_LMI_SDMR0(VID), 0x00000133)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000002)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000004)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000004)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000004)
	POKE_LONG(ST40_LMI_SDMR0(VID), 0x00000033)
	POKE_LONG(ST40_LMI_SCR(VID), 0x00000000)

	/*
	 * EMI setup
	 */
	POKE_LONG(ST40_EMI_BANK_ENABLE, 0x00000005)
	POKE_LONG(ST40_EMI_BANK0_BASEADDRESS, 0x00000000)
	POKE_LONG(ST40_EMI_BANK1_BASEADDRESS, 0x00000004)
	POKE_LONG(ST40_EMI_BANK2_BASEADDRESS, 0x00000008)
	POKE_LONG(ST40_EMI_BANK3_BASEADDRESS, 0x0000000a)
	POKE_LONG(ST40_EMI_BANK4_BASEADDRESS, 0x0000000c)
	/* FLASH */
	POKE_LONG(ST40_EMI_BANK0_EMICONFIGDATA0, 0x001016d1)
	POKE_LONG(ST40_EMI_BANK0_EMICONFIGDATA1, 0x9d200000)
	POKE_LONG(ST40_EMI_BANK0_EMICONFIGDATA2, 0x9d220000)
	POKE_LONG(ST40_EMI_BANK0_EMICONFIGDATA3, 0x00000000)
	/* STEM Module */
	POKE_LONG(ST40_EMI_BANK1_EMICONFIGDATA0, 0x041086f1)
	POKE_LONG(ST40_EMI_BANK1_EMICONFIGDATA1, 0x0e024400)
	POKE_LONG(ST40_EMI_BANK1_EMICONFIGDATA2, 0x0e024400)
	POKE_LONG(ST40_EMI_BANK1_EMICONFIGDATA3, 0x00000000)
	/* DVBCI */
	POKE_LONG(ST40_EMI_BANK2_EMICONFIGDATA0, 0x002046f9)
	POKE_LONG(ST40_EMI_BANK2_EMICONFIGDATA1, 0xa5a00000)
	POKE_LONG(ST40_EMI_BANK2_EMICONFIGDATA2, 0xa5a20000)
	POKE_LONG(ST40_EMI_BANK2_EMICONFIGDATA3, 0x00000000)
	/* ATAPI */
#if defined(CONFIG_SH_STB7100_V1_1)
	POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA0, 0x00021791)
	POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA1, 0x08004141)
	POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA2, 0x08004141)
	POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA3, 0x00000000)
#else
	POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA0, 0x00021791)
	POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA1, 0x0c006700)
	POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA2, 0x0c006700)
	POKE_LONG(ST40_EMI_BANK3_EMICONFIGDATA3, 0x00000000)
#endif

	/* EPLD & LAN91C111 */

	POKE_LONG(ST40_EMI_BANK4_EMICONFIGDATA0, 0x042086f1)
	POKE_LONG(ST40_EMI_BANK4_EMICONFIGDATA1, 0x88112111)
	POKE_LONG(ST40_EMI_BANK4_EMICONFIGDATA2, 0x88112211)
	POKE_LONG(ST40_EMI_BANK4_EMICONFIGDATA3, 0x00000000)

	/* Program other EMI registers */
	IF_DEVID(STB7100_CUT1)
	  POKE_LONG(ST40_EMI_GENCFG, 0x00000010)
	ENDIF
	IF_DEVID(STB7100_CUT2)
	  POKE_LONG(ST40_EMI_GENCFG, 0x00000050)
	ENDIF
	IF_DEVID(STB7100_CUT3)
	  POKE_LONG(ST40_EMI_GENCFG, 0x00000050)
	ENDIF
	IF_DEVID(STB7109_CUT1)
	  POKE_LONG(ST40_EMI_GENCFG, 0x00000010)
	ENDIF
	IF_DEVID(STB7109_CUT2)
	  POKE_LONG(ST40_EMI_GENCFG, 0x00000010)
	ENDIF
	IF_DEVID(STB7109_CUT3)
	  POKE_LONG(ST40_EMI_GENCFG, 0x00000010)
	ENDIF

	END_MARKER

__memory_setup_table_end:

	.end
