#	********************************************************************************
#                                     
#                                  upload_pkg.py
#
#   (c) Copyright 1992-2013, ZheJiang Dahua Information Technology Stock CO.LTD.
#                            All Rights Reserved
#
#	File		: upload_pkg.py
#	Description	: 
#	Modify		: 2013/08/08	LiBin		Create the file
#	********************************************************************************

#!/bin/env python

import os, sys
import shutil, stat
import string
import ftplib
from datetime import date

try :
	from Tkinter import *
except ImportError :
	pass


s_valid_targets_windows = [ "win32-vs2005-debug", "win32-vs2005-release",
	"win64-vs2005-debug", "win64-vs2005-release" ]
s_valid_targets_linux = [ "linux32-centos6-gcc-debug", "linux32-centos6-gcc-release",
	"linux64-centos6-gcc-debug", "linux64-centos6-gcc-release",
	"linux32-centos5-gcc-debug", "linux32-centos5-gcc-release" ]
s_valid_targets_mac = [ "mac32-llvmgcc42-debug", "mac32-llvmgcc42-release" ]
s_valid_targets_all = s_valid_targets_windows + s_valid_targets_linux + s_valid_targets_mac


def on_rmtree_error( func, path, exec_info ) :
	if os.access( path, os.F_OK ) :
		os.chmod( path, stat.S_IREAD | stat.S_IWRITE )
		func( path )

def do_rmtree( path ) :
	for i in range(3) :
		try :
			shutil.rmtree( path, onerror = on_rmtree_error )
		finally :
			if not os.access( path, os.F_OK ) :
				return 0
		time.sleep(1)

	print "delete path [%s] failed" % path
	return 1

def read_local_svn_info() :
	local_svn_info = {}
	local_svn_info["modname"] = "Unknown"
	local_svn_info["path"] = "/NotFound"
	local_svn_info["version"] = "404"
	os.putenv( "LC_ALL", "C" )
	info = os.popen( "svn info .." ).read()
	# URL: http://10.6.5.2/svnpl/BASPlatform/DSSModule/DssBaseLib/Trunk
	# Last Changed Rev: 54790
	for line in string.split( info, "\n" ) :
		if string.find( line, "URL:" ) == 0 :
			idx = line.find( "/", 12 )
			idx = line.find( "/", idx + 1 )
			local_svn_info["path"] = line[idx:]
			words = string.split( line, "/" )
			if words[-1] == "Trunk" :
				local_svn_info["modname"] = words[-2]
			else :
				local_svn_info["modname"] = words[-3]
		elif string.find( line, "Last Changed Rev:" ) == 0 :
			local_svn_info["version"] = str(int(line[18:]))
		
	return local_svn_info


def do_upload_pkg( up_param ) :
	if not up_param["target_type"] in s_valid_targets_all :
		print "ERR : target type [ " + up_param["target_type"] + " ] not valid"
		return 1
	if up_param["modname"] == "" or up_param["path"] == "" or up_param["version"] == "" :
		print "ERR : bad param"
		return 1

	####################################
	####	Custom Section Begin
	####################################

	today = date.today()

	# zipname = up_param["modname"]
	zipname = "Proj_DSSM"
	release_name = "General_DSSM-Server_Chn_IS_V3.00.000.R." + today.strftime( "%Y%m%d" )
	if up_param["target_type"].find( "debug" ) >= 0 :
		zipname = zipname + "_d"
		release_name = release_name + "_d"
	if up_param["target_type"][0:3] == "win" :
		zipname = zipname + ".zip"
		release_name = release_name + ".zip"
	else :
		zipname = zipname + ".tar.gz"
		release_name = release_name + ".tar.gz"
	
	####################################
	####	Custom Section End
	####################################

	pkgsvr = up_param["pkgsvr"]
	if pkgsvr[0:6] != "ftp://" :
		print "bak pkgsvr [%s]" % pkgsvr
		return 1

	host = pkgsvr[6:]
	port = 21
	user = "anonymous"
	passwd = "anonymous"
	path_prefix = "/"
	idx = host.find( "/" )
	if idx != -1 :
		path_prefix = host[idx:]
		host = host[0:idx]
	idx = host.find( "@" )
	if idx != -1 :
		user = host[0:idx]
		host = host[idx+1:]
	idx = host.find( ":" )
	if idx != -1 :
		port = int( host[idx+1:] )
		host = host[0:idx]
	idx = user.find( ":" )
	if idx != -1 :
		passwd = user[idx+1:]
		user = user[0:idx]

	try :
		hftp = ftplib.FTP()
		hftp.connect( host, port )
		hftp.login( user, passwd )
		hftp.cwd( path_prefix )
		total_path = "./" + up_param["path"] + "/" + up_param["version"] + "/" + up_param["target_type"]
		# enter path, if not exist, create it
		for pdir in string.split( total_path, "/" ) :
			if pdir == "" or pdir == "." :
				continue
			trymkd = 0
			try :
				hftp.cwd( pdir )
			except Exception, e :
				trymkd = 1
			if trymkd == 0 :
				continue
			try :
				hftp.mkd( pdir )
				hftp.cwd( pdir )
			except Exception, e :
				print "enter dir [%s] failed, err %s" % ( pdir, e )
				return 1

		# upload file
		fp = open( zipname, "rb" )
		hftp.storbinary( "STOR " + zipname, fp )
		fp.close()
		fp = open( release_name, "rb" )
		hftp.storbinary( "STOR " + release_name, fp )
		fp.close()
		hftp.close()
	except Exception, e :
		print "put ftp file [%s] failed, err %s" % ( zipname, e )
		return 1

	return 0
			

def direct_upload() :
	up_param = {}

	local_svn_info = read_local_svn_info()

	up_param["modname"] = local_svn_info["modname"]
	up_param["path"] = local_svn_info["path"]
	up_param["version"] = local_svn_info["version"]

	up_param["target_type"] = sys.argv[1]

	if len( sys.argv ) >= 3 :
		up_param["modname"] = sys.argv[2]

	if len( sys.argv ) >= 4 :
		up_param["path"] = sys.argv[3]

	if len( sys.argv ) >= 5 :
		up_param["version"] = sys.argv[4]

	up_param["pkgsvr"] = os.getenv( "DSLCT_PKGSVR", "ftp://10.24.5.46" )

	ret = do_upload_pkg( up_param )
	if ret == 0 :
		print "OK -- upload success"
	else :
		print "ERR : Upload Failed"

	sys.exit(ret)

def console_upload() :
	up_param = {}
	local_svn_info = read_local_svn_info()

	valid_target = s_valid_targets_linux + s_valid_targets_mac
	for i in range( len(valid_target) ) :
		print str(i+1) + " : " + valid_target[i]
	ret = raw_input( "Target [1] : " )
	if ret == "" :
		up_param["target_type"] = valid_target[0]
	else :
		up_param["target_type"] = valid_target[int(ret)-1]


	up_param["modname"] = raw_input( "ModuleName [" + local_svn_info["modname"] + "] : " )
	if up_param["modname"] == "" :
		up_param["modname"] = local_svn_info["modname"]
	up_param["path"] = raw_input( "Path [" + local_svn_info["path"] + "] : " )
	if up_param["path"] == "" :
		up_param["path"] = local_svn_info["path"]
	up_param["version"] = raw_input( "SVN SRC Version [" + local_svn_info["version"] + "] : " )
	if up_param["version"] == "" :
		up_param["version"] = local_svn_info["version"]

	up_param["pkgsvr"] = os.getenv( "DSLCT_PKGSVR", "ftp://10.24.5.46" )

	# print up_param
	# sys.exit(0)

	ret = do_upload_pkg( up_param )
	if ret == 0 :
		print "OK -- upload success"
	else :
		print "ERR : Upload Failed"

	sys.exit(ret)


class gui_uploader :
	def __init__( self ) :
		top = Tk()
		self.top = top
		top.grid()

		local_svn_info = read_local_svn_info()
		lb1 = Label( top, text="ModuleName" )
		lb1.grid( row=0, column=0, padx=7, pady=2 )
		self.var_modname = StringVar()
		et1 = Entry( top, textvariable=self.var_modname, width=50 )
		self.var_modname.set( local_svn_info["modname"] )
		et1.grid( row=0, column=1, padx=7, pady=2 )

		lb2 = Label( top, text="Path" )
		lb2.grid( row=1, column=0, padx=7, pady=2 )
		self.var_path = StringVar()
		et2 = Entry( top, textvariable=self.var_path, width=50 )
		self.var_path.set( local_svn_info["path"] )
		et2.grid( row=1, column=1, padx=7, pady=2 )

		lb3 = Label( top, text="Version" )
		lb3.grid( row=2, column=0, padx=7, pady=2 )
		self.var_version = StringVar()
		et3 = Entry( top, textvariable=self.var_version, width=50 )
		self.var_version.set( local_svn_info["version"] )
		et3.grid( row=2, column=1, padx=7, pady=2 )

		lb4 = Label( top, text="TargetName" )
		lb4.grid( row=3, column=0, padx=7, pady=2 )
		self.var_target = StringVar()
		om4 = OptionMenu( top, self.var_target, *s_valid_targets_windows )
		self.var_target.set( "win32-vs2005-debug" )
		om4.grid( row=3, column=1, padx=7, pady=2 )

		lb5 = Label( top, text="PkgSvr" )
		lb5.grid( row=4, column=0, padx=7, pady=2 )
		self.var_pkgsvr = StringVar()
		et5 = Entry( top, textvariable=self.var_pkgsvr, width=50 )
		self.var_pkgsvr.set( os.getenv( "DSLCT_PKGSVR", "ftp://10.24.5.46" ) )
		et5.grid( row=4, column=1, padx=7, pady=2 )

		btn = Button( top, text="upload", command=self.do_btn_upload )
		btn.grid( row=5, column=0, columnspan=2 )

		self.var_info = StringVar()
		self.info = Label( top, textvariable=self.var_info )
		self.info.grid( row=6, column=0, columnspan=2, pady=5 )


	def run( self ) :
		self.top.mainloop()

	def do_btn_upload( self ) :
		self.var_info.set( "uploading ... please wait!" )
		self.info.update()
		up_param = {}
		up_param["modname"] = self.var_modname.get()
		up_param["path"] = self.var_path.get()
		up_param["version"] = self.var_version.get()
		up_param["target_type"] = self.var_target.get()

		up_param["pkgsvr"] = self.var_pkgsvr.get()

		ret = do_upload_pkg( up_param )
		if ret == 0 :
			self.var_info.set( "OK -- upload success" )
		else :
			self.var_info.set( "ERR -- upload failed" )

if __name__ == "__main__" :
	if len( sys.argv ) >= 2 :
		direct_upload()
	elif os.name == "nt" :
		gud = gui_uploader()
		gud.run()
	else :
		console_upload()

