#include "ssl_thread_mutex.h"

/*
	* 普通锁实现
*/
int ssl_thread_mutex_init(ssl_thread_mutex* mutex)
{
	return pthread_mutex_init(&(mutex->mtx), NULL);
}

int ssl_thread_mutex_lock(ssl_thread_mutex* mutex)
{
	return pthread_mutex_lock(&(mutex->mtx));
}

int ssl_thread_mutex_unlock(ssl_thread_mutex* mutex)
{
	return pthread_mutex_unlock(&(mutex->mtx));
}

int ssl_thread_mutex_destroy(ssl_thread_mutex* mutex)
{
	return pthread_mutex_destroy(&(mutex->mtx)) ;
}

/*
	* 读写锁实现
*/
int ssl_thread_rw_mutex_init(ssl_thread_rw_mutex* mutex)
{
#ifndef _NO_RWLOCK_LINUX_
	return pthread_rwlock_init(&(mutex->lock_rw),NULL);
#else
	return pthread_mutex_init(&(mutex->mtx), NULL);
#endif	//_NO_RWLOCK_LINUX_
}

int ssl_thread_rw_mutex_lock(ssl_thread_rw_mutex* mutex, int mode)
{
#ifndef _NO_RWLOCK_LINUX_
	if( mode & SSL_READ_LOCK ){
		return pthread_rwlock_rdlock(&(mutex->lock_rw));
	}else if( mode & SSL_WRITE_LOCK ){
		return pthread_rwlock_wrlock(&(mutex->lock_rw));
	}
#else
	return pthread_mutex_lock(&(mutex->mtx));
#endif	//_NO_RWLOCK_LINUX_
}

int ssl_thread_rw_mutex_unlock(ssl_thread_rw_mutex* mutex)
{
#ifndef _NO_RWLOCK_LINUX_
	return pthread_rwlock_unlock(&(mutex->lock_rw));
#else
	return pthread_mutex_unlock(&(mutex->mtx));
#endif  //_NO_RWLOCK_LINUX_
}

int ssl_thread_rw_mutex_destroy(ssl_thread_rw_mutex* mutex)
{
#ifndef _NO_RWLOCK_LINUX_
	return pthread_rwlock_destroy(&(mutex->lock_rw));
#else
	return pthread_mutex_destroy(&(mutex->mtx)) ;
#endif  //_NO_RWLOCK_LINUX_
}
