/**********
This library is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the
Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version. (See <http://www.gnu.org/copyleft/lesser.html>.)

This library is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
more details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
**********/
// "liveMedia"
// Copyright (c) 1996-2012 Live Networks, Inc.  All rights reserved.
// MP4V-ES video RTP stream sources
// Implementation

#include "MPEG4ESVideoRTPSource.hh"

///////// MPEG4ESVideoRTPSource implementation ////////

//##### NOTE: INCOMPLETE!!! #####

// wanghao 2011/02/18 begin
int FindVOPStartCodeOffset(LPCBYTE lpSrc, unsigned nSrclen)
{
    // construct delta shift table
//    int     anMatch[16]    = {0};
    int     anMatch[256]    = {0};
    int     i               = 0;
    LPCBYTE lpPatternTemp   = NULL;
    LPCBYTE lpSrcTemp       = NULL;
    LPCBYTE lpSrcStr        = NULL;
//    BYTE    abyPattern[4]   = {0xB6, 0x01, 0x00, 0x00};
    BYTE    abyPattern[4]   = {0x00, 0x00, 0x01, 0xB6};

    for ( i = 0; i < 256; i ++ )
    {
        anMatch[i] = 4 + 1;
    }

    for ( i = 0, lpPatternTemp = abyPattern; i < 4; i ++, lpPatternTemp ++ )
    {
        anMatch[*lpPatternTemp] = static_cast<int>(4 - (lpPatternTemp - abyPattern));
    }

    // start searching...
    lpSrcStr = lpSrc;

    // the main searching loop
    while ( lpSrcStr + 4 <= lpSrc + nSrclen )
    {
        for ( i = 0, lpPatternTemp = abyPattern, lpSrcTemp = lpSrcStr; i < 4; lpPatternTemp ++, lpSrcTemp ++, i ++ )
        {
            if ( *lpPatternTemp != *lpSrcTemp ) // found a mismatch
            {
                break;
            }
        }

        if ( i == 4 ) // Yes! we found it!
        {
            return static_cast<int>(lpSrcStr - lpSrc);
        }

        lpSrcStr += anMatch[lpSrcStr[4]]; // move the pattern by a distance
    }

    return -1;
}
// wanghao 2011/02/18 end

MPEG4ESVideoRTPSource*
MPEG4ESVideoRTPSource::createNew(UsageEnvironment& env, Groupsock* RTPgs,
				   unsigned char rtpPayloadFormat,
				   unsigned rtpTimestampFrequency) {
  return new MPEG4ESVideoRTPSource(env, RTPgs, rtpPayloadFormat,
				   rtpTimestampFrequency);
}

MPEG4ESVideoRTPSource
::MPEG4ESVideoRTPSource(UsageEnvironment& env, Groupsock* RTPgs,
			unsigned char rtpPayloadFormat,
			unsigned rtpTimestampFrequency)
  : MultiFramedRTPSource(env, RTPgs,
			 rtpPayloadFormat, rtpTimestampFrequency) {
	fRTPHisSeqNo = 0;
	m_bSendFlag = False;
	fHisFrameNo = 0;
	m_bNext_Iframe = False;
	m_bOldPacketCompletesFrame = fCurrentPacketCompletesFrame;
	//m_bOldPacketCompletesFrame = False;
}

MPEG4ESVideoRTPSource::~MPEG4ESVideoRTPSource() {
}

Boolean MPEG4ESVideoRTPSource
::processSpecialHeader(BufferedPacket* packet,
		       unsigned& resultSpecialHeaderSize) {
  // The packet begins a frame iff its data begins with a system code
  // (i.e., 0x000001??)
  fCurrentPacketBeginsFrame
    = packet->dataSize() >= 4 && (packet->data())[0] == 0
    && (packet->data())[1] == 0 && (packet->data())[2] == 1;

  if(m_bOldPacketCompletesFrame && !fCurrentPacketBeginsFrame) {
	  envir()<< "packet error"<< (int)(packet->dataSize())<< "\r\n";
	  return False;
  }
  //if(!m_bOldPacketCompletesFrame && fCurrentPacketBeginsFrame)
	 // return False;

  // The RTP "M" (marker) bit indicates the last fragment of a frame:
  fCurrentPacketCompletesFrame = packet->rtpMarkerBit();
  m_bOldPacketCompletesFrame = fCurrentPacketCompletesFrame;
  // There is no special header
  resultSpecialHeaderSize = 0;
  if ( fCurrentPacketBeginsFrame )
  {
	  fKeyKeyPacketFrame = False;

        // search until we see vop_start_code (0x000001B6)
		// wanghao 2011/02/18 begin
        int nOffset = FindVOPStartCodeOffset( packet->data(), packet->dataSize() );

        if ( nOffset == -1 || packet->dataSize() <= static_cast<unsigned>(nOffset + 5) )
        {
            return True;
        }

        unsigned char vt_byte = (packet->data())[nOffset + 4];

        vt_byte &= 0xC0;
        vt_byte = vt_byte >> 6;

        if (vt_byte == 0)  //0,i-frame;1,p_frame;2,b_frame;3,d_frame
            fKeyKeyPacketFrame = True;
		//envir()<< (int)vt_byte << "\r\n";
        // wanghao 2011/02/18 end
  } 

  Boolean bResult = False;
  unsigned frameNo = fHisFrameNo;
  if(fCurrentPacketBeginsFrame)
	  frameNo += 1;
  if(fKeyKeyPacketFrame && fCurrentPacketBeginsFrame) {
	  fRTPHisSeqNo = packet->rtpSeqNo();
	  fHisFrameNo = frameNo;
	  m_bSendFlag = TRUE;
	  m_bNext_Iframe = FALSE;
	  bResult = True;
	//envir() << "seq=" << (int)fRTPHisSeqNo <<" " << (int)frameNo << "\n";
  }
  else
  {
	  bResult = checkSequenceSlice(packet->rtpSeqNo(), frameNo, fKeyKeyPacketFrame);
		//envir() << "seq=" << (int)packet->rtpSeqNo() <<" " << (int)frameNo << "\n";
	  return bResult;
  }
  return True;
}

char const* MPEG4ESVideoRTPSource::MIMEtype() const {
  return "video/MP4V-ES";
}


Boolean MPEG4ESVideoRTPSource
::checkSequenceSlice(short rtpSeqNo, unsigned frameNo, Boolean marker) {
	if(rtpSeqNo - fRTPHisSeqNo > 1 && fRTPHisSeqNo - rtpSeqNo != 65535) {
		m_bSendFlag = False;
		if(marker) {
			m_bNext_Iframe = False;
		} else {
			m_bNext_Iframe = True;
		}
	}
	if(!m_bSendFlag) {
		if(marker && fHisFrameNo != frameNo && m_bNext_Iframe) {
			m_bSendFlag = True;
		} else if (marker && fHisFrameNo != frameNo && !m_bNext_Iframe) {
			m_bNext_Iframe = True;
		}
	}
	fHisFrameNo = frameNo;
	fRTPHisSeqNo = rtpSeqNo;
	if(!m_bSendFlag)
	envir() <<"rtpseq" <<(int)rtpSeqNo <<"not send\r\n";
	return m_bSendFlag;
}