using System;
using System.Drawing;
using System.Windows.Forms;

namespace HUS.Controls.TabDock
{
	public interface IDockContent
	{
		DockContentHandler DockHandler	{	get;	}
		bool IsDisposed { get; }
	}

	public interface INestedPanesContainer
	{
		DockState DockState	{	get;	}
		Rectangle DisplayingRectangle	{	get;	}
		NestedPaneCollection NestedPanes	{	get;	}
		VisibleNestedPaneCollection VisibleNestedPanes	{	get;	}
		bool IsFloat	{	get;	}
	}

    internal interface IDragSource
    {
        Control DragControl { get; }
    }

    internal interface IDockDragSource : IDragSource
    {
        Rectangle BeginDrag(Point ptMouse);
        bool IsDockStateValid(DockState dockState);
        bool CanDockTo(DockPane pane);
        void FloatAt(Rectangle floatWindowBounds);
        void DockTo(DockPane pane, DockStyle dockStyle, int contentIndex);
        void DockTo(TabDockPanel panel, DockStyle dockStyle);
    }

    internal interface ISplitterDragSource : IDragSource
    {
        void BeginDrag(Rectangle rectSplitter);
        void EndDrag();
        bool IsVertical { get; }
        Rectangle DragLimitBounds { get; }
        void MoveSplitter(int offset);
    }
}
