/**************************************************************************
*
* Copyright (C) 2012 Steve Karg <skarg@users.sourceforge.net>
*
* Permission is hereby granted, free of charge, to any person obtaining
* a copy of this software and associated documentation files (the
* "Software"), to deal in the Software without restriction, including
* without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to
* permit persons to whom the Software is furnished to do so, subject to
* the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*********************************************************************/
#ifndef BACENUM_H
#define BACENUM_H

typedef enum {
    PROP_ACKED_TRANSITIONS = 0,
    PROP_ACK_REQUIRED = 1,
    PROP_ACTION = 2,
    PROP_ACTION_TEXT = 3,
    PROP_ACTIVE_TEXT = 4,
    PROP_ACTIVE_VT_SESSIONS = 5,
    PROP_ALARM_VALUE = 6,
    PROP_ALARM_VALUES = 7,
    PROP_ALL = 8,
    PROP_ALL_WRITES_SUCCESSFUL = 9,
    PROP_APDU_SEGMENT_TIMEOUT = 10,
    PROP_APDU_TIMEOUT = 11,
    PROP_APPLICATION_SOFTWARE_VERSION = 12,
    PROP_ARCHIVE = 13,
    PROP_BIAS = 14,
    PROP_CHANGE_OF_STATE_COUNT = 15,
    PROP_CHANGE_OF_STATE_TIME = 16,
    PROP_NOTIFICATION_CLASS = 17,
    PROP_BLANK_1 = 18,
    PROP_CONTROLLED_VARIABLE_REFERENCE = 19,
    PROP_CONTROLLED_VARIABLE_UNITS = 20,
    PROP_CONTROLLED_VARIABLE_VALUE = 21,
    PROP_COV_INCREMENT = 22,
    PROP_DATE_LIST = 23,
    PROP_DAYLIGHT_SAVINGS_STATUS = 24,
    PROP_DEADBAND = 25,
    PROP_DERIVATIVE_CONSTANT = 26,
    PROP_DERIVATIVE_CONSTANT_UNITS = 27,
    PROP_DESCRIPTION = 28,
    PROP_DESCRIPTION_OF_HALT = 29,
    PROP_DEVICE_ADDRESS_BINDING = 30,
    PROP_DEVICE_TYPE = 31,
    PROP_EFFECTIVE_PERIOD = 32,
    PROP_ELAPSED_ACTIVE_TIME = 33,
    PROP_ERROR_LIMIT = 34,
    PROP_EVENT_ENABLE = 35,
    PROP_EVENT_STATE = 36,
    PROP_EVENT_TYPE = 37,
    PROP_EXCEPTION_SCHEDULE = 38,
    PROP_FAULT_VALUES = 39,
    PROP_FEEDBACK_VALUE = 40,
    PROP_FILE_ACCESS_METHOD = 41,
    PROP_FILE_SIZE = 42,
    PROP_FILE_TYPE = 43,
    PROP_FIRMWARE_REVISION = 44,
    PROP_HIGH_LIMIT = 45,
    PROP_INACTIVE_TEXT = 46,
    PROP_IN_PROCESS = 47,
    PROP_INSTANCE_OF = 48,
    PROP_INTEGRAL_CONSTANT = 49,
    PROP_INTEGRAL_CONSTANT_UNITS = 50,
    PROP_ISSUE_CONFIRMED_NOTIFICATIONS = 51,
    PROP_LIMIT_ENABLE = 52,
    PROP_LIST_OF_GROUP_MEMBERS = 53,
    PROP_LIST_OF_OBJECT_PROPERTY_REFERENCES = 54,
    PROP_LIST_OF_SESSION_KEYS = 55,
    PROP_LOCAL_DATE = 56,
    PROP_LOCAL_TIME = 57,
    PROP_LOCATION = 58,
    PROP_LOW_LIMIT = 59,
    PROP_MANIPULATED_VARIABLE_REFERENCE = 60,
    PROP_MAXIMUM_OUTPUT = 61,
    PROP_MAX_APDU_LENGTH_ACCEPTED = 62,
    PROP_MAX_INFO_FRAMES = 63,
    PROP_MAX_MASTER = 64,
    PROP_MAX_PRES_VALUE = 65,
    PROP_MINIMUM_OFF_TIME = 66,
    PROP_MINIMUM_ON_TIME = 67,
    PROP_MINIMUM_OUTPUT = 68,
    PROP_MIN_PRES_VALUE = 69,
    PROP_MODEL_NAME = 70,
    PROP_MODIFICATION_DATE = 71,
    PROP_NOTIFY_TYPE = 72,
    PROP_NUMBER_OF_APDU_RETRIES = 73,
    PROP_NUMBER_OF_STATES = 74,
    PROP_OBJECT_IDENTIFIER = 75,
    PROP_OBJECT_LIST = 76,
    PROP_OBJECT_NAME = 77,
    PROP_OBJECT_PROPERTY_REFERENCE = 78,
    PROP_OBJECT_TYPE = 79,
    PROP_OPTIONAL = 80,
    PROP_OUT_OF_SERVICE = 81,
    PROP_OUTPUT_UNITS = 82,
    PROP_EVENT_PARAMETERS = 83,
    PROP_POLARITY = 84,
    PROP_PRESENT_VALUE = 85,
    PROP_PRIORITY = 86,
    PROP_PRIORITY_ARRAY = 87,
    PROP_PRIORITY_FOR_WRITING = 88,
    PROP_PROCESS_IDENTIFIER = 89,
    PROP_PROGRAM_CHANGE = 90,
    PROP_PROGRAM_LOCATION = 91,
    PROP_PROGRAM_STATE = 92,
    PROP_PROPORTIONAL_CONSTANT = 93,
    PROP_PROPORTIONAL_CONSTANT_UNITS = 94,
    PROP_PROTOCOL_CONFORMANCE_CLASS = 95,       /* deleted in version 1 revision 2 */
    PROP_PROTOCOL_OBJECT_TYPES_SUPPORTED = 96,
    PROP_PROTOCOL_SERVICES_SUPPORTED = 97,
    PROP_PROTOCOL_VERSION = 98,
    PROP_READ_ONLY = 99,
    PROP_REASON_FOR_HALT = 100,
    PROP_RECIPIENT = 101,
    PROP_RECIPIENT_LIST = 102,
    PROP_RELIABILITY = 103,
    PROP_RELINQUISH_DEFAULT = 104,
    PROP_REQUIRED = 105,
    PROP_RESOLUTION = 106,
    PROP_SEGMENTATION_SUPPORTED = 107,
    PROP_SETPOINT = 108,
    PROP_SETPOINT_REFERENCE = 109,
    PROP_STATE_TEXT = 110,
    PROP_STATUS_FLAGS = 111,
    PROP_SYSTEM_STATUS = 112,
    PROP_TIME_DELAY = 113,
    PROP_TIME_OF_ACTIVE_TIME_RESET = 114,
    PROP_TIME_OF_STATE_COUNT_RESET = 115,
    PROP_TIME_SYNCHRONIZATION_RECIPIENTS = 116,
    PROP_UNITS = 117,
    PROP_UPDATE_INTERVAL = 118,
    PROP_UTC_OFFSET = 119,
    PROP_VENDOR_IDENTIFIER = 120,
    PROP_VENDOR_NAME = 121,
    PROP_VT_CLASSES_SUPPORTED = 122,
    PROP_WEEKLY_SCHEDULE = 123,
    PROP_ATTEMPTED_SAMPLES = 124,
    PROP_AVERAGE_VALUE = 125,
    PROP_BUFFER_SIZE = 126,
    PROP_CLIENT_COV_INCREMENT = 127,
    PROP_COV_RESUBSCRIPTION_INTERVAL = 128,
    PROP_CURRENT_NOTIFY_TIME = 129,
    PROP_EVENT_TIME_STAMPS = 130,
    PROP_LOG_BUFFER = 131,
    PROP_LOG_DEVICE_OBJECT_PROPERTY = 132,
    /* The enable property is renamed from log-enable in
       Addendum b to ANSI/ASHRAE 135-2004(135b-2) */
    PROP_ENABLE = 133,
    PROP_LOG_INTERVAL = 134,
    PROP_MAXIMUM_VALUE = 135,
    PROP_MINIMUM_VALUE = 136,
    PROP_NOTIFICATION_THRESHOLD = 137,
    PROP_PREVIOUS_NOTIFY_TIME = 138,
    PROP_PROTOCOL_REVISION = 139,
    PROP_RECORDS_SINCE_NOTIFICATION = 140,
    PROP_RECORD_COUNT = 141,
    PROP_START_TIME = 142,
    PROP_STOP_TIME = 143,
    PROP_STOP_WHEN_FULL = 144,
    PROP_TOTAL_RECORD_COUNT = 145,
    PROP_VALID_SAMPLES = 146,
    PROP_WINDOW_INTERVAL = 147,
    PROP_WINDOW_SAMPLES = 148,
    PROP_MAXIMUM_VALUE_TIMESTAMP = 149,
    PROP_MINIMUM_VALUE_TIMESTAMP = 150,
    PROP_VARIANCE_VALUE = 151,
    PROP_ACTIVE_COV_SUBSCRIPTIONS = 152,
    PROP_BACKUP_FAILURE_TIMEOUT = 153,
    PROP_CONFIGURATION_FILES = 154,
    PROP_DATABASE_REVISION = 155,
    PROP_DIRECT_READING = 156,
    PROP_LAST_RESTORE_TIME = 157,
    PROP_MAINTENANCE_REQUIRED = 158,
    PROP_MEMBER_OF = 159,
    PROP_MODE = 160,
    PROP_OPERATION_EXPECTED = 161,
    PROP_SETTING = 162,
    PROP_SILENCED = 163,
    PROP_TRACKING_VALUE = 164,
    PROP_ZONE_MEMBERS = 165,
    PROP_LIFE_SAFETY_ALARM_VALUES = 166,
    PROP_MAX_SEGMENTS_ACCEPTED = 167,
    PROP_PROFILE_NAME = 168,
    PROP_AUTO_SLAVE_DISCOVERY = 169,
    PROP_MANUAL_SLAVE_ADDRESS_BINDING = 170,
    PROP_SLAVE_ADDRESS_BINDING = 171,
    PROP_SLAVE_PROXY_ENABLE = 172,
    PROP_LAST_NOTIFY_RECORD = 173,
    PROP_SCHEDULE_DEFAULT = 174,
    PROP_ACCEPTED_MODES = 175,
    PROP_ADJUST_VALUE = 176,
    PROP_COUNT = 177,
    PROP_COUNT_BEFORE_CHANGE = 178,
    PROP_COUNT_CHANGE_TIME = 179,
    PROP_COV_PERIOD = 180,
    PROP_INPUT_REFERENCE = 181,
    PROP_LIMIT_MONITORING_INTERVAL = 182,
    PROP_LOGGING_OBJECT = 183,
    PROP_LOGGING_RECORD = 184,
    PROP_PRESCALE = 185,
    PROP_PULSE_RATE = 186,
    PROP_SCALE = 187,
    PROP_SCALE_FACTOR = 188,
    PROP_UPDATE_TIME = 189,
    PROP_VALUE_BEFORE_CHANGE = 190,
    PROP_VALUE_SET = 191,
    PROP_VALUE_CHANGE_TIME = 192,
    /* enumerations 193-206 are new */
    PROP_ALIGN_INTERVALS = 193,
    /* enumeration 194 is unassigned */
    PROP_INTERVAL_OFFSET = 195,
    PROP_LAST_RESTART_REASON = 196,
    PROP_LOGGING_TYPE = 197,
    /* enumeration 198-201 is unassigned */
    PROP_RESTART_NOTIFICATION_RECIPIENTS = 202,
    PROP_TIME_OF_DEVICE_RESTART = 203,
    PROP_TIME_SYNCHRONIZATION_INTERVAL = 204,
    PROP_TRIGGER = 205,
    PROP_UTC_TIME_SYNCHRONIZATION_RECIPIENTS = 206,
    /* enumerations 207-211 are used in Addendum d to ANSI/ASHRAE 135-2004 */
    PROP_NODE_SUBTYPE = 207,
    PROP_NODE_TYPE = 208,
    PROP_STRUCTURED_OBJECT_LIST = 209,
    PROP_SUBORDINATE_ANNOTATIONS = 210,
    PROP_SUBORDINATE_LIST = 211,
    /* enumerations 212-225 are used in Addendum e to ANSI/ASHRAE 135-2004 */
    PROP_ACTUAL_SHED_LEVEL = 212,
    PROP_DUTY_WINDOW = 213,
    PROP_EXPECTED_SHED_LEVEL = 214,
    PROP_FULL_DUTY_BASELINE = 215,
    /* enumerations 216-217 are unassigned */
    /* enumerations 212-225 are used in Addendum e to ANSI/ASHRAE 135-2004 */
    PROP_REQUESTED_SHED_LEVEL = 218,
    PROP_SHED_DURATION = 219,
    PROP_SHED_LEVEL_DESCRIPTIONS = 220,
    PROP_SHED_LEVELS = 221,
    PROP_STATE_DESCRIPTION = 222,
    /* enumerations 223-225 are unassigned  */
    /* enumerations 226-235 are used in Addendum f to ANSI/ASHRAE 135-2004 */
    PROP_DOOR_ALARM_STATE = 226,
    PROP_DOOR_EXTENDED_PULSE_TIME = 227,
    PROP_DOOR_MEMBERS = 228,
    PROP_DOOR_OPEN_TOO_LONG_TIME = 229,
    PROP_DOOR_PULSE_TIME = 230,
    PROP_DOOR_STATUS = 231,
    PROP_DOOR_UNLOCK_DELAY_TIME = 232,
    PROP_LOCK_STATUS = 233,
    PROP_MASKED_ALARM_VALUES = 234,
    PROP_SECURED_STATUS = 235,
    /* enumerations 236-243 are unassigned  */
    /* enumerations 244-311 are used in Addendum j to ANSI/ASHRAE 135-2004 */
    PROP_ABSENTEE_LIMIT = 244,
    PROP_ACCESS_ALARM_EVENTS = 245,
    PROP_ACCESS_DOORS = 246,
    PROP_ACCESS_EVENT = 247,
    PROP_ACCESS_EVENT_AUTHENTICATION_FACTOR = 248,
    PROP_ACCESS_EVENT_CREDENTIAL = 249,
    PROP_ACCESS_EVENT_TIME = 250,
    PROP_ACCESS_TRANSACTION_EVENTS = 251,
    PROP_ACCOMPANIMENT = 252,
    PROP_ACCOMPANIMENT_TIME = 253,
    PROP_ACTIVATION_TIME = 254,
    PROP_ACTIVE_AUTHENTICATION_POLICY = 255,
    PROP_ASSIGNED_ACCESS_RIGHTS = 256,
    PROP_AUTHENTICATION_FACTORS = 257,
    PROP_AUTHENTICATION_POLICY_LIST = 258,
    PROP_AUTHENTICATION_POLICY_NAMES = 259,
    PROP_AUTHORIZATION_STATUS = 260,
    PROP_AUTHORIZATION_MODE = 261,
    PROP_BELONGS_TO = 262,
    PROP_CREDENTIAL_DISABLE = 263,
    PROP_CREDENTIAL_STATUS = 264,
    PROP_CREDENTIALS = 265,
    PROP_CREDENTIALS_IN_ZONE = 266,
    PROP_DAYS_REMAINING = 267,
    PROP_ENTRY_POINTS = 268,
    PROP_EXIT_POINTS = 269,
    PROP_EXPIRY_TIME = 270,
    PROP_EXTENDED_TIME_ENABLE = 271,
    PROP_FAILED_ATTEMPT_EVENTS = 272,
    PROP_FAILED_ATTEMPTS = 273,
    PROP_FAILED_ATTEMPTS_TIME = 274,
    PROP_LAST_ACCESS_EVENT = 275,
    PROP_LAST_ACCESS_POINT = 276,
    PROP_LAST_CREDENTIAL_ADDED = 277,
    PROP_LAST_CREDENTIAL_ADDED_TIME = 278,
    PROP_LAST_CREDENTIAL_REMOVED = 279,
    PROP_LAST_CREDENTIAL_REMOVED_TIME = 280,
    PROP_LAST_USE_TIME = 281,
    PROP_LOCKOUT = 282,
    PROP_LOCKOUT_RELINQUISH_TIME = 283,
    PROP_MASTER_EXEMPTION = 284,
    PROP_MAX_FAILED_ATTEMPTS = 285,
    PROP_MEMBERS = 286,
    PROP_MUSTER_POINT = 287,
    PROP_NEGATIVE_ACCESS_RULES = 288,
    PROP_NUMBER_OF_AUTHENTICATION_POLICIES = 289,
    PROP_OCCUPANCY_COUNT = 290,
    PROP_OCCUPANCY_COUNT_ADJUST = 291,
    PROP_OCCUPANCY_COUNT_ENABLE = 292,
    PROP_OCCUPANCY_EXEMPTION = 293,
    PROP_OCCUPANCY_LOWER_LIMIT = 294,
    PROP_OCCUPANCY_LOWER_LIMIT_ENFORCED = 295,
    PROP_OCCUPANCY_STATE = 296,
    PROP_OCCUPANCY_UPPER_LIMIT = 297,
    PROP_OCCUPANCY_UPPER_LIMIT_ENFORCED = 298,
    PROP_PASSBACK_EXEMPTION = 299,
    PROP_PASSBACK_MODE = 300,
    PROP_PASSBACK_TIMEOUT = 301,
    PROP_POSITIVE_ACCESS_RULES = 302,
    PROP_REASON_FOR_DISABLE = 303,
    PROP_SUPPORTED_FORMATS = 304,
    PROP_SUPPORTED_FORMAT_CLASSES = 305,
    PROP_THREAT_AUTHORITY = 306,
    PROP_THREAT_LEVEL = 307,
    PROP_TRACE_FLAG = 308,
    PROP_TRANSACTION_NOTIFICATION_CLASS = 309,
    PROP_USER_EXTERNAL_IDENTIFIER = 310,
    PROP_USER_INFORMATION_REFERENCE = 311,
    /* enumerations 312-316 are unassigned */
    PROP_USER_NAME = 317,
    PROP_USER_TYPE = 318,
    PROP_USES_REMAINING = 319,
    PROP_ZONE_FROM = 320,
    PROP_ZONE_TO = 321,
    PROP_ACCESS_EVENT_TAG = 322,
    PROP_GLOBAL_IDENTIFIER = 323,
    /* enumerations 324-325 are unassigned */
    PROP_VERIFICATION_TIME = 326,
    PROP_BASE_DEVICE_SECURITY_POLICY = 327,
    PROP_DISTRIBUTION_KEY_REVISION = 328,
    PROP_DO_NOT_HIDE = 329,
    PROP_KEY_SETS = 330,
    PROP_LAST_KEY_SERVER = 331,
    PROP_NETWORK_ACCESS_SECURITY_POLICIES = 332,
    PROP_PACKET_REORDER_TIME = 333,
    PROP_SECURITY_PDU_TIMEOUT = 334,
    PROP_SECURITY_TIME_WINDOW = 335,
    PROP_SUPPORTED_SECURITY_ALGORITHM = 336,
    PROP_UPDATE_KEY_SET_TIMEOUT = 337,
    PROP_BACKUP_AND_RESTORE_STATE = 338,
    PROP_BACKUP_PREPARATION_TIME = 339,
    PROP_RESTORE_COMPLETION_TIME = 340,
    PROP_RESTORE_PREPARATION_TIME = 341,
    /* enumerations 342-344 are defined in Addendum 2008-w */
    PROP_BIT_MASK = 342,
    PROP_BIT_TEXT = 343,
    PROP_IS_UTC = 344,
    PROP_GROUP_MEMBERS = 345,
    PROP_GROUP_MEMBER_NAMES = 346,
    PROP_MEMBER_STATUS_FLAGS = 347,
    PROP_REQUESTED_UPDATE_INTERVAL = 348,
    PROP_COVU_PERIOD = 349,
    PROP_COVU_RECIPIENTS = 350,
    PROP_EVENT_MESSAGE_TEXTS = 351,
    /* enumerations 352-363 are defined in Addendum 2010-af */
    PROP_EVENT_MESSAGE_TEXTS_CONFIG = 352,
    PROP_EVENT_DETECTION_ENABLE = 353,
    PROP_EVENT_ALGORITHM_INHIBIT = 354,
    PROP_EVENT_ALGORITHM_INHIBIT_REF = 355,
    PROP_TIME_DELAY_NORMAL = 356,
    PROP_RELIABILITY_EVALUATION_INHIBIT = 357,
    PROP_FAULT_PARAMETERS = 358,
    PROP_FAULT_TYPE = 359,
    PROP_LOCAL_FORWARDING_ONLY = 360,
    PROP_PROCESS_IDENTIFIER_FILTER = 361,
    PROP_SUBSCRIBED_RECIPIENTS = 362,
    PROP_PORT_FILTER = 363,
    /* enumeration 364 is defined in Addendum 2010-ae */
    PROP_AUTHORIZATION_EXEMPTIONS = 364,
    /* enumerations 365-370 are defined in Addendum 2010-aa */
    PROP_ALLOW_GROUP_DELAY_INHIBIT = 365,
    PROP_CHANNEL_NUMBER = 366,
    PROP_CONTROL_GROUPS = 367,
    PROP_EXECUTION_DELAY = 368,
    PROP_LAST_PRIORITY = 369,
    PROP_WRITE_STATUS = 370,
    /* enumeration 371 is defined in Addendum 2010-ao */
    PROP_PROPERTY_LIST = 371,
    /* enumeration 372 is defined in Addendum 2010-ak */
    PROP_SERIAL_NUMBER = 372,
    /* enumerations 373-386 are defined in Addendum 2010-i */
    PROP_BLINK_WARN_ENABLE = 373,
    PROP_DEFAULT_FADE_TIME = 374,
    PROP_DEFAULT_RAMP_RATE = 375,
    PROP_DEFAULT_STEP_INCREMENT = 376,
    PROP_EGRESS_TIMER = 377,
    PROP_IN_PROGRESS = 378,
    PROP_INSTANTANEOUS_POWER = 379,
    PROP_LIGHTING_COMMAND = 380,
    PROP_LIGHTING_COMMAND_DEFAULT_PRIORITY = 381,
    PROP_MAX_ACTUAL_VALUE = 382,
    PROP_MIN_ACTUAL_VALUE = 383,
    PROP_POWER = 384,
    PROP_TRANSITION = 385,
    PROP_EGRESS_ACTIVE = 386,
        /* The special property identifiers all, optional, and required  */
        /* are reserved for use in the ReadPropertyConditional and */
        /* ReadPropertyMultiple services or services not defined in this standard. */
        /* Enumerated values 0-511 are reserved for definition by ASHRAE.  */
        /* Enumerated values 512-4194303 may be used by others subject to the  */
        /* procedures and constraints described in Clause 23.  */
    /* do the max range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    MAX_BACNET_PROPERTY_ID = 4194303
} BACNET_PROPERTY_ID;


typedef enum {
    EVENT_LOW_LIMIT_ENABLE = 1,
    EVENT_HIGH_LIMIT_ENABLE = 2
} BACNET_LIMIT_ENABLE;

typedef enum {
    ACTION_DIRECT = 0,
    ACTION_REVERSE = 1
} BACNET_ACTION;

typedef enum {
    MIN_BINARY_PV = 0,  /* for validating incoming values */
    BINARY_INACTIVE = 0,
    BINARY_ACTIVE = 1,
    MAX_BINARY_PV = 1,  /* for validating incoming values */
    BINARY_NULL = 255   /* our homemade way of storing this info */
} BACNET_BINARY_PV;

typedef enum {
    ACTION_BINARY_PV,
    ACTION_UNSIGNED,
    ACTION_FLOAT
} BACNET_ACTION_VALUE_TYPE;

typedef enum {
    EVENT_STATE_NORMAL = 0,
    EVENT_STATE_FAULT = 1,
    EVENT_STATE_OFFNORMAL = 2,
    EVENT_STATE_HIGH_LIMIT = 3,
    EVENT_STATE_LOW_LIMIT = 4
} BACNET_EVENT_STATE;

typedef enum {
    EVENT_ENABLE_TO_OFFNORMAL = 1,
    EVENT_ENABLE_TO_FAULT = 2,
    EVENT_ENABLE_TO_NORMAL = 4
} BACNET_EVENT_ENABLE;

typedef enum {
    STATUS_OPERATIONAL = 0,
    STATUS_OPERATIONAL_READ_ONLY = 1,
    STATUS_DOWNLOAD_REQUIRED = 2,
    STATUS_DOWNLOAD_IN_PROGRESS = 3,
    STATUS_NON_OPERATIONAL = 4,
    STATUS_BACKUP_IN_PROGRESS = 5,
    MAX_DEVICE_STATUS = 6
} BACNET_DEVICE_STATUS;

typedef enum {
    /* Acceleration */
    UNITS_METERS_PER_SECOND_PER_SECOND = 166,
    /* Area */
    UNITS_SQUARE_METERS = 0,
    UNITS_SQUARE_CENTIMETERS = 116,
    UNITS_SQUARE_FEET = 1,
    UNITS_SQUARE_INCHES = 115,
    /* Currency */
    UNITS_CURRENCY1 = 105,
    UNITS_CURRENCY2 = 106,
    UNITS_CURRENCY3 = 107,
    UNITS_CURRENCY4 = 108,
    UNITS_CURRENCY5 = 109,
    UNITS_CURRENCY6 = 110,
    UNITS_CURRENCY7 = 111,
    UNITS_CURRENCY8 = 112,
    UNITS_CURRENCY9 = 113,
    UNITS_CURRENCY10 = 114,
    /* Electrical */
    UNITS_MILLIAMPERES = 2,
    UNITS_AMPERES = 3,
    UNITS_AMPERES_PER_METER = 167,
    UNITS_AMPERES_PER_SQUARE_METER = 168,
    UNITS_AMPERE_SQUARE_METERS = 169,
	UNITS_DECIBELS = 199,
	UNITS_DECIBELS_MILLIVOLT = 200,
	UNITS_DECIBELS_VOLT = 201,
    UNITS_FARADS = 170,
    UNITS_HENRYS = 171,
    UNITS_OHMS = 4,
    UNITS_OHM_METERS = 172,
    UNITS_MILLIOHMS = 145,
    UNITS_KILOHMS = 122,
    UNITS_MEGOHMS = 123,
    UNITS_MICROSIEMENS = 190,
    UNITS_MILLISIEMENS = 202,
    UNITS_SIEMENS = 173,        /* 1 mho equals 1 siemens */
    UNITS_SIEMENS_PER_METER = 174,
    UNITS_TESLAS = 175,
    UNITS_VOLTS = 5,
    UNITS_MILLIVOLTS = 124,
    UNITS_KILOVOLTS = 6,
    UNITS_MEGAVOLTS = 7,
    UNITS_VOLT_AMPERES = 8,
    UNITS_KILOVOLT_AMPERES = 9,
    UNITS_MEGAVOLT_AMPERES = 10,
    UNITS_VOLT_AMPERES_REACTIVE = 11,
    UNITS_KILOVOLT_AMPERES_REACTIVE = 12,
    UNITS_MEGAVOLT_AMPERES_REACTIVE = 13,
    UNITS_VOLTS_PER_DEGREE_KELVIN = 176,
    UNITS_VOLTS_PER_METER = 177,
    UNITS_DEGREES_PHASE = 14,
    UNITS_POWER_FACTOR = 15,
    UNITS_WEBERS = 178,
    /* Energy */
    UNITS_JOULES = 16,
    UNITS_KILOJOULES = 17,
    UNITS_KILOJOULES_PER_KILOGRAM = 125,
    UNITS_MEGAJOULES = 126,
    UNITS_WATT_HOURS = 18,
    UNITS_KILOWATT_HOURS = 19,
    UNITS_MEGAWATT_HOURS = 146,
    UNITS_WATT_HOURS_REACTIVE = 203,
    UNITS_KILOWATT_HOURS_REACTIVE = 204,
    UNITS_MEGAWATT_HOURS_REACTIVE = 205,
    UNITS_BTUS = 20,
    UNITS_KILO_BTUS = 147,
    UNITS_MEGA_BTUS = 148,
    UNITS_THERMS = 21,
    UNITS_TON_HOURS = 22,
    /* Enthalpy */
    UNITS_JOULES_PER_KILOGRAM_DRY_AIR = 23,
    UNITS_KILOJOULES_PER_KILOGRAM_DRY_AIR = 149,
    UNITS_MEGAJOULES_PER_KILOGRAM_DRY_AIR = 150,
    UNITS_BTUS_PER_POUND_DRY_AIR = 24,
    UNITS_BTUS_PER_POUND = 117,
    /* Entropy */
    UNITS_JOULES_PER_DEGREE_KELVIN = 127,
    UNITS_KILOJOULES_PER_DEGREE_KELVIN = 151,
    UNITS_MEGAJOULES_PER_DEGREE_KELVIN = 152,
    UNITS_JOULES_PER_KILOGRAM_DEGREE_KELVIN = 128,
    /* Force */
    UNITS_NEWTON = 153,
    /* Frequency */
    UNITS_CYCLES_PER_HOUR = 25,
    UNITS_CYCLES_PER_MINUTE = 26,
    UNITS_HERTZ = 27,
    UNITS_KILOHERTZ = 129,
    UNITS_MEGAHERTZ = 130,
    UNITS_PER_HOUR = 131,
    /* Humidity */
    UNITS_GRAMS_OF_WATER_PER_KILOGRAM_DRY_AIR = 28,
    UNITS_PERCENT_RELATIVE_HUMIDITY = 29,
    /* Length */
    UNITS_MICROMETERS = 194,
    UNITS_MILLIMETERS = 30,
    UNITS_CENTIMETERS = 118,
    UNITS_KILOMETERS = 193,
    UNITS_METERS = 31,
    UNITS_INCHES = 32,
    UNITS_FEET = 33,
    /* Light */
    UNITS_CANDELAS = 179,
    UNITS_CANDELAS_PER_SQUARE_METER = 180,
    UNITS_WATTS_PER_SQUARE_FOOT = 34,
    UNITS_WATTS_PER_SQUARE_METER = 35,
    UNITS_LUMENS = 36,
    UNITS_LUXES = 37,
    UNITS_FOOT_CANDLES = 38,
    /* Mass */
    UNITS_MILLIGRAMS = 196,
    UNITS_GRAMS = 195,
    UNITS_KILOGRAMS = 39,
    UNITS_POUNDS_MASS = 40,
    UNITS_TONS = 41,
    /* Mass Flow */
    UNITS_GRAMS_PER_SECOND = 154,
    UNITS_GRAMS_PER_MINUTE = 155,
    UNITS_KILOGRAMS_PER_SECOND = 42,
    UNITS_KILOGRAMS_PER_MINUTE = 43,
    UNITS_KILOGRAMS_PER_HOUR = 44,
    UNITS_POUNDS_MASS_PER_SECOND = 119,
    UNITS_POUNDS_MASS_PER_MINUTE = 45,
    UNITS_POUNDS_MASS_PER_HOUR = 46,
    UNITS_TONS_PER_HOUR = 156,
    /* Power */
    UNITS_MILLIWATTS = 132,
    UNITS_WATTS = 47,
    UNITS_KILOWATTS = 48,
    UNITS_MEGAWATTS = 49,
    UNITS_BTUS_PER_HOUR = 50,
    UNITS_KILO_BTUS_PER_HOUR = 157,
    UNITS_HORSEPOWER = 51,
    UNITS_TONS_REFRIGERATION = 52,
    /* Pressure */
    UNITS_PASCALS = 53,
    UNITS_HECTOPASCALS = 133,
    UNITS_KILOPASCALS = 54,
    UNITS_MILLIBARS = 134,
    UNITS_BARS = 55,
    UNITS_POUNDS_FORCE_PER_SQUARE_INCH = 56,
    UNITS_MILLIMETERS_OF_WATER = 206,
    UNITS_CENTIMETERS_OF_WATER = 57,
    UNITS_INCHES_OF_WATER = 58,
    UNITS_MILLIMETERS_OF_MERCURY = 59,
    UNITS_CENTIMETERS_OF_MERCURY = 60,
    UNITS_INCHES_OF_MERCURY = 61,
    /* Temperature */
    UNITS_DEGREES_CELSIUS = 62,
    UNITS_DEGREES_KELVIN = 63,
    UNITS_DEGREES_KELVIN_PER_HOUR = 181,
    UNITS_DEGREES_KELVIN_PER_MINUTE = 182,
    UNITS_DEGREES_FAHRENHEIT = 64,
    UNITS_DEGREE_DAYS_CELSIUS = 65,
    UNITS_DEGREE_DAYS_FAHRENHEIT = 66,
    UNITS_DELTA_DEGREES_FAHRENHEIT = 120,
    UNITS_DELTA_DEGREES_KELVIN = 121,
    /* Time */
    UNITS_YEARS = 67,
    UNITS_MONTHS = 68,
    UNITS_WEEKS = 69,
    UNITS_DAYS = 70,
    UNITS_HOURS = 71,
    UNITS_MINUTES = 72,
    UNITS_SECONDS = 73,
    UNITS_HUNDREDTHS_SECONDS = 158,
    UNITS_MILLISECONDS = 159,
    /* Torque */
    UNITS_NEWTON_METERS = 160,
    /* Velocity */
    UNITS_MILLIMETERS_PER_SECOND = 161,
    UNITS_MILLIMETERS_PER_MINUTE = 162,
    UNITS_METERS_PER_SECOND = 74,
    UNITS_METERS_PER_MINUTE = 163,
    UNITS_METERS_PER_HOUR = 164,
    UNITS_KILOMETERS_PER_HOUR = 75,
    UNITS_FEET_PER_SECOND = 76,
    UNITS_FEET_PER_MINUTE = 77,
    UNITS_MILES_PER_HOUR = 78,
    /* Volume */
    UNITS_CUBIC_FEET = 79,
    UNITS_CUBIC_METERS = 80,
    UNITS_IMPERIAL_GALLONS = 81,
    UNITS_MILLILITERS = 197,
    UNITS_LITERS = 82,
    UNITS_US_GALLONS = 83,
    /* Volumetric Flow */
    UNITS_CUBIC_FEET_PER_SECOND = 142,
    UNITS_CUBIC_FEET_PER_MINUTE = 84,
    UNITS_CUBIC_FEET_PER_HOUR = 191,
    UNITS_CUBIC_METERS_PER_SECOND = 85,
    UNITS_CUBIC_METERS_PER_MINUTE = 165,
    UNITS_CUBIC_METERS_PER_HOUR = 135,
    UNITS_IMPERIAL_GALLONS_PER_MINUTE = 86,
    UNITS_MILLILITERS_PER_SECOND = 198,
    UNITS_LITERS_PER_SECOND = 87,
    UNITS_LITERS_PER_MINUTE = 88,
    UNITS_LITERS_PER_HOUR = 136,
    UNITS_US_GALLONS_PER_MINUTE = 89,
    UNITS_US_GALLONS_PER_HOUR = 192,
    /* Other */
    UNITS_DEGREES_ANGULAR = 90,
    UNITS_DEGREES_CELSIUS_PER_HOUR = 91,
    UNITS_DEGREES_CELSIUS_PER_MINUTE = 92,
    UNITS_DEGREES_FAHRENHEIT_PER_HOUR = 93,
    UNITS_DEGREES_FAHRENHEIT_PER_MINUTE = 94,
    UNITS_JOULE_SECONDS = 183,
    UNITS_KILOGRAMS_PER_CUBIC_METER = 186,
    UNITS_KW_HOURS_PER_SQUARE_METER = 137,
    UNITS_KW_HOURS_PER_SQUARE_FOOT = 138,
    UNITS_MEGAJOULES_PER_SQUARE_METER = 139,
    UNITS_MEGAJOULES_PER_SQUARE_FOOT = 140,
    UNITS_NO_UNITS = 95,
    UNITS_NEWTON_SECONDS = 187,
    UNITS_NEWTONS_PER_METER = 188,
    UNITS_PARTS_PER_MILLION = 96,
    UNITS_PARTS_PER_BILLION = 97,
    UNITS_PERCENT = 98,
    UNITS_PERCENT_OBSCURATION_PER_FOOT = 143,
    UNITS_PERCENT_OBSCURATION_PER_METER = 144,
    UNITS_PERCENT_PER_SECOND = 99,
    UNITS_PER_MINUTE = 100,
    UNITS_PER_SECOND = 101,
    UNITS_PSI_PER_DEGREE_FAHRENHEIT = 102,
    UNITS_RADIANS = 103,
    UNITS_RADIANS_PER_SECOND = 184,
    UNITS_REVOLUTIONS_PER_MINUTE = 104,
    UNITS_SQUARE_METERS_PER_NEWTON = 185,
    UNITS_WATTS_PER_METER_PER_DEGREE_KELVIN = 189,
    UNITS_WATTS_PER_SQUARE_METER_DEGREE_KELVIN = 141,
    UNITS_PER_MILLE = 207,
	UNITS_GRAMS_PER_GRAM = 208,
	UNITS_KILOGRAMS_PER_KILOGRAM = 209,
	UNITS_GRAMS_PER_KILOGRAM = 210,
	UNITS_MILLIGRAMS_PER_GRAM = 211,
	UNITS_MILLIGRAMS_PER_KILOGRAM = 212,
	UNITS_GRAMS_PER_MILLILITER = 213,
	UNITS_GRAMS_PER_LITER = 214,
	UNITS_MILLIGRAMS_PER_LITER = 215,
	UNITS_MICROGRAMS_PER_LITER = 216,
	UNITS_GRAMS_PER_CUBIC_METER = 217,
	UNITS_MILLIGRAMS_PER_CUBIC_METER = 218,
	UNITS_MICROGRAMS_PER_CUBIC_METER = 219,
	UNITS_NANOGRAMS_PER_CUBIC_METER = 220,
	UNITS_GRAMS_PER_CUBIC_CENTIMETER = 221,
	UNITS_BECQUERELS = 222,
	UNITS_MEGABECQUERELS = 224,
	UNITS_GRAY = 225,
	UNITS_MILLIGRAY = 226,
	UNITS_MICROGRAY = 227,
	UNITS_SIEVERTS = 228,
	UNITS_MILLISIEVERTS = 229,
	UNITS_MICROSIEVERTS = 230,
	UNITS_MICROSIEVERTS_PER_HOUR = 231,
	UNITS_DECIBELS_A = 232,
	UNITS_NEPHELOMETRIC_TURBIDITY_UNIT = 233,
	UNITS_PH = 234,
	UNITS_GRAMS_PER_SQUARE_METER = 235,
	UNITS_MINUTES_PER_DEGREE_KELVIN = 236,
    /* Enumerated values 0-255 are reserved for definition by ASHRAE. */
    /* Enumerated values 256-65535 may be used by others subject to */
    /* the procedures and constraints described in Clause 23. */
    /* The last enumeration used in this version is 236. */
    MAX_UNITS = 237,
    /* do the proprietary range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    UNITS_PROPRIETARY_RANGE_MIN = 256,
    UNITS_PROPRIETARY_RANGE_MAX = 65535
} BACNET_ENGINEERING_UNITS;

typedef enum {
    POLARITY_NORMAL = 0,
    POLARITY_REVERSE = 1,
    MAX_POLARITY = 2
} BACNET_POLARITY;

typedef enum {
    PROGRAM_REQUEST_READY = 0,
    PROGRAM_REQUEST_LOAD = 1,
    PROGRAM_REQUEST_RUN = 2,
    PROGRAM_REQUEST_HALT = 3,
    PROGRAM_REQUEST_RESTART = 4,
    PROGRAM_REQUEST_UNLOAD = 5
} BACNET_PROGRAM_REQUEST;

typedef enum {
    PROGRAM_STATE_IDLE = 0,
    PROGRAM_STATE_LOADING = 1,
    PROGRAM_STATE_RUNNING = 2,
    PROGRAM_STATE_WAITING = 3,
    PROGRAM_STATE_HALTED = 4,
    PROGRAM_STATE_UNLOADING = 5
} BACNET_PROGRAM_STATE;

typedef enum {
    PROGRAM_ERROR_NORMAL = 0,
    PROGRAM_ERROR_LOAD_FAILED = 1,
    PROGRAM_ERROR_INTERNAL = 2,
    PROGRAM_ERROR_PROGRAM = 3,
    PROGRAM_ERROR_OTHER = 4,
        /* Enumerated values 0-63 are reserved for definition by ASHRAE.  */
        /* Enumerated values 64-65535 may be used by others subject to  */
        /* the procedures and constraints described in Clause 23. */
    /* do the max range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    PROGRAM_ERROR_PROPRIETARY_MIN = 64,
    PROGRAM_ERROR_PROPRIETARY_MAX = 65535
} BACNET_PROGRAM_ERROR;

typedef enum {
    RESTART_REASON_UNKNOWN = 0,
    RESTART_REASON_COLDSTART = 1,
    RESTART_REASON_WARMSTART = 2,
    RESTART_REASON_DETECTED_POWER_LOST = 3,
    RESTART_REASON_DETECTED_POWER_OFF = 4,
    RESTART_REASON_HARDWARE_WATCHDOG = 5,
    RESTART_REASON_SOFTWARE_WATCHDOG = 6,
    RESTART_REASON_SUSPENDED = 7,
/* Enumerated values 0-63 are reserved for definition by ASHRAE.
   Enumerated values 64-255 may be used by others subject to the
   procedures and constraints described in Clause 23. */
    /* do the max range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    RESTART_REASON_PROPRIETARY_MIN = 64,
    RESTART_REASON_PROPRIETARY_MAX = 255
} BACNET_RESTART_REASON;

typedef enum {
    PROP_STATE_BOOLEAN_VALUE = 0,
    PROP_STATE_BINARY_VALUE = 1,
    PROP_STATE_EVENT_TYPE = 2,
    PROP_STATE_POLARITY = 3,
    PROP_STATE_PROGRAM_CHANGE = 4,
    PROP_STATE_PROGRAM_STATE = 5,
    PROP_STATE_REASON_FOR_HALT = 6,
    PROP_STATE_RELIABILITY = 7,
    PROP_STATE_EVENT_STATE = 8,
    PROP_STATE_SYSTEM_STATUS = 9,
    PROP_STATE_UNITS = 10,
    PROP_STATE_UNSIGNED_VALUE = 11,
    PROP_STATE_LIFE_SAFETY_MODE = 12,
    PROP_STATE_LIFE_SAFETY_STATE = 13,
    PROP_STATE_RESTART_REASON = 14,
    PROP_STATE_DOOR_ALARM_STATE = 15,
    PROP_STATE_ACTION = 16,
    PROP_STATE_DOOR_SECURED_STATUS = 17,
    PROP_STATE_DOOR_STATUS = 18,
    PROP_STATE_DOOR_VALUE = 19,
    PROP_STATE_FILE_ACCESS_METHOD = 20,
    PROP_STATE_LOCK_STATUS = 21,
    PROP_STATE_LIFE_SAFETY_OPERATION = 22,
    PROP_STATE_MAINTENANCE = 23,
    PROP_STATE_NODE_TYPE = 24,
    PROP_STATE_NOTIFY_TYPE = 25,
    PROP_STATE_SECURITY_LEVEL = 26,
    PROP_STATE_SHED_STATE = 27,
    PROP_STATE_SILENCED_STATE = 28,
    PROP_STATE_ACCESS_EVENT = 30,
    PROP_STATE_ZONE_OCCUPANCY_STATE = 31,
    PROP_STATE_ACCESS_CRED_DISABLE_REASON = 32,
    PROP_STATE_ACCESS_CRED_DISABLE = 33,
    PROP_STATE_AUTHENTICATION_STATUS = 34
} BACNET_PROPERTY_STATES;

typedef enum {
    RELIABILITY_NO_FAULT_DETECTED = 0,
    RELIABILITY_NO_SENSOR = 1,
    RELIABILITY_OVER_RANGE = 2,
    RELIABILITY_UNDER_RANGE = 3,
    RELIABILITY_OPEN_LOOP = 4,
    RELIABILITY_SHORTED_LOOP = 5,
    RELIABILITY_NO_OUTPUT = 6,
    RELIABILITY_UNRELIABLE_OTHER = 7,
    RELIABILITY_PROCESS_ERROR = 8,
    RELIABILITY_MULTI_STATE_FAULT = 9,
    RELIABILITY_CONFIGURATION_ERROR = 10,
    RELIABILITY_MEMBER_FAULT = 11,
    RELIABILITY_COMMUNICATION_FAILURE = 12,
    RELIABILITY_TRIPPED = 13,
        /* Enumerated values 0-63 are reserved for definition by ASHRAE.  */
        /* Enumerated values 64-65535 may be used by others subject to  */
        /* the procedures and constraints described in Clause 23. */
    /* do the max range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    RELIABILITY_PROPRIETARY_MIN = 64,
    RELIABILITY_PROPRIETARY_MAX = 65535
} BACNET_RELIABILITY;

typedef enum {
    EVENT_CHANGE_OF_BITSTRING = 0,
    EVENT_CHANGE_OF_STATE = 1,
    EVENT_CHANGE_OF_VALUE = 2,
    EVENT_COMMAND_FAILURE = 3,
    EVENT_FLOATING_LIMIT = 4,
    EVENT_OUT_OF_RANGE = 5,
    /*  complex-event-type        (6), -- see comment below */
    /*  event-buffer-ready   (7), -- context tag 7 is deprecated */
    EVENT_CHANGE_OF_LIFE_SAFETY = 8,
    EVENT_EXTENDED = 9,
    EVENT_BUFFER_READY = 10,
    EVENT_UNSIGNED_RANGE = 11,
        /* Enumerated values 0-63 are reserved for definition by ASHRAE.  */
        /* Enumerated values 64-65535 may be used by others subject to  */
        /* the procedures and constraints described in Clause 23.  */
        /* It is expected that these enumerated values will correspond to  */
        /* the use of the complex-event-type CHOICE [6] of the  */
        /* BACnetNotificationParameters production. */
        /* The last enumeration used in this version is 11. */
   /* do the max range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    EVENT_PROPRIETARY_MIN = 64,
    EVENT_PROPRIETARY_MAX = 65535
} BACNET_EVENT_TYPE;

typedef enum {
    FILE_RECORD_ACCESS = 0,
    FILE_STREAM_ACCESS = 1,
    FILE_RECORD_AND_STREAM_ACCESS = 2
} BACNET_FILE_ACCESS_METHOD;

typedef enum {
    MIN_LIFE_SAFETY_MODE = 0,
    LIFE_SAFETY_MODE_OFF = 0,
    LIFE_SAFETY_MODE_ON = 1,
    LIFE_SAFETY_MODE_TEST = 2,
    LIFE_SAFETY_MODE_MANNED = 3,
    LIFE_SAFETY_MODE_UNMANNED = 4,
    LIFE_SAFETY_MODE_ARMED = 5,
    LIFE_SAFETY_MODE_DISARMED = 6,
    LIFE_SAFETY_MODE_PREARMED = 7,
    LIFE_SAFETY_MODE_SLOW = 8,
    LIFE_SAFETY_MODE_FAST = 9,
    LIFE_SAFETY_MODE_DISCONNECTED = 10,
    LIFE_SAFETY_MODE_ENABLED = 11,
    LIFE_SAFETY_MODE_DISABLED = 12,
    LIFE_SAFETY_MODE_AUTOMATIC_RELEASE_DISABLED = 13,
    LIFE_SAFETY_MODE_DEFAULT = 14,
    MAX_LIFE_SAFETY_MODE = 15,
        /* Enumerated values 0-255 are reserved for definition by ASHRAE.  */
        /* Enumerated values 256-65535 may be used by others subject to  */
        /* procedures and constraints described in Clause 23. */
   /* do the max range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    LIFE_SAFETY_MODE_PROPRIETARY_MIN = 256,
    LIFE_SAFETY_MODE_PROPRIETARY_MAX = 65535
} BACNET_LIFE_SAFETY_MODE;

typedef enum {
    LIFE_SAFETY_OP_NONE = 0,
    LIFE_SAFETY_OP_SILENCE = 1,
    LIFE_SAFETY_OP_SILENCE_AUDIBLE = 2,
    LIFE_SAFETY_OP_SILENCE_VISUAL = 3,
    LIFE_SAFETY_OP_RESET = 4,
    LIFE_SAFETY_OP_RESET_ALARM = 5,
    LIFE_SAFETY_OP_RESET_FAULT = 6,
    LIFE_SAFETY_OP_UNSILENCE = 7,
    LIFE_SAFETY_OP_UNSILENCE_AUDIBLE = 8,
    LIFE_SAFETY_OP_UNSILENCE_VISUAL = 9,
        /* Enumerated values 0-63 are reserved for definition by ASHRAE.  */
        /* Enumerated values 64-65535 may be used by others subject to  */
        /* procedures and constraints described in Clause 23. */
   /* do the max range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    LIFE_SAFETY_OP_PROPRIETARY_MIN = 64,
    LIFE_SAFETY_OP_PROPRIETARY_MAX = 65535
} BACNET_LIFE_SAFETY_OPERATION;

typedef enum {
    MIN_LIFE_SAFETY_STATE = 0,
    LIFE_SAFETY_STATE_QUIET = 0,
    LIFE_SAFETY_STATE_PRE_ALARM = 1,
    LIFE_SAFETY_STATE_ALARM = 2,
    LIFE_SAFETY_STATE_FAULT = 3,
    LIFE_SAFETY_STATE_FAULT_PRE_ALARM = 4,
    LIFE_SAFETY_STATE_FAULT_ALARM = 5,
    LIFE_SAFETY_STATE_NOT_READY = 6,
    LIFE_SAFETY_STATE_ACTIVE = 7,
    LIFE_SAFETY_STATE_TAMPER = 8,
    LIFE_SAFETY_STATE_TEST_ALARM = 9,
    LIFE_SAFETY_STATE_TEST_ACTIVE = 10,
    LIFE_SAFETY_STATE_TEST_FAULT = 11,
    LIFE_SAFETY_STATE_TEST_FAULT_ALARM = 12,
    LIFE_SAFETY_STATE_HOLDUP = 13,
    LIFE_SAFETY_STATE_DURESS = 14,
    LIFE_SAFETY_STATE_TAMPER_ALARM = 15,
    LIFE_SAFETY_STATE_ABNORMAL = 16,
    LIFE_SAFETY_STATE_EMERGENCY_POWER = 17,
    LIFE_SAFETY_STATE_DELAYED = 18,
    LIFE_SAFETY_STATE_BLOCKED = 19,
    LIFE_SAFETY_STATE_LOCAL_ALARM = 20,
    LIFE_SAFETY_STATE_GENERAL_ALARM = 21,
    LIFE_SAFETY_STATE_SUPERVISORY = 22,
    LIFE_SAFETY_STATE_TEST_SUPERVISORY = 23,
    MAX_LIFE_SAFETY_STATE = 24,
        /* Enumerated values 0-255 are reserved for definition by ASHRAE.  */
        /* Enumerated values 256-65535 may be used by others subject to  */
        /* procedures and constraints described in Clause 23. */
   /* do the max range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    LIFE_SAFETY_STATE_PROPRIETARY_MIN = 256,
    LIFE_SAFETY_STATE_PROPRIETARY_MAX = 65535
} BACNET_LIFE_SAFETY_STATE;

typedef enum {
    SILENCED_STATE_UNSILENCED = 0,
    SILENCED_STATE_AUDIBLE_SILENCED = 1,
    SILENCED_STATE_VISIBLE_SILENCED = 2,
    SILENCED_STATE_ALL_SILENCED = 3,
        /* Enumerated values 0-63 are reserved for definition by ASHRAE. */
        /* Enumerated values 64-65535 may be used by others subject to */
        /* procedures and constraints described in Clause 23. */
   /* do the max range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    SILENCED_STATE_PROPRIETARY_MIN = 64,
    SILENCED_STATE_PROPRIETARY_MAX = 65535
} BACNET_SILENCED_STATE;

typedef enum {
    MAINTENANCE_NONE = 0,
    MAINTENANCE_PERIODIC_TEST = 1,
    MAINTENANCE_NEED_SERVICE_OPERATIONAL = 2,
    MAINTENANCE_NEED_SERVICE_INOPERATIVE = 3,
        /* Enumerated values 0-255 are reserved for definition by ASHRAE.  */
        /* Enumerated values 256-65535 may be used by others subject to  */
        /* procedures and constraints described in Clause 23. */
   /* do the max range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    MAINTENANCE_PROPRIETARY_MIN = 256,
    MAINTENANCE_PROPRIETARY_MAX = 65535
} BACNET_MAINTENANCE;

typedef enum {
    NOTIFY_ALARM = 0,
    NOTIFY_EVENT = 1,
    NOTIFY_ACK_NOTIFICATION = 2
} BACNET_NOTIFY_TYPE;

typedef enum {
    OBJECT_ANALOG_INPUT = 0,
    OBJECT_ANALOG_OUTPUT = 1,
    OBJECT_ANALOG_VALUE = 2,
    OBJECT_BINARY_INPUT = 3,
    OBJECT_BINARY_OUTPUT = 4,
    OBJECT_BINARY_VALUE = 5,
    OBJECT_CALENDAR = 6,
    OBJECT_COMMAND = 7,
    OBJECT_DEVICE = 8,
    OBJECT_EVENT_ENROLLMENT = 9,
    OBJECT_FILE = 10,
    OBJECT_GROUP = 11,
    OBJECT_LOOP = 12,
    OBJECT_MULTI_STATE_INPUT = 13,
    OBJECT_MULTI_STATE_OUTPUT = 14,
    OBJECT_NOTIFICATION_CLASS = 15,
    OBJECT_PROGRAM = 16,
    OBJECT_SCHEDULE = 17,
    OBJECT_AVERAGING = 18,
    OBJECT_MULTI_STATE_VALUE = 19,
    OBJECT_TRENDLOG = 20,
    OBJECT_LIFE_SAFETY_POINT = 21,
    OBJECT_LIFE_SAFETY_ZONE = 22,
    OBJECT_ACCUMULATOR = 23,
    OBJECT_PULSE_CONVERTER = 24,
    OBJECT_EVENT_LOG = 25,
    OBJECT_GLOBAL_GROUP = 26,
    OBJECT_TREND_LOG_MULTIPLE = 27,
    OBJECT_LOAD_CONTROL = 28,
    OBJECT_STRUCTURED_VIEW = 29,
    OBJECT_ACCESS_DOOR = 30,
    /* 31 was lighting output, but BACnet editor changed it... */
    OBJECT_ACCESS_CREDENTIAL = 32,      /* Addendum 2008-j */
    OBJECT_ACCESS_POINT = 33,
    OBJECT_ACCESS_RIGHTS = 34,
    OBJECT_ACCESS_USER = 35,
    OBJECT_ACCESS_ZONE = 36,
    OBJECT_CREDENTIAL_DATA_INPUT = 37,  /* authentication-factor-input */
    OBJECT_NETWORK_SECURITY = 38,       /* Addendum 2008-g */
    OBJECT_BITSTRING_VALUE = 39,        /* Addendum 2008-w */
    OBJECT_CHARACTERSTRING_VALUE = 40,  /* Addendum 2008-w */
    OBJECT_DATE_PATTERN_VALUE = 41,     /* Addendum 2008-w */
    OBJECT_DATE_VALUE = 42,     /* Addendum 2008-w */
    OBJECT_DATETIME_PATTERN_VALUE = 43, /* Addendum 2008-w */
    OBJECT_DATETIME_VALUE = 44, /* Addendum 2008-w */
    OBJECT_INTEGER_VALUE = 45,  /* Addendum 2008-w */
    OBJECT_LARGE_ANALOG_VALUE = 46,     /* Addendum 2008-w */
    OBJECT_OCTETSTRING_VALUE = 47,      /* Addendum 2008-w */
    OBJECT_POSITIVE_INTEGER_VALUE = 48, /* Addendum 2008-w */
    OBJECT_TIME_PATTERN_VALUE = 49,     /* Addendum 2008-w */
    OBJECT_TIME_VALUE = 50,     /* Addendum 2008-w */
    OBJECT_NOTIFICATION_FORWARDER = 51, /* Addendum 2010-af */
    OBJECT_ALERT_ENROLLMENT = 52,       /* Addendum 2010-af */
    OBJECT_CHANNEL = 53,        /* Addendum 2010-aa */
    OBJECT_LIGHTING_OUTPUT = 54,        /* Addendum 2010-i */
        /* Enumerated values 0-127 are reserved for definition by ASHRAE. */
        /* Enumerated values 128-1023 may be used by others subject to  */
        /* the procedures and constraints described in Clause 23. */
   /* do the max range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    OBJECT_PROPRIETARY_MIN = 128,
    OBJECT_PROPRIETARY_MAX = 1023,
    MAX_BACNET_OBJECT_TYPE = 1024
} BACNET_OBJECT_TYPE;

typedef enum {
    SEGMENTATION_BOTH = 0,
    SEGMENTATION_TRANSMIT = 1,
    SEGMENTATION_RECEIVE = 2,
    SEGMENTATION_NONE = 3,
    MAX_BACNET_SEGMENTATION = 4
} BACNET_SEGMENTATION;

typedef enum {
    VT_CLASS_DEFAULT = 0,
    VT_CLASS_ANSI_X34 = 1,      /* real name is ANSI X3.64 */
    VT_CLASS_DEC_VT52 = 2,
    VT_CLASS_DEC_VT100 = 3,
    VT_CLASS_DEC_VT220 = 4,
    VT_CLASS_HP_700_94 = 5,     /* real name is HP 700/94 */
    VT_CLASS_IBM_3130 = 6,
        /* Enumerated values 0-63 are reserved for definition by ASHRAE.  */
        /* Enumerated values 64-65535 may be used by others subject to  */
        /* the procedures and constraints described in Clause 23. */
   /* do the max range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    VT_CLASS_PROPRIETARY_MIN = 64,
    VT_CLASS_PROPRIETARY_MAX = 65535
} BACNET_VT_CLASS;

typedef enum {
    CHARACTER_ANSI_X34 = 0,     /* deprecated */
    CHARACTER_UTF8 = 0,
    CHARACTER_MS_DBCS = 1,
    CHARACTER_JISC_6226 = 2,
    CHARACTER_UCS4 = 3,
    CHARACTER_UCS2 = 4,
    CHARACTER_ISO8859 = 5,
    MAX_CHARACTER_STRING_ENCODING = 6
} BACNET_CHARACTER_STRING_ENCODING;

typedef enum {
    BACNET_APPLICATION_TAG_NULL = 0,
    BACNET_APPLICATION_TAG_BOOLEAN = 1,
    BACNET_APPLICATION_TAG_UNSIGNED_INT = 2,
    BACNET_APPLICATION_TAG_SIGNED_INT = 3,
    BACNET_APPLICATION_TAG_REAL = 4,
    BACNET_APPLICATION_TAG_DOUBLE = 5,
    BACNET_APPLICATION_TAG_OCTET_STRING = 6,
    BACNET_APPLICATION_TAG_CHARACTER_STRING = 7,
    BACNET_APPLICATION_TAG_BIT_STRING = 8,
    BACNET_APPLICATION_TAG_ENUMERATED = 9,
    BACNET_APPLICATION_TAG_DATE = 10,
    BACNET_APPLICATION_TAG_TIME = 11,
    BACNET_APPLICATION_TAG_OBJECT_ID = 12,
    BACNET_APPLICATION_TAG_RESERVE1 = 13,
    BACNET_APPLICATION_TAG_RESERVE2 = 14,
    BACNET_APPLICATION_TAG_RESERVE3 = 15,
    MAX_BACNET_APPLICATION_TAG = 16
} BACNET_APPLICATION_TAG;

/* note: these are not the real values, */
/* but are shifted left for easy encoding */
typedef enum {
    PDU_TYPE_CONFIRMED_SERVICE_REQUEST = 0,
    PDU_TYPE_UNCONFIRMED_SERVICE_REQUEST = 0x10,
    PDU_TYPE_SIMPLE_ACK = 0x20,
    PDU_TYPE_COMPLEX_ACK = 0x30,
    PDU_TYPE_SEGMENT_ACK = 0x40,
    PDU_TYPE_ERROR = 0x50,
    PDU_TYPE_REJECT = 0x60,
    PDU_TYPE_ABORT = 0x70
} BACNET_PDU_TYPE;

typedef enum {
    /* Alarm and Event Services */
    SERVICE_CONFIRMED_ACKNOWLEDGE_ALARM = 0,
    SERVICE_CONFIRMED_COV_NOTIFICATION = 1,
    SERVICE_CONFIRMED_EVENT_NOTIFICATION = 2,
    SERVICE_CONFIRMED_GET_ALARM_SUMMARY = 3,
    SERVICE_CONFIRMED_GET_ENROLLMENT_SUMMARY = 4,
    SERVICE_CONFIRMED_GET_EVENT_INFORMATION = 29,
    SERVICE_CONFIRMED_SUBSCRIBE_COV = 5,
    SERVICE_CONFIRMED_SUBSCRIBE_COV_PROPERTY = 28,
    SERVICE_CONFIRMED_LIFE_SAFETY_OPERATION = 27,
    /* File Access Services */
    SERVICE_CONFIRMED_ATOMIC_READ_FILE = 6,
    SERVICE_CONFIRMED_ATOMIC_WRITE_FILE = 7,
    /* Object Access Services */
    SERVICE_CONFIRMED_ADD_LIST_ELEMENT = 8,
    SERVICE_CONFIRMED_REMOVE_LIST_ELEMENT = 9,
    SERVICE_CONFIRMED_CREATE_OBJECT = 10,
    SERVICE_CONFIRMED_DELETE_OBJECT = 11,
    SERVICE_CONFIRMED_READ_PROPERTY = 12,
    SERVICE_CONFIRMED_READ_PROP_CONDITIONAL = 13,
    SERVICE_CONFIRMED_READ_PROP_MULTIPLE = 14,
    SERVICE_CONFIRMED_READ_RANGE = 26,
    SERVICE_CONFIRMED_WRITE_PROPERTY = 15,
    SERVICE_CONFIRMED_WRITE_PROP_MULTIPLE = 16,
    /* Remote Device Management Services */
    SERVICE_CONFIRMED_DEVICE_COMMUNICATION_CONTROL = 17,
    SERVICE_CONFIRMED_PRIVATE_TRANSFER = 18,
    SERVICE_CONFIRMED_TEXT_MESSAGE = 19,
    SERVICE_CONFIRMED_REINITIALIZE_DEVICE = 20,
    /* Virtual Terminal Services */
    SERVICE_CONFIRMED_VT_OPEN = 21,
    SERVICE_CONFIRMED_VT_CLOSE = 22,
    SERVICE_CONFIRMED_VT_DATA = 23,
    /* Security Services */
    SERVICE_CONFIRMED_AUTHENTICATE = 24,
    SERVICE_CONFIRMED_REQUEST_KEY = 25,
    /* Services added after 1995 */
    /* readRange (26) see Object Access Services */
    /* lifeSafetyOperation (27) see Alarm and Event Services */
    /* subscribeCOVProperty (28) see Alarm and Event Services */
    /* getEventInformation (29) see Alarm and Event Services */
    MAX_BACNET_CONFIRMED_SERVICE = 30
} BACNET_CONFIRMED_SERVICE;

typedef enum {
    SERVICE_UNCONFIRMED_I_AM = 0,
    SERVICE_UNCONFIRMED_I_HAVE = 1,
    SERVICE_UNCONFIRMED_COV_NOTIFICATION = 2,
    SERVICE_UNCONFIRMED_EVENT_NOTIFICATION = 3,
    SERVICE_UNCONFIRMED_PRIVATE_TRANSFER = 4,
    SERVICE_UNCONFIRMED_TEXT_MESSAGE = 5,
    SERVICE_UNCONFIRMED_TIME_SYNCHRONIZATION = 6,
    SERVICE_UNCONFIRMED_WHO_HAS = 7,
    SERVICE_UNCONFIRMED_WHO_IS = 8,
    SERVICE_UNCONFIRMED_UTC_TIME_SYNCHRONIZATION = 9,
    /* addendum 2010-aa */
    SERVICE_UNCONFIRMED_WRITE_GROUP = 10,
    /* Other services to be added as they are defined. */
    /* All choice values in this production are reserved */
    /* for definition by ASHRAE. */
    /* Proprietary extensions are made by using the */
    /* UnconfirmedPrivateTransfer service. See Clause 23. */
    MAX_BACNET_UNCONFIRMED_SERVICE = 11
} BACNET_UNCONFIRMED_SERVICE;

/* Bit String Enumerations */
typedef enum {
    /* Alarm and Event Services */
    SERVICE_SUPPORTED_ACKNOWLEDGE_ALARM = 0,
    SERVICE_SUPPORTED_CONFIRMED_COV_NOTIFICATION = 1,
    SERVICE_SUPPORTED_CONFIRMED_EVENT_NOTIFICATION = 2,
    SERVICE_SUPPORTED_GET_ALARM_SUMMARY = 3,
    SERVICE_SUPPORTED_GET_ENROLLMENT_SUMMARY = 4,
    SERVICE_SUPPORTED_GET_EVENT_INFORMATION = 39,
    SERVICE_SUPPORTED_SUBSCRIBE_COV = 5,
    SERVICE_SUPPORTED_SUBSCRIBE_COV_PROPERTY = 38,
    SERVICE_SUPPORTED_LIFE_SAFETY_OPERATION = 37,
    /* File Access Services */
    SERVICE_SUPPORTED_ATOMIC_READ_FILE = 6,
    SERVICE_SUPPORTED_ATOMIC_WRITE_FILE = 7,
    /* Object Access Services */
    SERVICE_SUPPORTED_ADD_LIST_ELEMENT = 8,
    SERVICE_SUPPORTED_REMOVE_LIST_ELEMENT = 9,
    SERVICE_SUPPORTED_CREATE_OBJECT = 10,
    SERVICE_SUPPORTED_DELETE_OBJECT = 11,
    SERVICE_SUPPORTED_READ_PROPERTY = 12,
    SERVICE_SUPPORTED_READ_PROP_CONDITIONAL = 13,
    SERVICE_SUPPORTED_READ_PROP_MULTIPLE = 14,
    SERVICE_SUPPORTED_READ_RANGE = 35,
    SERVICE_SUPPORTED_WRITE_PROPERTY = 15,
    SERVICE_SUPPORTED_WRITE_PROP_MULTIPLE = 16,
    SERVICE_SUPPORTED_WRITE_GROUP = 40,
    /* Remote Device Management Services */
    SERVICE_SUPPORTED_DEVICE_COMMUNICATION_CONTROL = 17,
    SERVICE_SUPPORTED_PRIVATE_TRANSFER = 18,
    SERVICE_SUPPORTED_TEXT_MESSAGE = 19,
    SERVICE_SUPPORTED_REINITIALIZE_DEVICE = 20,
    /* Virtual Terminal Services */
    SERVICE_SUPPORTED_VT_OPEN = 21,
    SERVICE_SUPPORTED_VT_CLOSE = 22,
    SERVICE_SUPPORTED_VT_DATA = 23,
    /* Security Services */
    SERVICE_SUPPORTED_AUTHENTICATE = 24,
    SERVICE_SUPPORTED_REQUEST_KEY = 25,
    SERVICE_SUPPORTED_I_AM = 26,
    SERVICE_SUPPORTED_I_HAVE = 27,
    SERVICE_SUPPORTED_UNCONFIRMED_COV_NOTIFICATION = 28,
    SERVICE_SUPPORTED_UNCONFIRMED_EVENT_NOTIFICATION = 29,
    SERVICE_SUPPORTED_UNCONFIRMED_PRIVATE_TRANSFER = 30,
    SERVICE_SUPPORTED_UNCONFIRMED_TEXT_MESSAGE = 31,
    SERVICE_SUPPORTED_TIME_SYNCHRONIZATION = 32,
    SERVICE_SUPPORTED_UTC_TIME_SYNCHRONIZATION = 36,
    SERVICE_SUPPORTED_WHO_HAS = 33,
    SERVICE_SUPPORTED_WHO_IS = 34
        /* Other services to be added as they are defined. */
        /* All values in this production are reserved */
        /* for definition by ASHRAE. */
} BACNET_SERVICES_SUPPORTED;

typedef enum {
    BVLC_RESULT = 0,
    BVLC_WRITE_BROADCAST_DISTRIBUTION_TABLE = 1,
    BVLC_READ_BROADCAST_DIST_TABLE = 2,
    BVLC_READ_BROADCAST_DIST_TABLE_ACK = 3,
    BVLC_FORWARDED_NPDU = 4,
    BVLC_REGISTER_FOREIGN_DEVICE = 5,
    BVLC_READ_FOREIGN_DEVICE_TABLE = 6,
    BVLC_READ_FOREIGN_DEVICE_TABLE_ACK = 7,
    BVLC_DELETE_FOREIGN_DEVICE_TABLE_ENTRY = 8,
    BVLC_DISTRIBUTE_BROADCAST_TO_NETWORK = 9,
    BVLC_ORIGINAL_UNICAST_NPDU = 10,
    BVLC_ORIGINAL_BROADCAST_NPDU = 11,
    MAX_BVLC_FUNCTION = 12
} BACNET_BVLC_FUNCTION;

typedef enum {
    BVLC_RESULT_SUCCESSFUL_COMPLETION = 0x0000,
    BVLC_RESULT_WRITE_BROADCAST_DISTRIBUTION_TABLE_NAK = 0x0010,
    BVLC_RESULT_READ_BROADCAST_DISTRIBUTION_TABLE_NAK = 0x0020,
    BVLC_RESULT_REGISTER_FOREIGN_DEVICE_NAK = 0X0030,
    BVLC_RESULT_READ_FOREIGN_DEVICE_TABLE_NAK = 0x0040,
    BVLC_RESULT_DELETE_FOREIGN_DEVICE_TABLE_ENTRY_NAK = 0x0050,
    BVLC_RESULT_DISTRIBUTE_BROADCAST_TO_NETWORK_NAK = 0x0060
} BACNET_BVLC_RESULT;

/* Bit String Enumerations */
typedef enum {
    STATUS_FLAG_IN_ALARM = 0,
    STATUS_FLAG_FAULT = 1,
    STATUS_FLAG_OVERRIDDEN = 2,
    STATUS_FLAG_OUT_OF_SERVICE = 3
} BACNET_STATUS_FLAGS;

typedef enum {
    LOG_STATUS_LOG_DISABLED = 0,
    LOG_STATUS_BUFFER_PURGED = 1,
    LOG_STATUS_LOG_INTERRUPTED = 2
} BACNET_LOG_STATUS;

typedef enum {
    LOGGING_TYPE_POLLED = 0,
    LOGGING_TYPE_COV = 1,
    LOGGING_TYPE_TRIGGERED = 2
} BACNET_LOGGING_TYPE;

typedef enum {
    ACKNOWLEDGMENT_FILTER_ALL = 0,
    ACKNOWLEDGMENT_FILTER_ACKED = 1,
    ACKNOWLEDGMENT_FILTER_NOT_ACKED = 2
} BACNET_ACKNOWLEDGMENT_FILTER;

typedef enum {
    EVENT_STATE_FILTER_OFFNORMAL = 0,
    EVENT_STATE_FILTER_FAULT = 1,
    EVENT_STATE_FILTER_NORMAL = 2,
    EVENT_STATE_FILTER_ALL = 3,
    EVENT_STATE_FILTER_ACTIVE = 4
} BACNET_EVENT_STATE_FILTER;

typedef enum {
    SELECTION_LOGIC_AND = 0,
    SELECTION_LOGIC_OR = 1,
    SELECTION_LOGIC_ALL = 2
} BACNET_SELECTION_LOGIC;

typedef enum {
    RELATION_SPECIFIER_EQUAL = 0,
    RELATION_SPECIFIER_NOT_EQUAL = 1,
    RELATION_SPECIFIER_LESS_THAN = 2,
    RELATION_SPECIFIER_GREATER_THAN = 3,
    RELATION_SPECIFIER_LESS_THAN_OR_EQUAL = 4,
    RELATION_SPECIFIER_GREATER_THAN_OR_EQUAL = 5
} BACNET_RELATION_SPECIFIER;

typedef enum {
    COMMUNICATION_ENABLE = 0,
    COMMUNICATION_DISABLE = 1,
    COMMUNICATION_DISABLE_INITIATION = 2,
    MAX_BACNET_COMMUNICATION_ENABLE_DISABLE = 3
} BACNET_COMMUNICATION_ENABLE_DISABLE;

typedef enum {
    MESSAGE_PRIORITY_NORMAL = 0,
    MESSAGE_PRIORITY_URGENT = 1,
    MESSAGE_PRIORITY_CRITICAL_EQUIPMENT = 2,
    MESSAGE_PRIORITY_LIFE_SAFETY = 3
} BACNET_MESSAGE_PRIORITY;

/*Network Layer Message Type */
/*If Bit 7 of the control octet described in 6.2.2 is 1, */
/* a message type octet shall be present as shown in Figure 6-1. */
/* The following message types are indicated: */
typedef enum {
    NETWORK_MESSAGE_WHO_IS_ROUTER_TO_NETWORK = 0,
    NETWORK_MESSAGE_I_AM_ROUTER_TO_NETWORK = 1,
    NETWORK_MESSAGE_I_COULD_BE_ROUTER_TO_NETWORK = 2,
    NETWORK_MESSAGE_REJECT_MESSAGE_TO_NETWORK = 3,
    NETWORK_MESSAGE_ROUTER_BUSY_TO_NETWORK = 4,
    NETWORK_MESSAGE_ROUTER_AVAILABLE_TO_NETWORK = 5,
    NETWORK_MESSAGE_INIT_RT_TABLE = 6,
    NETWORK_MESSAGE_INIT_RT_TABLE_ACK = 7,
    NETWORK_MESSAGE_ESTABLISH_CONNECTION_TO_NETWORK = 8,
    NETWORK_MESSAGE_DISCONNECT_CONNECTION_TO_NETWORK = 9,
    /* X'0A' to X'7F': Reserved for use by ASHRAE, */
    /* X'80' to X'FF': Available for vendor proprietary messages */
    NETWORK_MESSAGE_INVALID = 0x100
} BACNET_NETWORK_MESSAGE_TYPE;

typedef enum {
    ABORT_REASON_OTHER = 0,
    ABORT_REASON_BUFFER_OVERFLOW = 1,
    ABORT_REASON_INVALID_APDU_IN_THIS_STATE = 2,
    ABORT_REASON_PREEMPTED_BY_HIGHER_PRIORITY_TASK = 3,
    ABORT_REASON_SEGMENTATION_NOT_SUPPORTED = 4,
    /* Enumerated values 0-63 are reserved for definition by ASHRAE. */
    /* Enumerated values 64-65535 may be used by others subject to */
    /* the procedures and constraints described in Clause 23. */
    MAX_BACNET_ABORT_REASON = 5,
    FIRST_PROPRIETARY_ABORT_REASON = 64,
    LAST_PROPRIETARY_ABORT_REASON = 65535
} BACNET_ABORT_REASON;

typedef enum {
    REJECT_REASON_OTHER = 0,
    REJECT_REASON_BUFFER_OVERFLOW = 1,
    REJECT_REASON_INCONSISTENT_PARAMETERS = 2,
    REJECT_REASON_INVALID_PARAMETER_DATA_TYPE = 3,
    REJECT_REASON_INVALID_TAG = 4,
    REJECT_REASON_MISSING_REQUIRED_PARAMETER = 5,
    REJECT_REASON_PARAMETER_OUT_OF_RANGE = 6,
    REJECT_REASON_TOO_MANY_ARGUMENTS = 7,
    REJECT_REASON_UNDEFINED_ENUMERATION = 8,
    REJECT_REASON_UNRECOGNIZED_SERVICE = 9,
    /* Enumerated values 0-63 are reserved for definition by ASHRAE. */
    /* Enumerated values 64-65535 may be used by others subject to */
    /* the procedures and constraints described in Clause 23. */
    MAX_BACNET_REJECT_REASON = 10,
    FIRST_PROPRIETARY_REJECT_REASON = 64,
    LAST_PROPRIETARY_REJECT_REASON = 65535
} BACNET_REJECT_REASON;

typedef enum {
    ERROR_CLASS_DEVICE = 0,
    ERROR_CLASS_OBJECT = 1,
    ERROR_CLASS_PROPERTY = 2,
    ERROR_CLASS_RESOURCES = 3,
    ERROR_CLASS_SECURITY = 4,
    ERROR_CLASS_SERVICES = 5,
    ERROR_CLASS_VT = 6,
    ERROR_CLASS_COMMUNICATION = 7,
    /* Enumerated values 0-63 are reserved for definition by ASHRAE. */
    /* Enumerated values 64-65535 may be used by others subject to */
    /* the procedures and constraints described in Clause 23. */
    MAX_BACNET_ERROR_CLASS = 8,
    FIRST_PROPRIETARY_ERROR_CLASS = 64,
    LAST_PROPRIETARY_ERROR_CLASS = 65535
} BACNET_ERROR_CLASS;

/* These are sorted in the order given in
   Clause 18. ERROR, REJECT AND ABORT CODES
   The Class and Code pairings are required
   to be used in accordance with Clause 18. */
typedef enum {
    /* valid for all classes */
    ERROR_CODE_OTHER = 0,

    /* Error Class - Device */
    ERROR_CODE_DEVICE_BUSY = 3,
    ERROR_CODE_CONFIGURATION_IN_PROGRESS = 2,
    ERROR_CODE_OPERATIONAL_PROBLEM = 25,

    /* Error Class - Object */
    ERROR_CODE_DYNAMIC_CREATION_NOT_SUPPORTED = 4,
    ERROR_CODE_NO_OBJECTS_OF_SPECIFIED_TYPE = 17,
    ERROR_CODE_OBJECT_DELETION_NOT_PERMITTED = 23,
    ERROR_CODE_OBJECT_IDENTIFIER_ALREADY_EXISTS = 24,
    ERROR_CODE_READ_ACCESS_DENIED = 27,
    ERROR_CODE_UNKNOWN_OBJECT = 31,
    ERROR_CODE_UNSUPPORTED_OBJECT_TYPE = 36,

    /* Error Class - Property */
    ERROR_CODE_CHARACTER_SET_NOT_SUPPORTED = 41,
    ERROR_CODE_DATATYPE_NOT_SUPPORTED = 47,
    ERROR_CODE_INCONSISTENT_SELECTION_CRITERION = 8,
    ERROR_CODE_INVALID_ARRAY_INDEX = 42,
    ERROR_CODE_INVALID_DATA_TYPE = 9,
    ERROR_CODE_NOT_COV_PROPERTY = 44,
    ERROR_CODE_OPTIONAL_FUNCTIONALITY_NOT_SUPPORTED = 45,
    ERROR_CODE_PROPERTY_IS_NOT_AN_ARRAY = 50,
    /* ERROR_CODE_READ_ACCESS_DENIED = 27, */
    ERROR_CODE_UNKNOWN_PROPERTY = 32,
    ERROR_CODE_VALUE_OUT_OF_RANGE = 37,
    ERROR_CODE_WRITE_ACCESS_DENIED = 40,

    /* Error Class - Resources */
    ERROR_CODE_NO_SPACE_FOR_OBJECT = 18,
    ERROR_CODE_NO_SPACE_TO_ADD_LIST_ELEMENT = 19,
    ERROR_CODE_NO_SPACE_TO_WRITE_PROPERTY = 20,

    /* Error Class - Security */
    ERROR_CODE_AUTHENTICATION_FAILED = 1,
    /* ERROR_CODE_CHARACTER_SET_NOT_SUPPORTED = 41, */
    ERROR_CODE_INCOMPATIBLE_SECURITY_LEVELS = 6,
    ERROR_CODE_INVALID_OPERATOR_NAME = 12,
    ERROR_CODE_KEY_GENERATION_ERROR = 15,
    ERROR_CODE_PASSWORD_FAILURE = 26,
    ERROR_CODE_SECURITY_NOT_SUPPORTED = 28,
    ERROR_CODE_TIMEOUT = 30,

    /* Error Class - Services */
    /* ERROR_CODE_CHARACTER_SET_NOT_SUPPORTED = 41, */
    ERROR_CODE_COV_SUBSCRIPTION_FAILED = 43,
    ERROR_CODE_DUPLICATE_NAME = 48,
    ERROR_CODE_DUPLICATE_OBJECT_ID = 49,
    ERROR_CODE_FILE_ACCESS_DENIED = 5,
    ERROR_CODE_INCONSISTENT_PARAMETERS = 7,
    ERROR_CODE_INVALID_CONFIGURATION_DATA = 46,
    ERROR_CODE_INVALID_FILE_ACCESS_METHOD = 10,
    ERROR_CODE_INVALID_FILE_START_POSITION = 11,
    ERROR_CODE_INVALID_PARAMETER_DATA_TYPE = 13,
    ERROR_CODE_INVALID_TIME_STAMP = 14,
    ERROR_CODE_MISSING_REQUIRED_PARAMETER = 16,
    /* ERROR_CODE_OPTIONAL_FUNCTIONALITY_NOT_SUPPORTED = 45, */
    ERROR_CODE_PROPERTY_IS_NOT_A_LIST = 22,
    ERROR_CODE_SERVICE_REQUEST_DENIED = 29,

    /* Error Class - VT */
    ERROR_CODE_UNKNOWN_VT_CLASS = 34,
    ERROR_CODE_UNKNOWN_VT_SESSION = 35,
    ERROR_CODE_NO_VT_SESSIONS_AVAILABLE = 21,
    ERROR_CODE_VT_SESSION_ALREADY_CLOSED = 38,
    ERROR_CODE_VT_SESSION_TERMINATION_FAILURE = 39,

    /* unused */
    ERROR_CODE_RESERVED1 = 33,
    /* new error codes from new addenda */
    ERROR_CODE_ABORT_BUFFER_OVERFLOW = 51,
    ERROR_CODE_ABORT_INVALID_APDU_IN_THIS_STATE = 52,
    ERROR_CODE_ABORT_PREEMPTED_BY_HIGHER_PRIORITY_TASK = 53,
    ERROR_CODE_ABORT_SEGMENTATION_NOT_SUPPORTED = 54,
    ERROR_CODE_ABORT_PROPRIETARY = 55,
    ERROR_CODE_ABORT_OTHER = 56,
    ERROR_CODE_INVALID_TAG = 57,
    ERROR_CODE_NETWORK_DOWN = 58,
    ERROR_CODE_REJECT_BUFFER_OVERFLOW = 59,
    ERROR_CODE_REJECT_INCONSISTENT_PARAMETERS = 60,
    ERROR_CODE_REJECT_INVALID_PARAMETER_DATA_TYPE = 61,
    ERROR_CODE_REJECT_INVALID_TAG = 62,
    ERROR_CODE_REJECT_MISSING_REQUIRED_PARAMETER = 63,
    ERROR_CODE_REJECT_PARAMETER_OUT_OF_RANGE = 64,
    ERROR_CODE_REJECT_TOO_MANY_ARGUMENTS = 65,
    ERROR_CODE_REJECT_UNDEFINED_ENUMERATION = 66,
    ERROR_CODE_REJECT_UNRECOGNIZED_SERVICE = 67,
    ERROR_CODE_REJECT_PROPRIETARY = 68,
    ERROR_CODE_REJECT_OTHER = 69,
    ERROR_CODE_UNKNOWN_DEVICE = 70,
    ERROR_CODE_UNKNOWN_ROUTE = 71,
    ERROR_CODE_VALUE_NOT_INITIALIZED = 72,
    ERROR_CODE_INVALID_EVENT_STATE = 73,
    ERROR_CODE_NO_ALARM_CONFIGURED = 74,
    ERROR_CODE_LOG_BUFFER_FULL = 75,
    ERROR_CODE_LOGGED_VALUE_PURGED = 76,
    ERROR_CODE_NO_PROPERTY_SPECIFIED = 77,
    ERROR_CODE_NOT_CONFIGURED_FOR_TRIGGERED_LOGGING = 78,
    ERROR_CODE_UNKNOWN_SUBSCRIPTION = 79,
    ERROR_CODE_PARAMETER_OUT_OF_RANGE = 80,
    ERROR_CODE_LIST_ELEMENT_NOT_FOUND = 81,
    ERROR_CODE_BUSY = 82,
    ERROR_CODE_COMMUNICATION_DISABLED = 83,
    ERROR_CODE_SUCCESS = 84,
    ERROR_CODE_ACCESS_DENIED = 85,
    ERROR_CODE_BAD_DESTINATION_ADDRESS = 86,
    ERROR_CODE_BAD_DESTINATION_DEVICE_ID = 87,
    ERROR_CODE_BAD_SIGNATURE = 88,
    ERROR_CODE_BAD_SOURCE_ADDRESS = 89,
    ERROR_CODE_BAD_TIMESTAMP = 90,
    ERROR_CODE_CANNOT_USE_KEY = 91,
    ERROR_CODE_CANNOT_VERIFY_MESSAGE_ID = 92,
    ERROR_CODE_CORRECT_KEY_REVISION = 93,
    ERROR_CODE_DESTINATION_DEVICE_ID_REQUIRED = 94,
    ERROR_CODE_DUPLICATE_MESSAGE = 95,
    ERROR_CODE_ENCRYPTION_NOT_CONFIGURED = 96,
    ERROR_CODE_ENCRYPTION_REQUIRED = 97,
    ERROR_CODE_INCORRECT_KEY = 98,
    ERROR_CODE_INVALID_KEY_DATA = 99,
    ERROR_CODE_KEY_UPDATE_IN_PROGRESS = 100,
    ERROR_CODE_MALFORMED_MESSAGE = 101,
    ERROR_CODE_NOT_KEY_SERVER = 102,
    ERROR_CODE_SECURITY_NOT_CONFIGURED = 103,
    ERROR_CODE_SOURCE_SECURITY_REQUIRED = 104,
    ERROR_CODE_TOO_MANY_KEYS = 105,
    ERROR_CODE_UNKNOWN_AUTHENTICATION_TYPE = 106,
    ERROR_CODE_UNKNOWN_KEY = 107,
    ERROR_CODE_UNKNOWN_KEY_REVISION = 108,
    ERROR_CODE_UNKNOWN_SOURCE_MESSAGE = 109,
    ERROR_CODE_NOT_ROUTER_TO_DNET = 110,
    ERROR_CODE_ROUTER_BUSY = 111,
    ERROR_CODE_UNKNOWN_NETWORK_MESSAGE = 112,
    ERROR_CODE_MESSAGE_TOO_LONG = 113,
    ERROR_CODE_SECURITY_ERROR = 114,
    ERROR_CODE_ADDRESSING_ERROR = 115,
    ERROR_CODE_WRITE_BDT_FAILED = 116,
    ERROR_CODE_READ_BDT_FAILED = 117,
    ERROR_CODE_REGISTER_FOREIGN_DEVICE_FAILED = 118,
    ERROR_CODE_READ_FDT_FAILED = 119,
    ERROR_CODE_DELETE_FDT_ENTRY_FAILED = 120,
    ERROR_CODE_DISTRIBUTE_BROADCAST_FAILED = 121,
    ERROR_CODE_UNKNOWN_FILE_SIZE = 122,
    ERROR_CODE_ABORT_APDU_TOO_LONG = 123,
    ERROR_CODE_ABORT_APPLICATION_EXCEEDED_REPLY_TIME = 124,
    ERROR_CODE_ABORT_OUT_OF_RESOURCES = 125,
    ERROR_CODE_ABORT_TSM_TIMEOUT = 126,
    ERROR_CODE_ABORT_WINDOW_SIZE_OUT_OF_RANGE = 127,
    ERROR_CODE_FILE_FULL = 128,
    ERROR_CODE_INCONSISTENT_CONFIGURATION = 129,
    ERROR_CODE_INCONSISTENT_OBJECT_TYPE = 130,
    ERROR_CODE_INTERNAL_ERROR = 131,
    ERROR_CODE_NOT_CONFIGURED = 132,
    ERROR_CODE_OUT_OF_MEMORY = 133,
    ERROR_CODE_VALUE_TOO_LONG = 134,
    ERROR_CODE_ABORT_INSUFFICIENT_SECURITY = 135,
    ERROR_CODE_ABORT_SECURITY_ERROR = 136,
        /* Enumerated values 0-255 are reserved for definition by ASHRAE. */
        /* Enumerated values 256-65535 may be used by others subject to */
        /* the procedures and constraints described in Clause 23. */
    /* do the max range inside of enum so that
       compilers will allocate adequate sized datatype for enum
       which is used to store decoding */
    FIRST_PROPRIETARY_ERROR_CODE = 256,
    LAST_PROPRIETARY_ERROR_CODE = 65535
} BACNET_ERROR_CODE;

typedef enum {
    BACNET_REINIT_COLDSTART = 0,
    BACNET_REINIT_WARMSTART = 1,
    BACNET_REINIT_STARTBACKUP = 2,
    BACNET_REINIT_ENDBACKUP = 3,
    BACNET_REINIT_STARTRESTORE = 4,
    BACNET_REINIT_ENDRESTORE = 5,
    BACNET_REINIT_ABORTRESTORE = 6,
    MAX_BACNET_REINITIALIZED_STATE = 7,
    BACNET_REINIT_IDLE = 255
} BACNET_REINITIALIZED_STATE;

typedef enum BACnetNodeType {
    BACNET_NODE_UNKNOWN = 0,
    BACNET_NODE_SYSTEM = 1,
    BACNET_NODE_NETWORK = 2,
    BACNET_NODE_DEVICE = 3,
    BACNET_NODE_ORGANIZATIONAL = 4,
    BACNET_NODE_AREA = 5,
    BACNET_NODE_EQUIPMENT = 6,
    BACNET_NODE_POINT = 7,
    BACNET_NODE_COLLECTION = 8,
    BACNET_NODE_PROPERTY = 9,
    BACNET_NODE_FUNCTIONAL = 10,
    BACNET_NODE_OTHER = 11
} BACNET_NODE_TYPE;

typedef enum BACnetShedState {
    BACNET_SHED_INACTIVE = 0,
    BACNET_SHED_REQUEST_PENDING = 1,
    BACNET_SHED_COMPLIANT = 2,
    BACNET_SHED_NON_COMPLIANT = 3
} BACNET_SHED_STATE;

typedef enum BACnetLightingOperation {
    BACNET_LIGHTS_NONE = 0,
    BACNET_LIGHTS_FADE_TO = 1,
    BACNET_LIGHTS_RAMP_TO = 2,
    BACNET_LIGHTS_STEP_UP = 3,
    BACNET_LIGHTS_STEP_DOWN = 4,
    BACNET_LIGHTS_STEP_ON = 5,
    BACNET_LIGHTS_STEP_OFF = 6,
    BACNET_LIGHTS_WARN = 7,
    BACNET_LIGHTS_WARN_OFF = 8,
    BACNET_LIGHTS_WARN_RELINQUISH = 9,
    BACNET_LIGHTS_STOP = 10
} BACNET_LIGHTING_OPERATION;

typedef enum BACnetLightingInProgress {
    BACNET_LIGHTING_IDLE = 0,
    BACNET_LIGHTING_FADE_ACTIVE = 1,
    BACNET_LIGHTING_RAMP_ACTIVE = 2,
    BACNET_LIGHTING_NOT_CONTROLLED = 3,
    BACNET_LIGHTING_OTHER = 4
} BACNET_LIGHTING_IN_PROGRESS;

typedef enum BACnetLightingTransition {
    BACNET_LIGHTING_TRANSITION_IDLE = 0,
    BACNET_LIGHTING_TRANSITION_FADE = 1,
    BACNET_LIGHTING_TRANSITION_RAMP = 2
} BACNET_LIGHTING_TRANSITION;

/* NOTE: BACNET_DAYS_OF_WEEK is different than BACNET_WEEKDAY */
/* 0=Monday-6=Sunday */
typedef enum BACnetDaysOfWeek {
    BACNET_DAYS_OF_WEEK_MONDAY = 0,
    BACNET_DAYS_OF_WEEK_TUESDAY = 1,
    BACNET_DAYS_OF_WEEK_WEDNESDAY = 2,
    BACNET_DAYS_OF_WEEK_THURSDAY = 3,
    BACNET_DAYS_OF_WEEK_FRIDAY = 4,
    BACNET_DAYS_OF_WEEK_SATURDAY = 5,
    BACNET_DAYS_OF_WEEK_SUNDAY = 6,
    MAX_BACNET_DAYS_OF_WEEK = 7
} BACNET_DAYS_OF_WEEK;

typedef enum BACnetEventTransitionBits {
    TRANSITION_TO_OFFNORMAL = 0,
    TRANSITION_TO_FAULT = 1,
    TRANSITION_TO_NORMAL = 2,
    MAX_BACNET_EVENT_TRANSITION = 3
} BACNET_EVENT_TRANSITION_BITS;

/* Not in standard, but useful for store Ack_Required */
typedef enum BACnetEventTransitionMask {
    TRANSITION_TO_OFFNORMAL_MASKED = 1,
    TRANSITION_TO_FAULT_MASKED = 2,
    TRANSITION_TO_NORMAL_MASKED = 4
} BACNET_EVENT_TRANSITION_MASK;

/* The Network Reject Reasons  for NETWORK_MESSAGE_REJECT_MESSAGE_TO_NETWORK */
typedef enum {
    NETWORK_REJECT_UNKNOWN_ERROR = 0,
    NETWORK_REJECT_NO_ROUTE = 1,
    NETWORK_REJECT_ROUTER_BUSY = 2,
    NETWORK_REJECT_UNKNOWN_MESSAGE_TYPE = 3,
    NETWORK_REJECT_MESSAGE_TOO_LONG = 4,
    /* Reasons this value or above we don't know about */
    NETWORK_REJECT_REASON_INVALID
} BACNET_NETWORK_REJECT_REASONS;


#endif /* end of BACENUM_H */
