/*================================================================================
                                                                               
                      Header Name: imageproc.h

General Description: Image process fuction(exported): Resize.
 
==================================================================================
                     Honeywell Confidential Proprietary
               ACS - Security (Asia Pacific) R&D Software Operations
               (c) Copyright Honeywell 2011, All Rights Reserved
 
Revision History:
                            Modification     Tracking
Author                 Date        Ver Number     Description of Changes
----------------   ------------    ----------   -------------------------
Zhao Lianfeng        08/24/2011    ver0.0.1    Initial   

================================================================================*/

#ifndef IMAGEPROC_SRC_IMAGEPROC_H_EDAD7BE8_9826_4D21_966E_8FE6D3D75DBB
#define IMAGEPROC_SRC_IMAGEPROC_H_EDAD7BE8_9826_4D21_966E_8FE6D3D75DBB


#define IMAGEPROCAPI extern "C" __declspec(dllexport)

enum ImageFormat {
	kRGBInterleaved = 0,
	kBGRInterleaved,
	kYUV444Interleaved,
	kYUV422Interleaved,
	kYUV420Plannar,
	kGrayScale
};

enum InterpolationMethod {
	kInterNN = 0,
	kInterLinear,
	kInterCubic,
	kInterArea
};

enum ResizeErrorCode {
	kErrorInvalidDstParam = -1,
	kErrorInsufficientDstBuf = -2,
	kErrorInvalidSrcParam = -3,
	kErrorInvalidInterMethod = -4,
	kErrorNoSupportConvert = -5
};

struct ImageInfoEx {
	ImageFormat enum_image_format;
	int num_image_width;
	int num_image_height;
	int num_image_datasize;
	int num_image_linesize0;
	int num_image_linesize1;
	int num_image_linesize2;
	int num_image_linesize3;
	char * ptr_image_data0;
	char * ptr_image_data1;
	char * ptr_image_data2;
	char * ptr_image_data3;
};

IMAGEPROCAPI int ImageResize(const ImageInfoEx& src, const InterpolationMethod method, ImageInfoEx& dst);

IMAGEPROCAPI void ConvertRGB24toRGB32(unsigned char* rgb24Buffer, const long width, const long height, unsigned char* rgb32Buffer);

IMAGEPROCAPI void DeltYUV(unsigned char* lpInY, unsigned char* lpInU, unsigned char* lpInV, 
  const long* linesize, const long width, const long height, 
  unsigned char* lpOutY, unsigned char* lpOutU, unsigned char* lpOutV);

IMAGEPROCAPI void ConvertYUVtoRGB24 (unsigned char* src0, unsigned char* src1, unsigned char* src2, 
  const int width, const int height, unsigned char* rgb24buffer);

#endif // IMAGEPROC_SRC_IMAGEPROC_H_EDAD7BE8_9826_4D21_966E_8FE6D3D75DBB