/*================================================================================
                                                                               
                      Header Name: imageproc.cpp

General Description: Image process fuction(exported): Resize.
 
==================================================================================
                     Honeywell Confidential Proprietary
               ACS - Security (Asia Pacific) R&D Software Operations
               (c) Copyright Honeywell 2011, All Rights Reserved
 
Revision History:
                            Modification     Tracking
Author                 Date        Ver Number     Description of Changes
----------------   ------------    ----------   -------------------------
Zhao Lianfeng        08/24/2011    ver0.0.1    Initial   

================================================================================*/

#include "stdafx.h"
#include "cv.h"
#include "highgui.h"
#include "imageproc.h"

int CalImageDataSize(const ImageInfoEx& info);
IplImage ConstructIplImage(const int width, const int height, const int widthstep, const int channel, const int size, char * data);
void RGBI2RGBI(const ImageInfoEx& src_info, const InterpolationMethod method, ImageInfoEx& dst_info);
void YUV420P2YUV420P(const ImageInfoEx& src_info, const InterpolationMethod method, ImageInfoEx& dst_info);
void Gray2Gray(const ImageInfoEx& src_info, const InterpolationMethod method, ImageInfoEx& dst_info);

IMAGEPROCAPI int ImageResize(const ImageInfoEx& src, 
	                         const InterpolationMethod method,
							 ImageInfoEx& dst) {
	if (dst.enum_image_format < kRGBInterleaved || 
	    dst.enum_image_format > kGrayScale ||
	    dst.num_image_width <= 0 ||
	    dst.num_image_height <= 0) {
		return kErrorInvalidDstParam;
	}
	if (dst.ptr_image_data0 == NULL ||
		(dst.enum_image_format == kYUV420Plannar && (dst.ptr_image_data1 == NULL || dst.ptr_image_data2 == NULL)) ||
		dst.num_image_datasize != CalImageDataSize(dst)) {
		int num_size = CalImageDataSize(dst);
		dst.num_image_datasize = num_size;
		return kErrorInsufficientDstBuf;
	}
	if (src.enum_image_format < kRGBInterleaved || 
		src.enum_image_format > kGrayScale ||
		src.num_image_width <= 0 ||
		src.num_image_height <= 0 ||
		src.ptr_image_data0 == NULL ||
		(src.enum_image_format == kYUV420Plannar && (src.ptr_image_data1 == NULL || src.ptr_image_data2 == NULL)) ||
		src.num_image_datasize != CalImageDataSize(src)) {
		return kErrorInvalidSrcParam;
	}
	if (method > kInterArea || method < kInterNN){
		return kErrorInvalidInterMethod;
	}

	if ((src.enum_image_format == kRGBInterleaved &&
		 dst.enum_image_format == kRGBInterleaved) ||
		(src.enum_image_format == kBGRInterleaved &&
		 dst.enum_image_format == kBGRInterleaved) ||
		(src.enum_image_format == kYUV444Interleaved &&
		 dst.enum_image_format == kYUV444Interleaved)) {
        RGBI2RGBI(src, method, dst);
	}
	else if (src.enum_image_format == kYUV420Plannar &&
		     dst.enum_image_format == kYUV420Plannar) {
		YUV420P2YUV420P(src, method, dst);
	}
	else if (src.enum_image_format == kGrayScale &&
		     dst.enum_image_format == kGrayScale) {
		Gray2Gray(src, method, dst);
	}
	else
	{
		return kErrorNoSupportConvert;
	}

	return dst.num_image_datasize;
}

int CalImageDataSize(const ImageInfoEx& info) {
	int num_size = 0;
	switch(info.enum_image_format) {
	case kRGBInterleaved:
	case kBGRInterleaved:
	case kYUV444Interleaved:
		num_size = info.num_image_linesize0*info.num_image_height;
		break;
	case kYUV422Interleaved:
		num_size = info.num_image_linesize0*info.num_image_height;
		break;
	case kYUV420Plannar:
		num_size = (int)(info.num_image_linesize0*info.num_image_height
			+ info.num_image_linesize1*info.num_image_height*0.5
			+ info.num_image_linesize2*info.num_image_height*0.5);
		break;
	case kGrayScale:
		num_size = info.num_image_linesize0*info.num_image_height;
		break;
	default:
		assert(false);
	}
	return num_size;
}

void RGBI2RGBI(const ImageInfoEx& src_info, const InterpolationMethod method, ImageInfoEx& dst_info) {
	IplImage src_iplimage;
	IplImage dst_iplimage;

	src_iplimage = ConstructIplImage(src_info.num_image_width,
		src_info.num_image_height,
		src_info.num_image_linesize0,
		3,
		src_info.num_image_datasize,
		src_info.ptr_image_data0);

	dst_iplimage = ConstructIplImage(dst_info.num_image_width,
		dst_info.num_image_height,
		dst_info.num_image_linesize0,
		3,
		dst_info.num_image_datasize,
		dst_info.ptr_image_data0);
	
	cvResize(&src_iplimage, &dst_iplimage, method);
}

void YUV420P2YUV420P(const ImageInfoEx& src_info, const InterpolationMethod method, ImageInfoEx& dst_info) {
	IplImage src_iplimageY, src_iplimageCb, src_iplimageCr;
	IplImage dst_iplimageY, dst_iplimageCb, dst_iplimageCr;

	src_iplimageY = ConstructIplImage(src_info.num_image_width,
		src_info.num_image_height,
		src_info.num_image_linesize0,
		1,
		src_info.num_image_width*src_info.num_image_height,
		src_info.ptr_image_data0);
	dst_iplimageY = ConstructIplImage(dst_info.num_image_width,
		dst_info.num_image_height,
		dst_info.num_image_linesize0,
		1,
		dst_info.num_image_width*dst_info.num_image_height,
		dst_info.ptr_image_data0);
	cvResize(&src_iplimageY, &dst_iplimageY, method);

	src_iplimageCb = ConstructIplImage(src_info.num_image_width*0.5,
		src_info.num_image_height*0.5,
		src_info.num_image_linesize1,
		1,
		src_info.num_image_width*src_info.num_image_height*0.25,
		src_info.ptr_image_data1);
	dst_iplimageCb = ConstructIplImage(dst_info.num_image_width*0.5,
		dst_info.num_image_height*0.5,
		dst_info.num_image_linesize1,
		1,
		dst_info.num_image_width*dst_info.num_image_height*0.25,
		dst_info.ptr_image_data1);
	cvResize(&src_iplimageCb, &dst_iplimageCb, method);

	src_iplimageCr = ConstructIplImage(src_info.num_image_width*0.5,
		src_info.num_image_height*0.5,
		src_info.num_image_linesize2,
		1,
		src_info.num_image_width*src_info.num_image_height*0.25,
		src_info.ptr_image_data2);

	dst_iplimageCr = ConstructIplImage(dst_info.num_image_width*0.5,
		dst_info.num_image_height*0.5,
		dst_info.num_image_linesize2,
		1,
		dst_info.num_image_width*dst_info.num_image_height*0.25,
		dst_info.ptr_image_data2);
	cvResize(&src_iplimageCr, &dst_iplimageCr, method);
}

void Gray2Gray(const ImageInfoEx& src_info, const InterpolationMethod method, ImageInfoEx& dst_info) {
	IplImage src_iplimage;
	IplImage dst_iplimage;

	src_iplimage = ConstructIplImage(src_info.num_image_width,
		src_info.num_image_height,
		src_info.num_image_linesize0,
		1,
		src_info.num_image_datasize,
		src_info.ptr_image_data0);

	dst_iplimage = ConstructIplImage(dst_info.num_image_width,
		dst_info.num_image_height,
		dst_info.num_image_linesize0,
		1,
		dst_info.num_image_datasize,
		dst_info.ptr_image_data0);

	cvResize(&src_iplimage, &dst_iplimage, method);
}

IplImage ConstructIplImage(const int width, const int height, const int widthstep, const int channel, const int size, char * data) {
	IplImage iplimage;

	memset(&iplimage, 0, sizeof(iplimage));
	iplimage.nSize = sizeof(IplImage);
	iplimage.width = width;
	iplimage.height = height;
	iplimage.nChannels = channel;
	iplimage.depth = 8;
	iplimage.widthStep = widthstep;
	iplimage.imageSize = size;
	iplimage.imageData = data;

	return iplimage;
}

//#include "taskimpl.h"
//yuv to rgb24
unsigned char *g_clp = NULL;
unsigned char *g_clp1;
long int g_crv_tab[256];
long int g_cbu_tab[256];
long int g_cgu_tab[256];

long int g_cgv_tab[256];
long int g_tab_76309[256];
bool g_TableInited = false;

//HUS::mutex g_mutex_tab_lock;

void init_dither_tab ()
{
  //HUS::scoped_lock<HUS::mutex> locker(g_mutex_tab_lock);
  if(g_TableInited)
    return;

  long int crv, cbu, cgu, cgv;
  int i;

  crv = 104597;
  cbu = 132201;                 /* fra matrise i global.h */
  cgu = 25675;
  cgv = 53279;

  for (i = 0; i < 256; i++)
  {
    g_crv_tab[i] = (i - 128) * crv;
    g_cbu_tab[i] = (i - 128) * cbu;
    g_cgu_tab[i] = (i - 128) * cgu;
    g_cgv_tab[i] = (i - 128) * cgv;
    g_tab_76309[i] = 76309 * (i - 16);
  }
  if (!(g_clp = (unsigned char *)malloc(sizeof(unsigned char)*1024)))
  {
    //AfxMessageBox("init decode table fail");
  }
  g_clp1 = g_clp;

  g_clp += 384;

  for (i = -384; i < 640; i++)
    g_clp[i] = (i < 0) ? 0 : ((i > 255) ? 255 : i);

  g_TableInited = true;
}

IMAGEPROCAPI void ConvertYUVtoRGB24 (
  unsigned char* src0, unsigned char* src1, unsigned char* src2, 
  const int width, const int height,
  unsigned char* rgb24buffer)
{
  if(!g_TableInited){
    init_dither_tab();
  }

  int y11, y21;
  int y12, y22;
  int y13, y23;
  int y14, y24;
  int u, v;
  int i, j;
  int c11, c21, c31, c41;
  int c12, c22, c32, c42;
  unsigned int DW;
  unsigned int *id1, *id2;
  unsigned char *py1, *py2, *pu, *pv;
  unsigned char *d1, *d2;

  d1 = rgb24buffer;
  d1 += width * height * 3 - width * 3;
  d2 = d1 - width * 3;

  py1 = src0;
  pu = src1;
  pv = src2;
  py2 = py1 + width;

  id1 = (unsigned int *) d1;
  id2 = (unsigned int *) d2;

  for (j = 0; j < height; j += 2)
  {
    /* line j + 0 */
    for (i = 0; i < width; i += 4)
    {
      u = *pu++;
      v = *pv++;
      c11 = g_crv_tab[v];
      c21 = g_cgu_tab[u];
      c31 = g_cgv_tab[v];
      c41 = g_cbu_tab[u];
      u = *pu++;
      v = *pv++;
      c12 = g_crv_tab[v];
      c22 = g_cgu_tab[u];
      c32 = g_cgv_tab[v];
      c42 = g_cbu_tab[u];

      y11 = g_tab_76309[*py1++];  /* (255/219)*65536 */
      y12 = g_tab_76309[*py1++];
      y13 = g_tab_76309[*py1++];  /* (255/219)*65536 */
      y14 = g_tab_76309[*py1++];

      y21 = g_tab_76309[*py2++];
      y22 = g_tab_76309[*py2++];
      y23 = g_tab_76309[*py2++];
      y24 = g_tab_76309[*py2++];

      /* RGBR */
      DW = ((g_clp[(y11 + c41) >> 16])) |
        ((g_clp[(y11 - c21 - c31) >> 16]) << 8) |
        ((g_clp[(y11 + c11) >> 16]) << 16) |
        ((g_clp[(y12 + c41) >> 16]) << 24);
      *id1++ = DW;

      /* GBRG */
      DW = ((g_clp[(y12 - c21 - c31) >> 16])) |
        ((g_clp[(y12 + c11) >> 16]) << 8) |
        ((g_clp[(y13 + c42) >> 16]) << 16) |
        ((g_clp[(y13 - c22 - c32) >> 16]) << 24);
      *id1++ = DW;

      /* BRGB */
      DW = ((g_clp[(y13 + c12) >> 16])) |
        ((g_clp[(y14 + c42) >> 16]) << 8) |
        ((g_clp[(y14 - c22 - c32) >> 16]) << 16) |
        ((g_clp[(y14 + c12) >> 16]) << 24);
      *id1++ = DW;

      /* RGBR */
      DW = ((g_clp[(y21 + c41) >> 16])) |
        ((g_clp[(y21 - c21 - c31) >> 16]) << 8) |
        ((g_clp[(y21 + c11) >> 16]) << 16) |
        ((g_clp[(y22 + c41) >> 16]) << 24);
      *id2++ = DW;

      /* GBRG */
      DW = ((g_clp[(y22 - c21 - c31) >> 16])) |
        ((g_clp[(y22 + c11) >> 16]) << 8) |
        ((g_clp[(y23 + c42) >> 16]) << 16) |
        ((g_clp[(y23 - c22 - c32) >> 16]) << 24);
      *id2++ = DW;

      /* BRGB */
      DW = ((g_clp[(y23 + c12) >> 16])) |
        ((g_clp[(y24 + c42) >> 16]) << 8) |
        ((g_clp[(y24 - c22 - c32) >> 16]) << 16) |
        ((g_clp[(y24 + c12) >> 16]) << 24);
      *id2++ = DW;
    }
    id1 -= (9 * width) >> 2;
    id2 -= (9 * width) >> 2;
    py1 += width;
    py2 += width;
  }
}

IMAGEPROCAPI void DeltYUV(
  unsigned char* lpInY, unsigned char* lpInU, unsigned char* lpInV, 
  const long* linesize,
  const long width, const long height,
  unsigned char* lpOutY, unsigned char* lpOutU, unsigned char* lpOutV)
{
  unsigned char* ptrTmp = (unsigned char*)(void*)lpInY;
  int startindex = 0;

  int halfwidth = width>>1;
  int halfheight = height>>1;
  for (int i = 0; i <  height; i++)
  {
    memcpy(lpOutY + startindex, ptrTmp,  width);
    ptrTmp += linesize[0];
    startindex +=  width;
  }
  ptrTmp = (unsigned char*)(void*)lpInU;
  startindex = 0;
  for (int i = 0; i <  halfheight; i++)
  {
    memcpy(lpOutU + startindex, ptrTmp,  halfwidth);
    ptrTmp += linesize[1];
    startindex +=  halfwidth;
  }
  ptrTmp = (unsigned char*)(void*)lpInV;
  startindex = 0;
  for (int i = 0; i <  halfheight; i++)
  {
    memcpy(lpOutV + startindex, ptrTmp,  halfwidth);
    ptrTmp += linesize[2];
    startindex +=  halfwidth;
  }
}

IMAGEPROCAPI void ConvertRGB24toRGB32(unsigned char* rgb24Buffer, 
  const long width, const long height, unsigned char* rgb32Buffer){
    unsigned char* pSrcPoint = rgb24Buffer;
    long mult32width = width/32 + ((width%32>0)?1:0);
    mult32width *= 32;
    unsigned char* pDstPoint = rgb32Buffer + ((mult32width*(height-1))<<2);//һпʼд
    //    ת
    //    unsigned char* pDstPoint = rgb32Buffer;
    //     for (long index=0; index< width * height; ++index)
    //     {
    //       *(pDstPoint++) = *(pSrcPoint++);
    //       *(pDstPoint++) = *(pSrcPoint++);
    //       *(pDstPoint++) = *(pSrcPoint++);
    //       pDstPoint++;
    //     }

    //    ת
    //    unsigned char* pDstPoint = rgb32Buffer+(width*(height-1))<<2;
    //     for (long j=0; j< height; ++j)
    //     {
    //       for (long i=0; i< width; ++i)
    //       {
    //         *(pDstPoint++) = *(pSrcPoint++);
    //         *(pDstPoint++) = *(pSrcPoint++);
    //         *(pDstPoint++) = *(pSrcPoint++);
    //         pDstPoint++;
    //       }
    //       pDstPoint -= (width<<3);//ÿص2
    //     }

    //    ת, 32Ϊ
    for (long j=0; j< height; ++j)
    {
      unsigned char* pPreDstPoint = pDstPoint;
      for (long i=0; i< width; ++i)
      {
        *(pDstPoint++) = *(pSrcPoint++);
        *(pDstPoint++) = *(pSrcPoint++);
        *(pDstPoint++) = *(pSrcPoint++);
        pDstPoint++;
      }
      pDstPoint = pPreDstPoint - (mult32width<<2);//ÿص1
    }
}

