﻿using System;
using System.Collections.Generic;
using System.Text;
using HUS.Controls.TabDock;
using System.Drawing;

namespace HUS.Controls.TabDock.Customization
{
    public class Extender
    {
        public enum Schema
        {
            VS2005,
            Default,
            HUSD4,
        }

        #region Default Schema

        private class DefaultDockPaneStripFactory : DockPanelExtender.IDockPaneStripFactory
        {
            public DockPaneStripBase CreateDockPaneStrip(DockPane pane)
            {
                return new DefaultDockPaneStrip(pane);
            }
        }

        private class DefaultAutoHideStripFactory : DockPanelExtender.IAutoHideStripFactory
        {
            public AutoHideStripBase CreateAutoHideStrip(TabDockPanel panel)
            {
                return new DefaultAutoHideStrip(panel);
            }
        }

        private class DefaultDockPaneCaptionFactory : DockPanelExtender.IDockPaneCaptionFactory
        {
            public DockPaneCaptionBase CreateDockPaneCaption(DockPane pane)
            {
                return new DefaultDockPaneCaption(pane);
            }
        }

        private class DefaultFloatWindowFactory : DockPanelExtender.IFloatWindowFactory
        {
            public FloatWindow CreateFloatWindow(TabDockPanel dockPanel, DockPane pane)
            {
                return new DefaultFloatWindow(dockPanel, pane);
            }

            public FloatWindow CreateFloatWindow(TabDockPanel dockPanel, DockPane pane, Rectangle bounds)
            {
                return new DefaultFloatWindow(dockPanel, pane, bounds);
            }

        }

        #endregion

        #region HUSD4 Schema

        private class HUSD4FloatWindowFactory : DockPanelExtender.IFloatWindowFactory
        {
            public FloatWindow CreateFloatWindow(TabDockPanel dockPanel, DockPane pane)
            {
                return new HUSD4FloatWindow(dockPanel, pane);
            }

            public FloatWindow CreateFloatWindow(TabDockPanel dockPanel, DockPane pane, Rectangle bounds)
            {
                return new HUSD4FloatWindow(dockPanel, pane, bounds);
            }

        }

        private class HUSD4DockPaneCaptionFactory : DockPanelExtender.IDockPaneCaptionFactory
        {
            public DockPaneCaptionBase CreateDockPaneCaption(DockPane pane)
            {
                return new HUSD4DockPaneCaption(pane);
            }
        }

        #endregion

        public static void SetSchema(TabDockPanel dockPanel, Extender.Schema schema)
        {
            if (schema == Extender.Schema.VS2005)
            {
                dockPanel.Extender.AutoHideStripFactory = null;
                dockPanel.Extender.DockPaneCaptionFactory = null;
                dockPanel.Extender.DockPaneStripFactory = null;
            }
            else if (schema == Extender.Schema.Default)
            {
                dockPanel.Extender.DockPaneCaptionFactory = new DefaultDockPaneCaptionFactory();
                dockPanel.Extender.AutoHideStripFactory = new DefaultAutoHideStripFactory();
                dockPanel.Extender.DockPaneStripFactory = new DefaultDockPaneStripFactory();
                dockPanel.Extender.FloatWindowFactory = new DefaultFloatWindowFactory();
            }
            else if (schema == Extender.Schema.HUSD4)
            {
                dockPanel.Extender.DockPaneCaptionFactory = new HUSD4DockPaneCaptionFactory();
                dockPanel.Extender.AutoHideStripFactory = new DefaultAutoHideStripFactory();
                dockPanel.Extender.DockPaneStripFactory = new DefaultDockPaneStripFactory();
                dockPanel.Extender.FloatWindowFactory = new HUSD4FloatWindowFactory();
            }

        }
    }
}
