/************************************************************
Copyright (C), 2007-2009, AVILSI Tech. Co., Ltd.
FileName: lrz.c
Author: Version : Date: Zhengxj v1.0.0 2009-03-26
Description: it's a program for zmodem transfer
Function List:
History:
NO  Date(YYYY-MM-DD)    Author  Modification
1.  2009-03-26          zxj         Create
***********************************************************/

#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <asm/cksim.h>
#include "busybox.h"
#include "usage.h"

#define BB_MEM_UNKNOW   0
#define BB_MEM_READ     1
#define BB_MEM_WRITE    2
#define BB_MEM_DUMPF    3
#define BB_MEM_SYSFUNC  4
#define BB_MEM_PCIREAD  5
#define BB_MEM_PCIWRITE 6

#define BB_MEM_READ_ARGC    4
#define BB_MEM_WRITE_ARGC   5

#define AVI_MEM_DEF_COUNT   ( 0x10 )
#define AVI_MEM_ALIGN_4     ( 0x04 )
#define AVI_MEM_ALIGN_2     ( 0x02 )
#define AVI_MEM_ALIGN_1     ( 0x01 )
#define AVI_MEM_MAKE_4      ( 0xFFFFFFFC )
#define AVI_MEM_MAKE_2      ( 0xFFFFFFFE )

#define AVI_MEM_VIEW_LIST   ( 0 )
#define AVI_MEM_VIEW_BLOCK  ( 1 )


#define AVI_ERR     -1
#define AVI_SUCESS  0

#define BB_MEM_DUMP_TEXT        0
#define BB_MEM_DUMP_BIN         1

#define BB_MEM_DUMP_HELP "mem f address count filename [c(char)s(short)w(dword)] [t(text)b(bin)]"

static unsigned int  MemAlign(unsigned int addr, char align,  unsigned int *fixaddr);

#define CKCOREPLD_BASE		0x30000000
#define PCICFG0_SIZE		0x01000000
#define PCICFG0_BASE		0x00000000

#define DEV1_IDSEL          0x80000000

#define DAHUA_IO(x)		((volatile unsigned long *)(CKCOREPLD_BASE+(x)))
#define PLD_WDMA_DST_ADDR DAHUA_IO(0)
#define PLD_WDMA_SRC_ADDR DAHUA_IO(0x4)
#define PLD_WDMA_CTRL DAHUA_IO(0x8)
#define PLD_RDMA_SRC_ADDR DAHUA_IO(0x20)
#define PLD_RDMA_DST_ADDR DAHUA_IO(0x24)
#define PLD_RDMA_CTRL DAHUA_IO(0x28)
#define PLD_CPU_ISTATUS DAHUA_IO(0x44)

/*Read DMA*/
#define PLD_DMA_INTER_ACK  0x00
#define PLD_DMA_IO_READ  0x20
#define PLD_DMA_MEMORY_READ  0x60
#define PLD_DMA_CONFIG_READ  0xa0
#define PLD_DMA_MEMORY_READ_MUL  0xc0

/*Write DMA*/
#define PLD_DMA_SPCIAL_CYC  0x10
#define PLD_DMA_IO_WRITE  0x30
#define PLD_DMA_MEMORY_WRITE  0x70
#define PLD_DMA_CONFIG_WRITE  0xb0
#define PLD_DMA_START 0x01



/*************************************************
Function: ParseHexUL
Description:ַתʮ,˽к
Input:  *s      ==> ַָ
Output: *number ==> ʮ
Return: תЧλ
History:
*************************************************/
static unsigned char ParseHexUL(const unsigned char *s, int *number)
{
    unsigned char   bits  = 0;
    int             val = 0;

    while ( *s != '\0')
    {
        if ((*s >= '0') && (*s <= '9'))
            val = val * 16 + *s++ - '0';
        else if ((*s >= 'a') && (*s <= 'f'))
            val = val * 16 + *s++ - 'a' + 10;
        else if ((*s >= 'A') && (*s <= 'F'))
            val = val * 16 + *s++ - 'A' + 10;
        else
            break;

        if (++bits >= 8)
            break;      /* 8 Hex bits Max: tU4 Para */
    }

    *number = val;

    return (bits);

}

/*************************************************
Function: avi_CommStr2Int
Description:ַתʮݻʮ,ⲿýӿ
Input:  *str      ==> ַָ
Output: 
Return: ת
*************************************************/
int avi_CommStr2Int(const unsigned char *str)
{
    char * p = (char*)str;
    int number;
    
    if ((p[0] == '0') && (p[1] == 'x'))
    {
        p += 2;
        ParseHexUL(p, &number);
    }
    else
    {
        number = (unsigned int)atoi(p);
    }
    
    return number;
}

/*************************************************
Function: MemRead
Description:  open the watchdog device
Input:
Output:
Return: return AVI_SUCESS or AVI_ERR
*************************************************/
static int MemRead(int argc, unsigned char **argv)
{
    unsigned int tmp, viewtp, aligntp;
    unsigned int *ip;
    unsigned short *sp;
    unsigned char *cp;
    char *str;
    unsigned int i, j, n, k, cnt;
    
    /* check the start address */
    if ( argc <= 0 )
    {
        printf("Please input the start address!\n");
        return AVI_ERR;
    }
    
    /* chech count */
    if ( argc <= 1 )
    {
        /* user don't input the count, use the default */
        cnt = AVI_MEM_DEF_COUNT;
    }
    else
    {
        /* use the input value for count */
        cnt = avi_CommStr2Int(argv[1]);
        if ( 0 == cnt)
        {
            printf("The read count is zero!\n");
            return AVI_ERR;
        }
    }
    
    /* check the align and fix the start address by align */
    tmp = avi_CommStr2Int(argv[0]);
    
    if ( argc >= 3 )
    {
        aligntp = MemAlign( tmp, argv[2][0], &tmp );
    }
    else
    {
        aligntp = MemAlign( tmp, ' ', &tmp );
    }
    
    if ( AVI_MEM_ALIGN_4 == aligntp )
    {
        ip = (unsigned int *)tmp;
    }
    else if ( AVI_MEM_ALIGN_2 == aligntp )
    {
        sp = (unsigned short *)tmp;
    }
    else
    {
        cp = (unsigned char *)tmp;
    }
    
    /* chehk view type , list or bloack, the block is default */
    viewtp = AVI_MEM_VIEW_LIST;
    if (4 == argc)
    {
        if ( 'b' == argv[3][0])
        {
            viewtp = AVI_MEM_VIEW_BLOCK;
        }
    }
    
    printf("\n");
    
    /* printf header */
    if (AVI_MEM_VIEW_LIST == viewtp)
    {
        /* display by list */
        printf("Address       Value\n");
        
        for (i = 0; i < cnt; i++)
        {
            if (AVI_MEM_ALIGN_4 == aligntp)
            {
                printf("[0x%08lx]: ", (unsigned int)(ip));
                printf("0x%08lx\n", *ip++);
            }
            else if (AVI_MEM_ALIGN_2 == aligntp)
            {
                printf("[0x%08lx]: ", (unsigned int)(sp));
                printf("0x%04lx\n", *sp++);
            }
            else
            {
                printf("[0x%08lx]: ", (unsigned int)(cp));
                printf("0x%02lx\n", *cp++);
            }
        }
    }
    else
    {
        /* display by block */
        printf("Address     ");
        if (AVI_MEM_ALIGN_4 == aligntp)
        {
            for (i = 0; i < 4; i++)
            {
                printf("%02lx       ", i * 4);
            }
            tmp = 4;
        }
        else if (AVI_MEM_ALIGN_2 == aligntp)
        {
            for (i = 0; i < 8; i++)
            {
                 printf("%02lx   ", i * 2);               
            }
            tmp = 8;
        }
        else
        {
            for (i = 0; i < 0x10; i++)
            {
                printf("%02lx ", i);                
            }
            tmp = 16;
        }
        printf(" Character\n"); /* printf header end */
        
        /* display memory */
        n = 0;
        for (i = 0; i < cnt; i++)
        {
            if (AVI_MEM_ALIGN_4 == aligntp)
            {
                if (0 == n)
                {
                    printf("0x%08lx: ", (unsigned int)(ip));
                    str = (char *)ip;
                }
                printf("%08lx ", *ip++);
            }
            else if (AVI_MEM_ALIGN_2 == aligntp)
            {
                if (0 == n)
                {
                    printf("0x%08lx: ", (unsigned int)(sp));
                    str = (char *)sp;
                }
                printf("%04lx ", *sp++);
            }
            else
            {
                if (0 == n)
                {
                    printf("0x%08lx: ", (unsigned int)(cp));
                    str = (char *)cp;
                }
                printf("%02lx ", *cp++);
            }
            
            n++; 
            
            /* display the current line as character */
            if ( (tmp == n) || ( (cnt - 1) == i ) )
            {
                /* align */
                if (tmp != n)
                {
                    if (AVI_MEM_ALIGN_4 == aligntp)
                    {
                        k = ( tmp - n ) * ( AVI_MEM_ALIGN_4 * 2 + 1 );
                    }
                    else if (AVI_MEM_ALIGN_2 == aligntp)
                    {
                        k = ( tmp - n ) * ( AVI_MEM_ALIGN_2 * 2 + 1 );
                    }
                    else
                    {
                        k = ( tmp - n ) * ( AVI_MEM_ALIGN_1 * 2 + 1 );
                    }
                    
                    for (j = 0; j < k; j++)
                    {
                        printf(" ");
                    }
                }
                
                /* printf character */
                for (j = 0; j < (n * aligntp); j++)
                {
                    if ( (*str < 0x20) || (*str > 0x7e) )
                    {
                        printf (".");
                    }
                    else
                    {
                        printf ("%c", *str);
                    }
                    
                    str++;
                }
                
                printf ("\n");
                n = 0;                           
            }
        }
        
    }
    printf ("\n");
    
    return AVI_SUCESS;
}


/*************************************************
Function: MemWrite
Description: 
Input:
Output:
Return: return AVI_SUCESS or AVI_ERR
*************************************************/
static int MemWrite(int argc, unsigned char **argv)
{
    unsigned int tmp, aligntp;
    unsigned int *ip;
    unsigned short *sp;
    unsigned char *cp;
    unsigned int i, cnt;
    
    /* check the start address */
    if ( argc <= 0)
    {
        printf("Please input the start address!\n");
        return AVI_ERR;
    }
    
    /* get data */
    
    
    /* chech count */
    if ( argc < 3)
    {
        /* user don't input the count, use the default */
        cnt = 1;
    }
    else
    {
        /* use the input value for count */
        cnt = avi_CommStr2Int(argv[2]);
        if ( 0 == cnt)
        {
            printf("The write count is zero!\n");
            return AVI_ERR;
        }
    }
    
    /* check the align and fix the start address by align */
    tmp = avi_CommStr2Int(argv[0]);
    
    if ( argc >= 4 )
    {
        aligntp = MemAlign( tmp, argv[3][0], &tmp );
    }
    else
    {
        aligntp = MemAlign( tmp, ' ', &tmp );
    }
    
    if ( AVI_MEM_ALIGN_4 == aligntp )
    {
        ip = (unsigned int *)tmp;
    }
    else if ( AVI_MEM_ALIGN_2 == aligntp )
    {
        sp = (unsigned short *)tmp;
    }
    else
    {
        cp = (unsigned char *)tmp;
    }
    
    tmp = avi_CommStr2Int(argv[1]);
        
    for (i = 0; i < cnt; i++)
    {
        if (AVI_MEM_ALIGN_4 == aligntp)
        {
            *ip++ = (unsigned int)tmp;
        }
        else if (AVI_MEM_ALIGN_2 == aligntp)
        {
            *sp++ = (unsigned short)tmp;
        }
        else
        {
            *cp++ = (unsigned char)tmp;
        }
    }
    
    return AVI_SUCESS;
}

static unsigned int  MemAlign(unsigned int addr, char align,  unsigned int *fixaddr)
{
    unsigned int tmp, aligntp;
    
    tmp = addr;
    
    switch ( align )
    {
    case 'w':
        {
            tmp = tmp & ( AVI_MEM_MAKE_4 );
            aligntp = AVI_MEM_ALIGN_4;
            break;
        }
    case 's':
        {
            tmp = tmp & ( AVI_MEM_MAKE_2 );
            aligntp = AVI_MEM_ALIGN_2;
            break;
        }
    case 'c':
        {
            aligntp = AVI_MEM_ALIGN_1;
            break;           
        }
    default:
        {
            /* unset align auto detect */
            aligntp = tmp & 0x03;
            
            if ( 0x00 == aligntp )
            {
                aligntp = AVI_MEM_ALIGN_4;
            }
            else if ( 0x02 == aligntp )
            {
                aligntp = AVI_MEM_ALIGN_2;
            }
            else
            {
                aligntp = AVI_MEM_ALIGN_1;
            }
            
            break;
        }
    }
    
    *fixaddr = tmp;
    
    //printf("fixaddr = %#x, aligntp = %d\n", tmp, aligntp);
    
    return aligntp;
}

static void MemDump(int argc, unsigned char **argv)
{
    unsigned int tmp, addr, viewtp, aligntp;
    unsigned int i, j, cnt;
    unsigned char *p;
    FILE *fd;
    
    /* check the start address */
    if ( argc < 3 )
    {
        printf("%s\n", BB_MEM_DUMP_HELP);
        return;
    }
    
    /* check count */
    cnt = avi_CommStr2Int(argv[1]);
    if ( 0 == cnt)
    {
        printf("The read count is zero!\n");
        return;
    }
    
    /* check the align and fix the start address by align */
    addr = avi_CommStr2Int(argv[0]);
    
    if (  argc >= 4 )
    {
        aligntp = MemAlign( addr, argv[3][0], &addr );
    }
    else
    {
        aligntp = MemAlign( addr, ' ', &addr );
    }
    
    viewtp = BB_MEM_DUMP_TEXT;
    
    if ( argc >= 5 )
    {
        if ( 'b' == argv[4][0] )
        {
            viewtp = BB_MEM_DUMP_BIN;
        }
    }
    
    /* open the file */
    if ((fd = fopen(argv[2], "wb")) == NULL)
    {
        printf(("Open file [%s] fail!\n", argv[2]));
        return ;
    }
    
    if ( BB_MEM_DUMP_TEXT == viewtp )
    {
        fprintf(fd, "Read from : addr = %#x count = %d\r\n", addr, cnt);
        //printf("Read from : addr = %#x count = %d\r\n", addr, cnt);
    }
    
    for (i = 0; i < cnt; i++)
    {
        if (AVI_MEM_ALIGN_4 == aligntp)
        {
            tmp = *(unsigned int *)(addr);
        }
        else if (AVI_MEM_ALIGN_2 == aligntp)
        {
            tmp = *(unsigned short *)(addr);            
        }
        else
        {
            tmp = *(unsigned char *)(addr);
        }
        
        if ( BB_MEM_DUMP_TEXT == viewtp )
        {
            fprintf(fd, "[%#x] = %#-12x (%d)\r\n", addr, tmp, tmp);
            //printf("[%#x] = %#x\r\n", addr, tmp);
        }
        else
        {
            p = &tmp;
            
            for ( j = 0; j < aligntp; j++ )
            {
                fprintf(fd, "%c", *p++);
            }
            
        }
        
        addr += aligntp;
        
    }
    
    if ( BB_MEM_DUMP_TEXT == viewtp )
    {
        fprintf(fd, "done.\r\n");
        //printf("done.\r\n");
    }

    fclose(fd);

    return ;    
}


static void configure_read( unsigned int devfn, int where )
{
    unsigned long addr = 0;
    unsigned long st = 0;
    int i;
    unsigned int value;
    unsigned int *value_test;
    
	
    if ( 0 == devfn )
    {  
        value = (*((unsigned long *)(CKCOREPLD_BASE + where)));
    }
    else 
    {
        devfn -= 1 << 3;
        
        value_test = ( unsigned int * )0xC3000000;

        memset( value_test, 0, 20 );

        addr = PCICFG0_BASE  | ( devfn << 8 );

        *PLD_RDMA_SRC_ADDR = (((unsigned long)addr + ((where) &(~0x03))) | (DEV1_IDSEL>>(devfn>>3)));
        *PLD_RDMA_DST_ADDR = (value_test);
        *PLD_RDMA_CTRL = ((0x10 << 8) |PLD_DMA_CONFIG_READ);
        *PLD_RDMA_CTRL |= (PLD_DMA_START);
        
        while ((*PLD_RDMA_CTRL) & PLD_DMA_START)
        {
            //BPRINTK("Before and control %x Read from %x to %x  dev %x \n", (*PLD_RDMA_CTRL), (*PLD_RDMA_SRC_ADDR), (*PLD_RDMA_DST_ADDR), addr);         
        };
        
        if ((*PLD_CPU_ISTATUS) & 0x0200)
        {
            //I set the value for dma error cause unknow data in
            printf("pci dma error\n");
        }

        *PLD_CPU_ISTATUS &= (0x0300);//bit 1 clear the bit, refer to datasheet

        value = (*((unsigned long *)(((unsigned long)value_test) + ( where & 0x03))));
    }
    
    printf("PCI READ: devfn = %#x, where = %#x, value = %#x\n", devfn, where, value );
    
}


static void configure_write( unsigned int devfn, int where, unsigned int value)
{
	unsigned long addr = 0;
	int i;
	
    if ( 0 == devfn )
    {  
        *((unsigned long *)(CKCOREPLD_BASE + where)) = (*(unsigned long *)value);
    }
	else 
    {
        devfn -= 1 << 3;
        
        addr = PCICFG0_BASE  | (devfn << 8);
        
        *PLD_WDMA_DST_ADDR = (((unsigned long)addr + ((where))) | (DEV1_IDSEL>>(devfn>>3)));
        *PLD_WDMA_SRC_ADDR = (value);//((unsigned long)value_test + 0x03)&(~0x03);
        *PLD_WDMA_CTRL =  (( 4 << 8) |PLD_DMA_CONFIG_WRITE);
        *PLD_WDMA_CTRL |= (PLD_DMA_START);
        while ((*PLD_WDMA_CTRL) & PLD_DMA_START)
        {
        };//wait until the start bit cleared
        
        if ((*PLD_CPU_ISTATUS) & 0x02)
        {
            printf("pci dma error\n");
        }
        
        *PLD_CPU_ISTATUS &= (0x03);//bit 1 clear the bit, refer to datasheet               
    }
		
    printf("PCI WRTIE: devfn = %#x, where = %#x, value = %#x\n", devfn, where, value );

}

int mem_main(int argc, char **argv)
{
    unsigned int ops;
    
    /* check the argv */
    ops = BB_MEM_UNKNOW;
    
    if ( argc < 2 )
    {
        printf("%s\n", mem_full_usage );
        return EXIT_SUCCESS;
    }
    
    if ( 'r' == argv[1][0] )
    {
        ops = BB_MEM_READ;
    }
    else if ( 'w' == argv[1][0] )
    {
        ops = BB_MEM_WRITE;
    }
    else if ( 'f' == argv[1][0] )
    {
        ops = BB_MEM_DUMPF;
    }
    else if ( 's' == argv[1][0] )
    {
        ops = BB_MEM_SYSFUNC;
    }
    else if ( 'p' == argv[1][0] )
    {
        if ( 'w' == argv[1][1] )
        {
            ops = BB_MEM_PCIWRITE;
        }
        else
        {
            ops = BB_MEM_PCIREAD;
        }
    }
    else
    {
        return 0;
    }
    
    argc -= 2;
    argv += 2;
    
    /* do for read or write */
    switch ( ops )
    {
        case BB_MEM_READ:
            {
                MemRead(argc, argv);
                break;
            }
        case BB_MEM_WRITE:
            {
                MemWrite(argc, argv);
                break;
            }
        case BB_MEM_DUMPF:
            {
                MemDump(argc, argv);
                break;
            }
        case BB_MEM_SYSFUNC:
            {
                ops = avi_CommStr2Int( argv[ 0 ] );
                printf("call sys_fun ops = %#x\n", ops);
                sysfun( ops, NULL );
                break;
            }
        case BB_MEM_PCIREAD:
            {
                unsigned int devfn, where;
                
                devfn = avi_CommStr2Int( argv[ 0 ] );
                where = avi_CommStr2Int( argv[ 1 ] );
                
                configure_read( devfn, where );
                break;
            }
        case BB_MEM_PCIWRITE:
            {
                unsigned int devfn, where, value;
                
                devfn = avi_CommStr2Int( argv[ 0 ] );
                where = avi_CommStr2Int( argv[ 1 ] );
                value = avi_CommStr2Int( argv[ 2 ] );
                
                              
                configure_write( devfn, where, value );
                break;
            }
        default:
            {
                /* printf the help */
                printf("\nmem r address count [c(char)s(short)w(dword)] [b(block)l(list)]\n");
                printf("mem w address value [count] [c(char)s(short)w(dword)] [b(block)l(list)]\n");
                printf("%s\n\n", BB_MEM_DUMP_HELP);
                break;
            }
    }
    
    return EXIT_SUCCESS;
}

