/* vi: set sw=4 ts=4: */
/*
 * $Id: ping.c,v 1.56 2004/03/15 08:28:48 andersen Exp $
 * Mini ping implementation for busybox
 *
 * Copyright (C) 1999 by Randolph Chung <tausq@debian.org>
 *
 * Adapted from the ping in netkit-base 0.10:
 * Copyright (c) 1989 The Regents of the University of California.
 * Derived from software contributed to Berkeley by Mike Muuss.
 *
 * Licensed under GPLv2 or later, see file LICENSE in this tarball for details.
 */

#include <stdio.h>
#include <stdlib.h>
#include <linux/i2c.h>
#include <linux/i2c-dev.h>
#include <asm/cksim.h>
#include "busybox.h"
#include "usage.h"

#include "spi.h"
#include "spi_flash_atmel.h"

extern int avi_CommStr2Int(const unsigned char *str);

unsigned int spi_inited = 0;

#define BB_SPI_MODE_BYTE    0
#define BB_SPI_MODE_PKT     1


#define BB_SPI_UNKNOW   0
#define BB_SPI_READ     1
#define BB_SPI_WRITE    2

#define BB_SPI_READ_ARGC    4
#define BB_SPI_WRITE_ARGC   5


unsigned int spi_mode;





#define PHMSG(fmt, args...) printf(fmt, ## args)


/*		$Function		:	void spi_initialize()
==	================================================================================
==		Description		:	initialize the spi Interface that access sd card
==		Argument			:	NULL
==		Return			:	NULL
==		Modification	:	2007-12-11	wangdx Create
==	================================================================================
*/
void spi_initialize( unsigned int uiMode )
{
	unsigned int modecfg = 0;
	int bits = 0x7,	clock_delay_times = 10,cpha = 0,cpol = 0,lsb = 0,pck_mod = SPI_PCK_MOD, hold_en = 0;
	int flash_mod = 1,tx_delay = 1,rx_delay = 1,reset = 1;
	int isr_enable = 0,txdffi_level = 0x10,rxdffi_level = 0x10,copmleteie = 1;
	int trans_cnt = 0;
	int baud = 0x02;
	int started = 0,cr_cs = 0xe,reg_ff_st_en = 0,reg_crc_en = 0,reg_bmult = 0,direction = 0;
	
	//if(  )

       //SPI_BDR = baud;
	modecfg = (bits << 24) +
				(clock_delay_times << 16) +
				(rx_delay << 15) +
				(cpha << 14) +
				(cpol << 13) +
				(lsb << 12) +
				(pck_mod << 10) +
				(hold_en << 9) +
				(flash_mod << 8)+
				(tx_delay << 1) + 1;
	SPI_MDR = modecfg;
	SPI_IQR = (txdffi_level <<16) + (rxdffi_level << 8) + (copmleteie << 2);
	SPI_TCR = trans_cnt;
	SPI_BDR = baud;
	SPI_CTR = (reg_ff_st_en << 26) +
			  (reg_crc_en << 25) +
			  (reg_bmult << 24) +
			  (cr_cs << 8) + (direction << 1) + (started); 
    
}


static int spi_sendbytes( unsigned int *tbuf, unsigned int cmdcnt, unsigned int tcnt )
{
	unsigned int *p;
	unsigned int i,  tmp, cnt;
	
	p = tbuf;
	cnt = ( cmdcnt + tcnt ) >> 2;
	if  ( ( cmdcnt + tcnt ) % 0x04 ) 
    {
        cnt ++;
    }
	
    for ( i = 0; i < cnt; i ++ )
    {
        SPI_SDR = *p++;
    }
    
    SPI_TCR = tcnt - 1 ;
    
    
    tmp = SPI_CTR;
    //PHMSG("tmp => %#x\n", tmp);
    tmp &= AVI_SPI_CMDLEN_MASK;
    tmp |= ( ( ( cmdcnt - 1 ) << 16 ) + 0x3 );;
    
    //PHMSG("tmp <=> %#x\n", tmp);
    
	SPI_CTR = tmp;
	

   
	while (((SPI_STR >> 16) & 0x0f) != INT_GEN)
	{
	    //PHMSG("SPI_STR = %#x, SPI_CTR = %#x, SPI_TCR = %#x\n",  SPI_STR, SPI_CTR, SPI_TCR);
	}
	
	SPI_STR |= (1UL << 20);
	
	return cnt;
}

static int spi_readbytes( unsigned int *rbuf, unsigned int cmdcnt, unsigned int rcnt )
{
    unsigned int i, tmp, cnt;
	unsigned int *p;

	p = rbuf;
	
	cnt = cmdcnt >> 2;
	if ( cmdcnt % 0x04 )
    {
        cnt ++;
    }
    
    //PHMSG("cmdcnt = %#x, rcnt = %#x, cnt = %#x\n",  cmdcnt, rcnt, cnt);
	    
	
	/* send the command to the fifo */
	for ( i = 0 ; i < cnt; i ++ )
	{
	    SPI_SDR = *p ++;
	    //SPI_SDR = *p ++;
	}
	
	SPI_TCR = ( rcnt - 1 );
	
	//PHMSG("SPI_TCR = %#x, ( rcnt - 1 ) = %#x\n",  SPI_TCR, ( rcnt - 1 ));
	
    tmp = SPI_CTR;
    tmp &= AVI_SPI_CMDLEN_MASK;
	//tmp &= (~(1UL << 1));   //direction = 0,trigger = 1		
	tmp |= ( cmdcnt - 1 ) << 16;
	tmp |= 1UL;
	
	//PHMSG("SPI_STR = %#x, SPI_CTR = %#x, SPI_MDR = %#x\n",  SPI_STR, tmp, SPI_MDR);
	
	SPI_CTR = tmp;
	
    p = rbuf;
    
    cnt = rcnt >> 2;
	if (  rcnt % 0x04  )
    {
        cnt ++;
    }
    
    //PHMSG("cmdcnt = %#x, rcnt = %#x, cnt = %#x\n",  cmdcnt, rcnt, cnt);

	while (((SPI_STR >> 16) & 0x0f) != INT_GEN)
	{
	    //PHMSG("SPI_STR = %#x\n",  SPI_STR);
	}
      
      
      
    for ( i = 0 ; i < cnt; i ++ )
    {
        *p ++ = SPI_RDR;
    }
    
    	SPI_STR |= (1UL << 20);
   


	return rcnt;
}

static  unsigned int spi_block_erase( unsigned int  startaddr, unsigned int endaddr )
{
    unsigned int s_block, e_block, i, bcnt, buf;
    
    /* calc the bloack count */
    s_block = startaddr & ( ~SPI_BLOCK_MASK );
    e_block = endaddr & ( ~SPI_BLOCK_MASK );
    
    bcnt = ( ( e_block - s_block ) / SPI_BLOCK_SIZE ) + 1;
    
    /* loop to erase the blocks */
    for ( i = 0 ; i < bcnt; i ++ )
    {
        //PHMSG("Block Erase => %#x\n", s_block );
        
        buf = SPI_CMD_WRITE_EN << 24;
        buf |= SPI_CMD_WRITE_EN << 16;
        spi_sendbytes( &buf, 1, 1 );
            
            
        buf = SPI_CMD_4KBLOCKE << 24;
        buf |= s_block;
            
        spi_sendbytes( &buf, 1, 3 );
        
        /* check status */
        while( 1 )
        {
            buf = SPI_CMD_STATUS_READ << 24;
            spi_readbytes( &buf, 1, 4 );
            
            if ( 0 == ( buf & 0x100 ) )
            {
                break;
            }
        }
        
        s_block += SPI_BLOCK_SIZE;
        
    }
    
    return bcnt;
    
}

static  unsigned int spi_sector_erase ( unsigned int  startaddr, unsigned int endaddr )
{
    
}

static unsigned int spi_sector_protect( unsigned int cmd, unsigned int  startaddr, unsigned int endaddr )
{
    unsigned int s_sect, e_sect, i, scnt, buf;
    
    if ( ( SPI_CMD_UNPROTECT_SEC != cmd ) && ( SPI_CMD_PROTECT_SEC != cmd ) )
    {
        return 0;
    }
    
    //PHMSG("startaddr = %#x, endaddr = %#x\n", startaddr, endaddr );
    
    /* calc the bloack count */
    s_sect = startaddr & ( ~SPI_SECTOR_MASK );
    e_sect = endaddr & ( ~SPI_SECTOR_MASK );
    
    //PHMSG("s_sect = %#x, e_sect = %#x\n", s_sect, e_sect );
    
    scnt = ( ( e_sect - s_sect ) / SPI_SECT_SIZE ) + 1;
    
    //PHMSG("scnt = %#x\n", scnt );
    
    /* loop to do */
    for ( i = 0 ; i < scnt; i ++ )
    {
        //PHMSG("Sector[%#x] => %#x\n", cmd, s_sect );
        
        /* check status */
        /*
        while( 1 )
        {
            buf[ 0 ] = SPI_CMD_STATUS_READ;
            spi_readbytes( &buf, 1, 4 );
            
            if ( 0 == ( buf[ 2 ] & 0x01 ) )
            {
                break;
            }
        }
        */
        buf = SPI_CMD_WRITE_EN << 24;
        buf |= SPI_CMD_WRITE_EN << 16;
        spi_sendbytes( &buf, 1, 1 );
        
        
        buf = cmd << 24;
        buf |= s_sect;
        spi_sendbytes( &buf, 1, 3 );
        
        s_sect += SPI_SECT_SIZE;
        
        //PHMSG("Sector[%#x] => %#x end\n", cmd, s_sect );
    
    }
    
    return scnt;    
}

static unsigned int spi_page_write( unsigned int addr, unsigned int *tbuf, unsigned int count )
{
    unsigned int cnt, i, tmp, tmpcnt, address;
    unsigned int *p;
    unsigned int buf[ 32 ];
    
     
    /* check addr */
    if ( addr & SPI_PAGE_MASK  )
    {
        return 0;
    }
    
    /* write */
    address = addr;
    p = tbuf;
    cnt = count;
    
    //PHMSG("Write to %#x, cnt = %#x\n", address, cnt );
    
    while ( 1 )
    {
        if ( 0 == cnt )
        {
            break;
        }
        
        if ( cnt > SPI_MAX_TXPK ) 
        {
            tmpcnt = SPI_MAX_TXPK;
        }
        else
        {
            tmpcnt = cnt;
        }
        
        cnt -= tmpcnt;
        
        tmp = tmpcnt >> 2;
        if ( ( tmpcnt % 0x04 ) )
        {
            tmp ++;
        }
        
        //PHMSG("wd\n");
        
        for ( i = 0 ; i < tmp; i ++ )
        {
            buf[ i + 1 ] = *p++;
            //PHMSG("%08x ", buf[ i + 1 ] );
        }
        
        //PHMSG("\nwdone..\n");
        
        /* busy ?*/
        while( 1 )
        {
            buf[ 0 ] = SPI_CMD_STATUS_READ << 24;
            spi_readbytes( &buf, 1, 4 );
            
            if ( 0 == ( buf[ 0 ] & 0x100 ) )
            {
                break;
            }
        }
        
        
        /* write the SPI_MAX_PK bytes to the flash */
        buf[ 0 ] = SPI_CMD_WRITE_EN << 24 ;
        buf[ 0 ] |= SPI_CMD_WRITE_EN << 16;
        spi_sendbytes( &buf, 1, 1 );
        
        //PHMSG("Write to %#x, tmpcnt = %#x\n", address, tmpcnt );
        
        buf[ 0 ] = address & 0xFFFFFF;
        buf[ 0 ] |= SPI_CMD_BYTE_PROG << 24;
        
        
        //PHMSG("Write to %#x, tmpcnt = %#x\n", buf[ 0 ], tmpcnt );
        spi_sendbytes( &buf, 4, tmpcnt );
        
        address += tmpcnt;
        
        //break;
        
    }
    
    return count;
    
}




int spi_main(int argc, char **argv)
{
    unsigned int ops;
    int dev_addr, addr,cnt;
    char tmp;
    char rbuf[16];
    
    /* check initialize */
    if (  0 == spi_inited )
    {
        spi_inited = 1;
        spi_initialize();
        
    }
    
    /* check the argv */
    ops = BB_IIC_UNKNOW;
    i2c_handle = NULL;
    if ( argc > 1 )
    {
        if ( 'r' == argv[1][0] )
        {
            ops = BB_IIC_READ;
        }
        else if ( 'w' == argv[1][0] )
        {
            ops = BB_IIC_WRITE;
        }
    }
    
    /* do for read or write */
    switch ( ops )
    {
        case BB_IIC_READ:
            {
                if ( argc < BB_IIC_READ_ARGC  )
                {
                    printf(i2c_trivial_usage);
                }
                else
                {
                    i2c_handle = Open_I2CDevice();
                    if ( NULL == i2c_handle )
                    {
                        printf("i2c device open failed!\n" );
                        goto _i2c_out;
                    }
                    
                    dev_addr = avi_CommStr2Int( argv[2] );
                    addr = avi_CommStr2Int( argv[3] );
                    cnt = 0;
                    
                    if ( argc > 4 )
                    {
                    	cnt = avi_CommStr2Int( argv[4] );
                    }
                    
					if ( cnt > 16 )
                	{
                		cnt = 16;
                	}
                	else if ( 0 == cnt )
                	{
                		cnt = 1;
                	}
                
                    I2CRead( dev_addr, addr, rbuf,  cnt);
                    
                    for ( tmp = 0; tmp < cnt; tmp ++ )
                    {
                    	printf( "I2CR[%#x]->[%#x] = %#x\n", dev_addr, addr + tmp, rbuf[tmp] );
                    }
                    
                }
                break;
            }
        case BB_IIC_WRITE:
            {
                if ( BB_IIC_WRITE_ARGC != argc )
                {
                    printf(i2c_trivial_usage);
                }
                else
                {
                    i2c_handle = Open_I2CDevice();
                    if ( NULL == i2c_handle )
                    {
                        printf("i2c device open failed!\n" );
                        goto _i2c_out;
                    }
                    
                    dev_addr = avi_CommStr2Int( argv[2] );
                    addr = avi_CommStr2Int( argv[3] );
                    tmp = avi_CommStr2Int( argv[4] );
                    
                    I2CWrite( dev_addr, addr, tmp );
                    printf( "I2CW[%#x]->[%#x] = %#x\n", dev_addr, addr, tmp );
                }
                break;
            }
        default:
            {
                printf("i2c unsupport this command[%s]\n", argv[1] );
                goto _i2c_out;
            }
    }
    

_i2c_out:
    if ( NULL != i2c_handle )
    {
        close(i2c_handle);
        i2c_handle = NULL;
    }
	return EXIT_SUCCESS;
}


