/*************************************************
Copyright (C), 2007-2011, HANGZHOU AVILSI TECHNOLOGY CO., LTD
File name:  conf.h
Author: Version: Date: xx v1.0.0 2011-06-17
Description: It's a config h for the spi flash of atmel AT25DFxxx
History:
NO  Date(YYYY-MM-DD)    Author  Modification
1.  2011-06-17          xxx     Create
2. ...
*************************************************/

#ifndef __SPI_FLASH_ATMEL_H__
#define __SPI_FLASH_ATMEL_H__


/* SPI Flash command */

/* read command */
#define SPI_CMD_READ            0x03
#define SPI_CMD_READ_2DUMMY     0x1B
#define SPI_CMD_READ_1DUMMY     0x0B

/* erase command */
#define SPI_CMD_4KBLOCKE        0x20
#define SPI_CMD_32KBLOCKE       0x52
#define SPI_CMD_64KBLOCKE       0xD8
#define SPI_CMD_CHIPERASE       0x60
#define SPI_CMD_CHIPERASE_OTH   0xC7


/* program command  */
#define SPI_CMD_BYTE_PROG       0x02
#define SPI_CMD_PAGE_PROG       0x02
#define SPI_CMD_DUAL_BPROG      0xA2
#define SPI_CMD_DUAL_PPROG      0xA2

/* program or erase other operation */
#define SPI_CMD_SUSPEND         0xB0
#define SPI_CMD_RESUME          0xD0

/* protection command */
#define SPI_CMD_WRITE_EN        0x06
#define SPI_CMD_WRITE_DIS       0x04
#define SPI_CMD_PROTECT_SEC     0x36
#define SPI_CMD_UNPROTECT_SEC   0x39
#define SPI_CMD_READ_PROTECT    0x3C

/* security command */
#define SPI_CMD_SECTOR_LOCKD    0x33
#define SPI_CMD_SECTOR_FREEZ    0x34
#define SPI_CMD_SECTOR_READ_ST  0x35
#define SPI_CMD_SECTOR_PROGOTP  0x9B
#define SPI_CMD_SECTOR_READOTP  0x77

/* status register command */
#define SPI_CMD_STATUS_READ     0x05
#define SPI_CMD_STATUS_WRITE_1B 0x01
#define SPI_CMD_STATUS_WRITE_2B 0x31

/* miscellaneous command */
#define SPI_CMD_RESET           0xF0
#define SPI_CMD_READ_ID         0x9F
#define SPI_CMD_DEEP_PWRD       0xB9
#define SPI_CMD_DEEP_RESUME     0xAB



/* Max size of oen packet */
#define SPI_MAX_RDPK            ( 32 * 4 )
#define SPI_MAX_TXPK            ( 31 * 4 )
#define SPI_PAGE_MASK           0xFF
#define SPI_BLOCK_MASK          0xFFF
#define SPI_SECTOR_MASK         0xFFFF

#define SPI_PAGE_SIZE           ( 0x100  )
#define SPI_BLOCK_SIZE          0x1000
#define SPI_SECT_SIZE           0x10000



#endif
