/*
 *  linux/arch/ckcorenommu/kernel/setup.c
 *  
 *  Copyright (C) 2004       Kang Sun <sunk@vlsi.zju.edu.cn>
 *  Copyleft  ()) 2000       James D. Schettine {james@telos-systems.com}
 *  Copyright (C) 1999-2003  Greg Ungerer (gerg@snapgear.com)
 *  Copyright (C) 1998,1999  D. Jeff Dionne <jeff@uClinux.org>
 *  Copyright (C) 1998       Kenneth Albanowski <kjahds@kjahds.com>
 *  Copyright (C) 1995       Hamish Macdonald
 *  Copyright (C) 2000       Lineo Inc. (www.lineo.com) 
 *  Copyright (C) 2001 	     Lineo, Inc. <www.lineo.com>
 *
 */

/*
 * This file handles the architecture-dependent parts of system setup
 */

#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/delay.h>
#include <linux/interrupt.h>
#include <linux/fs.h>
#include <linux/fb.h>
#include <linux/console.h>
#include <linux/genhd.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <linux/major.h>
#include <linux/bootmem.h>
#include <linux/seq_file.h>

#include <asm/setup.h>
#include <asm/irq.h>
#include <asm/machdep.h>

#ifdef CONFIG_BLK_DEV_INITRD
#include <linux/blk.h>
#include <asm/pgtable.h>
#endif

#ifdef CONFIG_BLK_DEV_BLKMEM
	#include <linux/cramfs_fs.h>	//add 2008-11-18 fo cramfs
	unsigned int avilsi_ramfs_start;
#endif

#ifdef CONFIG_CONSOLE
extern struct consw *conswitchp;
#ifdef CONFIG_FRAMEBUFFER
extern struct consw fb_con;
#endif
#endif

unsigned long rom_length;
unsigned long memory_start;
unsigned long memory_end;

struct task_struct *_current_task;

char command_line[512] = "console=ttyS";
char saved_command_line[512];
unsigned char mac_addr[0x08];

struct tag_bootpara bootpara;	//add by lin zhuowei




/* setup some dummy routines */
static void dummy_waitbut(void)
{
}

void (*mach_sched_init) (void (*handler)(int, void *, struct pt_regs *)) = NULL;
void (*mach_tick)( void ) = NULL;
/* machine dependent keyboard functions */
int (*mach_keyb_init) (void) = NULL;
int (*mach_kbdrate) (struct kbd_repeat *) = NULL;
void (*mach_kbd_leds) (unsigned int) = NULL;
/* machine dependent irq functions */
void (*mach_init_IRQ) (void) = NULL;
void (*(*mach_default_handler)[]) (int, void *, struct pt_regs *) = NULL;
int (*mach_request_irq) (unsigned int, void (*)(int, void *, struct pt_regs *),
                         unsigned long, const char *, void *);
void (*mach_free_irq) (unsigned int irq, void *dev_id) = NULL;
void (*mach_enable_irq) (unsigned int) = NULL;
void (*mach_disable_irq) (unsigned int) = NULL;
int (*mach_get_irq_list) (char *) = NULL;
void (*mach_process_int) (int irq, struct pt_regs *fp) = NULL;
void (*mach_trap_init) (void);
/* machine dependent timer functions */
unsigned long (*mach_gettimeoffset) (void) = NULL;
void (*mach_gettod) (int*, int*, int*, int*, int*, int*) = NULL;
int (*mach_hwclk) (int, struct hwclk_time*) = NULL;
int (*mach_set_clock_mmss) (unsigned long) = NULL;
void (*mach_mksound)( unsigned int count, unsigned int ticks ) = NULL;
void (*mach_reset)( void ) = NULL;
void (*waitbut)(void) = dummy_waitbut;
void (*mach_debug_init)(void) = NULL;
void (*mach_halt)( void ) = NULL;
void (*mach_power_off)( void ) = NULL;


#ifdef CONFIG_CK510
	#define CPU "CK510"
	#undef DEBUG
#endif

/* (es) */
/* note: why is this defined here?  the must be a better place to put this */
#if defined( CONFIG_TELOS) || defined( CONFIG_UCDIMM ) || defined( CONFIG_UCSIMM ) || defined(CONFIG_DRAGEN2) || (defined( CONFIG_PILOT ) && defined( CONFIG_M68328 ))
#define CAT_ROMARRAY
#endif
/* (/es) */

extern int _stext, _etext, _sdata, _edata, _sbss, _ebss, _end;
extern unsigned int _ramstart, _ramend, _cmdlinestart,_macaddr, _fsstart;

#if 0
void setup_test(void)
{
	unsigned int ts,te;
	register p, tmp, i;
	
	
	*(volatile unsigned int *)(0x70000040) |= 0x09000000;
	p = (unsigned int *)(0xC0700000);
	
	ts = *(volatile unsigned int *)(0x7000007C);
	
	printk("1ts = %#x\n", ts);
	
	ts = *(volatile unsigned int *)(0x7000007C);
	
	printk("2ts = %#x\n", ts);
	
	ts = *(volatile unsigned int *)(0x7000007C);
	
	
	__asm__ __volatile__	
	(		
		"lrw %2, 0x100000\n"		
		//"movi %0, 0x55\n"		
		"ldb %0,(%1,0)\n"		
		"addi %1,1\n"		
		"subi %2,1\n"		
		"cmpnei %2,0\n"		
		"bt .-8\n"		
		: "=r" (tmp),"=r" (p),"=r" (i)		
		: "0"(tmp),"1"(p),"2"(i)	
	);
	
	te = *(volatile unsigned int *)(0x7000007C);
	
	printk("ts = %#x, te = %#x\n", ts, te);
	
}
#endif

void setup_arch(char **cmdline_p)
{
	int bootmap_size;
	char tmp[8];
	char *p;
	int i, j;
	
#ifdef CONFIG_BLK_DEV_BLKMEM
	unsigned int dev_magic, dev_len;
#endif

#if defined(CAT_ROMARRAY) && defined(DEBUG)
	extern int __data_rom_start;
	extern int __data_start;
	int *romarray = (int *)((int) &__data_rom_start +
			      (int)&_edata - (int)&__data_start);
#endif

#if defined(CONFIG_CHR_DEV_FLASH) || defined(CONFIG_BLK_DEV_FLASH)
	/* we need to initialize the Flashrom device here since we might
	 * do things with flash early on in the boot
	 */
	flash_probe();
#endif

	#if 0
	setup_test();
	#endif

#ifdef CONFIG_BLK_DEV_BLKMEM

    avilsi_ramfs_start = _fsstart;
    
    //printk("avilsi_ramfs_start = %#x\n", avilsi_ramfs_start);
#endif

#if 0
#ifdef CONFIG_BLK_DEV_BLKMEM
    #ifndef CONFIG_ROMFS_FROM_ROM
    	#ifdef CONFIG_CAT_FS
    	    
    	    avilsi_ramfs_start = _ramstart + 4;
    	    //	printk("avilsi_ramfs_start = %#x\n", avilsi_ramfs_start);
    	    	
	    	dev_magic = ntohl(*(volatile unsigned int *)( avilsi_ramfs_start ));
	    	
	    	 //	printk("dev_magic = %#x; dev_len = %#x\n", dev_magic, dev_len);
	    	
	        if( CRAMFS_32(CRAMFS_MAGIC) == dev_magic )
	    	{
	    		//it's a cramfs
	    		dev_len = ntohl(*(volatile unsigned int *)(avilsi_ramfs_start + 4 ));
	    		dev_len = le32_to_cpu( dev_len );
	    		dev_len += 4;
	    	}
	    	else
	    	{
	    		//it's a romfs
	    		dev_len = ntohl(*(volatile unsigned int *)( avilsi_ramfs_start + 8 ));
	    		//dev_len = le32_to_cpu( dev_len );
	    		dev_len += 8;
	    	}
    	    
    	    /* add by zxj 2009-05-14 add reload fs by kernel */
    	    #ifdef CONFI_FS_RELOAD
    	        
    	        /* copy the fs to 0xc0020000 */
    	        printk("reload fs now...\n");
    	        memcpy( 0xc0040000, avilsi_ramfs_start, dev_len );
    	        avilsi_ramfs_start = 0xc0040000;
    	           
    	    #else
    	    
    	    	_ramstart += dev_len;
    	    	
    	    #endif
    	    
	    #else
	    	avilsi_ramfs_start = 0xc0040000;
	    #endif
    #endif
#endif

#endif

    avilsi_ramfs_start = 0xc0020000;
    memory_start = PAGE_ALIGN(_ramstart);
	memory_end = _ramend; /* by now the stack is part of the init task */
	
	
	init_mm.start_code = (unsigned long) &_stext;
	init_mm.end_code = (unsigned long) &_etext;
	init_mm.end_data = (unsigned long) &_edata;
	
	
#if 0 /* DAVIDM - don't set brk just incase someone decides to use it */
	init_mm.brk = (unsigned long) &_end;
#else
	init_mm.brk = (unsigned long) 0; 
#endif

	config_BSP(&command_line[0], sizeof(command_line));

	//printk("\r\nuClinux/" CPU "\n");

#ifdef CONFIG_UCDIMM
	printk("uCdimm by Arcturus Networks, Inc. <www.arcturusnetworks.com>\n");
#endif
#ifdef CONFIG_CK510
	//printk("CK510 Core port done \n");
#ifdef CONFIG_DH2004
	//printk("Dahua DH2004 Board \n");
#endif
#endif
	//printk("Flat model support (C) 1998,1999 Kenneth Albanowski, D. Jeff Dionne\n");

#ifdef DEBUG
	printk("KERNEL -> TEXT=0x%06x-0x%06x DATA=0x%06x-0x%06x "
		"BSS=0x%06x-0x%06x\n", (int) &_stext, (int) &_etext,
		(int) &_sdata, (int) &_edata,
		(int) &_sbss, (int) &_ebss);
	printk("KERNEL -> ROMFS=0x%06x-0x%06x MEM=0x%06x-0x%06x "
		"STACK=0x%06x-0x%06x\n",
#ifdef CAT_ROMARRAY
	       (int) romarray, ((int) romarray) + romarray[2],
#else
	       (int) &_ebss, (int) memory_start,
#endif
		(int) memory_start, (int) memory_end,
		(int) memory_end, (int) _ramend);
#endif

#ifdef CONFIG_BLK_DEV_BLKMEM
	ROOT_DEV = BLKMEM_MAJOR;
        ROOT_DEV <<= MINORBITS;
     //   MKDEV(BLKMEM_MAJOR,0); //modified by sunkang to avoid compiler bugs
#endif

	//printk("check bootargs\n");
	
	
		/* fix the kernel run without uboot,
		it's the r4 don't init by uboot and
		the _cmdlinestart value unkonw */
	if ( ( *(unsigned int *)( &_cmdlinestart) >= 0xc0000000 ) &&
			 ( *(unsigned int *)( &_cmdlinestart) <= 0xc4000000) )
	{
		memcpy( tmp, _cmdlinestart, 4 );
		tmp[4] = '\0';
	}
	else
	{
		//printk("&_cmdlinestart = %#x, *_cmdlinestart = %#x\n", &_cmdlinestart, *(unsigned int *)( &_cmdlinestart));
		tmp[0] = '\0';
	}
	
	if( 0 == strcmp(tmp,"daha") )
	{
		*cmdline_p = _cmdlinestart + 4;
		memcpy(mac_addr,(unsigned char *)_macaddr,8);
	}
	else
	{
		//*cmdline_p = "ROOT=/dev/nfs rw nfsroot=10.11.1.84:/nfspool/romfs_zhc CONSOLE=/dev/ttyS0 init=/bin/init ip=10.11.1.156"; 
		//*cmdline_p = "ROOT=/dev/rom0, Rootfstype=romfs,  CONSOLE=/dev/ttyS0 init=/bin/init";

		//*cmdline_p = "ROOT=/dev/rom0, Rootfstype=cramfs,  CONSOLE=/dev/ttyS0 init=/bin/init";
		*cmdline_p = "ROOT=/dev/rom0, Rootfstype=cramfs,  CONSOLE=/dev/ttyS0 init=/bin/init";
		tmp[0] = 0; tmp[1] = 0x56; tmp[2] = 0x00; tmp[3] = 0x80; tmp[4] = 0x00; tmp[5] = 0x00;
		memcpy(mac_addr,(unsigned char *)tmp,8);
	}
	
	/*
	p = ( char *)(0xc1400000);
	
	
	for ( i = 0; i < 0x10; i ++ )
	{
	    printk("\n");
	    for ( j = 0; j < 0x10; j ++ )
	    {
	        printk("%#x ", *p++ );
	    }
	}
	
	printk("\n");
	*/
	
			
      // *cmdline_p = "ROOT=/dev/rom1, Rootfstype=romfs, CONSOLE=/dev/ttyS0"; // added by sunkang
	/* Keep a copy of command line */
       //*cmdline_p = &command_line[0]; //commented by sunkang

    //  *cmdline_p = "ROOT=/dev/mtdblock0, CONSOLE=/dev/ttyS0 init=/bin/init"; // added by tony
  //*cmdline_p = "ROOT=/dev/nfs rw nfsroot=10.11.1.84:/nfspool/romfs_zhc CONSOLE=/dev/ttyS0 init=/bin/init ip=10.11.1.157"; 
	/* Keep a copy of command line */
	//memcpy(saved_command_line, command_line, sizeof(saved_command_line));
	//memcpy(saved_command_line, _cmdlinestart, sizeof(saved_command_line));
	memcpy(saved_command_line, *cmdline_p, sizeof(saved_command_line));
	saved_command_line[sizeof(saved_command_line)-1] = 0;

#ifdef DEBUG
	if (strlen(*cmdline_p)) 
		printk("Command line: '%s'\n", *cmdline_p);
#endif
	/*rom_length = (unsigned long)&_flashend - (unsigned long)&_romvec;*/
	
#ifdef CONFIG_CONSOLE
#ifdef CONFIG_FRAMEBUFFER
	conswitchp = &fb_con;
#else
	conswitchp = 0;
#endif
#endif

	/*
	 * give all the memory to the bootmap allocator,  tell it to put the
	 * boot mem_map at the start of memory
	 */
//	 printk("bdata %x\n", contig_page_data.bdata);
	bootmap_size = init_bootmem_node(
//	bootmap_size = init_bootmem(
			NODE_DATA(0),
			memory_start >> PAGE_SHIFT, /* map goes here */
			PAGE_OFFSET >> PAGE_SHIFT,	/* 0 on coldfire */
			memory_end >> PAGE_SHIFT);
	/*
	 * free the usable memory,  we have to make sure we do not free
	 * the bootmem bitmap so we then reserve it after freeing it :-)
	 */
//	 printk("free bdata %x\n", contig_page_data.bdata);
	free_bootmem(memory_start, memory_end - memory_start);
//	free_bootmem(PAGE_OFFSET, memory_end - PAGE_OFFSET);//zhc modify
	reserve_bootmem(memory_start, bootmap_size);
	/*
	 * get kmalloc into gear
	 */
	paging_init();
	
		//printk("_ebss = %#x; &_ebss = %#x\n",_ebss, &_ebss);
	
#ifdef DEBUG
	//printk("Done setup_arch\n");
#endif
{

    volatile struct tag_bootpara *pmem = (volatile struct tag_bootpara *)(0xc0000000);
    memset(&bootpara,0,sizeof(struct tag_bootpara));
    memcpy(&bootpara,pmem,sizeof(struct tag_bootpara));
    
    
    
}
}

/*
 *	Get CPU information for use by the procfs.
 */

static int show_cpuinfo(struct seq_file *m, void *v)
{
    char *cpu, *mmu, *fpu;
    u_long clockfreq;

    cpu = CPU;
    mmu = "none";
    fpu = "none";

#if defined(CONFIG_COLDFIRE)
    clockfreq = (loops_per_jiffy*HZ)*3;
#elif defined(CONFIG_DRAGONIXVZ)
    clockfreq = (loops_per_jiffy*HZ)*29;
#elif defined(CONFIG_UCDIMM)
    {
      unsigned short p, q;
      unsigned short prot;
      unsigned short sysclk_sel, presc1, presc2;

      p    = PLLFSR & PLLFSR_PC_MASK;
      q    = (PLLFSR & PLLFSR_QC_MASK) >> PLLFSR_QC_SHIFT;
      prot = (PLLFSR & PLLFSR_PROT)? 1 : 0;

      presc1 = (PLLCR & PLLCR_PRESC1) ? 1 : 0;
      presc2 = (PLLCR & PLLCR_PRESC2) ? 1 : 0;
      sysclk_sel = (PLLCR & PLLCR_SYSCLK_SEL_MASK) >> PLLCR_SYSCLK_SEL_SHIFT;

      clockfreq = 2*(14*(p+1) + q+1) * 32768;
      clockfreq = (clockfreq >> presc1) >> presc2;
    }
#else
    clockfreq = (loops_per_jiffy*HZ)*16;
#endif

    seq_printf(m, "CPU:\t\t%s\n"
		   "MMU:\t\t%s\n"
		   "FPU:\t\t%s\n"
		   "Clocking:\t%lu.%1luMHz\n"
		   "BogoMips:\t%lu.%02lu\n"
		   "Calibration:\t%lu loops\n",
		   cpu, mmu, fpu,
		   clockfreq/1000000,(clockfreq/100000)%10,
		   (loops_per_jiffy*HZ)/500000,((loops_per_jiffy*HZ)/5000)%100,
		   (loops_per_jiffy*HZ));

	return 0;
}

static void *c_start(struct seq_file *m, loff_t *pos)
{
	return *pos < NR_CPUS ? ((void *) 0x12345678) : NULL;
}

static void *c_next(struct seq_file *m, void *v, loff_t *pos)
{
	++*pos;
	return c_start(m, pos);
}

static void c_stop(struct seq_file *m, void *v)
{
}

struct seq_operations cpuinfo_op = {
	start:	c_start,
	next:	c_next,
	stop:	c_stop,
	show:	show_cpuinfo,
};

void arch_gettod(int *year, int *mon, int *day, int *hour,
		 int *min, int *sec)
{
	*year = *mon = *day = *hour = *min = *sec = 0;
	if (mach_gettod)
		mach_gettod(year, mon, day, hour, min, sec);
}


