/*
 *  linux/arch/ckcorenommu/kernel/traps.c
 *
 *  Copyright (C) 1993, 1994 by Hamish Macdonald
 *
 *  68040 fixes by Michael Rausch
 *  68040 fixes by Martin Apel
 *  68060 fixes by Roman Hodek
 *  68060 fixes by Jesper Skov
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file COPYING in the main directory of this archive
 * for more details.
 *
 *  Copyright (C) 2004 Kang Sun <sunk@vlsi.zju.edu.cn>
 */

/*
 * Sets up all exception vectors
 */

#include <linux/config.h>
#include <linux/sched.h>
#include <linux/signal.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/types.h>
#include <linux/a.out.h>
#include <linux/user.h>
#include <linux/string.h>
#include <linux/linkage.h>
#include <linux/init.h>

#include <asm/setup.h>
//#include <asm/fpu.h>
#include <asm/system.h>
#include <asm/uaccess.h>
#include <asm/traps.h>
#include <asm/pgtable.h>
#include <asm/machdep.h>
#include <asm/siginfo.h>

/* assembler routines */
asmlinkage void system_call(void);
asmlinkage void buserr(void);
asmlinkage void trap(void);
asmlinkage void inthandler(void);
asmlinkage void nmihandler(void);


e_vector vectors[256] = {
	0, 0, buserr, trap, trap, trap, trap, trap,
	trap, trap, trap, trap, trap, trap, trap, trap,
	trap, trap, trap, trap, trap, trap, trap, trap,
#ifdef CONFIG_COLDFIRE
	inthandler, inthandler, inthandler, inthandler,
	inthandler, inthandler, inthandler, inthandler,
#else
	trap, trap, trap, trap, trap, trap, trap, trap,
#endif     
	/* TRAP #0-15 */
	system_call, trap, trap, trap, trap, trap, trap, trap,
	trap, trap, trap, trap, trap, trap, trap, trap,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};

/* nmi handler for the Amiga */
asm(".text\n"
    __ALIGN_STR "\n"
    SYMBOL_NAME_STR(nmihandler) ": rte");

/*
 * this must be called very early as the kernel might
 * use some instruction that are emulated on the 060
 */
void __init base_trap_init(void)
{

}

void __init trap_init (void)
{
	if (mach_trap_init)
		mach_trap_init();
}



static char *vec_names[] = {
	"RESET SP", "RESET PC", "BUS ERROR", "ADDRESS ERROR",
	"ILLEGAL INSTRUCTION", "ZERO DIVIDE", "CHK", "TRAPcc",
	"PRIVILEGE VIOLATION", "TRACE", "LINE 1010", "LINE 1111",
	"UNASSIGNED RESERVED 12", "COPROCESSOR PROTOCOL VIOLATION",
	"FORMAT ERROR", "UNINITIALIZED INTERRUPT",
	"UNASSIGNED RESERVED 16", "UNASSIGNED RESERVED 17",
	"UNASSIGNED RESERVED 18", "UNASSIGNED RESERVED 19",
	"UNASSIGNED RESERVED 20", "UNASSIGNED RESERVED 21",
	"UNASSIGNED RESERVED 22", "UNASSIGNED RESERVED 23",
	"SPURIOUS INTERRUPT", "LEVEL 1 INT", "LEVEL 2 INT", "LEVEL 3 INT",
	"LEVEL 4 INT", "LEVEL 5 INT", "LEVEL 6 INT", "LEVEL 7 INT",
	"SYSCALL", "TRAP #1", "TRAP #2", "TRAP #3",
	"TRAP #4", "TRAP #5", "TRAP #6", "TRAP #7",
	"TRAP #8", "TRAP #9", "TRAP #10", "TRAP #11",
	"TRAP #12", "TRAP #13", "TRAP #14", "TRAP #15",
	"FPCP BSUN", "FPCP INEXACT", "FPCP DIV BY 0", "FPCP UNDERFLOW",
	"FPCP OPERAND ERROR", "FPCP OVERFLOW", "FPCP SNAN",
	"FPCP UNSUPPORTED OPERATION",
	"MMU CONFIGURATION ERROR"
	};

#ifndef NO_MMU
static char *space_names[] = {
	"Space 0", "User Data", "User Program", "Control",
	"Space 4", "Super Data", "Super Program", "CPU"
	};
#endif /* ! NO_MMU */

void die_if_kernel(char *,struct pt_regs *,int);
asmlinkage int do_page_fault(struct pt_regs *regs, unsigned long address,
                             unsigned long error_code);

asmlinkage void trap_c(int vector, struct frame *fp);



asmlinkage void buserr_c(struct frame *fp)
{
        printk("%s(%d): Bus Error Trap\n", __FILE__, __LINE__);
        dump((struct ptregs *) fp);
	/* Only set esp0 if coming from user mode */
	if (user_mode(&fp->ptregs)){
  		current->thread.esp0 = (unsigned long) fp;
        } else{
                die_if_kernel("Kernel mode BUS error", (struct pt_regs *)fp, 0);
        }

	 send_sig(SIGSEGV, current, 0);
}


int kstack_depth_to_print = 48;

/* MODULE_RANGE is a guess of how much space is likely to be
   vmalloced.  */
#define MODULE_RANGE (8*1024*1024)

static void show_stack(struct frame *fp)
{

        dump(fp);
}
/*
 * The architecture-independent backtrace generator
 */
void dump_stack(void)
{
	show_stack(0);
}

void bad_super_trap (int vector, struct frame *fp)
{
	console_verbose();
	
        printk ("Kernel: Bad trap from supervisor state, vector = %d\n", vector);
        printk ("Current process id is %d\n", current->pid);
        dump((struct pt_regs *)fp);	
        panic("Trap from supervisor state\n");
}

asmlinkage void trap_c(int vector, struct frame *fp)
{
	int sig;
	siginfo_t info;


        printk ("Kernel: trap found from vector = %d\n", vector);
        {
             	long temp;
                	
	        __asm__ __volatile__(       \
	                "mfcr %0, epc"      \
	                : "=r" (temp)          \
	        );
	        
	        printk("PC trap error value : %x and struct %x %x %x %x\n", temp,\
							*(((unsigned long *)(temp&(~0x3))) + 0),\
							*(((unsigned long *)(temp&(~0x3))) + 1),\
							*(((unsigned long *)(temp&(~0x3))) + 2),\
							*(((unsigned long *)(temp&(~0x3))) + 3) \
				  );
       }
	/* send the appropriate signal to the user program */
	switch (vector) {
	    case VEC_ACCESS:
		sig = SIGBUS;
		break;
            case VEC_ZERODIV:
                sig = SIGFPE;
                break;
            case VEC_TRACE:  /* ptrace single step */
                /* fp->ptregs.sr &= ~PS_T */
            case VEC_BREAKPOINT: /* breakpoint */
                sig = SIGTRAP;
                break;
            case VEC_ALIGN: /* breakpoint */
               /* {
                	long temp;
                	
			        __asm__ __volatile__(       \
			                "mfcr %0, epc"      \
			                : "=r" (temp)          \
			        );
			        
			        printk("PC align error value : %x\n", temp);
                }*/
                break;
            case VEC_ILLEGAL: /* breakpoint */
                /*{
                	long temp;
                	
			        __asm__ __volatile__(       \
			                "mfcr %0, epc"      \
			                : "=r" (temp)          \
			        );
			        
			        printk("PC error value : %x\n", temp);
                }*/
                break;
            case VEC_TRAP1:    /* gdb server breakpoint */
                fp->ptregs.pc -= 2;
                sig = SIGTRAP;
                break;
            default:
                sig = SIGILL;
                break;
	}
	send_sig(sig, current, 0);
}

asmlinkage void set_esp0 (unsigned long ssp)
{
	current->thread.esp0 = ssp;
}

void show_trace_task(struct task_struct *tsk)
{
	/* DAVIDM: we can do better, need a proper stack dump */
	//printk("STACK ksp=0x%lx, usp=0x%lx\n", tsk->thread.ksp, tsk->thread.usp);
	printk("STACK ksp=0x%lx, usp=0x%lx, sleep=%d, count=%d, sig=0x%x\n", tsk->thread.ksp, tsk->thread.usp, tsk->sleep_time , tsk->counter\
	, tsk->sigpending);
}

void die_if_kernel (char *str, struct pt_regs *fp, int nr)
{
	if (!(fp->sr & PS_S))
		return;

	console_verbose();
        dump(fp);
	printk("Process %s (pid: %d, stackpage=%08lx)\n",
		current->comm, current->pid, PAGE_SIZE+(unsigned long)current);
	show_stack((struct frame *)fp);
	do_exit(SIGSEGV);
}

