/*
 *  linux/arch/m68k/lib/semaphore.S
 *
 *  Copyright (C) 1996  Linus Torvalds
 *
 *  m68k version by Andreas Schwab
 *
 *  MAR/1999 -- modified to support ColdFire (gerg@snapgear.com)
 *
 *  ckcore version by Kang Sun, 2004
 */

#include <linux/linkage.h>
#include <linux/config.h>
#include <asm/semaphore.h>

/*
 * "down_failed" is called with the eventual return address
 * in r15, and the address of the semaphore in r2. We need
 * to increment the number of waiters on the semaphore,
 * call "__down()", and then eventually return to try again.
 */
ENTRY(__down_failed)
        subi  r0, 16 
        stw   r15, (r0, 8)
        stw   r8, (r0, 12)
        mov   r8, r0
        stw   r2, (r8, 0)
	jbsr SYMBOL_NAME(__down)
        mov   r0, r8
        ldw   r2, (r8, 0)
	ldw   r15, (r0, 8)
        ldw   r8, (r0, 12)
        addi  r0,16 
	rts

ENTRY(__down_failed_interruptible)  // the return value is save in r2
	subi  r0, 12 
        stw   r15, (r0, 4)
        stw   r8, (r0, 8)
        mov   r8, r0
	jbsr SYMBOL_NAME(__down_interruptible)
	mov   r0, r8
        ldw   r15, (r0, 4)
        ldw   r8, (r0, 8)
        addi  r0, 12     
        rts

ENTRY(__up_wakeup)
        subi  r0, 16 
        stw   r15, (r0, 8)
        stw   r8, (r0, 12)
        mov   r8, r0
        stw   r2, (r8, 0)
	jbsr SYMBOL_NAME(__up)
        mov   r0, r8
        ldw   r2, (r8, 0)
	ldw   r15, (r0, 8)
        ldw   r8, (r0, 12)
        addi  r0,16 
	rts

ENTRY(__down_failed_trylock)
        subi  r0, 16 
        stw   r15, (r0, 8)
        stw   r8, (r0, 12)
        mov   r8, r0
        stw   r2, (r8, 0)
	/* Modified by Li Chunqiang (chunqiang_li@c-sky.com) */
	//jbsr SYMBOL_NAME(__down)	
	jbsr  SYMBOL_NAME(__down_trylock)
        mov   r0, r8
        ldw   r2, (r8, 0)
	ldw   r15, (r0, 8)
        ldw   r8, (r0, 12)
        addi  r0,16 
	rts
