/*****************************************************************************/
/*
 *	crt0_ram.S -- startup code for DH2004 eval board.
 *
 *	(C) Copyright 1999-2002, Greg Ungerer (gerg@snapgear.com).
 *	(C) Copyright 2000, Lineo (www.lineo.com).
 *      (C) Copyright 2004, Kang Sun (sunk@vlsi.zju.edu.cn)
 *
 * 	1999/02/24 Modified for the 5307 processor David W. Miller
 *      2004/08/14 Modified for CK510 processor Kang Sun
 */

/*****************************************************************************/


#include "linux/autoconf.h"
#include "asm/ckcore.h"
#include "asm/cksim.h"

.global	_start
.global _rambase
.global _ramvec
.global	_ramstart
.global	_ramend
.global _cmdlinestart
.global _macaddr
.global _fsstart

/*****************************************************************************/

.data

/*
 *	Set up the usable of RAM stuff. Size of RAM is determined then
 *	an initial stack set up at the end.
 */
_rambase:
.long	0
_ramvec:
.long   VBR_BASE	
_ramstart:
.long	0
_ramend:
.long	0
_cmdlinestart:
.long	0
_macaddr:
.long	0

/* add by zxj for reload filesystem 2009-07-14 */
#ifdef CONFIG_BLK_DEV_BLKMEM
_fsstart:
.long	0
#endif  /* CONFIG_BLK_DEV_BLKMEM */  

#if CONFIG_BLK_DEV_INITRD
/*
 *	Setup initial RAM disk limits of using INITRD.
 */
.extern	initrd_start
.extern initrd_end
#endif





/*****************************************************************************/
#define RESET_CLEAR


.text

_vbr_sect:
/*
 *	This is the codes first entry point. This is where it all
 *	begins...
 */
 
 	jsri    _start
	jsri    _start
	
.long _edata
.fill   504


_start:

	lrw	r1, 0x80000100		/* Init psr value */
        mtcr    r1, psr                 /* Set psr register */
	/*
	 *	Setup initial vector base table for interrupts and exceptions
	 */
	lrw     r1, _vbr_sect            /* Load pre-defined vbr */
        mtcr    r1, vbr                 /* Set vbr register */
        lrw     r2, _ramvec             /* Load address of _ramvec */
        stw     r1, (r2)                /* Write vbr setting to it */
#ifdef RESET_CLEAR
        lrw   r7, 0x70000000    /* Load uart base address */
        lrw   r6, 0xffffffff
        st   r6, (r7, 0)  /* store to uart baud reg */
        st   r6, (r7, 4)  /* store to uart baud reg */
        st   r6, (r7, 8)  /* store to uart baud reg */
        movi   r6, 0x20
        st   r6, (r7, 0xc)  /* store to uart baud reg */
        movi   r6, 0xc
        st   r6, (r7, 0x10)  /* store to uart baud reg */
#endif

        /*
         *      Setup memory layout variables. This is the way that
         *      the memory info is passed to the higher level kernel.
         *      Also set up an initial kernel stack at limit of memory.
         */
        lrw     r1, MEM_BASE            /* Load pre-defined base */
        lrw     r2, _rambase            /* Load address of _rambase */
        stw     r1, (r2)                /* Write the ram base address to it */

	/*
	 *	Determine size of RAM, then set up initial stack.
	 */
	lrw     r1, 0xC0DFFFFF            /* Load ram size */
        lrw     r2, _ramend             /* Load address of _ramend */
        stw     r1, (r2)                /* Set end ram addr */
        lrw r1, 0xc00FFFFC
        mov     r0, r1                  /* Set initial stack */
        
	/* Copy the Command Line Start address to _cmdlinestart add by zxj */
		lrw r1, _cmdlinestart
		stw r4, (r1,0)			/* Save Command Line Start addr */
	
	/* Copy the Command Line Size  to _cmdlinesize add by zxj */	
		lrw r1, _macaddr
		stw r5, (r1,0)			/* Save Command Line Size */
	
	/* check watch dog */

    lrw	r6, 0x7000003C
    movi r7, 0x03
    stb r7,(r6, 0)
    
    movi r7, 0x02
    stb r7,(r6, 0)
    
    movi r7, 0x00
    stb r7,(r6, 0)
    
    /* test */

	/*
	 *	Enable CPU internal cache.
	 *      (Current not available)
         */

	/* Enable cache 
         * (Current not available)
         */
	//
	
#if 0
	lrw  r10,0xff06 	//priority setting,ff-read and write
    mtcr r10,cr19
	              
	//first block no cache                                           
	movi r10,0
	mtcr r10,cr21
	lrw  r10,0x3f   //4G space ,0x00 base address
	mtcr r10,cr20
	
	//Second block cache                                                                  
	movi r10,1
	mtcr r10,cr21
	lrw  r10,0xc000002B		//4M space ,0xC0000000->C03FFFFF base address, cache
	mtcr r10,cr20
	
    //3th block cache                                                                  
	movi r10,2
	mtcr r10,cr21
	lrw  r10,0xc0400027		//1M space ,0xC0400000->C04FFFFF base address, cache
	mtcr r10,cr20
	
    //4th block no cache                                                                  
	movi r10,3
	mtcr r10,cr21
	lrw  r10,0xc0000021		//128K space ,0xC0000000->C07FFFFF base address, no cache
	mtcr r10,cr20
#else

	lrw  r10,0x3f02 	//priority setting,ff-read and write
    mtcr r10,cr19
	              
	//first block no cache                                           
	movi r10,0
	mtcr r10,cr21
	lrw  r10,0x3f   //4G space ,0x00 base address
	mtcr r10,cr20
	
	//Second block cache                                                                  
	movi r10,1
	mtcr r10,cr21
	lrw  r10,0xc000002F		//16M space ,0xC0000000->C0DFFFFF base address, cache
	mtcr r10,cr20

    //3th block no cache                                                                  
	movi r10,2
	mtcr r10,cr21
	lrw  r10,0xc0d00027		//1M space ,0xC0400000->C04FFFFF base address, cache
	mtcr r10,cr20
	
#endif


#if 1
	//Set MGU(MGU_EN) and Set MGU(BR_PREDICTION_EN)
	mfcr  r7, cr18
	bseti r7, 0
	bclri r7, 1
	bseti r7 , 6
	mtcr   r7, cr18
   
	//Flush I & D Cache
	mfcr   r7, cr17
	bseti  r7, 0
	bseti  r7, 1
	bclri  r7, 2		//select I & D Cache
	bseti  r7, 4
	mtcr   r7, cr17

	//Config I & D Cache
	mfcr   r7, cr18
	
#ifdef CONFIG_ICACHE 
	bseti  r7, 2		//I Cache bseti = enable; bclri = disable
#else
	bclri  r7, 2		//I Cache bseti = enable; bclri = disable
#endif

#ifdef CONFIG_DCACHE
	bseti  r7, 3		//D Cache bseti = enable; bclri = disable

    /* add by zxj 2009-10-12 */
	#if CONFIG_CK510_DATA_CACHE_WB
		bseti  r7, 4
	#else
		bclri  r7, 4
	#endif

#else
	bclri  r7, 3		//D Cache bseti = enable; bclri = disable
#endif
	mtcr   r7, cr18
	
#endif


#if 0
    /* add by zxj for reload filesystem 2009-07-14 */
#ifdef CONFIG_BLK_DEV_BLKMEM
    #ifndef CONFIG_ROMFS_FROM_ROM
            
            
			lrw r5, 0xC0020000
			lrw r3, _fsstart
			st r5, (r3,0)
    
        #ifdef CONFIG_CAT_FS

            lrw r7, _edata
            ld r6,(r7,0)
            
            /* it's cramfs */
            //lrw r4, 0x453dcd28
            lrw r4, 0x28cd3d45
            cmpne r4,r6
            bf _load_cramfs
            
            /* it's romfs */
            lrw r4, 0x6d6f722d
						cmpne r4,r6
            bt _init_ebss
            
            /* get the romfs img's lenght */
            ld r6, (r7, 8)

//#if __BYTE_ORDER == __LITTLE_ENDIAN
            //l -> e
            mov r4, r6
			lsli r6, 8
			xtrb1 r1, r6
			or	r6, r1
			lsli r6, 16
			xtrb0 r1, r4
			or	r6, r1
			xtrb1 r1, r4
			lsli r1,8
			or	r6, r1
//#endif
            
            br _calc_dw
            
	_load_cramfs:
            /* get the cramfs img's length */
            ld r6, (r7,4)
            
            //l -> e
#if __BYTE_ORDER == __BIG_ENDIAN
           // mov r4, r6
			//lsli r6, 8
			//xtrb1 r1, r6
			//or	r6, r1
			//lsli r6, 16
			//xtrb0 r1, r4
			//or	r6, r1
			//xtrb1 r1, r4
			//lsli r1,8
			//or	r6, r1
#endif
			
	_calc_dw:
			/* calc the dw */
			lsri r6, 2
			addi r6, 0x02  /* safemode */
			
			/* start by end */
			//mov r2, r6
			//lsli r2, 2
			
			//add r7, r2
			//add r5, r2
			
			//addi r6, 0x01
			
		_reload_fs:
		    cmpnei r6, 0
		    bf _init_ebss
		    
		    ld r3, (r7,0)
		    st r3, (r5,0)
		    addi r7, 4
		    addi r5, 4
		    //subi r7, 4
		    //subi r5, 4
		    subi r6,1
		    br _reload_fs
		    
		    /* flush datacache */
		   // movi r2, 0x33
		    //mtcr r2, cr17
        
        #endif  /* CONFIG_CAT_FS */
        
    #endif  /* CONFIG_ROMFS_FROM_ROM */  
#endif  /* CONFIG_BLK_DEV_BLKMEM */  

#endif  


_init_ebss :
    
	lrw	r2, _ebss
	lrw	r4, _ramstart
	stw	r2, (r4)

	/*
	 *	Zero out the bss region.
	 */
	lrw	r1, _sbss		/* Get start of bss */
	lrw	r2, _ebss		/* Get end of bss */
	subu    r2, r1                  /* Calculate size of bss */
        lsri    r2, 2                   /* Size of whole words */
        
	movi	r3, 0
	cmpne	r2, r3
	bf	1f
        movi    r3, 0                   /* Set zero value to write */
       
_clear_bss:
	stw     r3, (r1)                /* Zero next word */
        addi    r1, 4                   /* Increase bss pointer */
        decne   r2                      /* Decrease counter */
        bt      _clear_bss              /* Repeat for all bss */
	br	2f
1:
2:


#if CONFIG_BLK_DEV_INITRD
# if CONFIG_ROMFS_FS
	/*
	 *	Setup up RAMdisk info if using it.
	 *	(Must do this after clearing the bss :-)
	 */
//        lrw     r3, initrd_start         /* Get address of initrd_start */
//        stw     r8, (r3)                 /* Set up start of initrd_start */
//        add     r8, r5                   /* Calculate end of initrd */
//        lrw     r3, initrd_end           /* Get address of initrd_end */
//	stw     r8, (r3)                 /* Store to initrd_end */

# else /* !CONFIG_ROMFS_FS */

	/*
	 * initrd support for Coldfire currently requires romfs.
	 * Generic initrd support requires a bootloader protocol to 
	 * tell the kernel where the image is located.
	 */
//        movi    r8, 0
//        lrw     r3, initrd_start 
//        stw     r8, (r3)
//        lrw     r3, initrd_end
//        stw     r8, (r3)

# endif /* !CONFIG_ROMFS_FS */
#endif /* CONFIG_BLK_DEV_INITRD */

	/*
	 *	Load the current task pointer and stack.
	 */
	lrw     r1, init_task_union
        lrw     r3, _current_task    /* Get address of _current_task */    
        stw     r1, (r3)             /* Store it */
        lrw     r2, 0x2000           /* 8K memory, 2 page for stack */
        add     r1, r2               /* Add 2 page offset to r1: task struct pointer */
        mov     r0, r1               /* Set current task stack pointer */
	
        /*
	 *	Assember start up done, start code proper.
	 */


    
	jsri	start_kernel			/* Start Linux kernel */

_exit:
	br	_exit				/* Should never get here */



/*****************************************************************************/

/******************Print V*********************/

#if 0
.export asmprint
.align  4
asmprint:
#ifdef ASM_PRINT
    lrw   r7, UART_BASE    /* Load uart base address */
    lrw   r6, UART_INIT_WORD
    stb   r6, (r7, UART_CNTL_OFF)  /* store to uart control reg */
    lrw   r6, UART_BAUR_WORD
    stb   r6, (r7, UART_BAUR_OFF)  /* store to uart baud reg */

    lrw    r5, 100       /* load delay count */
zhc_delay_loop:    
    subi	r5, 1
    cmpnei      r5, 0	
    bt    zhc_delay_loop		
    
//    lrw    r2, 'G'            /* time expired, write 'R' to uart */
    lrw     r7, UART_BASE            /* set uart base */
    stb     r2, (r7, UART_DATA_OFF)  /* read a byte from uart */
    lrw    r5, 500       /* load delay count */
zhc_loop:    
    subi	r5, 1
    cmpnei      r5, 0	
    bt    zhc_loop		
#endif
    jmp r15
#endif

