
MEMORY {
	ram    : ORIGIN = 0xc0100000, LENGTH = 0x1400000-0x100000  
}

SECTIONS {

	.text : {
		_stext = . ;
        	*(.text)
			*(.text.init)
			*(.text.exit)
			*(.text.lock)
			*(.exitcall.exit)
		__initcall_start = .;
			*(.initcall.init)
		. = ALIGN(4) ;
		__initcall_end = .;
		__setup_start = .;
			*(.setup.init)
		__setup_end = .;
		. = ALIGN(0x4) ;
  			*(.rodata)
			*(.rodata.*)
			*(.kstrtab)

		. = ALIGN(0x4) ;
                __start___ex_table = .; /* Exception table              */
                        *(__ex_table)
                __stop___ex_table = .;

		. = ALIGN(0x4) ;
		__start___ksymtab = .;  /* Kernel symbol table          */
			*(__ksymtab)
		__stop___ksymtab = .;

		. = ALIGN(0x4) ;
                __start___kallsyms = .; /* All kernel symbols           */
                        *(__kallsyms)
                __stop___kallsyms = .;

		. = ALIGN(0x4) ;
                *(.got)                 /* Global offset table          */

		. = ALIGN(4) ;
		_etext = . ;
	} > ram

	.data BLOCK(0x4) : {
		_sdata = . ;
		__data_start = . ;
        	*(.data)
		*(.data.init)
		*(.data.exit)
		. = ALIGN(0x2000) ;
        	*(.data.init_task)
		. = ALIGN(0x2000) ;
		_edata = . ;
	} > ram

	.init BLOCK(4096) : {
		__init_begin = .;
		. = ALIGN(16);
		__init_end = .;
	} > ram

	.bss BLOCK(0x4) : {
		_sbss = . ;
			*(.bss)
			*(COMMON)

		. = ALIGN(4) ;
		_ebss = . ;
		_end = . ;
	} > ram
}

