/***************************************************************************/

/*
 *	linux/arch/ckcorenommu/platform/DH2004/config.c
 *
 *	Copyright (C) 1999-2002, Greg Ungerer (gerg@snapgear.com)
 *	Copyright (C) 2000, Lineo (www.lineo.com)
 *      Copyright (C) 2004, Kang Sun (sunk@vlsi.zju.edu.cn)
 */

/***************************************************************************/

#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/param.h>
#include <linux/init.h>
#include <asm/irq.h>
#include <asm/dma.h>
#include <asm/traps.h>
#include <asm/machdep.h>
#include <asm/ckcore.h>
#include <asm/cktimer.h>
#include <asm/cksim.h>
//#include <asm/mcfdma.h>
#include <asm/delay.h>
#include <asm/pci_hardware.h>

/***************************************************************************/

void	ckcore_profile_init(void);

/***************************************************************************/

/*
 *	DMA channel base address table.
 */
#if 0
unsigned int   dma_base_addr[MAX_DMA_CHANNELS] = {
        MCF_MBAR + MCFDMA_BASE0,
        MCF_MBAR + MCFDMA_BASE1,
        MCF_MBAR + MCFDMA_BASE2,
        MCF_MBAR + MCFDMA_BASE3,
};
unsigned int dma_device_address[MAX_DMA_CHANNELS];
#endif

/***************************************************************************/
/*void sub_test(void)
{	
	unsigned long long tmp = 0x98, tmp1 = 0x87;	
	tmp = tmp1 - tmp;
	printk("error flag %x\n", tmp);
}*/
void ckcore_tick(void)
{
	 volatile unsigned long	*timerp;

//	test_sub();
//	SUB_TEST();
	/* Reset the DH2004 on board timer */
	timerp = (volatile unsigned long *) (CKTIMER_TCR);
	*timerp |= CKTIMER_TCR0_EN;  /* Reload the counter and start counting */
}
asmlinkage void EnableCache(void);
asmlinkage void DisableCache(void);

#define TSC_ENABLE


#ifndef TSC_ENABLE
//#define TIME1_TEST_INCLUDE
#endif

#ifdef TIME1_TEST_INCLUDE

unsigned long timeunit1 = 0;
void testhandler(int irq, void * dummy, struct pt_regs * regs)
{
//	show_mem();
//	printk("v");
	timeunit1++;
	return;
}

void clear_timer1(void)
{
	timeunit1 = 0;
}
#endif


#ifdef TSC_ENABLE

#define NS_USED

//void get_tsc_clock(unsigned long * pHI, unsigned long *pLOW)
void get_tsc_clock(unsigned long long * pclock)
{
//	unsigned long HI, LOW;
	unsigned long HI = 0, LOW = 0;//&LOW;
	
	HI = *((unsigned long *)CKTIMER_CUR_TCNT3);
	LOW = *((unsigned long *)CKTIMER_CUR_TCNT2);
	if (HI != *((unsigned long *)CKTIMER_CUR_TCNT3))
	{
		HI = *((unsigned long *)CKTIMER_CUR_TCNT3);
		LOW = *((unsigned long *)CKTIMER_CUR_TCNT2);
	}

//	printf("hi %x low %x\n", HI, LOW);
	*pclock =     ((long long)((unsigned long long)(HI) | ((unsigned long long)(LOW)<<32)));
// LONG_LONG(LOW, HI);//((unsigned long long)HI) << 32 + LOW;
//	printf("hilow %x\n", *pclock);

//	*pLOW = ((*pLOW) >> 8) | ((*pHI & 0xff) << 24);
//	*pHI = (*pHI) >> 8;
	return;
}
#endif
unsigned long test_sub(void)
{
//		register long tmp = 0x5a5a5a5a, tmp1 = 6;
		register long tmp = 0x56;//0x5a5a5a00;
		register long tmp1 = 0x96;

//		printk("tmp value %x and %x\n", tmp, tmp1);
			__asm__ __volatile__ (
		//	"subi %0, 8"
			"cmplt r2, r2\r\n"
			"INCF %0\r\n"
			"INCF %1\r\n"
			:"=r"(tmp1), "=r"(tmp)
			:"0"(tmp1), "1"(tmp)
			);
		printk("tmp value %x and %x\n", tmp, tmp1);
		return tmp1;
}

/***************************************************************************/
/* Note: the default work mode of the timer is cascade !! */
void ckcore_timer_init(void (*handler)(int, void *, struct pt_regs *))
{
	volatile unsigned long	*timerp;  /* timer counter pointer */
	volatile unsigned long	*icrp;    /* interrupt controller pointer */

    *(volatile unsigned int *)0x70000040 = 0;
	printk("Start Timer\n");
  /* Set up TIMER 1 as poll clock */
        timerp = (volatile unsigned long *) (CKTIMER_TCR);   /* timer control register, 16 bits */
        *timerp &= ~CKTIMER_TCR0_EN;   /* timer1 disable */
	*timerp |= CKTIMER_TCR0_CAPEN;
//        *timerp |= CKTIMER_TCR1_CASCADE; /* the work mode of timer1 is cascade */
#ifdef TIME1_TEST_INCLUDE
        *timerp &= ~CKTIMER_TCR1_EN;   /* timer1 disable */
#endif

#ifdef TSC_ENABLE
        *timerp &= ~CKTIMER_TCR2_EN;   /* timer2 disable */
        *timerp &= ~CKTIMER_TCR3_EN;   /* timer3 disable */
#endif

        timerp = (volatile unsigned long *) (CKTIMER_TCN0);  /* timer0 counter register, 32 bits */
        /* set the init value of timer1 counter, when the counter overflow, interrupt occurs */
        *timerp = (0xffffffff - (CK_CLK / HZ));   /* Set init value of timer1 counter */
#ifdef TIME1_TEST_INCLUDE
        timerp = (volatile unsigned long *) (CKTIMER_TCN1);  /* timer1 counter register32 bits */
        /* set the init value of timer1 counter, when the counter overflow, interrupt occurs */
//        *timerp = (0xffffffff - (CK_CLK / HZ   ));   /* Set init value of timer1 counter */
        *timerp = (0xffffffff - (CK_CLK / (HZ * 1000 * 100)   ));   /* Set init value of timer1 counter */
#endif

#ifdef TSC_ENABLE
        timerp = (volatile unsigned long *) (CKTIMER_TCN2);  /* timer2 counter register32 bits */
        *timerp = 0;   /* Set init value of timer2 counter */

        timerp = (volatile unsigned long *) (CKTIMER_TCN3);  /* timer1 counter register32 bits */
        *timerp = 0;   /* Set init value of timer1 counter */
#endif
           
        timerp = ( volatile unsigned long *) (CKTIMER_TCR); /* timer0 controlregister, 16 bits */
        *timerp &= ~CKTIMER_TCR0_SGLE; /* not single mode */
        *timerp |=  CKTIMER_TCR0_EN; /* Timer0 enable */
#ifdef TIME1_TEST_INCLUDE
        timerp = ( volatile unsigned long *) (CKTIMER_TCR); /* timer0 controlregister, 16 bits */
        *timerp &= ~CKTIMER_TCR1_SGLE; /* not single mode */
        *timerp |=  CKTIMER_TCR1_EN; /* Timer0 enable */
#endif

#ifdef TSC_ENABLE
        timerp = ( volatile unsigned long *) (CKTIMER_TCR); /* timer0 controlregister, 16 bits */
        *timerp &= ~CKTIMER_TCR2_SGLE; /* not single mode */
        *timerp |= CKTIMER_TCR2_CAPEN; /* not single mode */
        *timerp |= CKTIMER_TCR2_CASCADE; /* not single mode */
        *timerp |=  CKTIMER_TCR2_EN; /* Timer0 enable */
        *timerp &= ~CKTIMER_TCR3_SGLE; /* not single mode */
        *timerp |= CKTIMER_TCR3_CAPEN; /* not single mode */
        *timerp |= CKTIMER_TCR3_CASCADE; /* not single mode */
        *timerp |=  CKTIMER_TCR3_EN; /* Timer0 enable */
#endif

        icrp = (volatile unsigned long*) (CKSIM_PIC_BASE);  /* Program Interrupt Controller base address */
        /* set interrupt controller for timer */
        icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE4;     /* Edge triggered timer interrupt, int 1 */
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS4;      /* Pose edge sensitive, int 1 */
        icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT4_MASK;   /* Unmask cascade timer 1 interrupt */
        //icrp[CKSIM_PIC_COW1] |=  CKSIM_COW_AVEC; //del by phosor
        /* the number of timer interrupt is 33 */
        //request_irq(37, handler, SA_INTERRUPT, "DAHUA Timer", NULL); 
      //  request_irq(36, handler, SA_INTERRUPT, "DAHUA Timer", NULL); 
        request_irq(36, handler, SA_INTERRUPT, "DAHUA Timer", NULL); 
     //   request_irq(38, handler, SA_INTERRUPT, "DAHUA Timer", NULL); 
#ifdef TIME1_TEST_INCLUDE
        icrp = (volatile unsigned long*)(CKSIM_PIC_BASE);  /* PIC base address */
        /* set interrupt controller for timer */
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_POS5;      /* Pose edge sensitive, int 1 */
        icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE5;     /* Edge triggered timer interrupt, int 1 */
        icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT5_MASK;   /* Unmask cascade timer 1 interrupt */
//        icrp[CKSIM_PIC_COW1] |=  CKSIM_COW_AVEC;
        /* the number of timer interrupt is 33 */
        request_irq(37, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
#endif
 #ifdef CONFIG_HIGHPROFILE
        ckcore_profile_init();
  #endif








///////////////
 /*       icrp = (volatile unsigned long*) (CKSIM_PIC_BASE);
 
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE0;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS0;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT0_MASK;
        request_irq(32, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 

	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE1;
	icrp[CKSIM_PIC_POL] &= ~CKSIM_PIC_POS1;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT1_MASK;
        request_irq(33, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE2;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS2;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT2_MASK;
        request_irq(34, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 

	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE5;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS5;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT5_MASK;
        request_irq(42, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE6;
	icrp[CKSIM_PIC_POL]&= ~ CKSIM_PIC_POS6;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT6_MASK;
        request_irq(44, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 

	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE7;
	icrp[CKSIM_PIC_POL] &= ~CKSIM_PIC_POS7;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT7_MASK;
        request_irq(44, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
	
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE8;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS8;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT8_MASK;
        request_irq(40, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE9;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS9;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT9_MASK;
        request_irq(41, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
			
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE13;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS13;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT13_MASK;
        request_irq(45, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE14;
	icrp[CKSIM_PIC_POL] &= ~CKSIM_PIC_POS14;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT14_MASK;
        request_irq(46, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE15;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS15;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT15_MASK;
        request_irq(47, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 


	

	
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE16;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS16;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT16_MASK;
        request_irq(48, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE17;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS17;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT17_MASK;
        request_irq(49, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE18;
	icrp[CKSIM_PIC_POL]&= ~ CKSIM_PIC_POS18;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT18_MASK;
        request_irq(50, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE19;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS19;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT19_MASK;
        request_irq(51, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE20;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS20;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT20_MASK;
        request_irq(52, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE21;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS21;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT21_MASK;
        request_irq(53, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE22;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS22;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT22_MASK;
        request_irq(54, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE23;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS23;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT23_MASK;
        request_irq(55, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE24;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS24;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT24_MASK;
        request_irq(56, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE25;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS25;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT25_MASK;
        request_irq(57, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE26;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS26;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT26_MASK;
        request_irq(58, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE27;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS27;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT27_MASK;
        request_irq(59, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE28;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS28;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT28_MASK;
        request_irq(60, testhandler, SA_INTERRUPT, "TEST Timer", NULL);
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE29;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS29;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT29_MASK;
        request_irq(61, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE30;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS30;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT30_MASK;
        request_irq(62, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE31;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS31;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT31_MASK;
        request_irq(63, testhandler, SA_INTERRUPT, "TEST Timer", NULL);



        icrp = (volatile unsigned long*) (CKSIM_PIC_BASE);
 
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE0;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS0;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT0_MASK;
        request_irq(32, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 

	icrp[CKSIM_PIC_MODE] &= ~CKSIM_PIC_EDGE1;
	icrp[CKSIM_PIC_POL] &= ~CKSIM_PIC_POS1;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT1_MASK;
        request_irq(33, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~CKSIM_PIC_EDGE2;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS2;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT2_MASK;
        request_irq(34, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 

	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE5;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS5;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT5_MASK;
        request_irq(42, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE6;
	icrp[CKSIM_PIC_POL]&= ~ CKSIM_PIC_POS6;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT6_MASK;
        request_irq(44, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 

	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE7;
	icrp[CKSIM_PIC_POL] &= ~CKSIM_PIC_POS7;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT7_MASK;
        request_irq(44, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
	
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE8;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS8;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT8_MASK;
        request_irq(40, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE9;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS9;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT9_MASK;
        request_irq(41, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
			
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE13;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS13;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT13_MASK;
        request_irq(45, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE14;
	icrp[CKSIM_PIC_POL] &= ~CKSIM_PIC_POS14;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT14_MASK;
        request_irq(46, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE15;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS15;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT15_MASK;
        request_irq(47, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 


	
	
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE16;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS16;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT16_MASK;
        request_irq(48, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE17;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS17;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT17_MASK;
        request_irq(49, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE18;
	icrp[CKSIM_PIC_POL]&= ~ CKSIM_PIC_POS18;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT18_MASK;
        request_irq(50, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE19;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS19;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT19_MASK;
        request_irq(51, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~CKSIM_PIC_EDGE20;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS20;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT20_MASK;
        request_irq(52, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE21;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS21;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT21_MASK;
        request_irq(53, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE22;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS22;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT22_MASK;
        request_irq(54, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE23;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS23;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT23_MASK;
        request_irq(55, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE24;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS24;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT24_MASK;
        request_irq(56, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE25;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS25;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT25_MASK;
        request_irq(57, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE26;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS26;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT26_MASK;
        request_irq(58, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE27;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS27;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT27_MASK;
        request_irq(59, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE28;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS28;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT28_MASK;
        request_irq(60, testhandler, SA_INTERRUPT, "TEST Timer", NULL);
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE29;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS29;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT29_MASK;
        request_irq(61, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE30;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS30;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT30_MASK;
        request_irq(62, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE31;
	icrp[CKSIM_PIC_POL] &= ~ CKSIM_PIC_POS31;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT31_MASK;
        request_irq(63, testhandler, SA_INTERRUPT, "TEST Timer", NULL);




        icrp = (volatile unsigned long*) (CKSIM_PIC_BASE);
 
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE0;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS0;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT0_MASK;
        request_irq(32, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 

	icrp[CKSIM_PIC_MODE] &= ~CKSIM_PIC_EDGE1;
	icrp[CKSIM_PIC_POL] |=CKSIM_PIC_POS1;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT1_MASK;
        request_irq(33, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~CKSIM_PIC_EDGE2;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS2;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT2_MASK;
        request_irq(34, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 

	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE5;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS5;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT5_MASK;
        request_irq(42, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE6;
	icrp[CKSIM_PIC_POL]|=CKSIM_PIC_POS6;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT6_MASK;
        request_irq(44, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 

	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE7;
	icrp[CKSIM_PIC_POL] |=CKSIM_PIC_POS7;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT7_MASK;
        request_irq(44, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
	
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE8;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS8;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT8_MASK;
        request_irq(40, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE9;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS9;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT9_MASK;
        request_irq(41, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
			
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE13;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS13;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT13_MASK;
        request_irq(45, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE14;
	icrp[CKSIM_PIC_POL] |=CKSIM_PIC_POS14;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT14_MASK;
        request_irq(46, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE15;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS15;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT15_MASK;
        request_irq(47, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 

	
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE16;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS16;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT16_MASK;
        request_irq(48, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE17;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS17;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT17_MASK;
        request_irq(49, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE18;
	icrp[CKSIM_PIC_POL]|= CKSIM_PIC_POS18;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT18_MASK;
        request_irq(50, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE19;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS19;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT19_MASK;
        request_irq(51, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~CKSIM_PIC_EDGE20;
	icrp[CKSIM_PIC_POL] |=CKSIM_PIC_POS20;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT20_MASK;
        request_irq(52, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE21;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS21;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT21_MASK;
        request_irq(53, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE22;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS22;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT22_MASK;
        request_irq(54, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE23;
	icrp[CKSIM_PIC_POL] |=CKSIM_PIC_POS23;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT23_MASK;
        request_irq(55, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE24;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS24;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT24_MASK;
        request_irq(56, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE25;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS25;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT25_MASK;
        request_irq(57, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE26;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS26;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT26_MASK;
        request_irq(58, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE27;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS27;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT27_MASK;
        request_irq(59, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE28;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS28;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT28_MASK;
        request_irq(60, testhandler, SA_INTERRUPT, "TEST Timer", NULL);
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE29;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS29;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT29_MASK;
        request_irq(61, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE30;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS30;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT30_MASK;
        request_irq(62, testhandler, SA_INTERRUPT, "TEST Timer", NULL); 
		
	icrp[CKSIM_PIC_MODE] &= ~ CKSIM_PIC_EDGE31;
	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS31;
	icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT31_MASK;
        request_irq(63, testhandler, SA_INTERRUPT, "TEST Timer", NULL);*/
  
//////////////teset





  
}

void ckcore_enable_irq(int irq)
{
	volatile unsigned long	*icrp;    /* interrupt controller pointer */
        icrp = (volatile unsigned long*) (CKSIM_PIC_BASE);  /* Program Interrupt Controller base address */

//	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_POS11;      /* Pose edge sensitive, int 1 */
//        icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE11;     /* Edge triggered timer interrupt, int 1 */
//        icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT11_MASK;   /* Unmask cascade timer 1 interrupt */

		if (irq != 40)
			icrp[CKSIM_PIC_POL] |= (CKSIM_PIC_POS0 << (irq - 32)) ;      /* Pose edge sensitive, int 1 */

			
		icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE0 << (irq - 32);     /* Edge triggered timer interrupt, int 1 */
//		icrp[CKSIM_PIC_MODE] &= ~(CKSIM_PIC_EDGE0 << (irq - 32));     /* Edge triggered timer interrupt, int 1 */
		icrp[CKSIM_PIC_MASK] &= ~(CKSIM_INT0_MASK << (irq -32));   /* Unmask cascade timer 1 interrupt */
//		printk("Irq %x %x enabled to %x mask %x\n", irq, CKSIM_PIC_MODE, icrp[CKSIM_PIC_MODE] , icrp[CKSIM_PIC_MASK]);
		
		
		if ( irq == CKCORE_PCI_IRQ )
		{
//			printk("e\n");
            #ifdef CKCORE_PCI_BIG
			    (*PLD_CPU_IMASK) |= (cpu_to_le32(PLD_INTA_ENABLE));//enable the next interrupt
            #else
                (*PLD_CPU_IMASK) |= ((PLD_INTA_ENABLE));//enable the next interrupt
            #endif
		}
}
void ckcore_disable_irq(int irq)
{
	volatile unsigned long	*icrp;    /* interrupt controller pointer */
        icrp = (volatile unsigned long*) (CKSIM_PIC_BASE);  /* Program Interrupt Controller base address */
        
	if ( irq == CKCORE_PCI_IRQ )
	{
//		printk("d\n");
        #ifdef CKCORE_PCI_BIG
		    (*((unsigned long *)PLD_CPU_IMASK)) &= ~(cpu_to_le32(PLD_INTA_ENABLE));//disable the next interrupt
        #else
            (*((unsigned long *)PLD_CPU_IMASK)) &= ~((PLD_INTA_ENABLE));//disable the next interrupt
        #endif
	}

//	icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_POS11;      /* Pose edge sensitive, int 1 */
//        icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE11;     /* Edge triggered timer interrupt, int 1 */
//        icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT11_MASK;   /* Unmask cascade timer 1 interrupt */

//	icrp[CKSIM_PIC_MODE] &= ~((CKSIM_PIC_POS0 << (irq - 32)) );      /* Pose edge sensitive, int 1 */
//        icrp[CKSIM_PIC_MODE] &= ~(CKSIM_PIC_EDGE0 << (irq - 32));     /* Edge triggered timer interrupt, int 1 */
        icrp[CKSIM_PIC_MASK] |= CKSIM_INT0_MASK << (irq -32);   /* Unmask cascade timer 1 interrupt */
//		printk("Irq %x disabled to %x mask %x\n", irq, icrp[CKSIM_PIC_MODE] , icrp[CKSIM_PIC_MASK]);
}
/***************************************************************************/

unsigned long ckcore_timer_offset(void)
{
/*	volatile unsigned short *timerp;
	unsigned long		trr, tcn, offset;

	timerp = (volatile unsigned short *) (MCF_MBAR + MCFTIMER_BASE1);
	tcn = timerp[MCFTIMER_TCN];
	trr = timerp[MCFTIMER_TRR];
*/
	/*
	 * If we are still in the first half of the upcount and a
	 * timer interupt is pending, then add on a ticks worth of time.
	 */
/*	offset = ((tcn * (1000000 / HZ)) / trr);
	if (((offset * 2) < (1000000 / HZ)) && (mcf_getipr() & MCFSIM_IMR_TIMER1))
		offset += 1000000 / HZ;
	return offset;	*/
        return 1;
}

/***************************************************************************/
#ifdef CONFIG_HIGHPROFILE
/***************************************************************************/

#define	PROFILEHZ	1013

/*
 *	Use the other timer to provide high accuracy profiling info.
 */

void ckcore_profile_tick(int irq, void *dummy, struct pt_regs *regs)
{
	volatile unsigned char	*timerp;

	/* Reset the ColdFire timer2 */
/*	timerp = (volatile unsigned char *) (MCF_MBAR + MCFTIMER_BASE2);
	timerp[MCFTIMER_TER] = MCFTIMER_TER_CAP | MCFTIMER_TER_REF;

        if (!user_mode(regs)) {
                if (prof_buffer && current->pid) {
                        extern int _stext;
                        unsigned long ip = instruction_pointer(regs);
                        ip -= (unsigned long) &_stext;
                        ip >>= prof_shift;
                        if (ip < prof_len)
                                prof_buffer[ip]++;
                }
        }
*/
}

void ckcore_profile_init(void)
{
	volatile unsigned short	*timerp;
	volatile unsigned char	*icrp;

/*	printk("PROFILE: lodging timer2=%d as profile timer\n", PROFILEHZ);*/

	/* Set up TIMER 2 as poll clock */
/*	timerp = (volatile unsigned short *) (MCF_MBAR + MCFTIMER_BASE2);
	timerp[MCFTIMER_TMR] = MCFTIMER_TMR_DISABLE;

	timerp[MCFTIMER_TRR] = (unsigned short) ((MCF_CLK / 16) / PROFILEHZ);
	timerp[MCFTIMER_TMR] = MCFTIMER_TMR_ENORI | MCFTIMER_TMR_CLK16 |
		MCFTIMER_TMR_RESTART | MCFTIMER_TMR_ENABLE;

	icrp = (volatile unsigned char *) (MCF_MBAR + MCFSIM_TIMER2ICR);

	*icrp = MCFSIM_ICR_AUTOVEC | MCFSIM_ICR_LEVEL7 | MCFSIM_ICR_PRI3;
	request_irq(31, coldfire_profile_tick, (SA_INTERRUPT | IRQ_FLG_FAST),
		"Profile Timer", NULL);
	mcf_setimr(mcf_getimr() & ~MCFSIM_IMR_TIMER2);*/
}

/***************************************************************************/
#endif	/* CONFIG_HIGHPROFILE */
/***************************************************************************/

/*
 *	Program the vector to be an auto-vectored.
 */

/*
void ckcore_autovector(unsigned int vec)
{
	volatile unsigned int  *icrp;

	if ((vec >= 25) && (vec <= 31)) {
		icrp = (volatile unsigned int *) CKSIM_PIC_BASE;
                icrp[CKSIM_PIC_COW1] |= CKSIM_COW_AVEC;	
		ckcore_setimr(ckcore_getimr() & ~vec);
	}
}
*///del by phosor

/***************************************************************************/

extern e_vector	*_ramvec;

void set_evector(int vecnum, void (*handler)(void))
{
	if (vecnum >= 0 && vecnum <= 255)
		_ramvec[vecnum] = handler;
}

asmlinkage long sys_sysfun(int fun, int* info)
{
    
    printk("\n ======sys_sysfun  sys_sysfun ===%d===", fun);

    switch(fun)
    {
    case 0:
        info[0]=CK_BUSCLK;

	info[2] = *((unsigned long *)CKTIMER_CUR_TCNT3);
	info[1]= *((unsigned long *)CKTIMER_CUR_TCNT2);
	if (info[2] != *((unsigned long *)CKTIMER_CUR_TCNT3))
	{
		info[2] = *((unsigned long *)CKTIMER_CUR_TCNT3);
		info[1] = *((unsigned long *)CKTIMER_CUR_TCNT2);
	}
        break;

    case 1:
        break;
        
    case 2:
        break;

    case 3:
        break;
        
    default:
        break;
    }
    
    return 0;
}

/***************************************************************************/

/* assembler routines */
asmlinkage void buserr(void);
asmlinkage void trap(void);
asmlinkage void system_call(void);
asmlinkage void inthandler(void);
asmlinkage void autohandler(void);
asmlinkage void fasthandler(void);
asmlinkage void fastautohandler(void);

void __init ckcore_trap_init(void)
{
	int i;


#ifndef ENABLE_dBUG
        volatile unsigned int *icrp;
 	icrp = (volatile unsigned int *) (CKSIM_PIC_BASE);
        icrp[CKSIM_PIC_MASK] = CKSIM_PIC_MASKALL;
#endif

 //       icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE3;     /* Edge triggered timer interrupt, int 1 */
 //       icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT3_MASK;   /* Unmask cascade timer 1 interrupt */
//        icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE10;     /* Edge triggered timer interrupt, int 1 */
//	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS10;      /* Pose edge sensitive, int 1 */
 //       icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT10_MASK;   /* Unmask cascade timer 1 interrupt */	
 //       icrp[CKSIM_PIC_MODE] |= CKSIM_PIC_EDGE11;     /* Edge triggered timer interrupt, int 1 */
//	icrp[CKSIM_PIC_POL] |= CKSIM_PIC_POS11;      /* Pose edge sensitive, int 1 */
 //       icrp[CKSIM_PIC_MASK] &= ~CKSIM_INT11_MASK;   /* Unmask cascade timer 1 interrupt */	



	icrp[CKSIM_PIC_PRI0] = 0x03020100;
	icrp[CKSIM_PIC_PRI1] = 0x07060504;
	icrp[CKSIM_PIC_PRI2] = 0x0b0a0908;
	icrp[CKSIM_PIC_PRI3] = 0x0f0e0d0c;
	icrp[CKSIM_PIC_PRI4] = 0x13121110;
	icrp[CKSIM_PIC_PRI5] = 0x17161514;
	icrp[CKSIM_PIC_PRI6] = 0x1b1a1918;
	icrp[CKSIM_PIC_PRI7] = 0x1f1e1d1c;

	/*
	 *	There is a common trap handler and common interrupt
	 *	handler that handle almost every vector. We treat
	 *	the system call and bus error special, they get their
	 *	own first level handlers.
	 */
        for(i = 0; (i <= 19); i++)
              _ramvec[i] = trap;
        for(; (i < 128); i++)
             _ramvec[i] = inthandler;

 	
	// add by phosor for test quick int	
/*	unsigned long pfh;
	pfh= (unsigned long)fasthandler;	
	pfh++;        
	_ramvec[32] = pfh;
	_ramvec[33] = pfh;
	_ramvec[34] = pfh;
	_ramvec[35] = pfh;*/
	
     
        _ramvec[VEC_ACCESS] = buserr;
        _ramvec[VEC_SYS] = system_call;
        _ramvec[VEC_AUTOVEC] = autohandler;
        _ramvec[VEC_FAUTOVEC] = fastautohandler;

       icrp[CKSIM_PIC_MASK] = 0xffffffff;/*add by phosor.zhou for pic(32)*/

  	icrp[CKSIM_PIC_VEC] = 32;
       icrp[CKSIM_PIC_COW1] = CKSIM_COW_MD1;/*add by phosor.zhou for pic(32)*/
}

/***************************************************************************/

/*
 *	Generic dumping code. Used for panic and debug.
 */

void dump(struct pt_regs *fp)
{
	extern unsigned int sw_usp, sw_ksp;
	unsigned long	*sp;
	unsigned char	*tp;
	int		i;

	printk("\nCURRENT PROCESS:\n\n");
	printk("COMM=%s PID=%d\n", current->comm, current->pid);

	if (current->mm) {
		printk("TEXT=%08x-%08x DATA=%08x-%08x BSS=%08x-%08x\n",
			(int) current->mm->start_code,
			(int) current->mm->end_code,
			(int) current->mm->start_data,
			(int) current->mm->end_data,
			(int) current->mm->end_data,
			(int) current->mm->brk);
		printk("USER-STACK=%08x  KERNEL-STACK=%08x\n\n",
			(int) current->mm->start_stack,
			(int) (((unsigned long) current) + 2 * PAGE_SIZE));
	}

	printk("PC: %08lx\n", fp->pc);
	printk("SR: %08lx    SP: %08lx\n", (long) fp->sr, (long) fp);
//	printk("r1: %08lx    syscallr1: %08lx    r2: %08lx    r3: %08lx\n",
//		fp->r1, fp->syscallr1, fp->r2, fp->r3);
	printk("r4: %08lx    r5: %08lx    r6: %08lx    r7: %08lx\n",
		fp->r4, fp->r5, fp->r6, fp->r7);
	printk("r8 %08lx    r9: %08lx    r10: %08lx    r11: %08lx\n",
		fp->r8, fp->r9, fp->r10, fp->r11);
	printk("r12 %08lx    r13: %08lx    r14: %08lx    r15: %08lx\n",
		fp->r12, fp->r13, fp->r14, fp->r15);

	printk("\nUSP: %08x   KSP: %08x   TRAPFRAME: %08x\n",
		sw_usp, sw_ksp, (unsigned int) fp);

	printk("\nCODE:");
	tp = ((unsigned char *) fp->pc) - 0x20;
	for (sp = (unsigned long *) tp, i = 0; (i < 0x40);  i += 4) {
		if ((i % 0x10) == 0)
			printk("\n%08x: ", (int) (tp + i));
		printk("%08x ", (int) *sp++);
	}
	printk("\n");

	printk("\nKERNEL STACK:");
	tp = ((unsigned char *) fp) - 0x40;
	for (sp = (unsigned long *) tp, i = 0; (i < 0xc0); i += 4) {
		if ((i % 0x10) == 0)
			printk("\n%08x: ", (int) (tp + i));
		printk("%08x ", (int) *sp++);
	}
	printk("\n");

	printk("\nUSER STACK:");
	tp = (unsigned char *) (sw_usp - 0x10);
	for (sp = (unsigned long *) tp, i = 0; (i < 0x80); i += 4) {
		if ((i % 0x10) == 0)
			printk("\n%08x: ", (int) (tp + i));
		printk("%08x ", (int) *sp++);
	}
	printk("\n\n");
}

/***************************************************************************/

void config_BSP(char *commandp, int size)
{
#ifdef CONFIG_BOOTPARAM
	strncpy(commandp, CONFIG_BOOTPARAM_STRING, size);
	commandp[size-1] = 0;
#else
	memset(commandp, 0, size);
#endif

	mach_sched_init = ckcore_timer_init;
	mach_tick = ckcore_tick;
	mach_trap_init = ckcore_trap_init;
	mach_enable_irq = ckcore_enable_irq;
	mach_disable_irq = ckcore_disable_irq;
	mach_gettimeoffset = ckcore_timer_offset;
}

/***************************************************************************/
#ifdef TRAP_DBG_INTERRUPT

asmlinkage void dbginterrupt_c(struct frame *fp)
{
	extern void dump(struct pt_regs *fp);
	printk("%s(%d): BUS ERROR TRAP\n", __FILE__, __LINE__);
        dump((struct pt_regs *) fp);
	asm("bkpt");
}

#endif
/***************************************************************************/
