#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/slab.h>
#include <linux/init.h>
#include <linux/devfs_fs_kernel.h>
#include <linux/errno.h>
#include <linux/fs.h>
#include <asm/setup.h>
#include <asm/bitops.h>
#include "./inc/avilsi.h"

u32 avi_drvsta;

#define TEST_DMA_CACHE
#undef TEST_DMA_CACHE

#ifdef TEST_DMA_CACHE

#define DMA_MODE				((volatile u32 *)0x60030000)
#define DMA_SRCADDR				((volatile u32 *)0x60030004)
#define DMA_DSTADDR				((volatile u32 *)0x60030008)
#define DMA_CTRSLEN				((volatile u32 *)0x6003000c)
#define DMA_RTRSX				((volatile u32 *)0x60030010)
#define DMA_RTRSY				((volatile u32 *)0x60030014)
#define DMA_RTRWTH_S			((volatile u32 *)0x60030018)
#define DMA_RTRWTH_G			((volatile u32 *)0x6003001c)
#define DMA_START				((volatile u32 *)0x60030020)

#define DMA_STATUS				((volatile u32 *)0x60100000)

#define DMA_STATUS_BUSY			4
#define DMA_STATUS_END 			2
#define DMA_STATUS_ERROR		1

void dma_rect(void)
{
	int i, j;
	volatile unsigned char *cdst = (unsigned char *)(0xC0000000);
	volatile unsigned char *csrc; //= (unsigned char *)(0xc0100000);
	
	printk("DMA and DCache Test!\n");
	
	j = 1024;
	
	//cdst = kmalloc( j, GFP_DMA );
	csrc = kmalloc( j, GFP_KERNEL );
	
	printk("j addr = %#x\n",&j);
	
	printk("cdst = %#x\n",cdst );
	printk("csrc = %#x\n",csrc );	
	
	
	memset(cdst,0,j);
	memset(csrc,0,j);
	
	printk("target1 = %x\n",cdst[1]);
	printk("target1 = %x\n",csrc[1]);
	
	for(i=0;i<j;i++)
		csrc[i] = i;

	//busy
	if(*DMA_STATUS & DMA_STATUS_BUSY)
	{
		printk("dma busy!\n");
		return;
	}
	
	*DMA_MODE = 0;
	*DMA_SRCADDR = (unsigned long)csrc;
	*DMA_DSTADDR = (unsigned long)cdst;
	*DMA_CTRSLEN = j;
	*DMA_START = 1;

	//busy
	i = 0;
	while(*DMA_STATUS & DMA_STATUS_BUSY)
	{
		if(i ++ > 0xffffff)
		{
			printk("bus error!\n");
			return;
		}
	}
	
	//error
	if(*DMA_STATUS & DMA_STATUS_ERROR)
	{
		printk("dma error!\n");
		return;
	}
	
	printk("target3 = %x\n",cdst[1]);
	
	avi_fulsh_dcache();
	
	
	printk("target3 = %x\n",cdst[1]);
	
	
	
	for(i=0;i<j;i++)
		csrc[i] = 0x55;

	//busy
	if(*DMA_STATUS & DMA_STATUS_BUSY)
	{
		printk("dma busy!\n");
		return;
	}
	
	*DMA_MODE = 0;
	*DMA_SRCADDR = (unsigned long)csrc;
	*DMA_DSTADDR = (unsigned long)cdst;
	*DMA_CTRSLEN = j;
	*DMA_START = 1;

	//busy
	i = 0;
	while(*DMA_STATUS & DMA_STATUS_BUSY)
	{
		if(i ++ > 0xffffff)
		{
			printk("bus error!\n");
			return;
		}
	}
	
	//error
	if(*DMA_STATUS & DMA_STATUS_ERROR)
	{
		printk("dma error!\n");
		return;
	}
	
	printk("target3 = %x\n",cdst[1]);
	
	avi_fulsh_dcache();
	
	
	printk("target3 = %x\n",cdst[1]);	
	
	printk("done.\n");
	
	//kfree( cdst );
	kfree( csrc );
	
	return;			
}
#endif /* for test dms */


static int avi_open(struct inode * inode, struct file * file)
{
	return 0;
}

int avi_ioctl(struct inode *inode, struct file *file,
                 unsigned int ioctl_num,/* The number of the ioctl */
                 unsigned long ioctl_param) /* The parameter to it */
{
	int rc;
	
	rc = 0;
	if( 0 == ioctl_num )
		return rc;
	
	
	#ifdef CONFIG_BOOTENV

		if ( ioctl_num <= AVILSI_IOC_ENDCMD )
		{
			rc = avi_env_ioctl(ioctl_num,ioctl_param);
		}
		
	#endif
		
	//printk("ioctl_num = %#x; ioctl_param = %#x\n",ioctl_num, ioctl_param);
	switch( ioctl_num )
	{
		case AVILSI_IOC_MALLOC_NOR:
		{
			rc = kmalloc( ioctl_param, GFP_KERNEL );
			break;
		}
		case AVILSI_IOC_MALLOC_DMA:
		{
			rc = kmalloc( ioctl_param, GFP_DMA );
			break;
		}
		case AVILSI_IOC_FREE_NOR:
		{
			kfree( ioctl_param );
			break;
		}
		case AVILSI_IOC_FREE_DMA:
		{
			kfree( ioctl_param );
		}
		default:
			break;
	}
	
	return rc;
}

static int avi_release(struct inode * inode, struct file * file)
{
	return 0;
}

static struct file_operations avi_fops = {
	owner:		THIS_MODULE,
	llseek:		no_llseek,
	read:		NULL,
	write:		NULL,
	ioctl:		avi_ioctl,
	open:		avi_open,
	release:	avi_release,
};


static int __exit avi_exit(void)
{
	#ifdef CONFIG_BOOTENV
	
		if ( avi_drvsta & AVILSI_DRV_ENV )
		{
			avi_env_ioctl(AVILSI_IOC_ENVEXIT,0);
		}
		
	#endif
	
	return 0;
}

static int __init avi_init(void)
{
	devfs_handle_t avi_devfs_handle;
	
	printk("\n" AVI_DRIVER_NAME" "AVI_DRIVER_VER " register\n");

	avi_devfs_handle = devfs_mk_dir (NULL, "avilsi", NULL);

	devfs_register(avi_devfs_handle, "0", DEVFS_FL_DEFAULT,
                        AVI_MAJOR, 0,
                        S_IFCHR | S_IRUSR | S_IWUSR, &avi_fops, NULL);

	avi_drvsta = 0;
	
	#ifdef TEST_DMA_CACHE
	
    	dma_rect();	
	
	#endif

	return 0;
}

module_init(avi_init);
module_exit(avi_exit);

MODULE_AUTHOR("Zxj");
MODULE_DESCRIPTION("Driver for avilsi");
MODULE_LICENSE("GPL");
EXPORT_NO_SYMBOLS;