

#ifndef _AVILSI_H_
#define _AVILSI_H_

#ifdef CONFIG_AVILSI


//global
#define AVI_DRIVER_NAME	"AVILSI Drivers"
#define AVI_DRIVER_VER	"0.1"

#define AVI_MAJOR 254

/******************drivers *******************/

#define AVILSI_DRV_ENV			1


#ifdef CONFIG_BOOTENV
	//u_boot environment start address
	#define AVILSI_BOOTENVADDR		0x20030000
	#define AVILSI_BOOTENVMAXSIZE	0x00010000	//u_boot agline by sector
	
	
	typedef	struct environment_s 
	{
		unsigned int crc;
		char data[ AVILSI_BOOTENVMAXSIZE - 4 ];
	} env_t;
	
	#define AVILSI_ENV_IP		"ipaddr"
	#define AVILSI_ENV_MAC		"ethaddr"
	#define AVILSI_ENV_BOOTARGS	"bootargs"
	#define AVILSI_ENV_SERIP	"serverip"
	
#endif /* CONFIG_BOOTENV */


/******************IOCTRL command *******************/
#define AVILSI_IOC_IDLE				0

#ifdef CONFIG_BOOTENV
	
	#define AVILSI_IOC_ENVINIT		1
	#define AVILSI_IOC_ENVEXIT		2

	#define AVILSI_IOC_GETBOOTARGS	3
	#define AVILSI_IOC_SETBOOTARGS	4
	
	#define AVILSI_IOC_GETMAC		5
	#define AVILSI_IOC_SETMAC		6
	
	#define AVILSI_IOC_GETIP		7
	#define AVILSI_IOC_SETIP		8
	
	#define AVILSI_IOC_GETSERIP		9
	#define AVILSI_IOC_SETSERIP		10
	
	#define AVILSI_IOC_SAVEENV		11
	
	#define AVILSI_IOC_ENDCMD		AVILSI_IOC_SAVEENV

#endif /* CONFIG_BOOTENV */


	#define AVILSI_IOC_MALLOC_NOR	100
	#define AVILSI_IOC_MALLOC_DMA	101
	#define AVILSI_IOC_FREE_NOR		102
	#define AVILSI_IOC_FREE_DMA		103




#endif /* CONFIG_AVILSI */


#endif /* _AVILSI_H_ */