/*
 * include/i2c.h
 *
 * i2c module difinition.
 *
 * (C) Copyright 2004 to 2005 ImageSilicon.
 *
 * Xinhong Wang, Dec. 25 2004, File Created.
 *
 */

#ifndef	_I2C_H_
#define _I2C_H_


#define I2C_ENABLE		1		/* 1=Enable I2c Module	*/
#define	I2C_BASE		0x43000000	/* 0b0100_0011	(APB)	*/

/************************************************************************
 * Register Offsets
 ************************************************************************/
#define I2C_REG_PRER_H		0x1A
#define I2C_REG_PRER_L		0x1E
#define I2C_REG_SR		0x06
#define I2C_REG_TXR		0x0A
#define I2C_REG_RXR		0x0E
#define I2C_REG_CTR		0x12
#define I2C_REG_CR		0x16

/************************************************************************
 * Register Bit Masks
 ************************************************************************/
#define I2C_CTR_EN		0x80	/* Control Register		*/
#define I2C_CTR_IEN		0x40
#define I2C_CTR_RSV0_6		0x3F

#define I2C_CR_STA		0x80	/* Command Register		*/
#define I2C_CR_STP		0x40
#define I2C_CR_WR		0x20
#define I2C_CR_RD		0x10
#define I2C_CR_IACK		0x08
#define I2C_CR_ACK		0x04
#define I2C_CR_RSV1_0		0x03

#define I2C_SR_RXACK		0x80	/* Status Register		*/
#define I2C_SR_BUSY		0x40
#define	I2C_SR_AL		0x20
#define I2C_SR_TIP		0x10
#define I2C_SR_IFLAG	0x08
#define I2C_SR_IFLAG_QUERY		0x04
#define I2C_SR_RSV2_0		0x03


/************************************************************************
 * Misc Macros
 ************************************************************************/
#define I2C_NON_BURST		0
#define I2C_IS_BURST		1

#define I2C_MAX_LOOP		(4000 * SYS_CPU_CLK/54)

//#define I2C_DEFAULT_FSCL	400/* Default I2C Clock = 400KHz */
#define I2C_MAX_RETRY		10

/********** Supported I2c Write&Read Mode is listed as follows **********
 *
 **WR Flow: (4954/4360/7121/7113/0297/1307)
 *	     mS m(Ad+W\) sA   mReg sA  (mData sA...) mP   <--Spec Flow
 *	    [Addr+W\]         [Reg]    [wData]	    [?]	  <--Data Array
 *	    [STA+WR+Ex]       [WR+Ex]  [WR+(Ex)...] [STP] <--Cmd  Array
 *   (INT)                 ^         ^          ^...    ^
 *
 *
 **RD Flow: (4954/4360/7121/7113/0297/1307)
 *	     mS m(Ad+W\) sA mReg sA mP  mS m(Ad+R) sA (sData1 mA...) mP
 *	    [Addr+W\]       [Reg]  [?]  [Addr+R]      [rData]        [?]
 *	    [STA+WR+Ex]     [WR+Ex][STP][STA+WR+Ex]   [RD+ACK]       [STP]
 *   (INT)                 ^       ^  ^              ^          ^...     ^
 *
 ************************************************************************/
#define I2C_MODE_WRITE		0x00
#define I2C_MODE_READ		0x01
#define I2C_MODE_BURST_WRITE	0x10
#define I2C_MODE_BURST_READ	0x11
#define I2C_MODE_UNKNOWN	0xFF

/************************************************************************
 * Read/Write Address Mask
 ************************************************************************/
#define	I2C_WRITE		0x00
#define	I2C_READ		0x01

#define I2C_WR_ADDR_FILTER	0xFE
#define I2C_RD_ADDR_MASK	0x01

#define SYS_APB_CLOCK CK_BUSCLK
/************************************************************************
 * I2c Clock Frequency Setting: PRER = F_sysclk / (5 * F_scl) - 1
 ************************************************************************/
#define I2C_PRER(x)		(SYS_APB_CLOCK/(10000*(x))-1) /* in KHz	*/

/************************************************************************
 * I2c Command / Status Defines
 ************************************************************************/
#define I2C_CMD_NULL		0x00

#define I2C_CMD_STA		I2C_CR_STA	/*		0x80	*/
#define I2C_CMD_STP		I2C_CR_STP	/* Cause Int	0x40	*/
#define I2C_CMD_WR		I2C_CR_WR	/* Cause Int	0x20	*/
#define I2C_CMD_RD		I2C_CR_RD	/* Cause Int	0x10	*/
#define I2C_CMD_IACK		I2C_CR_IACK	/*		0x08	*/
#define I2C_CMD_NACK		I2C_CR_ACK	/* 1=NACK	0x04	*/
#define I2C_CMD_ACK		0x00		/* 0=ACK	0x00	*/
#define I2C_CMD_EXACK		0x03		/* CR Bit[1:0] Reserved	*/

#define I2C_IS_CMD_EXACK(x)	((x)&0x03)	/* 0=CMD Expect No Ack	*/

/************************************************************************
 * Driver Status: [7:0] = STA STP WR RD NOACK DP TO AL
 ************************************************************************/
#define I2C_STATUS_NOERROR      0x00
#define I2C_STATUS_FREE         0x00	/*------> Not Running, No Err	*/
					/*------> Running, No Err Yet	*/
#define I2C_STATUS_START        I2C_CR_STA	/* 0x80 (Expect No Int)	*/
#define I2C_STATUS_STOP         I2C_CR_STP	/* 0x40 (Expecting Int)	*/
#define I2C_STATUS_WRITE        I2C_CR_WR	/* 0x20	(Expecting Int)	*/
#define I2C_STATUS_READ         I2C_CR_RD	/* 0x10	(Expecting Int)	*/
					/*------> Exit, Err Occur	*/
#define I2C_STATUS_NOACK        0x08		/* No Ack From Slave	*/
#define I2C_STATUS_DROP         0x04		/* Set when Drop Halfway*/
#define I2C_STATUS_TIMEOUT      0x02		/* Set when Timeout	*/
#define I2C_STATUS_AL           0x01		/* Set when AL Happens	*/

#define I2C_IS_RUNNING(x)	((x)&0x70)

#define I2C_CMD_STATUS_RUNNING	0x01		/* One command Running	*/
#define I2C_CMD_STATUS_FREE	0x00		/* No command is running*/

#define I2C_SEMAPHORE_TIMEOUT 	0

#endif
