#ifndef __SPI_H__
#define __SPI_H__
#include <linux/types.h>
//SPIж״̬
#define INT_IDLE 0
#define INT_TXDFIFO 1		//txdfifo<= txdffi_level interrupt
#define INT_RXDFIFO 2		//rxdfifo>= rxdffi_level interrupt
#define INT_GEN 3			//general SPI TXD or RXD interrupt
#define INT_WRITE 4			//spd write  interrupt
#define INT_READ 5			//spd read interrupt
#define INT_ERROR 6			//register error interrupt


/* spi I/O addr 1th base addr is 0x60040000 2th is 0x60050000*/
//#define SPI_BASE_ADDR (0X60040000)
#define SPI0_BASE_ADDR (0X60040000)
#define SPI1_BASE_ADDR (0X60050000)

#define	SPI_TXDB_OFFSET         0x0
#define	SPI_RXDB_OFFSET         0x4
#define	SPI_BOUND_OFFSET        0x8
#define	SPI_MODECONF_OFFSET     0xc
#define	SPI_INTCONF_OFFSET      0x10
#define	SPI_TC_OFFSET           0x14
#define	SPI_CTRL_OFFSET         0x18
#define	SPI_STATE_OFFSET        0x1c
#define	SPI_SPD_OFFSET          0x20
#define	SPI_SPD_LEN_OFFSET      0x24

#define PHASE_CLK          1
#define BITS               0x7
#define CLOCK_DELAY_TIMES  10
#define CPHA               1
#define CPOL               1
#define LSB                0
#define PCK_MOD            1 
#define HOLD_EN            0
#define FLASH_MOD          1
#define TX_DELAY           1
#define RX_DELAY           1
#define RESET              1
#define SEND_ADV           1
#define ISR_ENABLE         0
#define TXDFFI_LEVEL       0x10
#define RXDFFI_LEVEL       0x10
#define COPMLETEIE         1
#define TRANS_CNT          0
#define BAUD               0x2
#define STARTED            0
#define CR_CS              0xF
#define REG_FF_ST_EN       0
#define REG_CRC_EN         0
#define REG_BMULT          0
#define DIRECTION          0


#define SPI1TH              (0)   ///һ·SPIƬѡ
#define SPI2TH              (1)	  ///ڶ·SPIƬѡ
#define SPI_CMDLEN_MASK     0xFF00FFFC

#define SWAP_DEF 1
#ifdef SWAP_DEF
#define SWAP16(x)	((((x) & 0xff) << 8) | ((x) >> 8))
#define SWAP16c(x)	((((x) & 0xff) << 8) | ((x) >> 8))
#define SWAP32(x)       ( \
	                (((x) >> 24) & 0x000000ff) | \
        		(((x) >>  8) & 0x0000ff00) | \
		        (((x) <<  8) & 0x00ff0000) | \
		        (((x) << 24) & 0xff000000) )

#else
#define SWAP16(x)	(x)
#define SWAP16c(x)	(x)
#define SWAP32(x)   (x)
#endif

#define SPI_READ_FIFO_MAX       ( 128 )
#define SPI_CMD_FIFO_MAX        ( 4 )

enum
{
    SPI_FLASH_MODE  =  0,
    SPI_NORMAL_MODE  = 1
};

void spi_init(void);
int spi_normal_mode_send(unsigned char ctr_num, unsigned int *tbuf, unsigned int tcnt );
int spi_normal_mode_recive( unsigned char ctr_num, unsigned int *rbuf, unsigned int rcnt );
int spi_flash_mode_send_for_recv( u8 ctr_num, u32 cmd,  u32 cmdcnt, u32 *recvbuf, u32 recvcnt );
int spi_flash_mode_send_cmd( u8 ctr_num, u32 cmd, u8 cmdcnt );
int spi_flash_mode_send_cmd_data( u8 ctr_num, u32 cmd, u32 addr, u32 *psendbuf, u32 sendcnt );

#endif
