/*
 *  drivers/mtd/nandids.c
 *
 *  Copyright (C) 2002 Thomas Gleixner (tglx@linutronix.de)
 *
 *
 * $Id: nand_ids.c,v 1.1.1.1 2005/01/17 01:39:56 licq Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#include <linux/module.h>
#include <linux/mtd/spi_nand.h>

/*
*	Chip ID list
*/
struct spi_nand_flash_dev spi_nand_flash_ids[] = {
	{"SPI NAND 8MB 3.3V", 0x4017, 23, 0x1000},	// 8Mb 3.3V
	{"SPI NAND 4MB 3.3V", 0x2016, 22, 0x2000},	// 4Mb 3.3V
	{NULL,}
};

/*
*	Manufacturer ID list
*/
struct spi_nand_manufacturers spi_nand_manuf_ids[] = {
	{NAND_MFR_WINBOND, "Winbond"},
	{NAND_MFR_DAHUA  , "dahua"},
	{0x0, "Unknown"}
};


EXPORT_SYMBOL (spi_nand_manuf_ids);
EXPORT_SYMBOL (spi_nand_flash_ids);

MODULE_LICENSE ("GPL");
MODULE_AUTHOR ("Thomas Gleixner <tglx@linutronix.de>");
MODULE_DESCRIPTION ("Nand device & manufacturer ID's");
