/*
**  ģļ
*/

#include "vs28xx.h"
#include "pci.h"
#include "im.h"
#include "yuv.h"
#include "list.h"
#include "preview.h"

static unsigned long s_refYup;
static unsigned long s_refMapup;


/*
**  ؼ֡
**  yݽ33ͨnvԤ16ͨݳӦòᳬ1D1
**  mapݽ50ͨmuxԤ16ͨ
*/
int kf_frame(int ch)
{
    int ret;
    unsigned long *pul;
    yuv_type_t *p0;
    dma_info_t dmaInfo;

    /* жʹλ */
    if (ch < 8)
    {
        ret = (read_reg(0x612600D0) >> (ch << 2)) & 0x7;
    }
    else
    {
        ret = (read_reg(0x612600D4) >> ((ch - 8) << 2)) & 0x7;
    }

    if (0 == ret)
    {
        return 0;
    }

    if (0 == id_pre_kf_y_len || 0 == id_pre_kf_map_len || id_pre_kf_y_len > 0x100000
        || id_pre_kf_map_len > 0x10000 || 0 == s_refYup || 0 == s_refMapup)
    {
        PRINT(ERR, "kf_frame fail para %#lx %#lx %#lx %#lx\n",
            id_pre_kf_y_len, id_pre_kf_map_len, s_refYup, s_refMapup);
        return 0;
    }

    pul = (unsigned long *)(dmaInfo.msgBuffer);
    pul[0] = byte_swap4(33);                        /* ͨnvԤ16ͨ */
    pul[1] = byte_swap4(id_pre_kf_y_len);           /*  */

	p0 = (yuv_type_t *)(pul + 2);                   /* ֻΪ˲֤ߺͳȵĹϵ */
	p0->yuv = 1;
	p0->pack = 0;
    p0->qua = 0x56;

    dmaInfo.pciAddr = g_ulPreAddr[1][16];           /* nvԤ16ͨ */
    dmaInfo.ahbAddr = s_refYup;
    dmaInfo.dmaLength = id_pre_kf_y_len;
    dmaInfo.module = 0;                             /* Ҫص */
    dmaInfo.command = 0xB1;
    dmaInfo.msgLength = 16;

    ret = pci_dma_write(&dmaInfo, 0, 0);            /* ΪжԲҪж */
    if (ret != 0)
    {
        PRINT(ERR, "kf write fail0\n");
    }

    pul = (unsigned long *)(dmaInfo.msgBuffer);
    pul[0] = byte_swap4(50);                        /* ͨMUXԤ16ͨ */
    pul[1] = byte_swap4(id_pre_kf_map_len);         /*  */

	p0 = (yuv_type_t *)(pul + 2);                   /* ֻΪ˲֤ߺͳȵĹϵ */
	p0->yuv = 1;
	p0->pack = 0;
    p0->qua = 0x56;

    dmaInfo.pciAddr = g_ulPreAddr[2][16];           /* MUXԤ16ͨ */
    dmaInfo.ahbAddr = s_refMapup;
    dmaInfo.dmaLength = id_pre_kf_map_len;
    dmaInfo.module = 0;                             /* Ҫص */
    dmaInfo.command = 0xB1;
    dmaInfo.msgLength = 16;

    ret = pci_dma_write(&dmaInfo, 0, 0);            /* ΪжԲҪж */
    if (ret != 0)
    {
        PRINT(ERR, "kf write fail1\n");
    }

    return 0;
}


/*
**  ؼ֡ģʼ
*/
void kf_init(void)
{
    int i;
    unsigned long kfCntThr;

    /*
    **  ڴ룬һֻʹһͨͨڴ
    **  w * h * 2?
    */
    s_refYup = get_memory(0x100000);
    if (0 == s_refYup)
    {
        PRINT(ERR, "kf_init fail\n");
        return;
    }

    /* w * h * 2 / 64? */
    s_refMapup = get_memory(0x10000);
    if (0 == s_refMapup)
    {
        PRINT(ERR, "kf_init fail\n");
        return;
    }

    /* [kfCntThr = frame_height * 6 / 8 * (frame_width - 2) * N_THR_MAIN / 128] */
    /* [kfCntThr = frame_height * 6 / 8 * (frame_width - 2) * 40 / 128] */
    /* ͨʼӦһ£ʹ0ͨ */
    kfCntThr = g_nPreSrcHeight[0] * (g_nPreSrcWidth[0] - 2) * 15 / 64;

    for (i = 0; i < 16; i++)
    {
        write_reg(g_ulList_s + (i << 10) + 0x334, 0x140C2808);
        write_reg(g_ulList_s + (i << 10) + 0x338, 0x01F4000C);
        write_reg(g_ulList_s + (i << 10) + 0x33C, kfCntThr);

        write_reg(g_ulList_s + (i << 10) + 0x344, s_refYup);
        write_reg(g_ulList_s + (i << 10) + 0x348, s_refMapup);
    }

    return;
}
