/*
**  jpegģļ
*/

#include "vs28xx.h"
#include "log.h"
#include "pci.h"
#include "yuv.h"
#include "reg/enc_reg.h"
#include "reg/jpeg_reg.h"
#include "jpeg.h"

//#define USE_TIMER

#ifdef USE_TIMER
#define DMA_IRQ                     1               /* ʱʹdmaҪж */
#define JPEG_TIMER_INTERVAL         10              /* ʱΪ10 */
struct timer_list jpeg_timer;
#else
#define DMA_IRQ                     0               /* жʹdmaҪж */
#endif

static unsigned long s_ulJpegDmaAddr[17];           /* jpeg dmaַ */

static unsigned long s_ulJpegStartAddr[17];         /* jpegʼַ4K룬ڴŲjepg */
static unsigned long s_ulJpegEndAddr[17];           /* jpegЧڴĽַ */

static unsigned long s_ulCurChannel;                /* ǰڲjpegͨ */
static int s_nJpegContinue;                         /* Ƿץͼı־ */
static int s_nJpegDoingDma;                         /* ־Ƿjpeg dma */


/*
**  jpeg dmaַȲܳ
**  0x65
*/
void cmd_jpg_set_dma_addr(unsigned char *pucData, int nLength)
{
    int i;
    unsigned long len;
    msg_jdma_t *pMsg;

    FUNC_TRACK(0x65);

    pMsg = (msg_jdma_t *)pucData;
    s_ulJpegDmaAddr[0] = byte_swap4(pMsg->addr);    /* pc˽jpegݵĻַ */
    len = byte_swap4(pMsg->len);                    /* pc˽jpegݵĻ */

    if (len >= 0x1100000)                           /* ռ㹻ʱÿͨ1M */
    {
        for (i = 1; i < 17; i++)
        {
            s_ulJpegDmaAddr[i] = s_ulJpegDmaAddr[i - 1] + 0x100000;
        }
    }
    else                                            /* ռ䲻ʱͨdmaַ */
    {
        for (i = 1; i < 17; i++)
        {
            s_ulJpegDmaAddr[i] = s_ulJpegDmaAddr[0];
        }
    }

    return;
}


/*
**  jpeg
**  0x64
*/
void cmd_jpg_set_switch(unsigned char *pucData, int nLength)
{
    msg_jpeg_switch_t *pMsg;
    unsigned long ch;
    unsigned long ulSwitch;
    unsigned char btContinue;
    unsigned char btQuality;

    FUNC_TRACK(0x64);

    if (s_nJpegDoingDma)
    {
        FUNC_COUNTER(0x64, 0x00);
        PRINT(WARN, "jpeg dma not finish\n");
        return;
    }

    pMsg = (msg_jpeg_switch_t *)pucData;
    ch = byte_swap4(pMsg->channel);
    ulSwitch = byte_swap4(pMsg->enable);
    btContinue = pMsg->motion;
    btQuality = pMsg->quality;

    if (ch > 16)                                    /* ֤ͨ */
    {
        FUNC_COUNTER(0x64, 0x01);
        PRINT(ERR, "jpeg_set_switch channel invalid 0x%lx\n", ch);
        return;
    }

    if (btQuality > 19)                             /* ֤ӣ0-13ʾӲӣ14-19Ӧ0-5 */
    {
        FUNC_COUNTER(0x64, 0x02);
        PRINT(ERR, "jpeg_set_switch quality invalid %d\n", btQuality);
        return;
    }

    if (0 == ulSwitch)                              /* رjpeg */
    {
        s_nJpegContinue = 0;
        PRINT(INFO, "jpeg stop 0x%lx\n", ch);
        return;
    }

    if (1 == btContinue)                            /* ץͼ */
    {
        s_nJpegContinue = 1;
    }

    s_ulCurChannel = ch;                            /* ͨ */

    hw_jpg_set_addr(ch, s_ulJpegStartAddr[ch], s_ulJpegEndAddr[ch]);    /* jpegַ */

    hw_jpg_set_quality(ch, btQuality);              /* jpeg */

    hw_jpg_enable(ch);                              /* ʹjpegץͼ */

    return;
}


/*
**  jpegʹdmaʱĻص
**  0x63
*/
void jpeg_dma_finish(void)
{
    FUNC_TRACK(0x63);

    s_nJpegDoingDma = 0;                            /* jpeg dma */

    if (s_nJpegContinue)                            /* һ֡jpegͳȥ֮Ҫץͼʹ */
    {
        FUNC_COUNTER(0x63, 0x00);                   /* ¼ץͼĴ */

        hw_jpg_enable(s_ulCurChannel);              /* ʹjpegץͼ */
    }

#ifdef VS28XX_MODE_ID
    id_frame_jiffies = jiffies;                     /* ʾԻ */
#endif

    return;
}


/*
**  jpegж
**  ʹöʱʱҲô
**  0x62
*/
#ifdef USE_TIMER
static void jpeg_handler(unsigned long v)
#else
static void jpeg_handler(int irq, void *dummy, struct pt_regs *regs)
#endif
{
    int i;
    int ret;
    unsigned long chs;
    unsigned long ulLength;
    unsigned long ulSendLength;
    unsigned long *pul;
    dma_info_t dmaInfo;

    FUNC_TRACK(0x62);

    chs = hw_jpg_get_channel();                     /* ȡжϵͨжԼͲ */
    if (chs)
    {
        for (i = 0; i < 17; i++)
        {
            if ((chs >> i) & 0x1)
            {
                IRQ_COUNTER(i, LOG_JPEG);                       /* ͨ(jpeg)жϼ */

                /*
                **  ȡjpegݳȣжϳȺϷ
                */
                ulLength = hw_jpg_analyze(i, s_ulJpegStartAddr[i], s_ulJpegEndAddr[i]);
                if (-1 == ulLength)
                {
                    FUNC_COUNTER(0x62, 0x01);
                    PRINT(ERR, "jpeg_analyze fail %d\n", i);
                    continue;
                }

                ret = ulLength & 0x3;                           /* dmaʱҪ4ֽڶ */
                if (0 == ret)
                {
                    ulSendLength = ulLength;
                }
                else
                {
                    ulSendLength = ulLength + 4 - ret;
                }

                pul = (unsigned long *)(dmaInfo.msgBuffer);
                pul[0] = byte_swap4(i);
                pul[1] = byte_swap4(ulLength);

                dmaInfo.pciAddr = s_ulJpegDmaAddr[i];
                dmaInfo.ahbAddr = s_ulJpegStartAddr[i] + 8;     /* jpegͷ8ֽΪϢ */
                dmaInfo.dmaLength = ulSendLength;
                dmaInfo.module = DMA_JPEG;
                dmaInfo.command = 0xB3;
                dmaInfo.msgLength = 8;

                s_nJpegDoingDma = 1;                            /* jpeg dma */

                /* ӵdmaУֻܵȴɺ󣬲һjpegץͼ */
                ret = pci_dma_write(&dmaInfo, 0, DMA_IRQ);
                if (ret != 0)
                {
                    s_nJpegDoingDma = 0;
                    FUNC_COUNTER(0x62, 0x02);
                    PRINT(ERR, "jpeg dma fail %d\n", i);
                }
            } /* if ((chs >> i) & 0x1)*/
        } /* for (i = 0; i < 17; i++;) */
    } /* if (chs) */

#ifdef USE_TIMER
    jpeg_timer.data = 0;
    jpeg_timer.function = jpeg_handler;
    jpeg_timer.expires = jiffies + JPEG_TIMER_INTERVAL;
    add_timer(&jpeg_timer);
#endif

    return;
}


/*
**  jpegģע
**  0x61
*/
void jpeg_exit(void)
{
    FUNC_TRACK(0x61);

#ifndef USE_TIMER
    disable_irq(JPEG_IRQ);                          /* ͷjpegж */
    free_irq(JPEG_IRQ, 0);
#endif

    return;
}


/*
**  jpegģʼ
**  0x60
*/
int jpeg_init(void)
{
    int i;
    int ret;
    unsigned long mem;

    FUNC_TRACK(0x60);

    mem = get_memory(JPEG_TOT_SIZE);                /* jpegڴ棬뵽ڴ4K */
    if (0 == mem)
    {
        FUNC_COUNTER(0x60, 0x00);
        PRINT(ERR, "jpeg_init memory fail\n");
        return -1;
    }

    for (i = 0; i < 17; i++)
    {
        /* jpegڴʼַ */
        s_ulJpegStartAddr[i] = mem + i * JPEG_MEM_SIZE;

        /* jpegڴַĽַһֽ */
        s_ulJpegEndAddr[i] = s_ulJpegStartAddr[i] + JPEG_MEM_SIZE  - 1;

        hw_jpg_set_addr(i, s_ulJpegStartAddr[i], s_ulJpegEndAddr[i]);
    }

    hw_jpg_quant_init();                            /* ʼ */

    hw_jpg_quant_table(JSQ_BADDR);                  /* ַ */

    hw_jpg_set_clock(0x9000000);                    /* һ֡ʱ */

    hw_jpg_set_mask(0, 0);                          /* jpegжϣÿж϶ͳ */

    /*
    **  עjpegʹdmaʱĻص
    **  ҪΪֻһƬjpegڴ棬һֻܴһ֡ݣҪϴεjpeg꣬һεjpegץͼ
    */
    register_dma_callback(DMA_JPEG, jpeg_dma_finish);

#ifdef USE_TIMER
    jpeg_timer.data = 0;
    jpeg_timer.function = jpeg_handler;
    jpeg_timer.expires = jiffies + JPEG_TIMER_INTERVAL;
    add_timer(&jpeg_timer);
#else
    ret = request_irq(JPEG_IRQ, jpeg_handler, SA_INTERRUPT, "jpeg_handler", 0);
    if(ret != 0)
    {
        FUNC_COUNTER(0x60, 0x01);
        PRINT(ERR, "jpeg_init request_irq fail\n");
        return -1;
    }
    enable_irq(JPEG_IRQ);
#endif

    PRINT(INFO, "jpeg_init 0x%lx\n", s_ulJpegStartAddr);

    return 0;
}
