/*
**  listģļ
*/

#include "vs28xx.h"
#include "log.h"
#include "list.h"

unsigned long g_ulList_h0 = 0;                      /* Ӳʹõlist0 */
unsigned long g_ulList_h1 = 0;                      /* Ӳʹõlist1 */
unsigned long g_ulList_s = 0;                       /* ʹõlist*/


/*
**  дlist
**  0x0A
*/
void write_list(unsigned long ch, unsigned long addr, unsigned long val)
{
	write_reg(g_ulList_s + (ch << 10) + (addr << 2), val);
	return;
}

/*
**  ˢlist
**  0x09
*/
void update_list(unsigned long ch)
{
    int i;
    unsigned long val0;
    unsigned long val1;
    unsigned long mask;

    FUNC_TRACK(0x09);

    /*
    **  ֻ0-15ͨlistcom, ĴֵlistȲ
    */
    if (ch > 16)
    {
        FUNC_COUNTER(0x09, 0x00);
        return;
    }

    /*
    **  08ĴӦλΪ1ʱܲ3
    */
    mask = (0x1 << ch);
    for (i = 0; i < 3; i++)
    {
        val0 = read_reg(0x61260008);
        if (val0 & mask)
        {
            /*
            **  ɹʱ
            **  ֮ǰĴӡǾ
            */
            udelay(10);
        }
        else
        {
            break;
        }
    }
    if (3 == i)
    {
        FUNC_COUNTER(0x09, 0x01);
        PRINT(ERR, "update_list fail!\n");
        return;
    }
    val0 |= mask;

    /*
    **  00ĴӦλΪ1ʱlist1Ϊ0ʱlist0֮ѶӦλȡ
    */
    val1 = read_reg(0x61260000);
    if (val1 & mask)
    {
        memcpy((void *)(g_ulList_h1 + (ch << 10)), (void *)(g_ulList_s + (ch << 10)), 0x400);
        val1 &= ~mask;
    }
    else
    {
        memcpy((void *)(g_ulList_h0 + (ch << 10)), (void *)(g_ulList_s + (ch << 10)), 0x400);
        val1 |= mask;
    }

    write_reg(0x61260000, val1);                    /* 00ĴӦλȡ */

    write_reg(0x61260008, val0);                    /* 08ĴӦλ1 */

    write_reg(0x6126000C, 0x10000000);              /* bit281list idЧ */

    return;
}


/*
**  Ϻ󣬿listӲlist
**  ֻϵͳvs28xx_initһ
**  0x08
*/
void list_fill_para_finish(void)
{
    FUNC_TRACK(0x08);

    /* list */
    memcpy((void *)g_ulList_h0, (void *)g_ulList_s, 0x4400);
    memcpy((void *)g_ulList_h1, (void *)g_ulList_s, 0x4400);

    /* ˢlist ch0-ch15, com */
    write_reg(0x61260000, 0x1FFFF);

    write_reg(0x6126000C, 0x10000000);              /* bit281list idЧ */

    return;
}


/*
**  listģע
**  0x07
*/
void list_exit(void)
{
    FUNC_TRACK(0x07);
    return;
}


/*
**  listģʼ
**  Ҫڴ棬Ӳʹbankлһbank17K16ͨÿͨ1KԼĹò1K
**  ΪȷbankлʱͨڲĲһԣĿǰõĻǣͳһд3bankٸӲ״̬
**  ͨ1KݵӦӲbank
**
**  0x06
*/
int list_init(void)
{
    FUNC_TRACK(0x06);

    g_ulList_h0 = get_memory(0x10000);              /* listڴ棬Ҫ3ÿ17Kռ64K */
    if (0 == g_ulList_h0)
    {
        FUNC_COUNTER(0x06, 0x00);
        return -1;
    }

    /*
    **  listĲǣ17kӲlist017kӲlist117klist
    */
    g_ulList_h1 = g_ulList_h0 + 0x4400;
    g_ulList_s = g_ulList_h1 + 0x4400;

    /*
    **  listú֮ҪlistӲlist
    **  ʵһһ䣬memset((void *)g_ulList_s, 0, 0x4400);
    **  ǺظͶ֣effect_init0ͨ15ͨȷͨʼһ
    **  Уlist֣ͨǰ20Ĵǽ⽻Ȳ׼ʡһ
    **  listĹò֣ǰ174ĴǽȲҲǷŵҲʡȥⲿ
    **  effect_initӦûlist_init汻
    **
    **  listδõĲ֣Ҳͳһ0
    */
    memset((void *)(g_ulList_s + 0x50), 0, 0x3B0);
    memset((void *)(g_ulList_s + 0x42B8), 0, 0x148);

    write_reg(0x61260004, g_ulList_h0);             /* дlistַ */

    PRINT(INFO, "list_init 0x%lx\n", g_ulList_h0);

    return 0;
}
