/*
**  ־ͷļ
*/

#ifndef _VS28XX_LOG_H_
#define _VS28XX_LOG_H_

#include <linux/string.h>       /* memset */
#include "vs28xx.h"

/*
**  28012811ϵͳ432λʱӣtimer0ʹãtimer1δtimer2timer3ʹ
**  ʱӸλtimer3ʱӵλtimer2
*/
#define SYSTEM_CLOCK_L      0x70000078      /* ϵͳʱӵλ */
#define SYSTEM_CLOCK_H      0x7000007C      /* ϵͳʱӸλ */

#define GLOBAL_LOG_ADDR     0xC0010000      /* ȫ־1Kɰ256Ŀ */
#define FUNCTION_LOG_ADDR   0xC0010400      /* ־16Kÿ64ֽڣɰ256 */
#define CHANNEL_LOG_ADDR    0xC0014400      /* ͨ־16Kÿͨ256ֽڣɰ64ͨ */
#define LOG_SIZE            0x8400          /* ־ȣĿǰ33k */

#define FUNC_BIT            6               /* ÿ־ռ64ֽڣ˰Ѻid6λͿԶλ */
#define CHN_BIT             8               /* ÿͨ־ռ256ֽڣ˰ͨ8λͿԶλ */

#define LOG_ENC             0               /* ־ */
#define LOG_PRE             1               /* Ԥ־ */
#define LOG_JPEG            2               /* jpeg־ */
#define LOG_AUDIO           3               /* Ƶ־ */


/*
**  ־ʹ64ֽڣÿ4ֽڣ16£
**  00.ʱӸλ
**  01.ʱӵλ
**  02.ô
**  03.1
**  04.2
**  05.3
**  06.4
**  07.Ϣ1
**  08.Ϣ2
**  09.Ϣ3
**  0A.Ϣ4
**  0B.1
**  0C.2
**  0D.3
**  0E.4
**  0F.5
**
**  ʱڼ¼ʱ
**  ʾʱĲ
**  Ϣڼ¼һĺϢ
**  ʾĳЩ״ķ
**  ע⣬ϢÿдҪȶأһд
**
**  ȻֲϢͼֻһ㶨壬ͬĺвͬ÷
*/


/*
**  ͨ־ʹ256ֽڣÿ4ֽڣ£
**  00.жϼ
**  01.Ԥжϼ
**  02.jpegжϼ
**  03.Ƶжϼ
**  04.
**  05.
**  06.
**  07.
**  08.뿪
**  09.Ԥ
**  0A.jpeg
**  0B.Ƶ
**  0C.
**  0D.
**  0E.
**  0F.
**  10.Ԥֱ
**  11.Ԥ
**  12.Ԥ߶
**  13.Ԥpcַ
**  14.
**  15.
**  16.
**  17.
**  18.Ԥ⽻
**  19.Ԥǿ
**  1A.Ԥ뿪
*/


/*
**  ־Ӧģʼʹãʹκ־֮ǰ
*/
#define ZERO_LOG()                                                      \
do {                                                                    \
    memset((void *)GLOBAL_LOG_ADDR, 0, LOG_SIZE);                       \
} while(0)


/*
**  ͨжϼ
**  chʾͨtʾж(ͬʱҲʾƫ)
**  tӦʹLOG_ENC,LOG_PREȺ
*/
#define IRQ_COUNTER(ch, t)                                              \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(CHANNEL_LOG_ADDR + (ch << CHN_BIT));          \
                                                                        \
    p[t]++;                                                             \
                                                                        \
} while(0)


/*
**  ͨ
**  chʾͨtʾͣsʾ
**  tӦʹLOG_ENC,LOG_PREȺ
*/
#define CH_SWITCH(ch, t, s)                                             \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(CHANNEL_LOG_ADDR + (ch << CHN_BIT));          \
                                                                        \
    p[t + 8] = (unsigned long)(s);                                      \
                                                                        \
} while(0)


/*
**  ԤϢ
**  chʾͨ
**  qʾֱ
**  wʾ
**  hʾ߶
**  aʾpcַ
*/
#define PRE_INFO(ch, q, w, h, a)                                        \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(CHANNEL_LOG_ADDR + (ch << CHN_BIT));          \
                                                                        \
    p[0x10] = (unsigned long)(q);                                       \
    p[0x11] = (unsigned long)(w);                                       \
    p[0x12] = (unsigned long)(h);                                       \
    p[0x13] = (unsigned long)(a);                                       \
                                                                        \
} while(0)


/*
**  Ԥ⽻ǿ뿪
**  chʾͨ
**  tΪ0ʾ⽻1ʾǿ2ʾ
**  sʾ
*/
#define PRE_ENH(ch, t, s)                                               \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(CHANNEL_LOG_ADDR + (ch << CHN_BIT));          \
                                                                        \
    p[0x18 + t] = (unsigned long)(s);                                   \
                                                                        \
} while(0)


/*
**  ¼ʱ䣬ѵô1
**  idֺ־СΪ64ֽڣƫҲ64ֽ
**  Ӧںʼʹ
*/
#define FUNC_TRACK(id)                                                  \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(FUNCTION_LOG_ADDR + (id << FUNC_BIT));        \
                                                                        \
    p[0] = read_reg(SYSTEM_CLOCK_H);                                    \
    p[1] = read_reg(SYSTEM_CLOCK_L);                                    \
    p[2]++;                                                             \
                                                                        \
} while(0)


/*
**  ״
**  idʾnʾƫӺ־4ʼ
**  ʹʱע
*/
#define FUNC_COUNTER(id, n)                                             \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(FUNCTION_LOG_ADDR + (id << FUNC_BIT));        \
                                                                        \
    p[n + 3]++;                                                         \
                                                                        \
} while(0)


/*
**  ¼Ϣ
**  idʾnʾƫpaʾ¼ϢӺ־4ʼ
**  ʹʱע
*/
#define FUNC_INFO1(id, n, pa)                                           \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(FUNCTION_LOG_ADDR + (id << FUNC_BIT));        \
                                                                        \
    p[n + 3] = (unsigned long)(pa);                                     \
                                                                        \
} while(0)


/*
**  ¼Ϣ
**  idʾnʾƫpaʾ¼ϢӺ־4ʼ
**  ʹʱע
*/
#define FUNC_INFO2(id, n, pa1, pa2)                                     \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(FUNCTION_LOG_ADDR + (id << FUNC_BIT));        \
                                                                        \
    p[n + 3] = (unsigned long)(pa1);                                    \
    p[n + 4] = (unsigned long)(pa2);                                    \
                                                                        \
} while(0)


/*
**  ¼Ϣ
**  idʾnʾƫpaʾ¼ϢӺ־4ʼ
**  ʹʱע
*/
#define FUNC_INFO3(id, n, pa1, pa2, pa3)                                \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(FUNCTION_LOG_ADDR + (id << FUNC_BIT));        \
                                                                        \
    p[n + 3] = (unsigned long)(pa1);                                    \
    p[n + 4] = (unsigned long)(pa2);                                    \
    p[n + 5] = (unsigned long)(pa3);                                    \
                                                                        \
} while(0)


/*
**  ¼Ϣ
**  idʾnʾƫpaʾ¼ϢӺ־4ʼ
**  ʹʱע
*/
#define FUNC_INFO4(id, n, pa1, pa2, pa3, pa4)                           \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(FUNCTION_LOG_ADDR + (id << FUNC_BIT));        \
                                                                        \
    p[n + 3] = (unsigned long)(pa1);                                    \
    p[n + 4] = (unsigned long)(pa2);                                    \
    p[n + 5] = (unsigned long)(pa3);                                    \
    p[n + 6] = (unsigned long)(pa4);                                    \
                                                                        \
} while(0)


/*
**  ¼1
**  FUNC_TRACKǶ¼1
*/
#define FUNC_PARA1(id, pa)                                              \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(FUNCTION_LOG_ADDR + (id << FUNC_BIT));        \
                                                                        \
    p[0] = read_reg(SYSTEM_CLOCK_H);                                    \
    p[1] = read_reg(SYSTEM_CLOCK_L);                                    \
    p[2]++;                                                             \
    p[3] = (unsigned long)(pa);                                         \
                                                                        \
} while(0)


/*
**  ¼2
*/
#define FUNC_PARA2(id, pa1, pa2)                                        \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(FUNCTION_LOG_ADDR + (id << FUNC_BIT));        \
                                                                        \
    p[0] = read_reg(SYSTEM_CLOCK_H);                                    \
    p[1] = read_reg(SYSTEM_CLOCK_L);                                    \
    p[2]++;                                                             \
    p[3] = (unsigned long)(pa1);                                        \
    p[4] = (unsigned long)(pa2);                                        \
                                                                        \
} while(0)


/*
**  ¼3
*/
#define FUNC_PARA3(id, pa1, pa2, pa3)                                   \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(FUNCTION_LOG_ADDR + (id << FUNC_BIT));        \
                                                                        \
    p[0] = read_reg(SYSTEM_CLOCK_H);                                    \
    p[1] = read_reg(SYSTEM_CLOCK_L);                                    \
    p[2]++;                                                             \
    p[3] = (unsigned long)(pa1);                                        \
    p[4] = (unsigned long)(pa2);                                        \
    p[5] = (unsigned long)(pa3);                                        \
                                                                        \
} while(0)


/*
**  ¼4
*/
#define FUNC_PARA4(id, pa1, pa2, pa3, pa4)                              \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(FUNCTION_LOG_ADDR + (id << FUNC_BIT));        \
                                                                        \
    p[0] = read_reg(SYSTEM_CLOCK_H);                                    \
    p[1] = read_reg(SYSTEM_CLOCK_L);                                    \
    p[2]++;                                                             \
    p[3] = (unsigned long)(pa1);                                        \
    p[4] = (unsigned long)(pa2);                                        \
    p[5] = (unsigned long)(pa3);                                        \
    p[6] = (unsigned long)(pa4);                                        \
                                                                        \
} while(0)


/*
**  ¼5
*/
#define FUNC_PARA5(id, pa1, pa2, pa3, pa4, pa5)                         \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(FUNCTION_LOG_ADDR + (id << FUNC_BIT));        \
                                                                        \
    p[0] = read_reg(SYSTEM_CLOCK_H);                                    \
    p[1] = read_reg(SYSTEM_CLOCK_L);                                    \
    p[2]++;                                                             \
    p[3] = (unsigned long)(pa1);                                        \
    p[4] = (unsigned long)(pa2);                                        \
    p[5] = (unsigned long)(pa3);                                        \
    p[6] = (unsigned long)(pa4);                                        \
    p[7] = (unsigned long)(pa5);                                        \
                                                                        \
} while(0)


/*
**  ¼6
*/
#define FUNC_PARA6(id, pa1, pa2, pa3, pa4, pa5, pa6)                    \
do {                                                                    \
    unsigned long *p;                                                   \
                                                                        \
    p = (unsigned long *)(FUNCTION_LOG_ADDR + (id << FUNC_BIT));        \
                                                                        \
    p[0] = read_reg(SYSTEM_CLOCK_H);                                    \
    p[1] = read_reg(SYSTEM_CLOCK_L);                                    \
    p[2]++;                                                             \
    p[3] = (unsigned long)(pa1);                                        \
    p[4] = (unsigned long)(pa2);                                        \
    p[5] = (unsigned long)(pa3);                                        \
    p[6] = (unsigned long)(pa4);                                        \
    p[7] = (unsigned long)(pa5);                                        \
    p[8] = (unsigned long)(pa6);                                        \
                                                                        \
} while(0)

#endif
