/*
**  ģļ
*/

#include "vs28xx.h"
#include "list.h"
#include "log.h"
#include "pci.h"
#include "md.h"
#include "enc.h"
#include "yuv.h"
#include "preview.h"

static unsigned long s_ulBakAddr0;                  /* ַ0ж֮󣬰Ѷ֡ת */
static unsigned long s_ulBakAddr1;                  /* ַ1ҪڴԤʱв */
static unsigned long s_ulDiffAddr0;                 /* вַ0 */
static unsigned long s_ulDiffAddr1;                 /* вַ1 */
static unsigned long s_ulOriAddr;                   /* οַ֡ */

unsigned long g_ulMaskAddr;                         /* ַ */


/*
**  öä쿪
**  0x36
*/
void cmd_md_set_switch(unsigned char *pucData, int nLength)
{
    unsigned long ch;
    unsigned long swh;
    unsigned long ulValue;
    msg_switch_t *pMsg;

    FUNC_TRACK(0x36);

    if (nLength != sizeof(msg_switch_t))            /* ֤ݳ */
    {
        FUNC_COUNTER(0x36, 0x00);
        PRINT(ERR, "set_motion_swh len %d\n", nLength);
        return;
    }

    pMsg = (msg_switch_t *)pucData;
    ch = byte_swap4(pMsg->channel);
    swh = byte_swap4(pMsg->enable);

    ulValue = read_reg(0x612600c0);

    if (1 == swh)                                   /* 򿪶 */
    {
        ulValue |= (0x1 << ch);
    }
    else if (2 == swh)                              /* رն */
    {
        ulValue &= ~(0x1 << ch);
    }
    else if (3 == swh)                              /* ä */
    {
        ulValue |= (0x1 << (ch + 16));
    }
    else if (4 == swh)                              /* رä */
    {
        ulValue &= ~(0x1 << (ch + 16));
    }
    else
    {
        FUNC_COUNTER(0x36, 0x01);
        return;
    }

    write_reg(0x612600c0, ulValue);

    PRINT(INFO, "md swh 0x%lx 0x%lx\n", ch, swh);

    return;
}


/*
**  ö
**  ֱд3Ĵ
**  0x35
*/
void cmd_md_set_para(unsigned char *pucData, int nLength)
{
    unsigned long ch;
    unsigned long para0;
    unsigned long para1;
    unsigned long para2;
    msg_motion_para_t *pMsg;

    FUNC_TRACK(0x35);

    if (nLength != sizeof(msg_motion_para_t))       /* ֤ݳ */
    {
        FUNC_COUNTER(0x35, 0x00);
        PRINT(ERR, "set_motion_para len %d\n", nLength);
        return;
    }

    pMsg = (msg_motion_para_t *)pucData;
    ch = byte_swap4(pMsg->channel);
    para0 = byte_swap4(pMsg->para0);
    para1 = byte_swap4(pMsg->para1);
    para2 = byte_swap4(pMsg->para2);

    write_reg(g_ulList_s + (ch << 10) + 0x2C8, para0);
    write_reg(g_ulList_s + (ch << 10) + 0x2CC, para1);
    write_reg(g_ulList_s + (ch << 10) + 0x2D0, para2);

    update_list(ch);

    write_reg(0x61240034, (0x1 << ch));             /* дһ֡ź(ʵֻ֡˲Ҫ) */

    PRINT(INFO, "mpara 0x%lx 0x%lx 0x%lx 0x%lx\n", ch, para0, para1, para2);

    return;
}


/*
**  ö
**  ע⣬ֻ򣬲Ѷʹܴ
**  0x34
*/
void cmd_md_set_area(unsigned char *pucData, int nLength)
{
    unsigned long ch;
    msg_motion_area_t *pMsg;

    FUNC_TRACK(0x34);

    if (nLength != sizeof(msg_motion_area_t))       /* ֤ݳ */
    {
        FUNC_COUNTER(0x34, 0x00);
        PRINT(ERR, "set_motion_area len %d\n", nLength);
        return;
    }

    pMsg = (msg_motion_area_t *)pucData;
    ch = byte_swap4(pMsg->channel);

    /* maskַÿͨ16K */
    memcpy((void *)(g_ulMaskAddr + (ch << 14)), pMsg->area, 1088);

    PRINT(INFO, "marea 0x%lx\n", ch);

    return;
}


/*
**  в
**  chΪͨ
**  typeΪ֡ͣsend_frameһ£typeΪ0x08ʾͲвݣΪ0x03ʾͶ
**
**  typeΪ0x08һԤжʱŷͣڲĿ
**  typeΪ0x03һǶжʱŷͣĲвͬһ
**
**  ֮׼bakַΪԴԶʱҪÿ֡ԤжʱвݣҪڶжʱ
**  в(Ȼݺܿһ)bak1ַרŸԤģõġ
**  עⲻҪƬdiffַûжӦϵ
**
**  ʹвʱǰҲǿ32ֽڵģȻûʲôֵ
**
**  вжϲܹҹΪпdiffʹûӲͲϴвݣжϻ
**
**  ʹʱĶ֡вݣpcҲв
**  ʱвݵķԤжݻCȽϡ
**  ֡ҲᷢͣҲвݣʱpcֻûж죬Ĳв
**
**  0x33
*/
void process_md_diff(int ch, int type)
{
    int i;
    unsigned long *pul;
    unsigned long ulPosAddr;
    unsigned long ulState;
    unsigned long ulDiffAddr;
    unsigned long ulBakAddr;
    unsigned long ulMotionBlock;

    FUNC_TRACK(0x33);

    /* пܲ */
    ulMotionBlock = (g_nPreSrcWidth[ch] / 16) * (g_nPreSrcHeight[ch] / 16);

    ulState = read_reg(0x61220030);                 /* ȡв״̬ */
    if (0 == ((ulState >> ch) & 0x1))
    {
#ifdef VS28XX_MODE_ID
        /*
        **  ڲģʽ£ԤжˣҪ󵼲вݣΪ0˵вЧֱӷ
        **  ǶжˣʹвЧ(Ӧdiffʹû)ҲҪͳ֡
        **  ʱ֡︽ĲвǷǷģģʽpc˱Ҳʹв
        */
        if (0x08 == type)
        {
            return;
        }
#else
        /*
        **  ʹʱdiffʹӦôˣжˣвȴЧӦǸ?
        */
        FUNC_COUNTER(0x33, 0x00);
        PRINT(ERR, "md diff invalid\n");
        return;
#endif
    }

    if (0 == ((ulState >> (ch + 16)) & 0x1))        /* жƬdiffַЧ */
    {
        ulDiffAddr = s_ulDiffAddr0 + (ch << 14);
    }
    else
    {
        ulDiffAddr = s_ulDiffAddr1 + (ch << 14);
    }

    if (0x03 == type)                               /* Ͷ֡ */
    {
        ulBakAddr = s_ulBakAddr0 + (ch << 14);

        pul = (unsigned long *)ulBakAddr;           /* ȡ츽Ϣ */

        pul[0] = g_nPreSrcWidth[ch];                /* ԴĿ */
        pul[1] = g_nPreSrcHeight[ch];               /* Դĸ߶ */
        pul += 2;

        ulPosAddr = 0x61230044 + (ch << 12);
        for (i = 0; i < 6; i++)                     /* ֹЩҪPC˽дСת */
        {
            pul[i] = read_reg(ulPosAddr + (i << 2));
        }

#ifdef VS28XX_MODE_ID
        /* Դʱ4ֽڴ֡λãʱpcҲĶ֡Ĳв */
        write_reg(ulBakAddr + 32, (id_pre_md_frame_pos - 2));
        memcpy((void *)(ulBakAddr + 36), (void *)ulDiffAddr, ulMotionBlock);
#else
        memcpy((void *)(ulBakAddr + 32), (void *)ulDiffAddr, ulMotionBlock);
#endif
    }
    else
    {
        ulBakAddr = s_ulBakAddr1 + (ch << 14);
        memcpy((void *)(ulBakAddr + 32), (void *)ulDiffAddr, ulMotionBlock);
    }

    /* 32ֽڵ֡β32ֽڵĸϢ */
    send_frame(ch, ulBakAddr, ulMotionBlock + 64, type, 0);

    return;
}


/*
**  ж
**  ĿǰΪ720*576Էֳ飬һ0-22ڶ23-44
**  ĿǰʹñģdmaҪע
**  0x32
*/
static void md_handler(int irq, void *dummy, struct pt_regs *regs)
{
    int i;
    unsigned long ulState[16];

    FUNC_TRACK(0x32);

    for (i = 0; i < 16; i++)                        /* ȡ16ͨ״̬ */
    {
        ulState[i] = read_reg(0x61230040 + (i << 12));
    }

    for (i = 0; i < 16; i++)
    {
        if (ulState[i] & 0x10000)                   /* ä죬򲻱 */
        {
            /* ԵĴ4ֽڣ4ֽǷжʱ֡λãʹʱ޺ʱ */
            write_reg(s_ulBakAddr0 + (i << 14), (id_pre_md_frame_pos - 2));
            send_frame(i, s_ulBakAddr0 + (i << 14), 36, 4, 0);
            continue;
        }

        if (ulState[i] & 0x1)                       /* Ҫ? */
        {
            process_md_diff(i, 0x03);
        }
    }

    return;
}


/*
**  ģע
**  0x31
*/
void md_exit(void)
{
    FUNC_TRACK(0x31);

    disable_irq(MD_IRQ);                            /* ͷŶж */
    free_irq(MD_IRQ, 0);

    return;
}


/*
**  ģʼ
**  0x30
*/
int md_init(void)
{
    int i;
    int ret;

    FUNC_TRACK(0x30);

    s_ulBakAddr0 = get_memory(MOTION_MEM_SIZE);     /* ڴ棬ڴ1K */
    if (0 == s_ulBakAddr0)
    {
        FUNC_COUNTER(0x30, 0x00);
        PRINT(ERR, "md_init memory fail\n");
        return -1;
    }

    /*
    **  ַÿͨƬÿƬ16K512K
    **  maskַÿͨ16K256K
    **  вַÿͨƬÿƬ16K512K
    **  οַ֡ÿͨ32K512K(ֿ֡֡1920*1088)
    */
    s_ulBakAddr1 = s_ulBakAddr0 + 0x40000;
    g_ulMaskAddr = s_ulBakAddr1 + 0x40000;
    s_ulDiffAddr0 = g_ulMaskAddr + 0x40000;
    s_ulDiffAddr1 = s_ulDiffAddr0 + 0x40000;
    s_ulOriAddr = s_ulDiffAddr1 + 0x40000;

    for (i = 0; i < 16; i++)
    {
#ifdef VS28XX_MODE_ID                               /* Դʱͨһmask */
        write_reg(g_ulList_s + (i << 10) + 0x2DC, g_ulMaskAddr);
#else
        write_reg(g_ulList_s + (i << 10) + 0x2DC, g_ulMaskAddr + (i << 14));
#endif
        write_reg(g_ulList_s + (i << 10) + 0x2D8, (((s_ulDiffAddr0 + (i << 14)) & 0xFFFFFFF) >> 10));
        write_reg(g_ulList_s + (i << 10) + 0x2C4, (((s_ulDiffAddr1 + (i << 14)) & 0xFFFFFFF) >> 10));
        write_reg(g_ulList_s + (i << 10) + 0x2D4, (((s_ulOriAddr + (i << 15)) & 0xFFFFFFF) >> 10));

        /* 򿪲вʹܣû⣿*/
        write_reg(g_ulList_s + (i << 10) + 0x2C8, 0xA500C);     /* Ϊ0xAΪ0x50ʹmask */
        write_reg(g_ulList_s + (i << 10) + 0x2CC, 0xA000C);     /* Ϊ0xAϵΪ0xC */
        write_reg(g_ulList_s + (i << 10) + 0x2D0, 0xC8051919);  /* Ϊ0xC8ֱ֡Ϊ5, 25, 25 */
    }

    write_reg(0x61240034, 0xFFFF);                  /* дһ֡ź */

    ret = request_irq(MD_IRQ, md_handler, SA_INTERRUPT, "md_handler", 0);
    if(ret != 0)
    {
        FUNC_COUNTER(0x30, 0x01);
        PRINT(ERR, "md_init request_irq fail\n");
        return -1;
    }
    enable_irq(MD_IRQ);

    PRINT(INFO, "md_init\n");

    return 0;
}
