/*
**  ƴģļ
*/

#include "vs28xx.h"
#include "pci.h"
#include "yuv.h"
#include "patch.h"
#include "preview.h"
#include "reg/preview_reg.h"
#include "reg/patch_reg.h"

//#define USE_TIMER

#ifdef USE_TIMER
#define DMA_IRQ                     1               /* ʱʹdmaҪж */
#define PATCH_TIMER_INTERVAL        300             /* ʱΪ300 */
struct timer_list patch_timer;
#else
#define DMA_IRQ                     0               /* жʹdmaҪж */
#endif

static unsigned long s_ulPatchFrameAddr;            /* ƴַ֡ */
static unsigned long s_ulVgaFrameAddr;              /* vgaַ֡ */
unsigned long g_ulBlockAddr[16];                    /* 16ĵַ */
unsigned long g_ulPatchOsdAddr[3];                  /* ƴosdݵַ */


/*
**  VGAݣRGBʽΪw * h * 3
**  ߺ͸һ
*/
static void send_vga_data(unsigned long ulWidth, unsigned long ulHeight)
{
    int ret;
    yuv_type_t *p0;
    dma_info_t dmaInfo;
    unsigned long *pul;
    unsigned long ulSize;
    unsigned long ulAhbAddr;

    id_frame_jiffies = jiffies;                     /* ʾƴӲԻڽ */

    if (0 == (read_reg(0x61300000) & 0x10))         /* жvgaǷʹ */
    {
        return;
    }

    ulSize = ulWidth * ulHeight * 3;                /* RGBʽݳΪw*h*3 */
    if ((0 == ulSize) || ((ulSize & 0x3) != 0))
    {
        PRINT(INFO, "vga size fail %#lx\n", ulSize);
        return;
    }
    ulAhbAddr = s_ulVgaFrameAddr;

    PRINT(INFO, "vga size %#lx\n", ulSize);

    pul = (unsigned long *)(dmaInfo.msgBuffer);
    pul[0] = byte_swap4(17);                        /* Ԥ0ͨ */
    pul[1] = byte_swap4(ulSize);                    /*  */

	p0 = (yuv_type_t *)(pul + 2);                   /* pul[2], 3ֽͣôСת */
	p0->yuv = 1;                                    /* yuvΪ422 */
	p0->pack = 0;                                   /* ʽΪֿ */
    p0->qua = 0x56;                                 /* ֱʣ־ʾ֤ߺͳȵĹϵ */

    dmaInfo.pciAddr = g_ulPreAddr[1][0];            /* Ԥ0ͨ */
    dmaInfo.ahbAddr = ulAhbAddr;
    dmaInfo.dmaLength = ulSize;
    dmaInfo.module = 0;                             /* Ҫص */
    dmaInfo.command = 0xB1;
    dmaInfo.msgLength = 16;

    ret = pci_dma_write(&dmaInfo, 0, DMA_IRQ);
    if (ret != 0)
    {
        PRINT(ERR, "vga write fail\n");
        return;
    }

    return;
}


/*
**  ƴݣͱ干ãַ֡
*/
static void send_patch_data(unsigned long ulWidth, unsigned long ulHeight)
{
    int ret;
    yuv_type_t *p0;
    pre_size_t *p1;
    dma_info_t dmaInfo;
    unsigned long *pul;
    unsigned long ulSize;

    id_frame_jiffies = jiffies;                     /* ʾƴӲԻڽ */

    ulSize = ulWidth * ulHeight * 2;                /* һ֡ĳΪ422**2 */
    if ((0 == ulSize) || (ulSize > 0x400000))
    {
        PRINT(ERR, "patch size fail 0x%lx\n", ulSize);
        return;
    }
    PRINT(INFO, "patch size 0x%lx\n", ulSize);

    pul = (unsigned long *)(dmaInfo.msgBuffer);
    pul[0] = byte_swap4(0);                         /* ôԤ0ͨ */
    pul[1] = byte_swap4(ulSize);                    /*  */

	p0 = (yuv_type_t *)(pul + 2);                   /* pul[2], 3ֽͣôСת */
	p0->yuv = 1;                                    /* yuvΪ422 */
	p0->pack = 0;                                   /* ʽΪֿ */
    p0->qua = 7;                                    /* ֱʣֱתcharͣ˲ôСת */

	p1 = (pre_size_t *)(pul + 3);                   /* pul[3] */
	p1->width = byte_swap2(ulWidth);                /* ʵ */
	p1->height = byte_swap2(ulHeight);              /* ʵ߶ */

    dmaInfo.pciAddr = g_ulPreAddr[0][0];            /* ôԤ0ͨ */
    dmaInfo.ahbAddr = s_ulPatchFrameAddr;
    dmaInfo.dmaLength = ulSize;
    dmaInfo.module = 0;                             /* Ҫص */
    dmaInfo.command = 0xB1;
    dmaInfo.msgLength = 16;

    ret = pci_dma_write(&dmaInfo, 0, DMA_IRQ);
    if (ret != 0)
    {
        PRINT(ERR, "patch write fail\n");
    }

    return;
}


/*
**  
**  0˵ݷͣ-1˵û
*/
static int process_data(void)
{
    unsigned long ulSize;

    if (1 == id_hdsd_ready)                         /*  */
    {
        if (read_reg(0x61000214) == 1)
        {
            id_hdsd_ready = 0;

            ulSize = read_reg(0x61300004);

            send_vga_data((ulSize & 0x7FF), ((ulSize >> 16) & 0x7FF));

            send_patch_data((ulSize & 0x7FF), ((ulSize >> 16) & 0x7FF));

            return 0;
        }
    }
    else if (2 == id_hdsd_ready)                    /*  */
    {
        if (read_reg(0x6100022C) == 1)
        {
            id_hdsd_ready = 0;

            ulSize = read_reg(0x61400004);

            send_patch_data((ulSize & 0x3FF), ((ulSize >> 16) & 0x3FF));

            return 0;
        }
    }

    return -1;
}


/*
**  ʱ(ж)̣ͱ干
**  ʱҪVGA
*/
#ifdef USE_TIMER
static void hd_handler(unsigned long v)
#else
static void hd_handler(int irq, void *dummy, struct pt_regs *regs)
#endif
{
    int ret;

    ret = process_data();

#ifdef USE_TIMER
    patch_timer.data = 0;
    patch_timer.function = hd_handler;
    patch_timer.expires = jiffies + PATCH_TIMER_INTERVAL;
    add_timer(&patch_timer);
#else
    if (ret != 0)   /* жϣûжӦID־״̬λǲԵ */
    {
        PRINT(ERR, "patch_irq fail %#lx\n", id_hdsd_ready);
    }
#endif

    return;
}


/*
**  ж
*/
static void hd_cad_handler(int irq, void *dummy, struct pt_regs *regs)
{
    PRINT(INFO, "hd_cad_handler\n");

    id_patch_ready = 1;

    return;
}


/*
**  벢ƴosdռ
**  3osdÿ1Mռ䣬3osdռŵ
**  ڼĴӦȥCͷ1KΪλ
**  listĹϵһosdַĿǰĴlistһַ
**  ͱ干õַ
**  0˵ɹʧ
*/
static int patch_osd(void)
{
    unsigned long mem;

    mem = get_memory(0x300000);
    if (0 == mem)
    {
        return -1;
    }

    g_ulPatchOsdAddr[0] = mem;
    g_ulPatchOsdAddr[1] = mem + 0x100000;
    g_ulPatchOsdAddr[2] = mem + 0x200000;

    mem = (mem & 0xFFFFFFF) >> 10;                  /* ȥCͷ1KΪλ */

    write_reg(0x61300078, mem);                     /*  */
    write_reg(0x6130007C, mem);
    write_reg(0x61300080, mem + 0x400);             /* 1KΪλǼ1M */
    write_reg(0x61300084, mem + 0x400);
    write_reg(0x61300088, mem + 0x800);
    write_reg(0x6130008C, mem + 0x800);

    write_reg(0x61400078, mem);                     /*  */
    write_reg(0x6140007C, mem);
    write_reg(0x61400080, mem + 0x400);             /* 1KΪλǼ1M */
    write_reg(0x61400084, mem + 0x400);
    write_reg(0x61400088, mem + 0x800);
    write_reg(0x6140008C, mem + 0x800);

    return 0;
}


/*
**  弶bankռ䣬ÿbank4M12M
**  0˵ɹʧ
*/
static int patch_bank(void)
{
    unsigned long mem;

    mem = get_memory(0xC00000);
    if (0 == mem)
    {
        return -1;
    }

    write_reg(0x61201010, mem);
    write_reg(0x61201014, mem + 0x400000);
    write_reg(0x61201018, mem + 0x800000);

    return 0;
}


/*
**  ƴģע
*/
void patch_exit(void)
{
    return;
}


/*
**  ƴģʼ
**  ƴ16棬֧1920*1080
**  ƴӺķֱʲᳬ1920*1080
**  ˸ÿ4MĿռ䣬ƴ֡Ҳ4Mռ
**  ҪܿռСΪ89M
**  4Mƴ֡棬64M 16ͨռ䣬6M VGA֡棬3MƴOSD12M弶bank
*/
int patch_init(void)
{
    int i;
    int ret;
    unsigned long addr;

    hw_patch_set_gamma_para();                      /* gamma */

    hw_patch_set_disen_para();                      /* ǿұ */

    s_ulPatchFrameAddr = get_memory(0x4A00000);     /* ڴ */
    if (0 == s_ulPatchFrameAddr)
    {
        PRINT(ERR, "patch_init not enough memory\n");
        return -1;
    }
    addr = s_ulPatchFrameAddr + 0x400000;

    /*
    **  pcֱдƴ16ͨĵַΪ˱ּݣ72MĿռ£
    **  4Mƴ֡ռ䣬64M 16ͨռ䣬6M VGA֡ռ
    */
    s_ulVgaFrameAddr = s_ulPatchFrameAddr + 0x4400000;

    /*
    **  ַ֡ȥCͷ1KΪλ
    **  ͱ干õַVGAҪĵַ
    */
    write_reg(0x61000210, ((s_ulPatchFrameAddr & 0xFFFFFFF) >> 10));
    write_reg(0x61000228, ((s_ulPatchFrameAddr & 0xFFFFFFF) >> 10));
    write_reg(0x61000218, ((s_ulVgaFrameAddr & 0xFFFFFFF) >> 10));

    for (i = 0; i < 16; i++)                        /* ַ */
    {
        /* ͱ干õַ */
        g_ulBlockAddr[i] = addr + i * 0x400000;
        write_reg((0x61200000 + i * 8), g_ulBlockAddr[i]);
        write_reg((0x61202000 + i * 8), g_ulBlockAddr[i]);
    }

    if (patch_osd() != 0)                           /* ƴosdռ */
    {
        PRINT(ERR, "patch_osd fail\n");
        return -1;
    }

    if (patch_bank() != 0)                          /* ƴbankռ */
    {
        PRINT(ERR, "patch_bank fail\n");
        return -1;
    }

#ifdef USE_TIMER
    patch_timer.data = 0;
    patch_timer.function = hd_handler;
    patch_timer.expires = jiffies + PATCH_TIMER_INTERVAL;
    add_timer(&patch_timer);
#else
    /* ͸干52жϣͬһжεĻǴЧ? */
    ret = request_irq(HD_IRQ, hd_handler, SA_INTERRUPT, "hd_handler", 0);
    if(ret != 0)
    {
        PRINT(ERR, "patch_init request_irq fail\n");
        return -1;
    }
    enable_irq(HD_IRQ);
#endif

    ret = request_irq(HD_CASCADE_IRQ, hd_cad_handler, SA_INTERRUPT, "hd_cad_handler", 0);
    if(ret != 0)
    {
        PRINT(ERR, "patch_init request_irq fail\n");
        return -1;
    }
    enable_irq(HD_CASCADE_IRQ);

    PRINT(INFO, "patch_init hdsdvga 0x%lx\n", s_ulPatchFrameAddr);

    return 0;
}
