/*
**  ƵģĴ֣ҪƵģ
*/

#include "../vs28xx.h"
#include "../yuv.h"
#include "audio_reg.h"

int g_nAudioFLen = 0;                               /* 16·Ƶ֡ */
int g_nSphEncLen = 0;                               /* Խ֡ */
int g_nSphDecLen = 0;                               /* Խ֡ */
unsigned long g_ulSphDecDataAddr = 0;               /* ʼַ */
unsigned long g_ulSphDecDataLeng = 0;               /* ܳ */


/*
**  ģʽ
**  typeΪ0ʾƵ
**  typeΪ1ʾԽ
**  typeΪ2ʾԽ
**  modeʾģʽȡֵ0-3ֱʾbypass, g711a, g711u, g721
*/
void hw_aud_set_mode(int type, int mode)
{
    unsigned long reg;
    unsigned long bit;
    unsigned long val;

    if (mode < 0 || mode > 3)                       /* жϲϷ */
    {
        return;
    }

    if (0 == type)
    {
        reg = AUDIO_CTRL;
        bit = 18;
    }
    else if (1 == type)
    {
        reg = SPH_CTRL;
        bit = 3;
    }
    else if (2 == type)
    {
        reg = SPH_CTRL;
        bit = 19;
    }
    else
    {
        return;
    }

    val = read_reg(reg);                            /*  */
    val &= ~(0x7 << bit);                           /* Ȱѱʾʾģʽλ0 */
    val |= (mode << bit);                           /* ģʽ */
    write_reg(reg, val);

    return;
}


/*
**  ò
**  typeΪ0ʾƵ(Ч)
**  typeΪ1ʾԽ
**  typeΪ2ʾԽ
**  freqʾʣȡֵ0-3ֱʾ4kbps,8kbps,16kbps,32kbps
*/
void hw_aud_set_smprate(int type, int freq)
{
    unsigned long bit;
    unsigned long val;

    if (freq < 0 || freq > 3)                       /* жϲϷ */
    {
        return;
    }

    if (1 == type)
    {
        bit = 6;
    }
    else if (2 == type)
    {
        bit = 22;
    }
    else
    {
        return;
    }

    val = read_reg(SPH_CTRL);                       /*  */
    val &= ~(0x3 << bit);                           /* Ȱѱʾʾģʽ2λ0 */
    val |= (freq << bit);                           /*  */
    write_reg(SPH_CTRL, val);

    return;
}


/*
**  ʱ
**  typeΪ0ʾƵ(Ч)
**  typeΪ1ʾԽ
**  typeΪ2ʾԽ
**  clkʾʱӣȡֵ0-1ֱʾ256fs,512fs
*/
void hw_aud_set_clk(int type, int clk)
{
    int n;

    if (1 == type)
    {
        n = 8;
    }
    else if (2 == type)
    {
        n = 24;
    }
    else
    {
        return;
    }

    if (clk)
    {
        write_reg(SPH_CTRL, (read_reg(SPH_CTRL) | (0x1 << n)));
    }
    else
    {
        write_reg(SPH_CTRL, (read_reg(SPH_CTRL) & ~(0x1 << n)));
    }

    return;
}


/*
**  ģʽ
**  typeΪ0ʾƵ(Ч)
**  typeΪ1ʾԽ
**  typeΪ2ʾԽ
**  mstȡֵ0-1ֱʾģʽģʽ
*/
void hw_aud_set_mst(int type, int mst)
{
    int n;

    if (1 == type)
    {
        n = 2;
    }
    else if (2 == type)
    {
        n = 18;
    }
    else
    {
        return;
    }

    if (mst)
    {
        write_reg(SPH_CTRL, (read_reg(SPH_CTRL) | (0x1 << n)));
    }
    else
    {
        write_reg(SPH_CTRL, (read_reg(SPH_CTRL) & ~(0x1 << n)));
    }

    return;
}


/*
**  
**  typeΪ0ʾƵ(Ч)
**  typeΪ1ʾԽ
**  typeΪ2ʾԽ(Ч)
**  sndȡֵ0-1ֱʾ
*/
void hw_aud_set_snd(int type, int snd)
{
    if (type != 1)
    {
        return;
    }

    if (snd)
    {
        write_reg(SPH_CTRL, (read_reg(SPH_CTRL) | (0x1 << 9)));
    }
    else
    {
        write_reg(SPH_CTRL, (read_reg(SPH_CTRL) & ~(0x1 << 9)));
    }

    return;
}


/*
**  Ƶ
**  ch0-15ʾ16·Ƶ
**  ch16ʾԽ
**  ch17ʾԽ
*/
void hw_aud_set_switch(int ch, int enable)
{
    if (0 <= ch && ch <= 15)    /* 16·Ƶ */
    {
        if (enable)
        {
            write_reg(AUDIO_CTRL, (read_reg(AUDIO_CTRL) | (0x1 << ch)));
        }
        else
        {
            write_reg(AUDIO_CTRL, (read_reg(AUDIO_CTRL) & ~(0x1 << ch)));
        }
    }
    else if (16 == ch)          /* Խ */
    {
        if (enable)
        {
            write_reg(SPH_CTRL, (read_reg(SPH_CTRL) | 0x1));
        }
        else
        {
            write_reg(SPH_CTRL, (read_reg(SPH_CTRL) | 0x2));
        }
    }
    else if (17 == ch)          /* Խ */
    {
        if (enable)
        {
            /* ϢЧ */
            write_reg(SPH_CTRL, (read_reg(SPH_CTRL) | 0x02010000));
        }
        else
        {
            write_reg(SPH_CTRL, (read_reg(SPH_CTRL) | 0x20000));
        }
    }
    else
    {
        return;
    }

    return;
}


/*
**  һжϲburst
**  typeΪ0ʾƵ룬countȡֵ1-128
**  typeΪ1ʾԽ룬countȡֵ1-128
**  typeΪ2ʾԽ룬countȡֵ1-255
**
**  һburst256ֽڵݣķΧΪ256-32K
**  Ŀǰƹҵƫ̶Ϊ32K+32burstĸıı
**  Խ⣬ûburstƹңֻǱʾݵĴС
*/
void hw_aud_set_burst(int type, int count)
{
    if (0 == type)
    {
        if (count < 1 || count > 128)               /* жϲϷ */
        {
            return;
        }

        g_nAudioFLen = count * 256;                 /* Ƶ */
        write_reg(AUDIO_BURST, (count << 16) | AUDIO_ONE_BANK);
    }
    else if (1 == type)
    {
        if (count < 1 || count > 128)               /* жϲϷ */
        {
            return;
        }

        g_nSphEncLen = count * 256;                 /* ݳ */
        write_reg(SPH_ENC_BURST, (count << 16) | AUDIO_ONE_BANK);
    }
    else if (2 == type)
    {
        if (count < 1 || count > 255)               /* жϲϷ */
        {
            return;
        }

        g_nSphDecLen = count * 256;                 /* ݳ */
        write_reg(SPH_DEC_LENG, g_nSphDecLen);
    }

    return;
}


/*
**  Ƶַ
**  memΪܵʼַ
**
**  һburst256ֽڣ޶һж128burst32Kݣϴõ32ֽ֡βҪ32K+32ֽ
**  ڲƹһƣҪƬһСڴ棬ԵͨҪ64K+64ֽ
**
**  Ƶ16ͨҪ0x100400ֽ
**  һ·Խ룬ƵͬҪ64K+64ֽ
**  һ·Խ룬󳤶Ϊ65535ֽڣ64K(Ҫݣ֡β)
*/
void hw_aud_config_memory(unsigned long mem)
{
    int i;
    unsigned long reg;

    reg = AUDIO_MEM_BASE;                           /* 16ͨƵ */
    for (i = 0; i < 16; i++)
    {
        write_reg(reg, mem);
        reg += 4;
        mem += AUDIO_TWO_BANK;
    }

    write_reg(SPH_ENC_MEM_BASE, mem);               /* Խ */
    mem += AUDIO_TWO_BANK;

    write_reg(SPH_DEC_MEM_BASE, mem);               /* Խ룬ʵĿռ? */

    return;
}


/*
**  ƵжʱȡƵʵַ
*/
unsigned long hw_aud_get_addr(int ch)
{
    return read_reg(AUDIO_DATA_BASE + (ch << 2));
}


/*
**  ƵжʱȡЧͨλʾͨ
*/
int hw_aud_get_channel(void)
{
    return read_reg(AUDIO_INT_ID) & 0xFFFF;
}
