/*
**  ƵģĴͷļ
*/

#ifndef _VS28XX_AUDIO_REG_H_
#define _VS28XX_AUDIO_REG_H_

#define AUDIO_IRQ               0x35                /* ƵжϺ */
#define SPHENC_IRQ              0x36                /* ԽжϺ */
#define SPHDEC_IRQ              0x37                /* ԽжϺ */

#define AUDIO_CTRL              0x60010000          /* ƼĴ */
#define AUDIO_BURST             0x60010004          /* burstĴ */
#define AUDIO_MEM_BASE          0x60010008          /* Ƶڴ׵ַ */
#define AUDIO_DATA_BASE         0x60010048          /* Ƶַ */
#define AUDIO_INT_ID            0x6001008C          /* ǰжϵͨ */
#define SPH_CTRL                0x60011000          /* ԽƼĴ */
#define SPH_ENC_BURST           0x60011004          /* ԽburstĴ */
#define SPH_ENC_MEM_BASE        0x60011008          /* Խڴ׵ַ */
#define SPH_ENC_DATA_BASE       0x6001100C          /* Խַ */
#define SPH_DEC_MEM_BASE        0x60011010          /* Խڴ׵ַ */
#define SPH_DEC_LENG            0x60011014          /* Խݳ */

#define AUDIO_MEM_SIZE          0x140000            /* ΪƵģĿռܴС */
#define AUDIO_ONE_BANK          (0x8000 + 32)       /* Чݼ֡βҲƹҵƫ */
#define AUDIO_TWO_BANK          (AUDIO_ONE_BANK * 2)/* ƹҵƬҲǵͨռռĴС */

extern int g_nAudioFLen;                            /* 16·Ƶ֡ */
extern int g_nSphEncLen;                            /* Խ֡ */
extern int g_nSphDecLen;                            /* Խ֡ */
extern unsigned long g_ulSphDecDataAddr;            /* ʼַ */
extern unsigned long g_ulSphDecDataLeng;            /* ܳ */

/*
**  ģʽ
**  typeΪ0ʾƵ
**  typeΪ1ʾԽ
**  typeΪ2ʾԽ
**  modeʾģʽȡֵ0-3ֱʾbypass, g711a, g711u, g721
*/
void hw_aud_set_mode(int type, int mode);

/*
**  ò
**  typeΪ0ʾƵ(Ч)
**  typeΪ1ʾԽ
**  typeΪ2ʾԽ
**  freqʾʣȡֵ0-3ֱʾ4kbps,8kbps,16kbps,32kbps
*/
void hw_aud_set_smprate(int type, int freq);

/*
**  ʱ
**  typeΪ0ʾƵ(Ч)
**  typeΪ1ʾԽ
**  typeΪ2ʾԽ
**  clkʾʱӣȡֵ0-1ֱʾ256fs,512fs
*/
void hw_aud_set_clk(int type, int clk);

/*
**  ģʽ
**  typeΪ0ʾƵ(Ч)
**  typeΪ1ʾԽ
**  typeΪ2ʾԽ
**  mstȡֵ0-1ֱʾģʽģʽ
*/
void hw_aud_set_mst(int type, int mst);

/*
**  
**  typeΪ0ʾƵ(Ч)
**  typeΪ1ʾԽ
**  typeΪ2ʾԽ(Ч)
**  sndȡֵ0-1ֱʾ
*/
void hw_aud_set_snd(int type, int snd);

/*
**  Ƶ
**  ch0-15ʾ16·Ƶ
**  ch16ʾԽ
**  ch17ʾԽ
*/
void hw_aud_set_switch(int ch, int enable);

/*
**  һжϲburst
**  typeΪ0ʾƵ룬countȡֵ1-128
**  typeΪ1ʾԽ룬countȡֵ1-128
**  typeΪ2ʾԽ룬countȡֵ1-255
**
**  һburst256ֽڵݣķΧΪ256-32K
**  Ŀǰƹҵƫ̶Ϊ32K+32burstĸıı
**  Խ⣬ûburstƹңֻǱʾݵĴС
*/
void hw_aud_set_burst(int type, int count);

/*
**  Ƶַ
**  memΪܵʼַ
**
**  һburst256ֽڣ޶һж128burst32Kݣϴõ32ֽ֡βҪ32K+32ֽ
**  ڲƹһƣҪƬһСڴ棬ԵͨҪ64K+64ֽ
**
**  Ƶ16ͨҪ0x100400ֽ
**  һ·Խ룬ƵͬҪ64K+64ֽ
**  һ·Խ룬󳤶Ϊ65535ֽڣ64K(Ҫݣ֡β)
*/
void hw_aud_config_memory(unsigned long mem);

/*
**  ƵжʱȡƵʵַ
*/
unsigned long hw_aud_get_addr(int ch);

/*
**  ƵжʱȡЧͨλʾͨ
*/
int hw_aud_get_channel(void);

#endif
