/*
**  ģĴ֣ҪԤģ
*/

#include "../vs28xx.h"
#include "../list.h"
#include "enc_reg.h"

#define CBR_DECAY		            900
#define ARITHMETIC_MIN_QP		    20

static unsigned long s_ulEBank;     /* Eڴ棬Ҫʹã2KΪλ */
static int s_nRawBufferID;          /* ID */

/* ddrò(256M)(ע⣬ͬddrܲһͨʹEʱҵ) */
static unsigned long ddr_params[DDR_PARA_NUM] =
{
    0x00000001, 0x00010001, 0x00010000, 0x00010001, /* 0x00 - 0x0C */
    0x00000000, 0x00010100, 0x00000001, 0x00010100, /* 0x10 - 0x1C */
    0x01010100, 0x00000001, 0x00000202, 0x00070003, /* 0x20 - 0x2C */
    0x02000202, 0x00000002, 0x07080a0f, 0x0002040f, /* 0x30 - 0x3C */
    0x00040000, 0x00020006, 0x02020202, 0x00000303, /* 0x40 - 0x4C */
    0x02000000, 0x02020400, 0x00070000, 0x05010000, /* 0x50 - 0x5C */
    0x00000802, 0x00000000, 0x00400242, 0x00000000, /* 0x60 - 0x6C */
    0x017e017e, 0x017e017e, 0x017e017e, 0xffff017e, /* 0x70 - 0x7C */
    0x00000000, 0x000000c8, 0x000a04b0, 0x000000c8, /* 0x80 - 0x8C */
    0x00004e20, 0x00000000, 0x00011c69, 0x00011c69, /* 0x90 - 0x9C */
    0x00011c69, 0x00011c69, 0x0035e01c, 0x0035e01c, /* 0xA0 - 0xAC */
    0x0035e01c, 0x0035e01c, 0x00000000, 0x00000000, /* 0xB0 - 0xBC */
    0x00000000, 0x00000000, 0x00000000, 0x000f1100, /* 0xC0 - 0xCC */
    0xf3013926, 0xf3013926, 0xf3013926, 0xf3013926, /* 0xD0 - 0xDC */
    0x26c00300, 0x26c00300, 0x26c00300, 0x26c00300, /* 0xE0 - 0xEC */
    0x00000004                                      /* 0xF0 */
};

/* ģʼҪ0x52050000-0x52050028 */
static unsigned long enc_params[11] =
{
    0xd82261f8,
    0x08837000,
    0x00000008,                                     /* ܣͷռΪ0βռΪ8 */
    0x07fe0000,                                     /* Ϊ2047 */
    0x00000000,
    0x3200961e,
    0x421e0100,
    0x00100100,
    0x00004000,
    0x00783c00,
    0x00000000
};


/*
**  ȡEڴռ䣬s_ulEBankָ
**  ulSizeΪռĴСֽΪλ
**  ֵΪ뵽ռʼַ0˵ʧ
**
**  ulSize4K룬Զ4K(ȡ)
**  Ŀռ䣬ֻ룬ͷţҪСʹ
**
**  ע⣬s_ulEBank2KΪλҲEͷصĵַʵַ2KΪλ
*/
unsigned long get_e_memory(unsigned long ulSize)
{
    unsigned long ulAlign;
    unsigned long ulAddr;

    if (0 == ulSize)
    {
        PRINT(ERR, "zero size\n");
        return 0;
    }

    ulAlign = ulSize & 0xFFF;                       /* ʹulSize 4K */
    if (ulAlign != 0)
    {
        ulSize += (0x1000 - ulAlign);
    }
    ulSize >>= 11;                                  /* 2KΪλ */

    if ((s_ulEBank + ulSize) > EBANK_END)
    {
        PRINT(ERR, "not enough memory\n");
        return 0;
    }

    ulAddr = (s_ulEBank << 11) | 0xE0000000;
    s_ulEBank += ulSize;                            /* ַ */

    return ulAddr;
}


/*
**  ddr
*/
void config_ddr(void)
{
    int i;
    unsigned long ulAddr;

	PRINT(INFO, "config_ddr 256M\n");

	ulAddr = 0x50000000;                            /* 0x00䵽0xF0 */
	for (i = 0; i < DDR_PARA_NUM; i++)
	{
	    write_reg(ulAddr, ddr_params[i]);
	    ulAddr += 4;
	}

	write_reg(0x50000020, 0x1010101);               /* 0x20һ */

	return;
}


/*
**  ʼ
*/
void enc_para_init(void)
{
    int i, j;
    unsigned long ulBase[2];

    /* üĴ */
    for (i = 0; i < 51; i++)
    {
        for (j = 0; j < 11; j++)
        {
            write_reg(0x52050000 + (i << 8) + (j << 2), enc_params[j]);
        }
    }

    /* ԿĴ */
    write_reg(0x52010000, 0x01234567);              /* DES key */
    write_reg(0x52010004, 0x89abcdef);
    write_reg(0x52010040, 0x01234567);              /* AES key */
    write_reg(0x52010044, 0x89abcdef);
    write_reg(0x52010048, 0x01234567);
    write_reg(0x5201004C, 0x89abcdef);

    /* ʿƻֲ */
    ulBase[0] = RC0_BADDR;
    ulBase[1] = RC1_BADDR;
    for (i = 0; i < 2; i++)                         /* ܹƬʿƻ */
    {
        for (j = 0; j < 51; j++)                    /* 51ͨ */
        {
            write_reg(ulBase[i] + 0x78, 0xCF3CC08C);
            write_reg(ulBase[i] + 0x80, 0x40660000);
            write_reg(ulBase[i] + 0x9C, 0x99DE006C);    /* Ŀǰmax_qp_pb_inΪ51min_qp_pb_inΪ0*/
            write_reg(ulBase[i] + 0xA4, 0x0285032C);
            ulBase[i] += 256;
        }
    }

    return;
}


/*
**  òο֡
**  chΪͨ()(0-50)
**  sizeΪС2KΪλ
**  0˵ɹ-1˵ʧ
*/
static int set_refe_buffer(int ch, int size)
{
    /* жڴûԽ */
	if ((s_ulEBank + size) > EBANK_END)
	{
	    PRINT(ERR, "set_refe_buffer fail %d %d\n", ch, size);
	    return -1;
	}

    /* ο֡ʼַ */
	write_reg(0x52030000 + (ch << 8), s_ulEBank);

	/* οַ֡ */
    write_reg(0x52030004 + (ch << 8), s_ulEBank + size - 1);

    /* ο֡ʼַ */
    write_reg(0x52030008 + (ch << 8), s_ulEBank);

    /* ַ */
    s_ulEBank += size;

	return 0;
}


/*
**  h264֡
**  chΪͨ(0-16)
**  streamΪ(0-2)
**  indexΪ(0-3)ÿ4Ƭڴ(ʵǣûB֡ʱ2Ƭڴ͹B֡ʱ3Ƭڴ)
**  sizeΪС2KΪλ
**  0˵ɹ-1˵ʧ
*/
static int set_h264_raw_buffer(int ch, int stream, int index, int size)
{
    unsigned long reg;
    unsigned long val;

    /* жڴûԽ */
	if ((s_ulEBank + size) >= EBANK_END)
	{
	    PRINT(ERR, "h264 raw fail %d %d %d %d\n", ch, stream, index, size);
	    return -1;
	}

	/* дID */
	reg = 0x54040000 + (ch << 8) + (stream << 4) + (index << 2);
	val = (0x1 << 12) | s_nRawBufferID;
	write_reg(reg, val);

	/* дIDӦַ֡ */
	reg = 0x54060000 + (s_nRawBufferID << 2);
	write_reg(reg, s_ulEBank);

    /* ַ */
	s_ulEBank += size;

	/* ID */
	s_nRawBufferID++;

	return 0;
}


/*
**  jpeg֡
**  typeΪûԶڴ
**  indexΪ(0-51)52Ƭڴ
**  sizeΪС2KΪλ
**  0˵ɹ-1˵ʧ
*/
static int set_jpeg_raw_buffer(int type, int index, int size)
{
    unsigned long reg;
    unsigned long val;

    /* жڴûԽ */
	if ((s_ulEBank + size) >= EBANK_END)
	{
	    PRINT(ERR, "jpeg raw fail %d %d\n", index, size);
		return -1;
	}

    /* дID */
    reg = 0x54050000 + (index << 2);
    val = (type << 16) | (1 << 12) | s_nRawBufferID;
	write_reg(reg, val);

	/* дIDӦַ֡ */
	reg = 0x54060000 + (s_nRawBufferID << 2);
	write_reg(reg, s_ulEBank);

    /* ַ */
	s_ulEBank += size;

	/* ID */
	s_nRawBufferID++;

	return 0;
}


/*
**  ʼ֡
*/
void enc_raw_buffer_init(void)
{
    int ret;
    int size;
    int regularSize;
    int i, j, k;

    s_ulEBank = EBANK_START;
    s_nRawBufferID = 0;

    /* ڱ߱16ı */
    regularSize = ENC_MAX_WIDTH * ENC_MAX_HEIGHT / 256;

    /* 2Kڴ԰5飬Ҫȡ */
    if (0 == (regularSize % 5))
    {
        regularSize /= 5;
    }
    else
    {
        regularSize /= 5;
        regularSize++;
    }

    /*
    **  ֡沼£
    **
    **  stream0ο֡
    **  jpeg֡0
    **  stream0֡0
    **  stream0֡1
    **  stream0֡2
    **  stream17ο֡
    **  jpeg֡1
    **  stream17֡0
    **  stream17֡1
    **  stream17֡2
    **  ...
    **  ֮壬Ϊڴ治ʱȷǰ沿ͨȫ
    */
    for (i = 0; i < 17; i++)            /* 17ͨ */
    {
        if (0 == i)
        {
            size = 1632;                /* 0֧ͨ1920x1088 */
        }
        else
        {
            size = regularSize;
        }

        for (j = 0; j < 3; j++)         /* ÿͨ3 */
        {
            /* ÿĲο֡֡ */
            ret = set_refe_buffer(j * 17 + i, size * 2);
            if (ret != 0)
            {
                return;
            }

            /*
            **  jpeg֡
            **  jpegûĸֻǵ
            **  jpeg52֡滺Ҳᳬ
            */
            ret = set_jpeg_raw_buffer(0, i * 3 + j, size);
            if (ret != 0)
            {
                return;
            }

            /* h264֡棬ÿ3Ƭ */
            for (k = 0; k < 3; k++)
            {
                ret = set_h264_raw_buffer(i, j, k, size);
                if (ret != 0)
                {
                    return;
                }
            }
        }
    }

    return;
}


/*
**  Ԥ֡
**  ԤǱߣЧͨΪ16ÿͨ351ͨ
**  MUX,ENC0ENC1֡ʼĴ֪ֻ֪ͨźbs
**
**  16, 33, 50⣬Ϊǳnvƴ
*/
static void hw_enc_set_viu_frame(int ch, int fr)
{
    int stream;
    int bit;
    unsigned long ulAddr;
    unsigned long ulVal;

    stream = ch / 17;                               /* 0,1,2 */
    ch %= 17;                                       /* ͨ */

    if (16 == ch)
    {
        ulAddr = g_ulList_s + 0x42B0;               /* λlistò */
        if (0 == stream)
        {
            bit = 4;
        }
        else if (1 == stream)
        {
            bit = 9;
        }
        else
        {
            bit = 16;
        }
    }
    else
    {
        ulAddr = g_ulList_s + (ch << 10) + 0x144;
        bit = stream * 8;                           /* ӦĴ0,8,16ƫλ */
    }

    ulVal = read_reg(ulAddr);
    if (fr == ((ulVal >> bit) & 0x1F))              /* µ֮֡ǰһ£ֱӷ */
    {
        return;
    }

    ulVal &= ~(0x1F << bit);
    ulVal |= (fr << bit);

    write_reg(ulAddr, ulVal);

    update_list(ch);                                /* listòҲˢ */

    return;
}


/*
**  Ув
**  wʾmux,enc0,enc1ȹܵı
**  hʾmux,enc0,enc1ȹܵı߶
**  paraʾв
**
**  ʵʳߴ磬ʵʿԸ
**  0ʾʧ
*/
inline unsigned long check_cut_para(unsigned long w, unsigned long h, unsigned long para)
{
    int mbx, mby, mbw, mbh;

    if (0 == (para & 0x10000000))                   /* bit28ʾʹ */
    {
        return w * h;
    }

    mbx = ((para >> 21) & 0x7F) << 4;               /* ꣬Ӻת */
    mby = ((para >> 14) & 0x7F) << 4;
    mbw = ((para >> 7) & 0x7F) << 4;
    mbh = (para & 0x7F) << 4;

    if ((mbx + mbw > w) || (mby + mbh > h))         /* ֹԽ */
    {
        PRINT(ERR, "enc cut over %#x %#x %#x %#x\n", mbx, mby, mbw, mbh);
        return 0;
    }

    return mbw * mbh;
}


/*
**  ñʿز
**  ĲⲿĿߵȽиı
*/
void hw_enc_set_rcpara(msg_enc_para_t *para)
{
    unsigned long size;
    unsigned long bpsPerFrame;
    unsigned long ulVal[8];
    unsigned long ulBase;

    size = check_cut_para(para->width, para->height, para->cutPara);
    if ((0 == size) || (0 == para->frameRate))      /* ֻų˳쳣 */
    {
        return;
    }

    /* Ԥ֡ */
    hw_enc_set_viu_frame(para->channel, para->frameRate);

    ulBase = 0x52050000 + (para->channel << 8);
    ulVal[0] = read_reg(ulBase);                    /* ʿģʽ */
    ulVal[0] &= 0xFFF8BFFF;

    ulVal[1] = read_reg(ulBase + 0x14);             /* ֡qp */
    ulVal[1] &= 0x00FFFFC0;

    if (0 == para->rcMode)                          /* ̶QPģʽ(ʿ֡) */
    {
        ulVal[0] |= 0x20000;                        /* ̶QP */
        write_reg(ulBase, ulVal[0]);

        ulVal[1] |= (para->frameInterval << 24);    /* ֡ */
        ulVal[1] |= (para->qp);                     /* qp */
        write_reg(ulBase + 0x14, ulVal[1]);

        return;
    }
    else if (1 == para->rcMode)                     /* VBR */
    {
        ulVal[0] |= 0x50000;                        /* VBR */
        write_reg(ulBase, ulVal[0]);

        ulVal[1] |= (para->frameInterval << 24);    /* ֡ */
        write_reg(ulBase + 0x14, ulVal[1]);
    }
    else                                            /* CBR */
    {
        ulVal[0] |= 0x14000;                        /* CBR */
        write_reg(ulBase, ulVal[0]);

        ulVal[1] |= (para->frameInterval << 24);    /* ֡ */
        write_reg(ulBase + 0x14, ulVal[1]);
    }

    write_reg(ulBase + 0x28, para->cutPara);        /* в */

    bpsPerFrame = para->bps / para->frameRate;      /* תÿ֡ı */

    ulVal[0] = bpsPerFrame * 192 / size;            /* 0x70 mb_b_bits_in*/

    ulVal[1] = bpsPerFrame * 224 / size;            /* 0x74 mb_p_bits_in */
    ulVal[1] <<= 10;
    ulVal[1] |= CBR_DECAY;

    ulVal[2] = bpsPerFrame * 307 / 40;              /* 0x7C buf_size_in */

    ulVal[3] = 0x54A00489 | (para->iqp << 12);      /* 0x88 init_qp_i_in */

    ulVal[4] = (ulVal[2] >> 1) << 6;                /* 0x8C buf_fill_in init_qp_pb_in */
    ulVal[4] |= para->qp;

    ulVal[5] = (ulVal[2] << 2) / 10;                /* 0x94 buf_fill_min_in */
    ulVal[2] |= (ARITHMETIC_MIN_QP << 26);

    /*
    **  0xA8 init_pred_satd_in
    **  init_pred_satd_inֵΪ(size * 2.5 / 4)ڼĴﻹҪ3λ
    **  øֵЧãСȥ(sizeǿԱ8)
    */
    ulVal[6] = size * 3;

    ulVal[7] = bpsPerFrame * 102;                   /* 0xB4 abr_buffer_in */

    ulBase = RC0_BADDR + (para->channel << 8);      /* ĿǰֻһƬʻ */
    write_reg(ulBase + 0x70, ulVal[0]);
    write_reg(ulBase + 0x74, ulVal[1]);
    write_reg(ulBase + 0x7C, ulVal[2]);
    write_reg(ulBase + 0x84, bpsPerFrame);
    write_reg(ulBase + 0x88, ulVal[3]);
    write_reg(ulBase + 0x8C, ulVal[4]);
    write_reg(ulBase + 0x94, ulVal[5]);
    write_reg(ulBase + 0xA8, ulVal[6]);
    write_reg(ulBase + 0xAC, para->frameRate);

    /* ʿصĲ */
    if (1 == para->rcMode)                          /* VBR */
    {
        write_reg(ulBase + 0xB0, 0x00318018);
        write_reg(ulBase + 0xB4, ulVal[7]);
    }
    else                                            /* CBR */
    {
        ulVal[7] |= (6 << 26);
        write_reg(ulBase + 0xB0, 0x0C318618);
        write_reg(ulBase + 0xB4, ulVal[7]);
    }

    return;
}
