/*
**  ԤģĴ֣ҪԤģ
*/

#include "../vs28xx.h"
#include "../list.h"
#include "preview_reg.h"


/*
**  dcmĸͨ0-3˳id
**  Դʱʹituʹʱʹ0ͨitu
*/
#ifdef VS28XX_MODE_ID
int idTab[8] = {0x40, 0xE0, 0x40, 0xE0, 0x40, 0xE0, 0x40, 0xE0};
#else
int idTab[8] = {0x41, 0xE0, 0x40, 0xE0, 0x40, 0xE0, 0x40, 0xE0};
#endif


/*
**  ͨͨӳ䣬ѿͨǰ
*/
#if defined TW2864_27M_1D1
#if defined CHIP4_0                                 /* 14283C */
int chMap[16] = {0x0, 0x4, 0x8, 0xC, 0x1, 0x5, 0x6, 0x7, 0x2, 0x9, 0xA, 0xB, 0x3, 0xD, 0xE, 0xF};
#elif defined CHIP2_02                              /* 16283E */
int chMap[16] = {0x0, 0x6, 0x8, 0xE, 0x4, 0x5, 0x1, 0x7, 0x2, 0x9, 0xA, 0xB, 0xC, 0xD, 0x3, 0xF};
#endif
#elif defined TW2864_54M_2D1
#if defined CHIP4_0                                 /* 238967CD */
int chMap[16] = {0x0, 0x1, 0x8, 0x9, 0x4, 0x5, 0xC, 0xD, 0x2, 0x3, 0xA, 0xB, 0x6, 0x7, 0xE, 0xF};
#elif defined CHIP2_02                              /* 238945EF */
int chMap[16] = {0x0, 0x1, 0x8, 0x9, 0xE, 0xF, 0x6, 0x7, 0x2, 0x3, 0xA, 0xB, 0xC, 0xD, 0x4, 0x5};
#endif
#elif defined TW2864_54M_4CIF                       /* һһӦý */
int chMap[16] = {0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xA, 0xB, 0xC, 0xD, 0xE, 0xF};
#elif defined TW2864_108M_4D1                       /* һһӦý */
int chMap[16] = {0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xA, 0xB, 0xC, 0xD, 0xE, 0xF};
#endif

unsigned long g_ulDenSize = 0;                      /* ͨƬڴС */
unsigned long g_ulDenTotalSize = 0;                 /* ͨڴСÿͨƬ */


/*
**  ý⽻дĴ
**  chΪͨ
**  thrΪ0ʾдVPS_IP_CHXX_DEI_MODEĴΪ1ʾдVPS_IP_CHXX_DEI_THRĴ
**  valΪĴֵ
*/
void hw_pre_set_deinterlace_ex(int ch, int thr, unsigned long val)
{
    unsigned long v;

    if (thr)
    {
        write_reg(g_ulList_s + (ch << 10) + 4, val);
    }
    else
    {
        write_reg(g_ulList_s + (ch << 10), val);

        v = read_reg(0x61260010);                   /* ⽻ڼĴ0x61260010list */
        v &= ~(0x3 << (ch << 1));                   /* ѶӦλ0 */
        v |= ((val & 0x3) << (ch << 1));            /* ʹλ */
        write_reg(0x61260010, v);
    }

    return;
}


/*
**  ý⽻
**  Ŀǰ򵥴ҪôbypassҪô3d⽻
*/
void hw_pre_set_deinterlace(int ch, int enable)
{
    unsigned long val;
    unsigned long bit;

    bit = 0x3 << (ch << 1);
    val = read_reg(0x61260010);

    if (enable)                                     /* 0Ϊ3D⽻3Ϊbypass */
    {
        val &= ~bit;
    }
    else
    {
        /*
        **  עλȫ1Բã
        **  λ2Ͳȥ(Ҫ0)
        */
        val |= bit;
    }

    write_reg(0x61260010, val);

    return;
}


/*
**  ǿ
*/
void hw_pre_set_enhance(int ch, int enable)
{
    unsigned long val;
    unsigned long addr;

    addr = 0x61002088 + (ch << 3);
    val = read_reg(addr);

    if (enable)
    {
        val |= 0x1;
    }
    else
    {
        val &= ~0x1;
    }

    write_reg(addr, val);

    return;
}


/*
**  ý
**  Ŀǰ򵥴ҪôbypassҪôɫȽ
*/
void hw_pre_set_denoise(int ch, int enable)
{
    unsigned long val;

    val = read_reg(0x61260014);

    val &= ~(0x3 << (ch << 1));                     /* ȰѶӦλ0bypass */

    if (enable)
    {
        val |= (0x2 << (ch << 1));                  /* 򿪽ǰѶӦλ2(֮ǰѾ0) */
    }

    write_reg(0x61260014, val);

    return;
}


/*
**  1/2
*/
void hw_pre_set_halfscale(int ch, int enable)
{
    unsigned long val;

    val = read_reg(0x61002110);
    if (enable)
    {
        val |= (0x1 << ch);
    }
    else
    {
        val &= ~(0x1 << ch);
    }
    write_reg(0x61002110, val);

    return;
}


/*
**  ýڴ
**  eΪ1ʾʹeڴ棬Ϊ0ʾʹcڴ
**  listΪ1ʾҪˢlistΪ0ʾҪˢlist
*/
int hw_set_den_mem(int e, int list)
{
    int i;
    unsigned long ulBase;
    static unsigned long s_ulBaseE;
    static unsigned long s_ulBaseC;

    /* ڴ棬CκEΣֻһ*/
    if (e)
    {
        if (0 == s_ulBaseE)
        {
            s_ulBaseE = get_e_memory(g_ulDenTotalSize);
            if (0 == s_ulBaseE)
            {
                return 0;
            }
        }

        ulBase = s_ulBaseE;
    }
    else
    {
        if (0 == s_ulBaseC)
        {
            s_ulBaseC = get_memory(g_ulDenTotalSize);
            if (0 == s_ulBaseC)
            {
                return 0;
            }
        }

        ulBase = s_ulBaseC;
    }

    for (i = 0; i < PRE_CH_NUM; i++)
    {
        /* ɫȲο֡ */
        write_reg(g_ulList_s + (chMap[i] << 10) + 0x10, ulBase);
        ulBase += g_ulDenSize;

        /* Ȳο֡ */
        write_reg(g_ulList_s + (chMap[i] << 10) + 0x4C, ulBase);
        ulBase += g_ulDenSize;
    }

    /* Ҫˢlist16ͨһˢ */
    if (list)
    {
        unsigned long val0;
        unsigned long val1;

        /*
        **  08ĴӦλΪ1ʱܲ3
        **  Ҫ16ͨԲ
        */
        for (i = 0; i < 3; i++)
        {
            val0 = read_reg(0x61260008);
            if (val0 & 0xffff)
            {
                /*
                **  ɹʱ
                **  ֮ǰĴӡǾ
                */
                udelay(10);
            }
            else
            {
                break;
            }
        }
        if (3 == i)
        {
            PRINT(ERR, "update_listx fail!\n");
            return 0;
        }
        val0 |= 0xffff;

        /*
        **  00ĴӦλΪ1ʱlist1Ϊ0ʱlist0֮ѶӦλȡ
        */
        val1 = read_reg(0x61260000);
        for (i = 0; i < 16; i++)
        {
            if (val1 & (0x1 << i))
            {
                memcpy((void *)(g_ulList_h1 + (i << 10)), (void *)(g_ulList_s + (i << 10)), 0x400);
                val1 &= ~(0x1 << i);
            }
            else
            {
                memcpy((void *)(g_ulList_h0 + (i << 10)), (void *)(g_ulList_s + (i << 10)), 0x400);
                val1 |= (0x1 << i);
            }
        }

        write_reg(0x61260000, val1);                     /* 00ĴӦλȡ */

        write_reg(0x61260008, val0);                     /* 08ĴӦλ1 */
    }

    return PRE_CH_NUM;
}


/*
**  ʽ
**  nΪ0ʾPALnΪ1ʾNTSC
*/
void hw_pre_set_standard(int ch, int n)
{
    unsigned long val;

    val = read_reg(0x61002000);
    if (n)
    {
        val |= (0x10000 << ch);
    }
    else
    {
        val &= ~(0x10000 << ch);
    }
    write_reg(0x61002000, val);

    return;
}


/*
**  üй
**  enableʾʹ
**  modeʾģʽ
**  54M4CIFģʽ£ϲ˵0,1,2ֱʾ߼0,4,8أӦӲֵΪ0,1,8
**  ģʽ£ϲ˵0,1,2,3,4ֱʾ߼0,4,8,12,16أӦӲֵΪ0,1,4,8,12
*/
void hw_pre_set_cut(int ch, int enable, int mode)
{
    int biten;
    int bitv;
    unsigned long reg;
    unsigned long val;

#ifdef TW2864_54M_4CIF
    static int map[3] = {0, 1, 8};
    if (mode > 2)
    {
        return;
    }
#else
    static int map[5] = {0, 1, 4, 8, 12};
#endif

    reg = 0x61002004 + ((ch >> 1) << 2);            /* ͨһĴ */
    biten = (0 == (ch & 0x1)) ? 8 : 16;
    bitv = biten + 4;

    val = read_reg(reg);
    val &= ~(0x1 << biten);
    val &= ~(0xF << bitv);
    if (enable)
    {
        val |= (map[mode] << bitv);
        val |= (0x1 << biten);
    }
    write_reg(reg, val);

    return;
}


/*
**  ֿͨ
**  widthʾԴ
**  numʾֿ
**
**  20110418ѷֿӼĴĵlistΪ˱ּݣطд
**  ⲿҪˢlist
*/
void hw_pre_set_blkdiv(int ch, int width, int num)
{
    int bitn;
    int bitw;
    unsigned long reg;
    unsigned long val;

    reg = 0x61000040 + ((ch >> 1) << 2);            /* ͨһĴ */
    bitn = (0 == (ch & 0x1)) ? 0 : 16;
    bitw = bitn + 4;

    val = read_reg(reg);
    val &= ~(0xFFFF << bitn);
    val |= (num << bitn);
    val |= (width << bitw);
    write_reg(reg, val);

    val = num | (width << 16);
    write_list(ch, 211, val);

    return;
}
