/****************************************************************************/

/*
 *	ckcore.h -- C-Sky CKcore CPU sepecific defines
 *
 *	(C) Copyright 1999-2002, Greg Ungerer (gerg@snapgear.com)
 *	(C) Copyright 2000, Lineo (www.lineo.com)
 *  (C) Copyright 2004, Kang Sun
 *  (C) Copyright 2004, Li Chunqiang (chunqiang_li@c-sky.com)
 */

/****************************************************************************/
#ifndef	ckcore_h
#define	ckcore_h
/****************************************************************************/

#include <linux/config.h>

/*
 *	Define the processor support peripherals base address.
 *	This is generally setup by the boards start up code.
 */
#define	CK_MBAR	    0x00000000
#define	CK_MBAR2	0x80000000
#define	CK_IPSBAR	0x40000000

#if (defined(CONFIG_CK510) || defined(CONFIG_CK520))
#undef CK_MBAR
#define	CK_MBAR	CK_IPSBAR
#endif

/*
 *	Define Board Bus clock frequency.
 */
#if defined(CONFIG_CK510EVB)
	#if defined(CONFIG_CLOCK_5MHZ)
	#define	CK_BUS_CLK	5000000
	#elif defined(CONFIG_CLOK_6MHZ)
	#define	CK_BUS_CLK	6000000
	#elif defined(CONFIG_CLOCK_8MHZ)
	#define	CK_BUSCLK	8000000
	#elif defined(CONFIG_CLOCK_10MHZ)
	#define CK_BUSCLK	10000000
	#elif defined(CONFIG_CLOCK_12P5MHZ)
	#define CK_BUSCLK	12500000
	#elif defined(CONFIG_CLOCK_14MHZ)
	#define	CK_BUSCLK	14000000
	#elif defined(CONFIG_CLOCK_15MHZ)
	#define	CK_BUSCLK	15000000
	#elif defined(CONFIG_CLOCK_16MHZ)
	#define	CK_BUSCLK	16000000
	#elif defined(CONFIG_CLOCK_17MHZ)
	#define	CK_BUSCLK	17000000
	#elif defined(CONFIG_CLOCK_18MHZ)
	#define CK_BUSCLK	18000000
	#elif defined(CONFIG_CLOCK_19MHZ)
	#define CK_BUSCLK	19000000
	#elif defined(CONFIG_CLOCK_20MHZ)
	#define	CK_BUSCLK	20000000
	#elif defined(CONFIG_CLOCK_21MHZ)
	#define	CK_BUSCLK	21000000
	#elif defined(CONFIG_CLOCK_22MHZ)
	#define CK_BUSCLK	22000000
	#elif defined(CONFIG_CLOCK_23MHZ)
	#define	CK_BUSCLK	23000000
	#elif defined(CONFIG_CLOCK_24MHZ)
	#define CK_BUSCLK	24000000
	#elif defined(CONFIG_CLOCK_25MHZ)
	#define	CK_BUSCLK	25000000
	#elif defined(CONFIG_CLOCK_26MHZ)
	#define	CK_BUSCLK	26000000
	#elif defined(CONFIG_CLOCK_27MHZ)
	#define	CK_BUSCLK	27000000
	#elif defined(CONFIG_CLOCK_28MHZ)
	#define CK_BUSCLK	28000000
	#elif defined(CONFIG_CLOCK_29MHZ)
	#define	CK_BUSCLK	29000000
	#elif defined(CONFIG_CLOCK_30MHZ)
	#define CK_BUSCLK	30000000
	#elif defined(CONFIG_CLOCK_31MHZ)
	#define CK_BUSCLK	31000000
	#elif defined(CONFIG_CLOCK_32MHZ)
	#define CK_BUSCLK	32000000
	#elif defined(CONFIG_CLOCK_33MHZ)
	#define CK_BUSCLK	33000000
	#elif defined(CONFIG_CLOCK_34MHZ)
	#define CK_BUSCLK	34000000
	#elif defined(CONFIG_CLOCK_35MHZ)
	#define	CK_BUSCLK	35000000
	#elif defined(CONFIG_CLOCK_40MHZ)
	#define CK_BUSCLK	40000000
	#elif defined(CONFIG_CLOCK_50MHZ)
	#define CK_BUSCLK	50000000
	#elif defined(CONFIG_CLOCK_60MHZ)
	#define CK_BUSCLK	60000000
	#elif defined(CONFIG_CLOCK_80MHZ)
	#define CK_BUSCLK	80000000
	#elif defined(CONFIG_CLOCK_100MHZ)
	#define CK_BUSCLK	100000000
	#else
	#error "Don't know what your Bus clock frequency is??"
	#endif
#endif
/*
 *     Define the CPU Clock Multiple
 */
#if defined(CONFIG_CPU_CLOCK_X1)
#define CK_CLK  CK_BUSCLK
#elif defined(CONFIG_CPU_CLOCK_X2)
#define	CK_CLK	CK_BUSCLK*2
#elif defined(CONFIG_CPU_CLOCK_X4)
#define CK_CLK  CK_BUSCLK*4
#elif defined(CONFIG_CPU_CLOCK_X8)
#define CK_CLK  CK_BUSCLK*8
#else
#error "Don't know what the CPU Clock multiple"
#endif

/****************************************************************************/
/*
 *	Define the Ram base address and Size
 */
#if defined(CONFIG_CK510EVB)
	#if defined(CONFIG_RAM2MB)
	#define CK_RAM_SIZE  0x02200000
	#elif defined(CONFIG_RAM4MB)
	#define CK_RAM_SIZE  0x02400000
	#elif defined(CONFIG_RAM8MB)
	#define CK_RAM_SIZE  0x02800000
	#elif defined(CONFIG_RAM16MB)
	#define CK_RAM_SIZE  0x03000000
	#elif defined(CONFIG_RAM32MB)
	#define CK_RAM_SIZE  0x04000000
	#else
	#error "Don't know what the Ram Size"
	#endif

	#define CK_RAM_BASE	0x2000000
#endif
 /***************************************************************************/
#endif	/* ckcore_h */
